<?php
namespace app\bbs\controller;

use org\Http;
use think\Controller;
use think\Db;
class Index extends Controller
{
    function _initialize()
    {
        parent::_initialize();
        if (config('web.WEB_BBS') == 0) {
            $this->redirect(url('shop/index/index'));
        }
    }
    public function index()
    {
        $show['show'] = 1;
        //分类板块展示
        $category = Db::name('category');
        $gjfl = $category->where("tid = 0")->order('sort desc')->select();
        $gjfls = $category->where("tid != 0")->order('sort desc')->select();
        foreach ($gjfls as $ks => $vc) {
            $gjfls[$ks]['count'] = Db::name('forum')->where('tid', $vc['id'])->count();
        }
        $this->assign('gjfl', $gjfl);
        $this->assign('gjfls', $gjfls);
        //分类数据
        $artbycatelist = Db::name('category')->where($show)->order('sort desc')->select();
        foreach ($artbycatelist as $k => $v) {
            $artbycatelist[$k]['artlists'] = get_articles_by_cid($v['id'], 5);
        }
        $this->assign('artbycatelist', $artbycatelist);
        $forum = Db::name('forum');
        $open['open'] = 1;
        $settop['settop'] = 1;
        $t = input('t');
        if ($t == 'index' || $t == '') {
            //最新
            $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name')->where($open)->order('f.settop desc , f.id desc')->paginate(15);
            $this->assign('gzc', $gzc);
        } elseif ($t == 'news') {
            //最新
            $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name')->where($open)->order('f.id desc')->paginate(15, false, ['query' => request()->param()]);
            $this->assign('gzc', $gzc);
        }
        $c = array('type' => config('web.Cascade'));
        $this->assign('c', $c);
        $this->assign('t', $t);
        print s();
        return view();
    }

    public function search()
    {
        $ks = input('ks');
        if (empty($ks)) {
            return $this->error('亲！你迷路了');
        } else {
            $forum = Db::name('forum');
            $open['open'] = 1;
            $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name')->order('f.id desc')->where($open)->where('f.title|f.keywords', 'like', '%' . $ks . '%')->paginate(15, false, $config = ['query' => array('ks' => $ks)]);
            $this->assign('gzc', $gzc);
        $c = array('type' => config('web.Cascade'));
        $this->assign('c', $c);
            return view();
        }
    }
    public function bankuai()
    {
        $id = input('id');
        if (empty($id)) {
            return $this->error('亲！你迷路了');
        } else {
            $category = Db::name('category');
            $c = $category->where("id = {$id}")->find();
            $bankuai = $category->where("tid = {$id}")->order('sort desc')->select();
            foreach ($bankuai as $ks => $vc) {
                $bankuai[$ks]['count'] = Db::name('forum')->where('tid', $vc['id'])->count();
            }
            $this->assign('bankuai', $bankuai);
            if ($c) {
                $forum = Db::name('forum');
                $open['open'] = 1;
                $category = Db::name('category');
                $c = $category->where('id', $id)->find();
                $cs = $category->where('id', $c['tid'])->find();
                $open['open'] = 1;
                $id = $c['id'];
                $description = $c['description'];
                $keywords = $c['keywords'];
                $name = $c['name'];
                $names = $cs['name'];
                $ids = $cs['id'];
                $pic = $c['pic'];
                $tid = $c['tid'] = $c['id'];
                $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name,c.keywords,c.description')->where("f.tid={$id} or c.tid={$id}")->where($open)->order('f.settop desc , f.id desc')->paginate(15);
                $countv = $forum->alias('f')->join('category c', 'c.id=f.tid')->where("f.tid={$id} or c.tid={$id}")->where($open)->count();
                $this->assign('countv', $countv);
                $this->assign('gzc', $gzc);
                $this->assign('c', $c);
                $this->assign('name', $name);
                $this->assign('ids', $ids);
                $this->assign('names', $names);
                $this->assign('pic', $pic);
                $this->assign('keywords', $keywords);
                $this->assign('description', $description);
                $this->assign('id', $id);
                return view();
            } else {
                $this->error("亲！你迷路了！");
            }
        }
    }
    public function view()
    {
        $id = input('id');
        if (empty($id)) {
            return $this->error('亲！你迷路了');
        } else {
            $category = Db::name('category');
            $c = $category->where("id = {$id}")->find();
            if ($c) {
                $forum = Db::name('forum');
                $open['open'] = 1;
                $category = Db::name('category');
                $c = $category->where('id', $id)->find();
                $cs = $category->where('id', $c['tid'])->find();
                $open['open'] = 1;
                $id = $c['id'];
                $description = $c['description'];
                $keywords = $c['keywords'];
                $name = $c['name'];
                $names = $cs['name'];
                $ids = $cs['id'];
                $pic = $c['pic'];
                $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name,c.keywords,c.description')->where("f.tid={$id} or c.tid={$id}")->where($open)->order('f.settop desc , f.id desc')->paginate(15);
                $countv = Db::name('forum')->where('tid', $c['id'])->count();
                $this->assign('gzc', $gzc);
                $this->assign('countv', $countv);
                $this->assign('name', $name);
                $this->assign('ids', $ids);
                $this->assign('c', $c);
                $this->assign('names', $names);
                $this->assign('pic', $pic);
                $this->assign('keywords', $keywords);
                $this->assign('description', $description);
                $this->assign('id', $id);
                return view();
            } else {
                $this->error("亲！你迷路了！");
            }
        }
    }
    public function choice()
    {
        $forum = Db::name('forum');
        $open['open'] = 1;
        $choice['choice'] = 1;
        $gzc = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,m.userid,m.userhead,m.username,c.name')->where($open)->where($choice)->order('f.id desc')->paginate(15);
        $this->assign('gzc', $gzc);
        return view();
    }
    public function thread()
    {
        $id = input('id');
        if (empty($id)) {
            return $this->error('亲！你迷路了');
        } else {
            $forum = Db::name('forum');
            $a = $forum->where("id = {$id}")->find();

            if ($a) {
                $forum->where("id = {$id}")->setInc('view', 1);
                $t = $forum->alias('f')->join('category c', 'c.id=f.tid')->join('member m', 'm.userid=f.uid')->field('f.*,c.id as cid,c.name,m.userid,m.grades,m.point,m.userhead,m.username')->find($id);
                $this->assign('t', $t);
                $content = $t['content'];
                $content = htmlspecialchars_decode($content);
                $this->assign('content', $content);
                
                $gzc = Db::name('comment')->alias('c')->join('member m', 'm.userid=c.uid')->where("tid = 0")->where("fid = {$id}")->order('c.id asc')->paginate(15);
                $gzcs = Db::name('comment')->alias('c')->join('member m', 'm.userid=c.uid')->where("tid != 0")->where("fid = {$id}")->order('c.id asc')->paginate(15);
                $this->assign('gzc', $gzc);
                $this->assign('gzcs', $gzcs);
                print s();
                
                //上一篇
                $open['open'] = 1;
                $tptf = Db::name('forum')->where('id > ' . $id)->limit(1)->select();
                $this->assign('tptf', $tptf);
                //下一篇
                $tpta = Db::name('forum')->where('id < ' . $id)->order('id desc')->limit('1')->select();
                $this->assign('tpta', $tpta);
                
                
                //查询是否为版主
                $uid = session('userid');
                $isbanzhu = 0;
                if (!empty($uid)) {
                    $res = banzhu($uid, $t['tid']);
                    if ($res) {
                        $isbanzhu = 1;
                    }
                }
                $this->assign('isbanzhu', $isbanzhu);
                
                return view();
            } else {
                return $this->error('亲！你迷路了');
            }
        }
    }
}