<?php
!defined('P_W') && exit('Forbidden');

class PW_CmsAttachService {
	/**
	 * Ӹ
	 * @param int $articleId
	 * @param array $attachs
	 * return array('Ƿи','ͼƬid')
	 */
	function updateAttachs($articleId,$attachs) {
		$cmsAttachDAO = $this->_getCmsAttachDAO();
		$ifAttach = 0;
		$uploadIds = array();
		foreach ($attachs as $value) {
			if ($value['attname'] != 'delete') $ifAttach = 1;
			if ($value['attname'] == 'replace') {
				$saveData = $this->_cookUploadData($value,$articleId);
				$cmsAttachDAO->update($saveData,$value['id']);
			} elseif ($value['attname'] == 'attachment') {
				$saveData = $this->_cookUploadData($value,$articleId);
				$temp = $cmsAttachDAO->insert($saveData);
				$uploadIds[$value['id']] = $temp;
			} elseif ($value['attname'] == 'update') {
				$cmsAttachDAO->update(array('descrip' => $value['descrip']),$value['attach_id']);
			} elseif ($value['attname'] == 'delete') {
				$cmsAttachDAO->delete($value['attach_id']);
			}
		}
		return array($ifAttach,$uploadIds);
	}
	/**
	 * ȡӵĸ
	 * @param $articleId
	 * return array
	 */
	function getArticleAttachs($articleId) {
		$cmsAttachDAO = $this->_getCmsAttachDAO();
		$attachs = $cmsAttachDAO->findArticleAttaches($articleId);
		
		$result = array();
		foreach ($attachs as $key => $value) {
			$value['attachurl'] = $this->_getImageUrl($value['attachurl']);
			$result[$value['attach_id']] = $value;
		}
		return $result;
	}
	
	/**
	 * ȡӵͼƬ
	 * @param $articleId
	 * @return array
	 */
	function getArticlePics($articleId){
		$articleId = intval($articleId);
		if($articleId < 0) return array();
		$cmsAttachDAO = $this->_getCmsAttachDAO();
		$pics = $cmsAttachDAO->getAriclePictures($articleId);
		$result = array();
		foreach ($pics as $key => $value) {
			if(!$value) continue;
			$value['attachurl'] = $this->_getImageUrl($value['attachurl']);
			$result[$value['attach_id']] = $value;
		}
		return $result;
	}
	
	/**
	 * ȡϢ
	 * @param $id
	 */
	function getAttachById($id) {
		$cmsAttachDAO = $this->_getCmsAttachDAO();
		$temp = $cmsAttachDAO->get($id);
		if (!$temp) return array();
		$temp['attachurl'] = $this->_getImageUrl($temp['attachurl']);
		return $temp;
	}
	
	function _cookUploadData($data,$articleId) {
		global $timestamp;
		return array(
			'name' => $data['name'],
			'descrip' => $data['descrip'],
			'article_id' => $articleId,
			'type' => $data['type'],
			'size' => $data['size'],
			'uploadtime' => $timestamp,
			'attachurl' => $data['fileuploadurl'],
			'ifthumb' => $data['ifthumb'],
		);
	}
	
	function _getImageUrl($path) {
		$temp = geturl($path);
		return $temp[0];
	}
	function _getCmsAttachDAO() {
		return C::loadDB('cmsattach');
	}
}