<?php
!defined('P_W') && exit('Forbidden');

/**
 * äservice
 * 
 * @package PW_CollectionTypeService
 * @author	panjl
 * @abstract
 */

class PW_CollectionTypeService {
	
	/**
	 * K[
	 * 
	 * @param array $fieldsData ƾڼƲաAHƾڮwrqkey
	 * @return int sWid
	 */
	function insert ($fieldsData) {
		if (S::isArray($fieldsData)) {
			$typeDb = $this->_getCollectionTypeDB();
			return $typeDb->insert($fieldsData);
		}
	}

	/**
	 * s
	 * 
	 * @param array $fieldsData ƾڼƲաAHƾڮwrqkey
	 * @param int $ctid ID
	 * @return int ̷ss誺ID
	 */
	function update ($fieldsData, $ctid) {
		$ctid = intval($ctid);
		if ($ctid < 1) return NULL;
		if (S::isArray($fieldsData)) {
			$typeDb = $this->_getCollectionTypeDB();
			return $typeDb->update($fieldsData, $ctid);
		}
	}

	/**
	 * R
	 * 
	 * @param int $ctid  ID
	 * @return int R
	 */
	function delete ($ctid) {
		$ctid = intval($ctid);
		if ($ctid != '-1' && $ctid < 1) return null;
		$typeDb = $this->_getCollectionTypeDB();
		return $typeDb->delete($ctid);
	}

	/**
	 * ΤIDMWdctid
	 *
	 * @param int $uid Τuid
	 * @param string $typeName W
	 * @return int ID
	 */
	function getCtidByUidAndName($uid, $typeName) {
		$uid = (int)$uid;
		if ( $uid < 1 || !$typeName ) return 0;
		$typeDb = $this->_getCollectionTypeDB();
		return $typeDb->getCtidByUidAndName($uid, $typeName);
	}

	/**
	 * uid˴O_sb
	 *
	 * @param int $uid Τuid
	 * @param string $typeName W
	 * @param int ctid ID
	 * @return boolen 
	 */
	function checkTypeExist($uid, $typeName, $ctid=null) {
		global $winduid;
		$uid = (int)$uid;
		$ctid   = (int)$ctid;
		if ( !$typeName || ($uid != $winduid) ) return false;
		if ( !$ctid ) {
			$isExistType = $this->getCtidByUidAndName($uid,$typeName);
			if ($isExistType > 0) return false;
		} else {
			$typeDb = $this->getTypeByCtid($ctid);
			if ($typeDb['name'] != $typeName) {
				$isExistType = $this->getCtidByUidAndName($uid,$typeName);
				if ($isExistType > 0) return false;
			}
		}
		 return true;
	}

	/**
	 * ھڥΤid d䦬ä
	 *
	 * @param int $uid Τuid
	 * @return array ä
	 */
	function getTypesByUid($uid) {
		$uid = (int)$uid;
		if ( $uid < 1 ) return array();
		$typeDb = $this->_getCollectionTypeDB();
		return $typeDb->getTypesByUid($uid);
	}

	/**
	 * ھڤID d䦬ä
	 *
	 * @param int $ctid ID
	 * @return array
	 */
	function getTypeByCtid($ctid) {
		$ctid = (int)$ctid;
		if ( $ctid < 1 ) return array();
		$typeDb = $this->_getCollectionTypeDB();
		return $typeDb->getTypeByCtid($ctid);
	}

	/**
	 * get PW_CollectionTypeDB
	 * 
	 * @access protected
	 * @return PW_CollectionTypeDB
	 */
	function _getCollectionTypeDB() {
		return L::loadDB('CollectionType', 'collection');
	}
}

