<?php
!defined('P_W') && exit('Forbidden');

/**
 * äƾڼh
 * 
 * @package PW_CollectionTypeDB
 * @author	panjl
 * @abstract
 */

class PW_CollectionTypeDB extends BaseDB {
	var $_tableName 	= 	"pw_collectiontype";
	var $_primaryKey 	= 	'ctid';

	/**
	 * K[
	 * 
	 * @param array $fieldsData ƾڼƲաAHƾڮwrqkey
	 * @return int sWid
	 */
	function insert($fieldsData) {
		if (S::isArray($fieldsData)) {
			return $this->_insert($fieldsData);
		}
	}

	/**
	 * s
	 * 
	 * @param array $fieldsData ƾڼƲաAHƾڮwrqkey
	 * @param int $ctid ID
	 * @return int ̷ss誺ID
	 */
	function update($fieldsData,$ctid) {
		$ctid = intval($ctid);
		if ($ctid < 1) return null;
		if (S::isArray($fieldsData)) {
			return $this->_update($fieldsData,$ctid);
		}
	}

	/**
	 * R
	 * 
	 * @param int $ctid  ID
	 * @return int R
	 */
	function delete($ctid) {
		$ctid = intval($ctid);
		if ($ctid < 1) return null;
		return $this->_delete($ctid);
	}

	/**
	 * ھڤIDH
	 * 
	 * @param int $ctid  ID
	 * @return array 
	 */
	function getTypeByCtid($ctid) {
		$ctid = intval($ctid);
		if ( $ctid < 1 ) return array();
		return $this->_db->get_one ("SELECT * FROM ".$this->_tableName." WHERE ctid = ". S::sqlEscape($ctid));
	}

	/**
	 * ھڥΤuidH
	 * 
	 * @param int $uid  Τuid
	 * @return array 
	 */
	function getTypesByUid($uid) {
		$uid = intval($uid);
		if ( $uid < 1 ) return array();
		$query = $this->_db->query ( "SELECT * FROM ".$this->_tableName." WHERE uid = ". S::sqlEscape($uid));
		return $this->_getAllResultFromQuery ($query);
	}

	/**
	 * uid˴O_sb
	 * 
	 * @param int $userId Τuid
	 * @param string $typeName
	 * @return int ctid
	 */
	function getCtidByUidAndName($uid, $typeName) {
		$uid = intval($uid);
		if ( $uid < 1 || !$typeName ) return 0;
		return $this->_db->get_value( "SELECT ctid FROM ".$this->_tableName." WHERE uid = ". S::sqlEscape($uid) . " AND name = " . S::sqlEscape($typeName));
	}

}