<?php
! defined ( 'P_W' ) && exit ( 'Forbidden' );
class GatherCache_PW_Bbsinfo_Cache extends GatherCache_Base_Cache {
	var $_defaultCache = PW_CACHE_MEMCACHE; 
	var $_prefix = 'bbsinfo_'; 
	
	/**
	 * qws@bbsinfoO
	 *
	 * @param int $id
	 * @return array
	 */
	function getBbsInfoById($id){
		$id = S::int ( $id );
		if ($id < 1) return false;
		$key = $this->_getBbsInfoKeyById($id);
		if (! ($bbsInfo = $this->_cacheService->get($key))){
			$bbsInfo = $this->_getBbsInfoByIdNoCache($id);
			$bbsInfo && $this->_cacheService->set($key, $bbsInfo);
		}
		return $bbsInfo;
	}
	
	/**
	 * qLwsAqbbsinfo@O
	 *
	 * @param int $id
	 * @return array
	 */
	function _getBbsInfoByIdNoCache($id){
		$bbsInfoDb = L::loadDB ( 'bbsInfo', 'forum' );
		return $bbsInfoDb->get( $id );		
	}
	
	/**
	 * M@bbsinfows
	 *
	 * @param int $id
	 */
	function clearBbsInfoCacheById($id){
		$this->_cacheService->delete($this->_getBbsInfoKeyById($id));
	}
	
	/**
	 * qMws
	 *
	 * @param array $ids
	 */
	function clearBbsInfoCacheByIds($ids){
		$ids = (array) $ids;
		foreach ($ids as $id){
			$this->_cacheService->delete($this->_getBbsInfoKeyById($id));
		}
	}
	
	/**
	 * bbsinfobwskey
	 *
	 * @param int $id
	 * @return array
	 */
	function _getBbsInfoKeyById($id){
		return $this->_prefix . 'id_' . $id;
	}
}