<?php
!defined('P_W') && exit('Forbidden');

/**
 * ͱ챵tƾڼh
 * 
 * @package PW_SharelinkstypeDB
 * @author	panjl
 * @abstract
 */

class PW_SharelinksRelationDB extends BaseDB {
	var $_tableName 	= 	'pw_sharelinksrelation';

	/**
	 * K[
	 * 
	 * @param array $fieldsData ƾڼƲաAHƾڮwrqkey
	 * @return int sWid
	 */
	function insert($fieldsData) {
		if (S::isArray($fieldsData)) {
			pwQuery::insert($this->_tableName, $fieldsData);
			return $this->_db->insert_id();
		}
	}

	/**
	 * ھڤIDRƾ
	 * 
	 * @param int $typeId 
	 * @return int R
	 */
	function deleteByStid($stid){
		$stid = intval($stid);
		if ($stid < 1) return null;
		pwQuery::delete($this->_tableName, "stid=:stid", array($stid));
		return $this->_db->affected_rows();
	}

	/**
	 * ھ챵IDRƾ
	 * 
	 * @param int $sid  챵ID
	 * @return int R
	 */
	function deleteBySid($sid) {
		$sid = intval($sid);
		if ($sid < 1) return null;
		pwQuery::delete($this->_tableName, "sid=:sid", array($sid));
		return $this->_db->affected_rows();
	}

	/**
	 * ھ챵IDdID
	 * 
	 * @param int $sid ͱ챵ID
	 * @return int ID
	 */
	function findStidBySid($sid) {
		$sid = intval($sid);
		if ($sid < 1) return null;
		$query = $this->_db->query('SELECT stid FROM ' . $this->_tableName . ' WHERE sid = ' . S::sqlEscape($sid) .' ORDER BY stid ASC');
		return $this->_getAllResultFromQuery($query);
	}

	/**
	 * IDdҦsid
	 * 
	 * @param int $stid ID
	 * @return array Ʋ챵ID
	 */
	function findSidByStid($stid) {
		$stid = intval($stid);
		if ($stid < 1) return array();
		$query = $this->_db->query('SELECT sid FROM ' . $this->_tableName . ' WHERE stid = ' . S::sqlEscape($stid));
		return $this->_getAllResultFromQuery($query);
	}

}