<?php
/**
 * MD~ȪA
 * 
 * @package STopic
 */

!defined('P_W') && exit('Forbidden');

/**
 * MD~ȪAȹH
 * 
 * ѩҦMD~Ⱦާ@AȱfA]AMD~Ⱦާ@BMDާ@BMDIϤާ@C
 *
 * @package STopic
 */
class PW_STopicService {
	/**
	 * MDtm
	 * 
	 * @var array
	 */
	var $_stopicConfig = null;

	/**
	 * MD׼
	 * 
	 * @return int
	 */
	function getCommentNum($stopicId) {
		$stopicId = intval($stopicId);
		if (!$stopicId) return false;
		$stopicDB = $this->_getSTopicDB();
		return $stopicDB->getCommentNum($stopicId);
	}
	
	/**
	 * s^_
	 * 
	 * @param array $fieldsData
	 * @param int $commentid 
	 * @return boolean 
	 */
	function updateCommentnum($num,$stopicId) {
		$stopicId = intval($stopicId);
		if($stopicId < 1 || !$num) return false;
		$stopicDB = $this->_getSTopicDB();
		return $stopicDB->updateCommentnum($num,$stopicId);
	}
	
	/**
	 * MDiΥC
	 * 
	 * @return array MDCƲ
	 */
	function getLayoutList() {
		$layoutTypes= $this->_getSTopicConfig('layoutTypes');
		$layoutList	= array ();
		foreach ( $layoutTypes as $typeName => $typeDesc ) {
			$tmp = $this->getLayoutInfo ($typeName);
			if ($tmp)
				$layoutList [$typeName] = $tmp;
		}
		return $layoutList;
	}

	/**
	 * MDtmH
	 * 
	 * @param string $typeName W١Aptype1v0,type1v1
	 * @return array tmƲ
	 */
	function getLayoutInfo($typeName) {
		$stopicConfig = $this->_getSTopicConfig ();
		$checkDir = $stopicConfig ['layoutPath'] . $typeName . "/";
		if (! is_dir ( $checkDir ))
			return false;

		foreach ( $stopicConfig ['layoutConfig'] as $checkFile ) {
			if (! is_file ( $checkDir . $checkFile ))
				return false;
		}
		$checkData = array ();
		$checkData ['logo'] = $stopicConfig ['layoutBaseUrl'] . $typeName . "/" . $stopicConfig ['layoutConfig'] ['logo'];
		$checkData ['html'] = $checkFile . $stopicConfig ['layoutConfig'] ['html'];
		$checkData ['desc'] = $stopicConfig ['layoutTypes'] [$typeName];
		return $checkData;
	}
	
	/**
	 * MDq{˦csstm
	 * 
	 * @param string $defaultStyle q{˦WAq{Ȭbaby_org
	 * @return array ˦csstmƲ
	 */
	function getLayoutDefaultSet($defaultStyle = 'baby_org') {
		$styleConfig = $this->getStyleConfig('baby_org');
		if (empty($styleConfig)) { 
			return $this->_getSTopicConfig('layout_set');
		} else {
			$layoutSet = $styleConfig['layout_set'];
			$layoutSet['bannerurl'] = $this->getStyleBanner($defaultStyle);
			return $layoutSet;
		}
	}

	/**
	 * MD˦csstm
	 * 
	 * @param string $style ˦W
	 * @return array ˦csstmƲ
	 */
	function getLayoutSet($style) {
		$stylePath = $this->_getSTopicConfig('stylePath');
		if ($style && is_dir($stylePath.$style)) {
			return $this->getStyleConfig($style,'layout_set');
		}
		return $this->getLayoutDefaultSet();
	}

	/**
	 * ˦C
	 * 
	 * @return array ˦CƲ
	 */
	function getStyles() {
		$stylePath = $this->_getSTopicConfig('stylePath');
		$fp	= opendir($stylePath);
		$styles	= array();
		while ($styleDir = readdir($fp)) {
			if (in_array($styleDir,array('.','..')) || strpos($styleDir,'.')!==false) continue;
			$styles[$styleDir] = array(
				'name'=>$this->getStyleConfig($styleDir,'name'),
				'minipreview'=>$this->getStyleMiniPreview($styleDir),
				'preview'=>$this->getStylePreview($styleDir),
			);
		}
		return $styles;
	}

	/**
	 * ˦wYurl
	 * 
	 * @param string $style ˦W
	 * @return string Yurl
	 */
	function getStyleMiniPreview($style) {
		return $this->_getSTopicConfig('styleBaseUrl').$style.'/'.$this->_getSTopicConfig('styleMiniPreview');
	}

	/**
	 * ˦wurl
	 * 
	 * @param string $style ˦W
	 * @return string wurl
	 */
	function getStylePreview($style) {
		return $this->_getSTopicConfig('styleBaseUrl').$style.'/'.$this->_getSTopicConfig('stylePreview');
	}
	
	/**
	 * ˦TϤurl
	 * 
	 * @param string $style ˦W
	 * @return string TϤurl
	 */
	function getStyleBanner($style) {
		$temp = $this->getStyleConfig($style,'banner');
		if ($temp) {
			if (strpos($temp,'http')===false) {
				$temp = $GLOBALS['db_bbsurl'].'/'.$temp;
			}
			return $temp;
		}
		if ($style && file_exists($this->_getSTopicConfig('stylePath').$style.'/'.$this->_getSTopicConfig('styleBanner'))) {
			return $this->_getSTopicConfig('styleBaseUrl').$style.'/'.$this->_getSTopicConfig('styleBanner');
		}
		return 'http://';
	}
	
	/**
	 * ˦tm
	 * 
	 * @param string $style ˦W
	 * @param string $key ˦tm
	 * @return mixed pG$keyūh^˦tmƲաA_h^wtm
	 */
	function getStyleConfig($style,$key='') {
		static $styles = array();
		if (!isset($styles[$style])) {
			$stylePath = $this->_getSTopicConfig('stylePath');
			if (file_exists($stylePath.$style.'/config.php')) {
				$styles[$style] = include S::escapePath($stylePath.$style."/config.php");
			} else {
				$styles[$style] = array();
			}
		}
		if ($key) {
			return isset($styles[$style][$key]) ? $styles[$style][$key] : '';
		}
		return $styles[$style];
	}

	/**
	 * ͦMDhtml
	 * 
	 * @param int $stopic_id MDid
	 * @return null
	 */
	function creatStopicHtml($stopic_id) {
		global $db_charset,$wind_version,$db_bbsurl,$db_htmifopen;
		$stopic	= $this->getSTopicInfoById($stopic_id);
		if (!$stopic) return false;
		$tpl_content	= $this->getStopicContent($stopic_id,0);
		@extract($stopic, EXTR_SKIP);
		if (defined('A_P')) {
			include(A_P.'template/stopic.htm');
		} else {
			include(R_P.'apps/stopic/template/stopic.htm');
		}
		$output = str_replace(array('<!--<!---->','<!---->'),array('',''),ob_get_contents());
		ob_end_clean();
		$stopicDir	= $this->getStopicDir($stopic_id, $stopic['file_name']);
		$output = parseHtmlUrlRewrite($output, $db_htmifopen);
		pwCache::writeover($stopicDir,$output);
		ObStart();
	}

	/**
	 * sWMD
	 * 
	 * @param $fieldsData MDƾڼƲաAƾڮwrq
	 * @return int MDidAѫh^0
	 */
	function addSTopic($fieldsData) {
		if (!is_array($fieldsData) || !count($fieldsData)) return 0;
		$fieldsData['create_date'] = time();

		$stopicDB = $this->_getSTopicDB();
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$stopicId = $stopicDB->add($fieldsData);
		//if ($stopicId && isset($fieldsData['copy_from']) && $fieldsData['copy_from']) $stopicDB->increaseField($fieldsData['copy_from'], 'used_count');
		if ($stopicId && isset($fieldsData['bg_id']) && $fieldsData['bg_id']) $stopicPicturesDB->increaseField($fieldsData['bg_id'], 'num');
		return $stopicId;
	}

	/**
	 * RhӱMD
	 * 
	 * @param array $stopicIds MDidƲ
	 * @return int RӼ
	 */
	function deleteSTopics($stopicIds) {
		$success = 0;
		foreach ( $stopicIds as $stopicId ) {
			$success += $this->deleteSTopicById ( $stopicId );
		}
		return $success;
	}

	/**
	 * RӱMD
	 * 
	 * @param int $stopicId MDid
	 * @return bool O_\
	 */
	function deleteSTopicById($stopicId) {
		$stopicDB = $this->_getSTopicDB();
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$stopicUnitDB = $this->_getSTopicUnitDB();

		$stopicData = $stopicDB->get($stopicId);
		if (null == $stopicData) return false;
		$isSuccess = (bool) $stopicDB->delete($stopicId);
		if ($isSuccess && $stopicData['bg_id']) $stopicPicturesDB->increaseField($stopicData['bg_id'], 'num', -1);
		if ($isSuccess) {
			$stopicUnitDB->deleteAll($stopicId);
			$this->_delFile($this->getStopicDir($stopicId, $stopicData['file_name']));
		}
		return $isSuccess;
	}

	/**
	 * R
	 * 
	 * @access protected
	 * @see P_unlink
	 * @param string $fileName W
	 * @return bool O_\
	 */
	function _delFile($fileName) {
		return P_unlink($fileName);
	}

	/**
	 * sMDO
	 * 
	 * @param int $stopicId MDid
	 * @param array $updateData nsƾڼƲ
	 * @return bool O_s
	 */
	function updateSTopicById($stopicId, $updateData) {
		$stopicDB = $this->_getSTopicDB();
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$stopicData = $stopicDB->get($stopicId);
		if (null == $stopicData) return false;

		$isSuccess = (bool) $stopicDB->update($stopicId,$updateData);
		if (isset($updateData['bg_id']) && $updateData['bg_id'] != $stopicData['bg_id']) {
			if ($stopicData['bg_id']) $stopicPicturesDB->increaseField($stopicData['bg_id'], 'num', -1);
			if ($updateData['bg_id']) $stopicPicturesDB->increaseField($updateData['bg_id'], 'num');
		}
		if (isset($updateData['file_name'])) {
			$stopicDB->updateFileName($stopicId, $updateData['file_name']);
			if ($updateData['file_name'] != $stopicData['file_name'] && '' != $stopicData['file_name']) {
				$this->_delFile($this->getStopicDir($stopicId, $stopicData['file_name']));
			}
		}
		return $isSuccess;
	}

	/**
	 * MDH
	 * 
	 * @param $stopicId
	 * @return array|null MDƾڼƲ
	 */
	function getSTopicInfoById($stopicId) {
		$stopicDB = $this->_getSTopicDB();

		$stopic = $stopicDB->get($stopicId);
		if ($stopic) $stopic['bg_url'] = $stopic['bg_id'] ? $this->_getBackgroundUrl($stopic['bg_id']) : "";

		return $stopic;
	}

	/**
	 * űMD]MDK[󤺮e^
	 * 
	 * @return array|null MDƾڼƲ
	 */
	function getEmptySTopic() {
		$stopicDB = $this->_getSTopicDB();
		$stopic = $stopicDB->getEmpty();
		return $stopic;
	}

	/**
	 * MDӼ
	 * 
	 * @param string $keyword dr
	 * @param int $categoryId id
	 * @return int
	 */
	function countSTopic($keyword = '', $categoryId = 0) {
		$stopicDB = $this->_getSTopicDB();
		return $stopicDB->countByKeyWord ($keyword, $categoryId);
	}

	/**
	 * d߱MD
	 * 
	 * @param int $page ĴX
	 * @param int $perPage CO
	 * @param string $keyword r
	 * @param int $categoryId id
	 * @return array MDƾڤGƲ
	 */
	function findSTopicInPage($page, $perPage, $keyword = '', $categoryId = 0) {
		$stopicDB = $this->_getSTopicDB();
		$page = intval ( $page );
		$perPage = intval ( $perPage );
		if ($page <= 0 || $perPage <= 0) return array ();
		$result	= $stopicDB->findByKeyWordInPage($page, $perPage, $keyword, $categoryId);
		foreach ($result as $key=>$value) {
			$result[$key]['url'] = $this->getStopicUrl($value['stopic_id'], $value['file_name']);
			$result[$key]['create_date'] = get_date($value['create_date']);
		}
		return $result;
	}

	/**
	 * ھڤĪMDC
	 * 
	 * @param int $page ĴX
	 * @param int $perPage CO
	 * @param int $categoryId id
	 * @return array MDƾڤGƲ
	 */
	function findValidCategorySTopicInPage($page, $perPage, $categoryId = 0) {
		$stopicDB = $this->_getSTopicDB();
		$page = intval ( $page );
		$perPage = intval ( $perPage );
		if ($page <= 0 || $perPage <= 0)
			return array ();

		return $stopicDB->findValidByCategoryIdInPage ( $page, $perPage, $categoryId );
	}

	/**
	 * ھڤϥβvMDC
	 * 
	 * @param int $limit Ӽ
	 * @param int $categoryId id
	 * @return array MDƾڤGƲ
	 */
	function findUsefulSTopicInCategory($limit, $categoryId = 0) {
		$stopicDB = $this->_getSTopicDB();
		$limit = intval ( $limit );
		if ($limit <= 0) return array ();

		return $this->_lardBackground($stopicDB->findByCategoryIdOrderByUsedInPage(1, $limit, $categoryId));
	}

	/**
	 * oMͦMDƾڦsؿ
	 * 
	 * @param int $stopic_id MDid
	 * @param string $file_name W
	 * @return string |
	 */
	function getStopicDir($stopic_id, $file_name='') {
		$stopic_id = (int) $stopic_id;
		if (!$stopic_id) return false;
		if ('' == $file_name) $file_name = $stopic_id;
		$stopicDir	= S::escapePath($this->_getSTopicConfig('htmlDir'));
		if (!file_exists($stopicDir)) {
			if (mkdir($stopicDir)) {
				@chmod($stopicDir,0777);
			} else {
				showmsg('stopic_htm_is_not_777');
			}
		}
		return $stopicDir.'/'.$file_name.$this->_getSTopicConfig('htmlSuffix');
	}

	/**
	 * MDurl
	 * 
	 * @param int $stopic_id MDid
	 * @param string $file_name W
	 * @return string|bool MDurl
	 */
	function getStopicUrl($stopic_id, $file_name) {
		if ('' == $file_name) return false;
		$stopicDir = $this->getStopicDir($stopic_id, $file_name);
		if ($stopicDir && file_exists($stopicDir)) {
			return $this->_getSTopicConfig('htmlUrl').'/'.$file_name.$this->_getSTopicConfig('htmlSuffix');
		} else {
			return false;
		}
	}

	/**
	 * MDhtmle
	 * 
	 * @param int $stopic_id MDid
	 * @param bool $ifadmin O_Ox޲zɨϥΪhtml
	 * @return string
	 */
	function getStopicContent($stopic_id,$ifadmin) {
		$stopic	= $this->getSTopicInfoById($stopic_id);
		$units	= $this->getStopicUnitsByStopicId($stopic_id);
		$blocks	= $this->getBlocks();

		$parseStopicTpl	= L::loadClass('ParseStopicTpl','stopic');
		$tpl_content	= $parseStopicTpl->exute($this,$stopic,$units,$blocks,$ifadmin);
		return $tpl_content;
	}
	
	/**
	 * MDOsO_Qϥ
	 * 
	 * @param int $stopicId MDid
	 * @param string $fileName W
	 * @return bool
	 */
	function isFileUsed($stopicId, $fileName) {
		$stopicId = intval($stopicId);
		$stopicDB = $this->_getSTopicDB();
		$isFind = $stopicDB->getByFileNameAndExcept($stopicId, $fileName);
		return $isFind && file_exists($this->getStopicDir($stopicId, $fileName));
	}

	/**
	 * sW@ӱMD
	 *
	 * @param array $fieldData MDƾڼƲ
	 * @return int idAѪ^0
	 */
	function addCategory($fieldData) {
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		return $stopicCategoryDB->add($fieldData);
	}

	/**
	 * s@ӱMD
	 *
	 * @param array $fieldData MDƾڼƲ
	 * @param int $categoryId id
	 * @return int|null O_s\
	 */
	function updateCategory($fieldData, $categoryId) {
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		$categoryId = intval ( $categoryId );
		if ($categoryId<= 0) {
			return NULL;
		}
		return $stopicCategoryDB->update($fieldData,$categoryId);
	}

	/**
	 * R@ӱMD PɧsI
	 *
	 * @param int $categoryId id
	 * @return int
	 */
	function deleteCategory($categoryId) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$stopicCategoryDB = $this->_getSTopicCategoryDB();

		$categoryId = intval ( $categoryId );
		if ($categoryId <= 0 || ! $this->isAllowDeleteCategory ( $categoryId )) {
			return NULL;
		}
		return ($stopicCategoryDB->delete ( $categoryId )) ? $stopicPicturesDB->updateByCategoryId ( array("categoryid"=>0),$categoryId ) : NULL;
	}

	/**
	 * O_\R
	 * 
	 * q{MDR/UpGMDR
	 *
	 * @param int $categoryId id
	 * @return bool
	 */
	function isAllowDeleteCategory($categoryId) {
		$stopicDB = $this->_getSTopicDB();
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		if ($stopicDB->countByCategoryId($categoryId)) return false;
		$category = $stopicCategoryDB->get($categoryId);
		if (!$category || $category['status'] == 1) return false;
		return true;
	}

	/**
	 * ҦMD
	 *
	 * @return array MDGƲ
	 */
	function getCategorys() {
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		return $stopicCategoryDB->gets ();
	}

	/**
	 * YӤH
	 *
	 * @param int $categoryId id
	 * @return array MDƾڼƲ
	 */
	function getCategory($categoryId) {
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		return $stopicCategoryDB->get ( $categoryId );
	}

	/**
	 * WO_sb
	 * 
	 * @param string $categoryName W
	 * @return bool
	 */
	function isCategoryExist($categoryName) {
		$stopicCategoryDB = $this->_getSTopicCategoryDB();
		return $stopicCategoryDB->getByName($categoryName) ? true : false;
	}

	/**
	 * WǭIϤ üW[@Ϥ O
	 *
	 * @param array $fileArray WǤƾڼƲ
	 * @return string Wp[20090819152809.jpg]
	 */
	function uploadPicture($fileArray, $categoryId, $creator) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$uploadPictureClass = $this->_setUploadPictureClass();
		if (count ( $fileArray ) < 0 || intval ( $categoryId ) < 0 || trim ( $creator ) == "") {
			return null;
		}
		$filename = $uploadPictureClass->upload ( $fileArray );
		if ($filename === FALSE) {
			return null;
		}
		$fieldData = array (
			"title" => time(),
			"categoryid" => intval($categoryId),
			"path" => trim ($filename),
			"creator" => $creator
		);
		return $stopicPicturesDB->add ( $fieldData );
	}

	/**
	 * W
	 * 
	 * @access protected
	 */
	function _setUploadPictureClass() {
		$tempUpdatePicture = L::loadClass('UpdatePicture');
		$tempUpdatePicture->init($this->_getSTopicConfig ('bgUploadPath'));
		return $tempUpdatePicture;
		//return new UpdatePicture ($this->_getSTopicConfig ('bgUploadPath'));
	}

	/**
	 * sIϤ
	 *
	 * @param int $fieldData IϤƾڼƲ
	 * @param int $pictureId IϤif
	 * @return int|null
	 */
	function updatePicture($fieldData, $pictureId) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$pictureId = intval ( $pictureId );
		if ($pictureId <= 0) {
			return NULL;
		}
		return $stopicPicturesDB->update($fieldData,$pictureId);
	}

	/**
	 * RIϤ RƾڨçRzϤ
	 *
	 * @param int $pictureId
	 * @return int|null
	 */
	function deletePicture($pictureId) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$uploadPictureClass = $this->_setUploadPictureClass();
		$pictureId = intval ( $pictureId );
		if ($pictureId <= 0) return null;
		if (!$this->isAllowDeletePicture($pictureId)) return null;
		$picture = $stopicPicturesDB->get($pictureId);
		if (!$picture) return null;
		return ($stopicPicturesDB->delete ( $pictureId )) ? $uploadPictureClass->delete ( $picture ['path'] ) : "";
	}

	/**
	 * O_\RIϤ
	 *
	 * @param int $pictureId
	 * @return bool
	 */
	function isAllowDeletePicture($pictureId) {
		$stopicDB = $this->_getSTopicDB();
		return $stopicDB->countByBackgroundId($pictureId) ? false : true;
	}

	/**
	 * IϤ
	 *
	 * @param int $categoryId idA0hҦ
	 * @return array
	 */
	function getPictures($categoryId = 0) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		$categoryId = intval ( $categoryId );
		if ($categoryId < 0) return array();

		return $this->_lardBackground( $categoryId
			? $stopicPicturesDB->getsByCategoryId ($categoryId)
			: $stopicPicturesDB->gets() );
	}

	/**
	 * MDIϤ
	 * 
	 * @param int $page
	 * @param int $perPage
	 * @param int $categoryId id
	 * @return array IϤGƲ
	 */
	function getBackgroundsInPage($page, $perPage, $categoryId=0) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		return $this->_lardBackground($stopicPicturesDB->getsInPage($page, $perPage, $categoryId));
	}

	/**
	 * tq{IϤMΤWǪIϤC
	 * 
	 * tq{IϤidtơAp-1,-2
	 * 
	 * @param int $categoryId id
	 * @return array IϤGƲ
	 */
	function getPicturesAndDefaultBGs($categoryId = 0) {
		$defaults = $this->_getDefaultBackGrounds();
		$thisTypePictures = $this->getPictures($categoryId);
		return array_merge($defaults,$thisTypePictures);
	}

	/**
	 * IϤurl
	 * 
	 * @access protected
	 * @param int $bgId IϤid
	 * @return string
	 */
	function _getBackgroundUrl($bgId) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		if ($bgId<0) return $this->_getDefaultBackgroundUrl($bgId);

		$bg = $stopicPicturesDB->get($bgId);
		return $bg['path'] ? $this->_getSTopicConfig ('bgBaseUrl') . $bg ['path'] : "";
	}

	/**
	 * tq{IϤurl
	 * 
	 * @access protected
	 * @param int $bgId IϤid
	 * @return string
	 */
	function _getDefaultBackgroundUrl($bgId) {
		$bgId = (int) $bgId;
		$bgId = abs($bgId);
		if (file_exists($this->_getSTopicConfig('bgDefalutPath').$bgId.'.jpg')) {
			return $this->_getSTopicConfig('bgDefalutUrl').$bgId.'.jpg';
		}
		return '';
	}

	/**
	 * tq{IϤC
	 * 
	 * @access protected
	 * @return array
	 */
	function _getDefaultBackGrounds() {
		$backPath = $this->_getSTopicConfig('bgDefalutPath');
		$fp	= opendir($backPath);
		$backs	= array();

		while ($back = readdir($fp)) {
			if (in_array($back,array('.','..')) || !strpos($back,'.jpg')) continue;
			$id	= $this->_getDefaultBackGroudId($back);
			$backs[] = array(
				'id'	=> $id,
				'categoryid'	=> 'defalut',
				'thumb_url'	=> $this->_getDefaultBackgroundUrl($id)
			);
		}
		return $backs;
	}

	/**
	 * tq{IϤid
	 * 
	 * ثeഫWhϤWରtƧYϤid
	 * 
	 * @access protected
	 * @param string $filename tq{IϤW
	 * @return int
	 */
	function _getDefaultBackGroudId($filename) {
		$temp = (int) $filename;
		if (!$temp || $temp<0) return false;
		return 0-$temp;
	}

	/**
	 * έpIϤӼ
	 *
	 * @param int $categoryId idA0hέpҦ
	 * @return int
	 */
	function countPictures($categoryId = 0) {
		$stopicPicturesDB = $this->_getSTopicPicturesDB();
		return $categoryId ? $stopicPicturesDB->countByCategoryId($categoryId) : $stopicPicturesDB->count();
	}

	/**
	 * [uIϤƾ
	 * 
	 * ƾڤsWIϤurl
	 * 
	 * @access protected
	 * @param array $bgList IϤƲ
	 * @return array
	 */
	function _lardBackground($bgList) {
		foreach ($bgList as $key => $bg) {
			$bgList[$key]['thumb_url'] = $bg['path'] ? $this->_getSTopicConfig('bgBaseUrl') . "thumb_" . $bg ['path'] : "";
		}
		return $bgList;
	}

	/**
	 * ҶC
	 * 
	 * @return ҶC
	 */
	function getBlocks() {
		return $this->_getSTopicConfig('blockTypes');
	}

	/**
	 * Ҷ
	 * 
	 * @param string $typeId ҶW
	 * @return array
	 */
	function getBlockById($typeId) {
		$blockTypes = $this->_getSTopicConfig('blockTypes');
		return $blockTypes[$typeId];
	}

	/**
	 * K[MDҶ
	 * 
	 * @param array $fieldData ҶƾڼƲ
	 * @return int Ҷid
	 */
	function addUnit($fieldData) {
		$stopicUnitDB = $this->_getSTopicUnitDB();
		return $stopicUnitDB->add($fieldData);
	}

	/**
	 * sҶƾ
	 * 
	 * @param int $stopic_id MDid
	 * @param string $html_id ҪObhtmlid
	 * @param array $fieldData sƾ
	 * @return bool O_s\
	 */
	function updateUnitByFild($stopic_id,$html_id,$fieldData) {
		$stopicUnitDB = $this->_getSTopicUnitDB();
		return $stopicUnitDB->updateByFild($stopic_id,$html_id,$fieldData);
	}

	/**
	 * RhӱMDҶ
	 * 
	 * @param int $stopic_id MDid
	 * @param array $html_ids ҶidƲ
	 * @return int RӼ
	 */
	function deleteUnits($stopic_id,$html_ids) {
		$stopicUnitDB = $this->_getSTopicUnitDB();
		return $stopicUnitDB->deletes($stopic_id,$html_ids);
	}

	/**
	 * MDҶC
	 * 
	 * @param int $stopic_id MDid
	 * @return array
	 */
	function getStopicUnitsByStopicId($stopic_id) {
		$stopicUnitDB = $this->_getSTopicUnitDB();
		return $stopicUnitDB->getStopicUnits($stopic_id);
	}

	/**
	 * MD@ӼҶƾ
	 * 
	 * @param int $stopic_id MDid
	 * @param string $html_id Ҷid
	 * @return array
	 */
	function getStopicUnitByStopic($stopic_id,$html_id) {
		$stopicUnitDB = $this->_getSTopicUnitDB();
		return $stopicUnitDB->getByStopicAndHtml($stopic_id,$html_id);
	}

	/**
	 * ҶhtmlҪOe
	 * 
	 * @param array $block_data ҶRƾ
	 * @param string $block_type Ҷ
	 * @param int $block_id Ҷid
	 * @return string
	 */
	function getHtmlData($block_data, $block_type, $block_id=null) {
		$block_job = 'show';
		include S::escapePath(A_P."/template/admin/block/$block_type.htm");
		$output = ob_get_contents();
		ob_clean();
		return $output;
	}

	/**
	 * ^MDƾڮwާ@H
	 * 
	 * @access protected
	 * @return PW_STopicDB
	 */
	function _getSTopicDB() {
		return L::loadDB('STopic', 'stopic');
	}
	
	/**
	 * ^MDIϤƾڮwާ@H
	 * 
	 * @access protected
	 * @return PW_STopicPicturesDB
	 */
	function _getSTopicPicturesDB() {
		return L::loadDB('STopicPictures', 'stopic');
	}
	
	/**
	 * ^MDƾڮwާ@H
	 * 
	 * @access protected
	 * @return PW_STopicCategoryDB
	 */
	function _getSTopicCategoryDB() {
		return L::loadDB('STopicCategory', 'stopic');
	}
	
	/**
	 * ^MDҶƾڮwާ@H
	 * 
	 * @access protected
	 * @return PW_STopicUnitDB
	 */
	function _getSTopicUnitDB() {
		return L::loadDB('STopicUnit', 'stopic');
	}

	/**
	 * MDtm
	 * 
	 * @access protected
	 * @param string $key MDtmAūhҦ
	 * @return mixed tm
	 */
	function _getSTopicConfig($key = '') {
		if (null == $this->_stopicConfig) {
			$this->_stopicConfig = include A_P."config.php";
		}
		if ($key) {
			return $this->_stopicConfig[$key];
		}
		return $this->_stopicConfig;
	}
}

