<?php 
!defined('P_W') && exit('Forbidden');

/**
 * Ǯճ]mDAO
 * @package PW_SchoolDB
 */
class PW_SchoolDB extends BaseDB{
	
	var $_tableName = 'pw_school';
	var $_primaryKey = 'schoolid';
	
	/**
	 * K[@ҾǮ
	 * @param string $schoolName ǮզW
	 * @param int $areaId aId
	 * @param int $type ǮJ1pǡA2ǡA3j
	 * @return int $Id Ǯ
	 */
	function addSchool($areaId,$schoolName,$type){
		$areaId = intval($areaId);
		$schoolName = trim($schoolName);
		$type = intval($type);
		if (!$schoolName || $areaId < 1 || $type < 0) return false;
		$tmpSchoolId = $this->_db->get_value("SELECT `schoolid` FROM $this->_tableName WHERE areaid =". S::sqlEscape($areaId). "AND schoolname= ". S::sqlEscape($schoolName)."");
		if(count($tmpSchoolId) > 0) return $tmpSchoolId;
		$fieldData = array($areaId,$schoolName,$type);
		return $this->_insert($fieldData);
	}
	
	/**
	 * qK[hҾǮ
	 * @param string $schoolNames ǮզW
	 * @return int $Id Ǯ
	 */
	function addSchools($fieldData){
		if (!S::isArray($fieldData)) return false;
		return $this->_db->update("INSERT INTO " . $this->_tableName . " (schoolname,areaid,type) VALUES " . S::sqlMulti($fieldData));
	}
	
	/**
	 * qǮզWO__
	 * @param int $areaIds aid
	 * @param string $schoolNames ǮզW
	 * @param array schoolids
	 */
	function checkSchoolNames($areaid,$type,$schoolNames){
		if (!$areaid || !$schoolNames || !$type) return false;
		return $this->_db->get_value("SELECT count(*) FROM $this->_tableName WHERE areaid = " . S::sqlEscape($areaid) . " AND type = " . S::sqlEscape($type) . " AND schoolname IN (" . S::sqlImplode($schoolNames) . ")");
	}
	
	/**
	 * ھڤ@ӾǮIDƾ
	 * @param int schoolId
	 * @return array
	 */
	function getBySchoolId($schoolId){
		$schoolId = intval($schoolId);
		if($schoolId < 1) return false;
		return $this->_get($schoolId);
	}
	
	/**
	 * ھڦhӾǰ|IDƾ
	 * @param array schoolIds
	 * @return array
	 */
	function getSchoolsBySchoolIds($schoolIds){
		if(!S::isArray($schoolIds)) return array();
		$query = $this->_db->query("SELECT * FROM  $this->_tableName WHERE schoolid IN (" . S::sqlImplode($schoolIds) . ")");
		return $this->_getAllResultFromQuery($query,'schoolid');
	}
	
	/**
	 * ھڦaIDǮ
	 * @param int areaId aID
	 * @param int type Ǯ
	 * @return array Ǯռƾ
	 */
	function getSchoolByArea($areaId,$type){
		if(!$areaId || !$type) return false;
		$result = array();
		$query = $this->_db->query("SELECT * FROM  $this->_tableName WHERE areaid = " . S::sqlEscape($areaId) . " And type = " . S::sqlEscape($type)."");
		while ($rt = $this->_db->fetch_array($query)) {
			$rt['schoolname'] = str_replace('&nbsp;', ' ', $rt['schoolname']);
			$result[$rt[schoolid]] = $rt;
		}
		return $result;
		//return $this->_getAllResultFromQuery($query,'schoolid');
	}
	
	/**
	 * s@Ǯռƾ
	 * @param int id
	 * @param string name
	 * @return bool
	 */
	function editSchool($schoolId,$schoolName){
		if (!$schoolId || !$schoolName) return false;
		return pwQuery::update($this->_tableName, "schoolid=:schoolid", array($schoolId), array('schoolname'=>$schoolName));
	}
	
	/**
	 * ھھǮIDRƾ
	 * @param int schoolId Ǯid
	 * @return bool
	 */
	function deleteSchool($schoolId){
		if(!$schoolId) return false;
		return pwQuery::delete($this->_tableName, 'schoolid=:schoolid', array($schoolId));
	}
	
	/**
	 * ھھǮIDRhƾ
	 * @param int schoolIds Ǯid
	 * @return bool
	 */	
	function deleteSchools($schoolIds){
		if(!S::isArray($schoolIds)) return false;
		return pwQuery::delete($this->_tableName, 'schoolid IN (:schoolid)', array($schoolIds));
	}
}
?>