<?php 
!defined('P_W') && exit('Forbidden');

/**
 * ǲ߸gDAO
 * @package PW_UserEducationDB
 */
class PW_UserEducationDB extends BaseDB{
	
	var $_tableName = 'pw_user_education';
	var $_schoolTable = 'pw_school';
	var $_primaryKey = 'educationid';
	
	/**
	 * K[Ш|g
	 * @param array $data
	 * @return bool
	 */
	function addEducation($data){
		if (!S::isArray($data)) return false;
		return $this->_insert($data);
	}
	
	/**
	 * qK[Ш|g
	 * @param array $data
	 * @return bool
	 */
	function addEducations($data){
		if (!S::isArray($data)) return false;
		return $this->_db->update("INSERT INTO " . $this->_tableName . "(uid,schoolid,educationlevel,starttime) VALUES " . S::sqlMulti($data));
	}
	
	/**
	 * ھڥΤIDШ|g
	 * @param int uid
	 * @return array
	 */
	function getEducations($uid){
		if(!$uid) return array();
		$query = $this->_db->query("SELECT ue.*, s.schoolname FROM  $this->_tableName ue LEFT JOIN $this->_schoolTable s USING(schoolid) WHERE ue.uid = " . S::sqlEscape($uid) . " ORDER BY educationid ASC");
		return $this->_getAllResultFromQuery($query,'educationid');
	}
	
	/**
	 * ھھǮթξǰ|IDΤID
	 * @param int schoolId
	 * @return array
	 */
	function getUserId($schoolId){
		if(!$schoolId) return array();
		$query = $this->_db->query("SELECT uid FROM  $this->_tableName WHERE schoolid = " . S::sqlEscape($schoolId) . "");
		return $this->_getAllResultFromQuery($query,'uid');
	}
	
	/**
	 * ھڱШ|gID@Ш|g
	 * @param int educationId
	 * @return array
	 */
	function getEducation($educationId){
		if(!$educationId) return array();
		return $this->_get($educationId);
	}
	
	/**
	 * s@Ш|g
	 * @param int $uid Τid
	 * @param int $schoolId ǮId
	 * @param int $startTime JǦ~
	 * @return bool
	 */
	function editEducation($educationId,$educationLevel,$schoolId,$startTime){
		if (!$educationId || !$educationLevel || !$schoolId || !$startTime) return false;
		return pwQuery::update($this->_tableName, "educationid=:educationid", array($educationId), array('schoolid'=>$schoolId,'educationlevel'=>$educationLevel,'starttime'=>$startTime));
	}
	
	/**
	 * ھھǮIDRƾ
	 * @param int schoolId Ǯid
	 * @return bool
	 */
	function deleteEduBySchoolId($schoolId){
		if(!$schoolId) return false;
		return pwQuery::delete($this->_tableName, 'schoolid=:schoolid', array($schoolId));
	}
	
	/**
	 * ھھǮIDRhƾ
	 * @param int schoolIds Ǯid
	 * @return bool
	 */	
	function deleteEduBySchoolIds($schoolIds){
		if(!S::isArray($schoolIds)) return false;
		return pwQuery::delete($this->_tableName, 'schoolid IN (:schoolid)', array($schoolIds));
	}
	
	/**
	 * ھڱШ|gidR@Ш|g
	 * @param int educationId Ш|gid
	 * @return bool
	 */
	function deleteEducation($educationId){
		if(!$educationId) return false;
		return pwQuery::delete($this->_tableName, 'educationid=:educationid', array($educationId));
	}
	
	/**
	 * ھڱШ|gidRhШ|g
	 * @param int educationIds Ш|gid
	 * @return bool
	 */
	function deleteEducations($educationIds){
		if(!S::isArray($educationIds)) return false;
		return pwQuery::delete($this->_tableName, 'educationid IN (:educationid)', array($educationIds));
	}
}