<?php
!defined('P_W') && exit('Forbidden');

/**
 * Ҿ
 */
class PW_Validator {
	
	/**
	 * ҦrŦ
	 * 
	 * @param string $data ƾڦrŦ
	 * @param string $type 
	 * @return bool O_Xk
	 */
	function validate($data, $type) {
		if (empty($type)) return false;
		if (null !== ($reg = PW_Validator::_getRegValidator($type))) {
			return PW_Validator::_validateByReg($data, $reg);
		} elseif (null !== ($specify = PW_Validator::_getSpecifyValidator($type))) {
			return PW_Validator::_validateBySpecify($data, $specify);
		}
		return false;
	}
	
	/**
	 * hҾ
	 * 
	 * @access protected
	 * @param string $type 
	 * @return string|null hF
	 */
	function _getRegValidator($type) {
		$regValidateConfig = array(
			"username" => "/^[a-zA-Z0-9_]{4,20}$/",
			"email" => "/^[-a-zA-Z0-9_\.]+@([0-9A-Za-z][0-9A-Za-z-]+\.)+[A-Za-z]{2,5}$/",
			"url" => "/^http:\/\/[A-Za-z0-9]*\.[A-Za-z0-9]*[\/=\?%\-&_~@\.A-Za-z0-9]*$/",
		);
		return isset($regValidateConfig[$type]) ? $regValidateConfig[$type] : null;
	}
	
	/**
	 * wҾ
	 * @param string $type 
	 * @return Object wҾH
	 */
	function _getSpecifyValidator($type) {
		return L::loadClass('Validate' . ucfirst(strtolower($type)), 'utility/validate/specify');
	}
	
	/**
	 * qLh
	 * 
	 * @param string $data ƾ
	 * @param string $reg h
	 * @return bool O_Xk
	 */
	function _validateByReg($data, $reg) {
		return (bool) preg_match($reg, $data);
	}
	/**
	 * qLwҾ
	 * 
	 * @param string $data ƾ
	 * @param Object $specify ҾH
	 * @return bool O_Xk
	 */
	function _validateBySpecify($data, $specify) {
		return $specify->validate($data);
	}
}
