<?php

// +---------------------------------------------+
// |     Copyright 2010 - 2018 GuaGua BBS        |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+



/**
 * Handles objects global to page execution and adding elements to the page.
 * @package Framework
 */
class Page {
	// Private Properties
	var $Controls;          // An associative array of control collections
	var $Context;
	var $Events;				// An array of ordered event names to be fired

	// Add a control to an event
	function AddControl($Event, &$Control, $Position = '0') {
		$Position = ForceInt($Position, -1);
		if ($Position >= 0) {
			// Create the key/array if it doesn't exist yet
			if (!array_key_exists($Event, $this->Controls)) $this->Controls[$Event] = array();
			$this->InsertControlAt($this->Controls[$Event], $Control, $Position);
		} else {
			$this->Controls[$Event][] =& $Control;
		}
	}

	// Add a control to the 'Page_Render' event
	function AddRenderControl(&$Control, $Position = '0') {
		$this->AddControl('Page_Render', $Control, $Position);
	}

	function FireEvent($Event) {
		// Loop through the elements of this type and write them.
		if (array_key_exists($Event, $this->Controls)) $this->WriteControls($this->Controls[$Event]);
		// Destruct
		if ($Event == 'Page_Unload') $this->Context->Unload();
	}

	function FireEvents() {
		$EventCount = count($this->Events);
		$i = 0;
		for ($i = 0; $i < $EventCount; $i++) {
			$this->FireEvent($this->Events[$i]);
		}
	}

	function InsertControlAt(&$Collection, &$Control, $Position) {
		if (array_key_exists($Position, $Collection)) {
			$this->InsertControlAt($Collection, $Collection[$Position], $Position+1);
		}
		$Collection[$Position] =& $Control;
	}

	// Constructor
	function Page(&$Context, $Events) {
		$this->Context = &$Context;
		$this->Controls = array();
		$this->Events = $Events;
	}

	function WriteControls($Controls) {
		// Loop through the controls and write them
		if (is_array($Controls)) {
			ksort($Controls);
			while (list($key, $Control) = each($Controls)) {
				$Control->Render();
			}
		}
	}
}
?>