<?php
/*

// +---------------------------------------------+
// |     Copyright 2010 - 2018 GuaGua BBS        |
// |     http://www.weentech.com                 |
// |     This file may not be redistributed.     |
// +---------------------------------------------+

/*
* Description: Web forms that handle running, saving, and removing searches
*/

include("appg/settings.php");
$Configuration['SELF_URL'] = 'search.php';
include("appg/init_guagua.php");

// 1. DEFINE VARIABLES AND PROPERTIES SPECIFIC TO THIS PAGE

	// Ensure the user is allowed to view this page
	$Context->Session->Check($Context);

	// Define properties of the page controls that are specific to this page
	$Context->PageTitle = $Context->GetDefinition("Search");
	$Head->BodyId = 'SearchPage';
	$Menu->CurrentTab = "search";
	$Panel->CssClass = "SearchPanel";
	$Panel->BodyCssClass = "Search";

// 2. BUILD PAGE CONTROLS

	// Search form
	$SearchForm = $Context->ObjectFactory->CreateControl($Context, "SearchForm");

// 3. ADD CONTROLS TO THE PAGE

	$Page->AddRenderControl($Head, $Configuration["CONTROL_POSITION_HEAD"]);
	$Page->AddRenderControl($Menu, $Configuration["CONTROL_POSITION_MENU"]);
	$Page->AddRenderControl($Panel, $Configuration["CONTROL_POSITION_PANEL"]);
	$Page->AddRenderControl($NoticeCollector, $Configuration['CONTROL_POSITION_NOTICES']);
	$Page->AddRenderControl($SearchForm, $Configuration["CONTROL_POSITION_BODY_ITEM"]);
	$Page->AddRenderControl($Foot, $Configuration["CONTROL_POSITION_FOOT"]);
	$Page->AddRenderControl($PageEnd, $Configuration["CONTROL_POSITION_PAGE_END"]);

// 4. FIRE PAGE EVENTS

	$Page->FireEvents();

?>