<?php
define('THIS_SCRIPT', 'sysinfo');
include_once 'global.php';
if (defined('MAIN_DOMAIN_NAME')) {
	exit('Access denied!');
}
$lang = load_lang($lang,'sysinfo');
checklogin();
header("content-Type: text/html; charset=".$charset);
head();
if ( strpos($sysinfo['flag'],'33,') === false ){
	show_msg($lang['readme_tit'],$lang['error.str1'],0,'','','','');
	exit;
}
PageLoad();
footer();
function Pageload(){
	global $lang,$action,$db,$dv,$os,$phpos,$sysInfo,$sysReShow,$doaction,$valInt,$valFloat,$valIo,$isMysql,$isMail,$deaction,$reaction;
	$doaction=$_POST['doaction'];
	$deaction=$_POST['deaction'];
	sys_linux();
	phpos();
	server_captest($doaction);
	def_check($deaction);
	$act=$_GET['act'];
	php_info($act);
	$os = explode(" ", php_uname());
	$isMysql = (false !== function_exists("mysql_query"))?"":" disabled";
    $isMail = (false !== function_exists("mail"))?"":" disabled";
include printout('sysinfo');
}
function phpos(){
	global $sysInfo,$lang;
	$PHP_OS=PHP_OS;
	switch ($PHP_OS){
	case "Linux":
		$sysInfo = sys_linux();
	break;
	case "FreeBSD":
		$sysInfo = sys_freebsd();
	break;
	default:
	break;
	}
}
function sys_linux(){
	global $lang;
	// CPU
	if (false === ($str = @file("/proc/cpuinfo"))) return false;
	$str = implode("", $str);
	@preg_match_all("/model\s+name\s{0,}\:+\s{0,}([\w\s\)\(.]+)[\r\n]+/", $str, $model);
	@preg_match_all("/cache\s+size\s{0,}\:+\s{0,}([\d\.]+\s{0,}[A-Z]+[\r\n]+)/", $str, $cache);
	if (false !== is_array($model[1])){
		$res['cpu']['num'] = sizeof($model[1]);
		for($i = 0; $i < $res['cpu']['num']; $i++){
			$res['cpu']['detail'][] = $lang['sys.info1'].$model[1][$i].$lang['sys.info2'].$cache[1][$i];
		}
		if (false !== is_array($res['cpu']['detail'])){
			$res['cpu']['detail'] = implode("<br />", $res['cpu']['detail']);
		}
	}
	// UPTIME
	if (false === ($str = @file("/proc/uptime"))) return false;
	$str = explode(" ", implode("", $str));
	$str = trim($str[0]);
	$min = $str / 60;
	$hours = $min / 60;
	$days = floor($hours / 24);
	$hours = floor($hours - ($days * 24));
	$min = floor($min - ($days * 60 * 24) - ($hours * 60));
	if ($days !== 0) $res['uptime'] = $days.$lang['sys.info3'];
	if ($hours !== 0) $res['uptime'] .= $hours.$lang['sys.info4'];
	$res['uptime'] .= $min.$lang['sys.info5'];
	// MEMORY
	if (false === ($str = @file("/proc/meminfo"))) return false;
	$str = implode("", $str);	preg_match_all("/MemTotal\s{0,}\:+\s{0,}([\d\.]+).+?MemFree\s{0,}\:+\s{0,}([\d\.]+).+?SwapTotal\s{0,}\:+\s{0,}([\d\.]+).+?SwapFree\s{0,}\:+\s{0,}([\d\.]+)/s", $str, $buf);
	$res['memTotal'] = round($buf[1][0]/1024, 2);
	$res['memFree'] = round($buf[2][0]/1024, 2);
	$res['memUsed'] = ($res['memTotal']-$res['memFree']);
	$res['memPercent'] = (floatval($res['memTotal'])!=0)?round($res['memUsed']/$res['memTotal']*100,2):0;
	$res['swapTotal'] = round($buf[3][0]/1024, 2);
	$res['swapFree'] = round($buf[4][0]/1024, 2);
	$res['swapUsed'] = ($res['swapTotal']-$res['swapFree']);
	$res['swapPercent'] = (floatval($res['swapTotal'])!=0)?round($res['swapUsed']/$res['swapTotal']*100,2):0;
	// LOAD AVG
	if (false === ($str = @file("/proc/loadavg"))) return false;
	$str = explode(" ", implode("", $str));
	$str = array_chunk($str, 3);
	$res['loadAvg'] = implode(" ", $str[0]);
	return $res;
}
function sys_freebsd(){
	global $lang;
	//CPU
	if (false === ($res['cpu']['num'] = get_key("hw.ncpu"))) return false;
	$res['cpu']['detail'] = get_key("hw.model");
	//LOAD AVG
	if (false === ($res['loadAvg'] = get_key("vm.loadavg"))) return false;
	$res['loadAvg'] = str_replace("{", "", $res['loadAvg']);
	$res['loadAvg'] = str_replace("}", "", $res['loadAvg']);
	//UPTIME
	if (false === ($buf = get_key("kern.boottime"))) return false;
	$buf = explode(' ', $buf);
	$sys_ticks = time() - intval($buf[3]);
	$min = $sys_ticks / 60;
	$hours = $min / 60;
	$days = floor($hours / 24);
	$hours = floor($hours - ($days * 24));
	$min = floor($min - ($days * 60 * 24) - ($hours * 60));
	if ($days !== 0) $res['uptime'] = $days.$lang['sys.info3'];
	if ($hours !== 0) $res['uptime'] .= $hours.$lang['sys.info4'];
	$res['uptime'] .= $min.$lang['sys.info5'];
	//MEMORY
	if (false === ($buf = get_key("hw.physmem"))) return false;
	$res['memTotal'] = round($buf/1024/1024, 2);
	$buf = explode("\n", do_command("vmstat", ""));
	$buf = explode(" ", trim($buf[2]));
	$res['memFree'] = round($buf[5]/1024, 2);
	$res['memUsed'] = ($res['memTotal']-$res['memFree']);
	$res['memPercent'] = (floatval($res['memTotal'])!=0)?round($res['memUsed']/$res['memTotal']*100,2):0;
	$buf = explode("\n", do_command("swapinfo", "-k"));
	$buf = $buf[1];
	preg_match_all("/([0-9]+)\s+([0-9]+)\s+([0-9]+)/", $buf, $bufArr);
	$res['swapTotal'] = round($bufArr[1][0]/1024, 2);
	$res['swapUsed'] = round($bufArr[2][0]/1024, 2);
	$res['swapFree'] = round($bufArr[3][0]/1024, 2);
	$res['swapPercent'] = (floatval($res['swapTotal'])!=0)?round($res['swapUsed']/$res['swapTotal']*100,2):0;
	return $res;
}
function bar($percent){
	global $lang;
	return $percent;
}
function getcon($varName){
	global $lang;
	switch($res = get_cfg_var($varName)){
		case 0:
			return NO;
		break;
		case 1:
			return YES;
		break;
		default:
			return $res;
		break;
	}
}
function xml_support($temp){
	global $lang;
	if($temp==1){
		echo $lang['sys.info6'];
	}
	else{
		echo $lang['sys.info7'];
	}
}
function isfun($funName){
	global $lang;
	return (function_exists($funName)!==false)?YES:NO;
}
function php_info($php_act){
	global $lang;
	if ($php_act=="phpinfo"){
		phpinfo();
		exit();
	}
}
function server_captest($act){
	global $valInt,$valFloat,$valIo,$lang;
    if($act== "int"){
        $valInt = test_int();
    }
	else{
        $valInt = $lang['sys.info8'];
	}
    if($act== "flo"){
        $valFloat = test_float();
    }
	else{
        $valFloat = $lang['sys.info8'];
	}
    if($act== "io"){
        $valIo = test_io();
    }
	else{
        $valIo = $lang['sys.info8'];
	}
}
function test_int(){
	global $lang;
	$timeStart = gettimeofday();
	for($i = 0; $i < 3000000; $i++);{
		$t = 1+1;
	}
	$timeEnd = gettimeofday();
	$time = ($timeEnd["usec"]-$timeStart["usec"])/1000000+$timeEnd["sec"]-$timeStart["sec"];
	$time = round($time, 3).$lang['sys.info9'];
	return $time;
}
function test_float(){
	global $lang;
	$t = pi();
	$timeStart = gettimeofday();
	for($i = 0; $i < 3000000; $i++);{
		sqrt($t);
	}
	$timeEnd = gettimeofday();
	$time = ($timeEnd["usec"]-$timeStart["usec"])/1000000+$timeEnd["sec"]-$timeStart["sec"];
	$time = round($time, 3).$lang['sys.info9'];
	return $time;
}
function test_io(){
	global $lang;
	$fp = fopen($lang['file_path'], "r");
	$timeStart = gettimeofday();
	for($i = 0; $i < 10000; $i++){
		fread($fp, 10240);
		rewind($fp);
	}
	$timeEnd = gettimeofday();
	fclose($fp);
	$time = ($timeEnd["usec"]-$timeStart["usec"])/1000000+$timeEnd["sec"]-$timeStart["sec"];
	$time = round($time, 3).$lang['sys.info9'];
	return($time);
}
function def_check($act){
	global $lang;
	switch ($act){
		case "demysql":
			de_mysql();
		break;
		case "deemail":
			de_email();
		break;
		case "defunc":
			de_func();
		break;
		case "depar":
			de_par();
		break;
	}
}
function de_mysql(){
	global $lang;
	$mysqlReShow = "show";
	$mysqlRe = $lang['sys.info10'];
	$mysqlRe .= (false !== @mysql_connect($_POST['mysqlHost'], $_POST['mysqlUser'], $_POST['mysqlPassword']))?$lang['sys.info11']:$lang['sys.info12'];
	$mysqlRe .= $lang['sys.info13'].$_POST['mysqlDb']."</b> ";
	$mysqlRe .= (false != @mysql_select_db($_POST['mysqlDb']))?$lang['sys.info14']:$lang['sys.info15'];
}
function de_email(){
	global $lang;
	$mailReShow = "show";
	$mailRe = $lang['sys.info16'];
	$mailRe .= (false !== @mail($_POST["mailReceiver"], "MAIL SERVER TEST", "This email is sent by iProber.\r\n\r\ndEpoch Studio\r\nhttp://depoch.net"))?$lang['sys.info17']:$lang['sys.info18'];
}
function de_func(){
	global $lang;
	$funReShow = "show";
	$funRe = $lang['sys.info19'].$_POST['funName'].$lang['sys.info20'].isfun($_POST['funName']);
}
function de_par(){
	global $lang;
	$opReShow = "show";
	$opRe = $lang['sys.info21'].$_POST['opName'].$lang['sys.info22'].getcon($_POST['opName']);
}
function get_key($keyName){
	global $lang;
	return do_command('sysctl', "-n $keyName");
}
function find_command($commandName){
	global $lang;
	$path = array('/bin', '/sbin', '/usr/bin', '/usr/sbin', '/usr/local/bin', '/usr/local/sbin');
	foreach($path as $p){
		if (@is_executable("$p/$commandName")) return "$p/$commandName";
	}
	return false;
}
function do_command($commandName, $args){
	global $lang;
	$buffer = "";
	if (false === ($command = find_command($commandName))) return false;
	if ($fp = @popen("$command $args", 'r')){
		while (!@feof($fp))	{
			$buffer .= @fgets($fp, 4096);
		}
		return trim($buffer);
	}
	return false;
}
function grab_key ($key){
	global $lang;
	return execute_program('sysctl', "-n $key");
}
function get_sys_ticks (){
	global $lang;
	$s = explode(' ', grab_key('kern.boottime'));
	$a = ereg_replace('{ ', '', $s[3]);
	$sys_ticks = time() - $a;
	return $sys_ticks;
}
function uptime (){
	global $lang;
	if(PHP_OS==="Linux"){
		if(!$fd = @fopen('/proc/uptime', 'r')){
			echo $lang['sys.info104'];
			return false;
		}
		else{
			$ar_buf = explode(' ', fgets($fd, 4096));
			fclose($fd);
			$sys_ticks = trim($ar_buf[0]);
		}
	}
	else{
		$sys_ticks = get_sys_ticks();
	}
	$min   = $sys_ticks / 60;
	$hours = $min / 60;
	$days  = floor($hours / 24);
	$hours = floor($hours - ($days * 24));
	$min   = floor($min - ($days * 60 * 24) - ($hours * 60));
	if ($days != 0) {
		$result = "".$days.$lang['sys.info3'];
	}
	if ($hours != 0) {
		$result .= "".$hours.$lang['sys.info4'];
	}
	$result .= "".$min.$lang['sys.info5'];
	echo $result;
}
function execute_program ($program, $args = ''){
	$buffer = '';
	$program = find_program($program);
	if (!$program) { return; }
	if ($args) {
		$args_list = split(' ', $args);
		for ($i = 0; $i < count($args_list); $i++) {
			if ($args_list[$i] == '|') {
				$cmd = $args_list[$i+1];
				$new_cmd = find_program($cmd);
				$args = ereg_replace("\| $cmd", "| $new_cmd", $args);
			}
		}
	}
}
function find_program ($program){
    $path = array('/bin', '/sbin', '/usr/bin', '/usr/sbin', '/usr/local/bin', '/usr/local/sbin');
    while ($this_path = current($path)) {
        if (is_executable("$this_path/$program")) {
        return "$this_path/$program";
    }
    next($path);
    }
    return;
}
?>