<?php

define('THIS_SCRIPT', 'admin_postings');
require_once 'global.php';
require_once INC_PATH.'filehandle.misc.php';
require_once INC_PATH.'BoardCache.class.php';
$lang = load_lang($lang, 'admin_postings' );
$stats = $lang['HeaderTitle'];
$gettitle = $lang['HeaderTitle'];
head();
if( $userid <= 0 ){
	showmsg($lang['Error.strings0']);
	exit;
}

if( $boardid <= 0 ){
	showmsg($lang['Error.strings1']);
	exit;
}

if( !is_numeric($id) || $id <= 0 ){
	showmsg($lang['Error.strings2']);
	exit;
}

if( $action{0}.$action{1} != 'p_' ){
	showmsg(str_replace('{$action}',$action,$lang['Error.strings7']));
	exit;
}
if( !function_exists($action) ){
	showmsg(str_replace('{$action}',$action,$lang['Error.strings7']));
	exit;
}

if( ChkPost() === false ){
	showmsg($lang['Error.strings3']);
	exit;
}

$_topicInfo = false;

$ActionInfo = $lang['Action.Info'][str_replace('do_','',$action)];
$LocalCanLockTopic = false;
$LocalCanDelTopic = false;
$LocalCanMoveTopic = false;
$LocalCanTopTopic = false;
$LocalCanBestTopic = false;
$LocalCanAwardTopic = false;
$LocalCanTopTopic_a = false;
$LocalCanTopTopic_m = false;
$LocalCanTopicMode = false;
$allmsg = $lang['template.strings4'];

if( $query = $db->query("SELECT topicid,title,boardid,pollid,locktopic,child,postusername,postuserid,dateandtime,hits,expression,votetotal,lastpost,lastposttime,istop,isvote,isbest,posttable,smsuserlist,issmstopic,lastsmstime,topicmode,mode,getmoney,usetools,getmoneytype,hidename FROM {$dv}topic WHERE topicid='{$id}' AND boardid={$boardid}") ){
	$_topicInfo =& $db->fetch_array($query);
}
if(empty($_topicInfo)){
	showmsg($lang['Error.strings4']);
	exit;
} else{
	$tblName = $db->escape_string($_topicInfo['posttable']);
}
$UpdateBoardID = $boardinfo['parentstr'].','.$boardid;

$S= explode(',',$UpdateBoardID);
$temp= "";
$i= 0;
while($i<count($S))
{
	if($temp == "")
		$temp= $S[$i];
	else		
		$temp.= ",".$S[$i];
	$i++;
}
$UpdateBoardID= $temp;

$nowTotalUseTable = $fsetting['nowtablename'];

if( is_numeric($dowealth) && $dowealth != 0 ){
	$doWealthMsg = $lang['template.strings5'].$dowealth.$lang['template.strings3'];
} else{
	$dowealth = 0;
}
if( is_numeric($douserep) && $douserep != 0 ){
	$douserEPMsg = $lang['template.strings6'].$douserep.$lang['template.strings3'];
} else{
	$douserep = 0;
}
if( is_numeric($dousercp) && $dousercp != 0 ){
	$douserCPMsg = $lang['template.strings7'].$dousercp.$lang['template.strings3'];
} else{
	$dousercp = 0;
}
if( $doWealthMsg != '' || $douserEPMsg != '' || $douserCPMsg != '' ){
	$allmsg = $lang['template.strings8'].$doWealthMsg.$douserEPMsg.$douserCPMsg;
}

if( $userinfo['usertoday'] == '' ){
	$arrUserToday = array(0,0,0,0,0);
} else{
	$arrUserToday = explode('|',$userinfo['usertoday']);
}

if( !isset($delupfile) ){
	$delupfile = 0;
}

global $__REMOVED_FILE_ID_LIST;

isset($replyID) AND !isset($replyid) AND ($replyid = $replyID);
$action($_GET['funcargs']);
function_exists('_dv_muf_adminpostings_callback') AND _dv_muf_adminpostings_callback($action, $id, $replyid, $__REMOVED_FILE_ID_LIST);

footer();



/**
 ******************************************************
 *				ºⲿ
 ******************************************************
 */

function p_fix_topic(){//޸
	$reaction = 'p_do_fix_topic';
	$strAction = $lang['Action.title'][$GLOBALS['action']];
	require printout('admin_postings');
}//end function p_fix_topic
function p_do_fix_topic(){//ύ޸
	global $db, $dv, $boardid, $id, $sucmsg, $lang, $nowTotalUseTable,$checkbox,$tblName,$LogType;
	$usetools = $db->scalar("SELECT usetools FROM {$dv}topic WHERE boardid='{$boardid}' AND topicid='{$id}'");
	$LogType = 3;
	$sucmsg = $lang['template.strings21'];
	$rs =& $db->getResultSet("SELECT COUNT(1) AS c, MAX(dateandtime) AS m FROM ".$db->escape_string($tblName)." WHERE boardid='{$boardid}' AND rootid='{$id}'", array('pageSize'=>1));
	if (!empty($rs)) {
		if (false !== strpos(",{$usetools},", ',13,')) {
			$db->query("UPDATE {$dv}topic SET child=".($rs[0]['c']-1)." WHERE topicid='{$id}'");
		} else {
			$db->query("UPDATE {$dv}topic SET child=".($rs[0]['c']-1).",lastposttime='".$db->escape_string($rs[0]['m'])."' WHERE topicid='{$id}'");
		}
	}
	FixLastPost();
	//$GLOBALS['topicUserName']=$lang['template.strings21'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_topic($boardid,$id);
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($sucmsg));
}//end function p_do_fix_topic

function FixLastPost()
{
	global $db, $dv, $boardid, $id, $sucmsg, $lang, $nowTotalUseTable;
	$rs =& $db->getResultSet("SELECT topic, body, announceid, dateandtime, username, postuserid, rootid, boardid, signflag, SUBSTRING(REPLACE(body, '$', ''), 1, 20) AS subbody FROM ".$db->escape_string($nowTotalUseTable)." WHERE boardid='{$boardid}' AND rootid='{$id}' ORDER BY announceid DESC", array('pageSize'=>1));
	if (!empty($rs)) {
		$bbsinfo =& $rs[0];
		$lastrootid = $bbsinfo['announceid'];
		$lastposttime = $bbsinfo['datandtime'];
		if (2 == $bbsinfo['signflag']) {	//	û
			$lastpostuser = $db->escape_string($lang['template.strings22']);
		} else {
			$lastpostuser = $db->escape_string(str_replace('$', '', $bbsinfo['username']));
		}
		$body = $db->escape_string($bbsinfo['body']);
		$lasttopic = htmlspecialchars($db->escape_string($bbsinfo['subbody']));
		$lastpostuserid = $bbsinfo['postuserid'];
		$lastid = $bbsinfo['rootid'];
		$boardid = $bbsinfo['boardid'];
	} else {
		$lastpostuser = $lasttopic = $db->scalar("SELECT SUBSTRING('".$db->escape_string(htmlspecialchars($lang['template.strings14']))."', 1, 20)");
		$lastrootid = 0;
		$lastposttime = TIME_NOW;
		$lastpostuserid = 0;
		$body = '';
		$lastid = 0;
		$boardid = 0;
	}
	$GLOBALS['topicUserName']= $lastpostuser;
	$lastposttime=TIME_NOW;
	$lastpost = $lastpostuser.'$'.$lastrootid.'$'.$lastposttime.'$'.$lasttopic.'$'.$Uploadpic_n.'$'.$lastposruserid.'$'.$lastid.'$'.$boardid;
	$db->query("UPDATE {$dv}topic SET lastpost='{$lastpost}' WHERE topicid='{$id}'");
}//end function FixLastPost

function p_special_topic_manage(){//ר
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( CanMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$reaction = 'p_do_special_topic_manage0';
	require printout('admin_postings');
}//end function p_special_topic_manage
function p_do_special_topic_manage0(){//ύר
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_POST,$board_settings,$boardinfo,$checkbox;
	if( CanMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}

	if( empty($_POST['title']) && empty($_POST['content']) ){
		showmsg($lang['Error.strings6']);
		exit;
	}
	require printout('admin_postings.ztgl');
}//end function p_do_special_topic_manage0
function p_do_special_topic_manage(){//ύר
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_POST,$_topicInfo,$checkbox;
	if( CanMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( empty($_POST['title']) && empty($_POST['content']) ){
		showmsg($lang['Error.strings6']);
		exit;
	}
	$LogType = 5;
	InitRequestInfo();
	$db->query("UPDATE {$dv}topic SET mode=".intval($_POST['mode'])." WHERE boardid={$boardid} AND topicid='{$id}'");
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_special_topic_manage'];

	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_special_topic_manage

function p_lock_topic(){//ʾ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_lock_topic';
	
	require printout('admin_postings');
}//end function p_lock_topic
function p_do_lock_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$_topicInfo,$lang,$checkbox;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 5;
	InitRequestInfo();
	$db->query("UPDATE {$dv}topic SET locktopic=1 WHERE boardid={$boardid} AND topicid='{$id}'");
	if (-1 == $_topicInfo['isvote']) {	//	жǷΪ
		$db->query("UPDATE {$dv}argue_topic SET locktopic=1 WHERE rootid='{$id}' AND boardid={$boardid}");
		require_once INC_PATH.'argue_mod.functions.php';
		$arguecachefile = CACHE_PATH.'argumentation/cache_'.$id.'.php';
		if (@is_file($arguecachefile)) {
			@unlink($arguecachefile);
		}
	}
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_lock_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_lock_topic

function p_unlock_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	$reaction = 'p_do_unlock_topic';
	require printout('admin_postings');
}//end function p_unlock_topic
function p_do_unlock_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo,$lang,$checkbox;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$db->query("UPDATE {$dv}topic SET locktopic=0 WHERE boardid={$boardid} AND topicid='{$id}'");
	if (-1 == $_topicInfo['isvote']) {	//	жǷΪ
		$db->query("UPDATE {$dv}argue_topic SET locktopic=0 WHERE rootid='{$id}' AND boardid={$boardid}");
		require_once INC_PATH.'argue_mod.functions.php';
		$arguecachefile = CACHE_PATH.'argumentation/cache_'.$id.'.php';
		if (@is_file($arguecachefile)) {
			@unlink($arguecachefile);
		}
	}
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_unlock_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_unlock_topic

function p_exalt_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_exalt_topic';
	require printout('admin_postings');
}//end function p_exalt_topic
function p_do_exalt_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$checkbox;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$db->query("UPDATE {$dv}topic SET lastposttime='".TIME_NOW."' WHERE boardid={$boardid} AND istop=0 AND topicid='{$id}'");
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_exalt_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_exalt_topic

function p_sink_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_sink_topic';
	require printout('admin_postings');
}//end function p_sink_topic
function p_do_sink_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$checkbox;
	if( canLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$db->query("UPDATE {$dv}topic SET lastpost=REPLACE(lastpost, CONCAT('$', lastposttime, '$'), CONCAT('$', lastposttime-8640000, '$')), lastposttime=lastposttime-8640000 WHERE boardid={$boardid} AND istop=0 AND topicid='{$id}'");
	require_once INC_PATH.'BoardCache.class.php';
	Create_index_forumnum();//20070523
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_sink_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_sink_topic

function p_follow_topic_manage(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$tblName;
	global $dowealth,$douserep,$dousercp,$board_user;
	$dowealth = -$board_user[3];
	$douserep = -$board_user[8];
	$dousercp = -$board_user[13];
	Check_topicInfo();
	//жûǷɾȨ
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $page,$_topicInfo,$board_settings;
	if( !is_numeric($page) || $page <= 0 ){
		$page = 1;
	}
	$pageSize = $board_settings[61];
	$RecordCount = $db->scalar("SELECT COUNT(1) FROM {$tblName} WHERE boardid='{$boardid}' AND rootid='{$id}' AND boardid<>777 AND boardid<>444");
	$arrTopicInfo =& $db->getResultSet("SELECT  announceid,parentid,boardid,username,postuserid,topic,dateandtime,length,rootid,layer,orders,expression,body  FROM {$tblName} WHERE boardid='{$boardid}' AND rootid='{$id}' AND boardid<>777 AND boardid<>444 ORDER BY parentid ASC,rootid DESC,orders",array('absolutePage'=>$page,'pageSize'=>$pageSize));
	$reaction = 'p_do_follow_topic_manage';
	require printout('admin_postings.gtgl');
}//end function p_follow_topic_manage
function p_do_follow_topic_manage(){//ύɾ
	global $lang,$dv,$db,$delid,$lang,$_topicInfo,$replyid;
	if( empty($delid) ){
		showmsg($lang['Error.strings12']);
		exit;
	}
	//жûǷɾȨ
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$DelIDList = implode(',',$delid);
	if( checkIDList($DelIDList) === false ){
		showmsg($lang['Error.strings12']);
		exit;
	}
	Check_topicInfo();
	$index = 0;
	$replyTitle = $lang['template.strings15'];
	$dateNow = TIME_NOW;
	foreach( $delid as $index => $replyid ){
		commonDelete(0);
	}
	//ɾ
	del_static_topic($boardid,$id);
	Create_index_forumnum();//20070523
	showmsg(SucMsgInfo(str_replace('{$num}',$index+1,$lang['template.strings18'])));
}//end function p_do_follow_topic_manage

function commonDelete($md){
	global $dv,$db,$userid,$id,$replyid,$_topicInfo,$boardid,$tblName,$lang,$checkbox,$LogType;
	//жûǷɾȨ
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$dateNow = TIME_NOW;
	$todaynum = 0;
	$tmpRs =& $db->getResultSet("SELECT topic,username,postuserid,dateandtime,isbest,isupload FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs !== false ){
		$_topicInfo['title'] = !$tmpRs[0]['topic'] ? $lang['template.strings15'] : $tmpRs[0]['topic'];
		$_topicInfo['postusername'] = $tmpRs[0]['username'];
		$GLOBALS['topicUserName']= $_topicInfo['postusername'];
		$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
		$isbest = $tmpRs[0]['isbest'];
		$IsUpload = $tmpRs[0]['isupload'];
		if( dateDiff('d',$tmpRs[0]['dateandtime'],$dateNow) == 0 ){
			$todaynum = 1;
		} else{
			$todaynum = 0;
		}
	} else{
		if( $md == 1 ){
			showmsg($lang['Error.strings4']);
			exit;
		}
	}
	$LogType = 3;
	InitRequestInfo();
	//ɾʱԶɾظ
	if( intval($isbest) == 1 ){
		$db->query("UPDATE {$dv}topic SET isbest='0' WHERE boardid='{$boardid}' AND topicid='{$id}'");
		$db->query("DELETE FROM {$dv}besttopic WHERE announceid='{$replyid}'");
	}
	$istop = $_topicInfo['istop'];
	$db->query("UPDATE ".$tblName." SET boardid=444,locktopic='{$boardid}' WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	$LastPostime = $db->scalar("SELECT MAX(dateandtime) FROM ".$tblName." WHERE boardid='{$boardid}' AND rootid='{$id}'");
	isLastPost();
	LastCount($boardid);
	BoardNumSub($boardid,0,1,$todaynum);
	AllboardNumSub($todaynum,1,0);
	global $_POST;
	if( $IsUpload == 1 ){
		if( $_POST['delupfile'] == 1 ){
			delupfiles($boardid,$id.'|'.$replyid);
		}
		//ϴ
		$db->query("UPDATE {$dv}upfile SET f_flag=4 WHERE f_boardid='{$boardid}' AND f_announceid LIKE '{$id}|{$replyid}'");
	}
	if( $istop > 0 ){
		$db->query("UPDATE {$dv}topic SET child=child-1 WHERE boardid='{$boardid}' AND topicid='{$id}'");
	} else{
		$db->query("UPDATE {$dv}topic SET child=child-1,lastposttime='{$LastPostime}' WHERE boardid='{$boardid}' AND topicid='{$id}'");
	}
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_delete_topic'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point(',userpost=userpost-1,userdel=userdel+1');
	}
	Topic_Manage_Sms();
	if( $md == 1 ){
		showmsg(SucMsgInfo($GLOBALS['sucmsg']));
	}
}//end function commonDelete

//жǷΪظ
function isLastPost(){
	global $dv,$db,$boardid,$id,$lang,$_topicInfo,$replyid,$tblName;
	$returnVal = false;
	//ȡõǰظID
	//{$dv}topic.topicidΨһģˣѯ$_topicInfo
	if( $_topicInfo['lastpost'].'' !== '' ){
		$arrTmp = explode('$',$_topicInfo['lastpost']);
		if( $arrTmp[1] == $replyid ){
			$returnVal = true;
		}
	}
	if( $returnVal === true ){
		if (-1 == $_topicInfo['isvote']) {	//	жǷΪ
			$tmpRs =& $db->getResultSet("SELECT (CASE WHEN LENGTH(title)>0 THEN title WHEN LENGTH(content)>0 THEN SUBSTRING(content, 1, 20) ELSE '' END) AS Topic, argueid AS AnnounceID, creation_date AS CreationDate, postusername AS PostUserName, postuserid AS PostUserID, rootid, boardid FROM {$dv}argue WHERE rootid='{$id}' AND arguetype IN('0', '1', '2', '3') AND parentid>0 AND parentid<>argueid AND boardid='{$boardid}' ORDER BY argueid DESC", array('pageSize'=>1));
		} else {
			$tmpRs =& $db->getResultSet("SELECT (CASE WHEN LENGTH(topic)>0 THEN topic WHEN LENGTH(body)>0 THEN SUBSTRING(body, 1, 20) ELSE '' END) AS Topic, announceid AS AnnounceID, dateandtime AS CreationDate, username AS PostUserName, postuserid AS PostUserID, rootid, boardid FROM {$tblName} WHERE rootid='{$id}' AND boardid='{$boardid}' ORDER BY announceid DESC",array('pageSize'=>1));
		}
		if( $tmpRs !== false ){
			$LastRootID = $tmpRs[0]['AnnounceID'];
			$LastPostTime = $tmpRs[0]['CreationDate'];
			$LastPostUser = str_replace('$','',$tmpRs[0]['PostUserName']);
			$tmpRs[0]['Topic'] = trim($tmpRs[0]['Topic']);
			if ('' === $tmpRs[0]['Topic']) {
				$LastTopic = $lang['template.strings14'];
			} else {
				$LastTopic = $tmpRs[0]['Topic'];
			}
			$LastPostUserID = $tmpRs[0]['PostUserID'];
			$LastID = $tmpRs[0]['rootid'];
			$boardid = $tmpRs[0]['boardid'];
		} else{
			$LastRootID = 0;
			$LastPostTime = TIME_NOW;
			$LastPostUser = $lang['template.strings14'];
			$LastTopic = $lang['template.strings14'];
			$LastPostUserID = 0;
			$LastID = 0;
			$boardid = 0;
		}
		$LastTopic = strip_tags($LastTopic);
		$LastPost = $LastPostUser.'$'.$LastRootID.'$'.$LastPostTime.'$'.htmlspecialchars($LastTopic).'$'.$uploadpic_n.'$'.$LastPostUserID.'$'.$LastID.'$'.$boardid;
		$db->query("UPDATE {$dv}topic SET lastpost='".$db->escape_string($LastPost)."' WHERE topicid='{$id}'");
	}
	return $returnVal;
}//end function isLastPost

function p_delete_topic(){//ɾ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$_topicInfo;
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$GLOBALS['dowealth'] = -$board_user[3];
	$GLOBALS['douserep'] = -$board_user[8];
	$GLOBALS['dousercp'] = -$board_user[13];
	$GLOBALS['delupfile']  = 1;
	if (-1 == $_topicInfo['isvote']) {
		$reaction = 'p_do_delete_argue_topic';
	} else {
		$reaction = 'p_do_delete_topic';
	}
	require printout('admin_postings');
}//end function p_delete_topic
function p_do_delete_topic(){//ύɾ
	global $checkbox,$lang,$LogType;
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $_topicInfo,$lang,$db,$dv,$boardid,$userid,$membername,$id;
	if( $_topicInfo['title'] == '' || is_null($_topicInfo['title']) ){
		$_topicInfo['title'] = $lang['template.strings15'];
	}
	$LogType = 3;
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	InitRequestInfo();
	$postNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' and forumtype=0");
	$today_star = dv_gmtimestamp(gmdate('Y-m-d 00:00:00'));
	$today_end = dv_gmtimestamp(gmdate('Y-m-d 23:59:59'));
	$todayNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' AND (dateandtime BETWEEN '{$today_star}' AND '{$today_end}') and forumtype=0");
	//վվboardidΪ444locktopicΪԭID
	$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET boardid=444,locktopic='{$boardid}' WHERE rootid='{$id}' and forumtype=0");
	if( $_topicInfo['isvote'] == 1 ){
		$db->query("UPDATE {$dv}topic SET boardid=444,locktopic='{$boardid}',isvote=0,votetotal=0 WHERE topicid='{$id}'");
		$db->query("DELETE FROM {$dv}vote WHERE voteid='{$_topicInfo['pollid']}'");
		$db->query("DELETE FROM {$dv}voteuser WHERE voteid='{$_topicInfo['pollid']}'");
	} elseif( intval($_topicInfo['isbest']) == 1 ){//ɾʱԶ
		$db->query("UPDATE {$dv}topic SET boardid=444,locktopic='{$boardid}',isbest='0' WHERE topicid='{$id}'");
		$db->query("DELETE FROM {$dv}besttopic WHERE rootid='{$id}'");
	} else{
		$db->query("UPDATE {$dv}topic SET boardid=444,locktopic='{$boardid}' WHERE topicid='{$id}'");
	}
	$db->query("UPDATE {$dv}topic_ft SET boardid=444,locktopic='{$boardid}' WHERE topicid='{$id}'", array('type'=>'SILENT')); // ȫݷվ
	$db->query("UPDATE {$dv}bbs_ft SET boardid=444,locktopic='{$boardid}' WHERE rootid='{$id}'", array('type'=>'SILENT')); // ȫݷվ
	if( $_topicInfo['istop'] > 0 ){
		$db->query("UPDATE {$dv}topic SET istop=0,lastposttime='".TIME_NOW."' WHERE topicid='{$id}'");
		if( $_topicInfo['istop'] == 3 ){
			//̶ܹIDñȥ
			$iForum_AllTopNum = $db->scalar("SELECT forum_alltopnum FROM {$dv}setup");
			if( strpos(','.$iForum_AllTopNum.',',",{$id},") !== false ){
				$iForum_AllTopNum = str_replace("{$id},", '', "{$iForum_AllTopNum},");
				if ($iForum_AllTopNum != '') {
					$iForum_AllTopNum = substr($iForum_AllTopNum, 0, -1);
				}
				$db->query("UPDATE {$dv}setup SET forum_alltopnum='{$iForum_AllTopNum}'");
			}
		} else{
			//̶IDӰȥ
			//ѯóԭ̶İ
			$tmpRs =& $db->getResultSet("SELECT boardid,boardtopstr FROM {$dv}board WHERE boardtopstr LIKE '%{$id}%'");
			if( $tmpRs !== false ){
				foreach( $tmpRs as $currRs ){
					$currBoardTopStr = str_replace("{$id},", '', "{$currRs['boardtopstr']},");
					if ($currBoardTopStr != '') {
						$currBoardTopStr = substr($currBoardTopStr, 0, -1);
					}
					$db->query("UPDATE {$dv}board SET boardtopstr='{$currBoardTopStr}' WHERE boardid='{$currRs['boardid']}'");
				}
			}
		}
	}
	global $_POST;
	if( $_POST['delupfile'] == 1 ){
		delupfiles($boardid,$id.'|');
	} else{
		//ϴļݸ
		$db->query("UPDATE {$dv}upfile SET f_flag=4 WHERE f_boardid='{$boardid}' AND f_announceid LIKE '{$id}|%' ");
	}
	LastCount($boardid);
	BoardNumSub($boardid,1,$postNum,$todayNum);
	AllboardNumSub($todayNum,$postNum,1);
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_delete_single_topic'];
	Insert_Forum_Log();
	if( $_topicInfo['postuserid'] != 0 ){
		Topic_Manage_Sms();
		if( $GLOBALS['allmsg'] != '' ){
			global $topicUserID;
			$tmpRs =& $db->getResultSet("SELECT postuserid FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' and forumtype=0");
			if( $tmpRs !== false ){
				foreach( $tmpRs as $currRs ){
					$topicUserID = $currRs['postuserid'];
					if($checkbox!='checkbox'){
						Update_User_Point(',userpost=userpost-1,userdel=userdel+1');
					}
				}
			}
		}
	}
	lastpost();

	//ɾ
	del_static_topic($boardid,$id);
	del_static_boards($boardid);

	$boardcache =& new BoardCache($db);
	$boardcache->createAll();
	$boardcache->createForumSetting();
	Create_index_forumnum();//20070523
	Create_Forum_Topic_List(3,'');
	unset($boardcache);
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_delete_topic
function p_do_delete_argue_topic()//ύɾ
{
	global $checkbox,$LogType;
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $_topicInfo,$lang,$db,$dv,$boardid,$userid,$membername,$id;
	if( $_topicInfo['title'] == '' || is_null($_topicInfo['title']) ){
		$_topicInfo['title'] = $lang['template.strings15'];
	}
	$LogType = 3;
	InitRequestInfo();
	require_once INC_PATH.'argue_mod.functions.php';
	$arguetopicinfo =& get_argumentation_topicinfo($id, $boardid);
	$postNum = $arguetopicinfo['child'];
	$today_star = dv_gmtimestamp(gmdate('Y-m-d 00:00:00'));
	$today_end = dv_gmtimestamp(gmdate('Y-m-d 23:59:59'));
	$todayNum = $db->scalar("SELECT COUNT(1) FROM {$dv}argue WHERE boardid='{$boardid}' AND rootid='{$id}' AND (creation_date BETWEEN {$today_star} AND {$today_end})");
	//վվboardidΪ444locktopicΪԭID
		$db->query("UPDATE {$dv}argue_topic SET boardid='444', locktopic='{$boardid}' WHERE boardid='{$boardid}' AND rootid='{$id}'");
	/*	//	ΪɾֻǷվɾͶƱϢһӴӻվԭôͶƱϢᶪʧ
	//*/
	if( intval($_topicInfo['isbest']) == 1 ){//ɾʱԶ
		$db->query("UPDATE {$dv}topic SET boardid=444,locktopic='{$boardid}',isbest='0' WHERE topicid='{$id}'");
		$db->query("DELETE FROM {$dv}besttopic WHERE rootid='{$id}'");
	} else{
		$db->query("UPDATE {$dv}topic SET boardid=444,locktopic='{$boardid}' WHERE topicid='{$id}'");
	}
	$db->query("UPDATE {$dv}topic_ft SET boardid=444,locktopic='{$boardid}' WHERE topicid='{$id}'", array('type'=>'SILENT')); // ȫݷվ
	$db->query("UPDATE {$dv}bbs_ft SET boardid=444,locktopic='{$boardid}' WHERE rootid='{$id}'", array('type'=>'SILENT')); // ȫݷվ
	if( $_topicInfo['istop'] > 0 ){
		$db->query("UPDATE {$dv}topic SET istop=0,lastposttime='".TIME_NOW."' WHERE topicid='{$id}'");
		if( $_topicInfo['istop'] == 3 ){
			//̶ܹIDñȥ
			$iForum_AllTopNum = $db->scalar("SELECT forum_alltopnum FROM {$dv}setup");
			if( strpos(','.$iForum_AllTopNum.',',",{$id},") !== false ){
				$iForum_AllTopNum = str_replace("{$id},", '', "{$iForum_AllTopNum},");
				if ($iForum_AllTopNum != '') {
					$iForum_AllTopNum = substr($iForum_AllTopNum, 0, -1);
				}
				$db->query("UPDATE {$dv}setup SET forum_alltopnum='{$iForum_AllTopNum}'");
			}
		} else{
			//̶IDӰȥ
			//ѯóԭ̶İ
			$tmpRs =& $db->getResultSet("SELECT boardid,boardtopstr FROM {$dv}board WHERE boardtopstr LIKE '%{$id}%'");
			if( $tmpRs !== false ){
				foreach( $tmpRs as $currRs ){
					$currBoardTopStr = str_replace("{$id},", '', "{$currRs['boardtopstr']},");
					if ($currBoardTopStr != '') {
						$currBoardTopStr = substr($currBoardTopStr, 0, -1);
					}
					$db->query("UPDATE {$dv}board SET boardtopstr='{$currBoardTopStr}' WHERE boardid='{$currRs['boardid']}'");
				}
			}
		}
	}
	global $_POST;
	if( $_POST['delupfile'] == 1 ){
		delupfiles($boardid,$id.'|');
	} else{
		//ϴļݸ
		$db->query("UPDATE {$dv}upfile SET f_flag=4 WHERE f_boardid='{$boardid}' AND f_announceid LIKE '{$id}|%' ");
	}
	LastCount($boardid);
	BoardNumSub($boardid,1,$postNum,$todayNum);
	AllboardNumSub($todayNum,$postNum,1);
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_delete_argue_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if( $_topicInfo['postuserid'] != 0 ){
		Topic_Manage_Sms();
		if( $GLOBALS['allmsg'] != '' ){
			global $topicUserID;
			$tmpRs =& $db->getResultSet("SELECT postuserid FROM {$dv}argue WHERE rootid='{$id}'");
			if( $tmpRs !== false ){
				foreach( $tmpRs as $currRs ){
					$topicUserID = $currRs['postuserid'];
					if($checkbox!='checkbox'){
						Update_User_Point(',userpost=userpost-1,userdel=userdel+1');
					}
				}
			}
		}
	}
	lastpost();

	//ɾ
	del_static_boards($boardid);
	$arguecachefile = CACHE_PATH.'argumentation/cache_'.$id.'.php';
	if (@is_file($arguecachefile)) {
		@unlink($arguecachefile);
	}
	$boardcache =& new BoardCache($db);
	$boardcache->createAll();
	$boardcache->createForumSetting();
	Create_index_forumnum();//20070523
	Create_Forum_Topic_List(3,'');
	unset($boardcache);
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_delete_argue_topic
function ReloadBoardInfo($lboardid) {
	global $lang,$dv,$db;
	$boardidlist=explode(",",$lboardid);
	foreach ($boardidlist as $bid){
		if($bid<>0 and $bid<>""){
			$bid=intval(trim($bid));			
		}
	}

}
function LoadBoardinformation($bid) {
	global $lang,$dv,$db;
}
function Get_RequestInfo() {
	global $lang,$dv,$db,$ActionInfo,$allmsg,$topic,$id;
	$sucmsg="";
	$title=htmlspecialchars($_POST['title']);
	$content=htmlspecialchars($_POST['content']);
	$content=$lang['template.strings0'].$title.$content;
	if($_POST['title']=='' and $_POST['content']==''){
		showmsg($lang['Error.strings6']);
		exit;				
	}
	$topic=$db->scalar("select title from {$dv}topic where topicid=".intval($id)."");
	$sucmsg=$ActionInfo.$lang['template.strings1'].htmlspecialchars($topic).$lang['template.strings2'].htmlspecialchars($content).$lang['template.strings3'].$allmsg."" ;
	return $sucmsg;
}
function p_delete_single_topic(){//ɾ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo,$replyid,$delupfile;
	if (-1 == $_topicInfo['isvote']) {
		$reaction = 'p_do_delete_single_argue_topic';
		$funcargs = "&amp;funcargs[]=1&amp;boardid={$boardid}&amp;replyid={$replyid}&amp;id={$id}&amp;star={$GLOBALS['star']}&page={$GLOBALS['page']}&amp;destuserid={$GLOBALS['destuserid']}";
	} else {
		$reaction = 'p_do_delete_single_topic';
		$funcargs = "&funcargs[]=1";
	}
	$delupfile = $fileconfirm = 1;
	require printout('admin_postings');
}//end function p_delete_single_topic
function p_do_delete_single_topic($funcargs){//ύɾ
	global $dv,$db,$lang,$title,$replyid,$id,$boardid,$sysusername,$master,$boardmaster,$superboardmaster,$md,$checkbox,$LogType,$sucmsg;
	$id=intval($id);
	$replyid=intval($replyid);
	$boardid=intval($boardid);
	if (!empty($funcargs) AND is_array($funcargs)) {
		$md = $funcargs[0];
	} else {
		showmsg($lang['Error.strings12']);
		exit;
	}
	//if($sysusername===true or $master===true or $superboardmaster===true or $boardmaster===true){
	if( CanDelTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	else{
		if(empty($id) or empty($replyid) or empty($boardid)){
			showmsg($lang['Error.strings1']);
			exit;
		}
		else{
			$nowusetable=$db->scalar("select posttable from {$dv}topic where topicid=".$id."");
			$sql=$db->query("select topic,username,postuserid,dateandtime,isbest,isupload from ".$nowusetable." where boardid=".$boardid." and announceid=".$replyid."");
			$arr=$db->fetch_array($sql);
			$topic=$arr['topic'];
			if(empty($arr)){
				showmsg($lang['tpl.ztgl.str10']);
				exit;			
			}
			else{
				$GLOBALS['topicUserName']= $arr['username'];
				if($topic==''){
					$topic=$lang['tpl.ztgl.str11'];
				}
				$is_nowdate=gmdate('Y-m-d',$arr['dateandtime']);
				$nowtime=gmdate("Y-m-d");
				if($is_nowdate==$nowtime){
					$todaynum=1;
				}
				else{
					$todaynum=0;
				}
				$LogType=3;
				$sucmsg=Get_RequestInfo();//õɾϢ;
				if(intval($arr['isbest'])==1){//ɾʱԶɾظ
					$sql_1=$db->query("update {$dv}topic set isbest='0' where boardid=".$boardid." and topicid=".$id."");
					$sql_2=$db->query("delete from {$dv}besttopic where announceid=".$replyid."");
				}
				$istop=$db->scalar("select istop from {$dv}topic where boardid=".$boardid." and topicid=".$id."");
				$lastpostime=$db->scalar("select max(dateandtime) as last_postime  from ".$nowusetable." where boardid=".$boardid." and rootid=".$id."");
				$sql=$db->query("update ".$nowusetable." set locktopic='{$boardid}',boardid=444 where boardid=".$boardid." and announceid=".$replyid."");
				isLastPost();//жǷΪ;
				LastCount($boardid);
				BoardNumSub($boardid,0,1,$todaynum);
				AllboardNumSub($todaynum,1,0);
				//ReloadBoardInfo($UpdateBoardID);//û
				if(intval($arr['isupload'])==1){
					if($_GET['delupfile']<>'' and intval($_GET['delupfile'])==1){						
						delupfiles($boardid,$id."|".$replyid);
					}
					else{
						$sql=$db->query("update {$dv}upfile set f_flag=4 where f_boardid=".$boardid." and f_announceid like '%".$id."|".$replyid."%'");
					}				
				}
				if(intval($istop)>1){
					$sql=$db->query("update {$dv}topic set child=child-1 where boardid=".$boardid." and topicid=".$id."");
				}
				else{
					$sql=$db->query("update {$dv}topic set child=child-1,lastposttime='".$lastpostime."' where boardid=".$boardid." and topicid=".$id."");
				}
				//$GLOBALS['topicUserName']=$lang['Action.Info']['p_delete_single_topic'];
				Insert_Forum_Log();
				if($checkbox!='checkbox'){
					Update_User_Point(",userpost=userpost-1,userdel=userdel+1");
				}
				//ɾ
				del_static_topic($boardid,$id);
				Topic_Manage_Sms();
				If (intval($md)==1){
					lastpost();
					showmsg(SucMsgInfo($sucmsg));//ɾɹصϢ;
				}
			}
		}
	}
	Create_index_forumnum();//20070523
}//end function p_do_delete_single_topic
function p_do_delete_single_argue_topic($funcargs)	//	ύɾ/ɾ۵
{
	global $dv,$db,$lang,$title,$replyid,$id,$boardid,$sysusername,$master,$boardmaster,$superboardmaster,$md,$_topicInfo,$checkbox,$LogType;
	$id=intval($id);
	$replyid=intval($replyid);
	$boardid=intval($boardid);
	if (!empty($funcargs) AND is_array($funcargs)) {
		$md = $funcargs[0];
	} else {
		showmsg($lang['Error.strings12']);
		exit;
	}
	if($sysusername===true or $master===true or $superboardmaster===true or $boardmaster===true){
		if(empty($id) or empty($replyid) or empty($boardid)){
			showmsg($lang['Error.strings1']);
			exit;
		}
		else{
			$rs =& $db->getResultSet("SELECT title, postusername, postuserid, creation_date, isbest, isupload, arguetype, parentid, argueid FROM {$dv}argue WHERE argueid='".$replyid."' AND boardid='{$boardid}'");
			if(empty($rs)){
				showmsg($lang['tpl.ztgl.str10']);
				exit;			
			}
			else{
				$argueinfo =& $rs[0];
				$GLOBALS['topicUserName']= $argueinfo['postusername'];
				unset($rs);
				$topic = $argueinfo['title'];
				if($topic==''){
					$topic=$lang['tpl.ztgl.str11'];
				}
				$is_nowdate=gmdate("Y-m-d",$argueinfo['creation_date']);
				$nowtime=gmdate("Y-m-d");
				if($is_nowdate==$nowtime){
					$todaynum=1;
				}
				else{
					$todaynum=0;
				}
				$logtype=3;
				$sucmsg=Get_RequestInfo();//õɾϢ;
				/*
				// ݲṩܣ˴˴뾫йصϢ
				//*/
				$istop = $db->scalar("SELECT istop FROM {$dv}topic WHERE boardid=".$boardid." and topicid='".$id."'");
				$lastpostime = $db->scalar("SELECT MAX(creation_date) AS last_postime FROM {$dv}argue WHERE rootid='".$id."' AND arguetype IN ('0', '1', '2', '3') AND parentid>=0 AND boardid='".$boardid."'");
				$updatefld = '';
				if (1 == intval($argueinfo['arguetype'])) {
					$updatefld .= ',child_obverse=child_obverse-1';
					if ($argueinfo['parentid'] == $argueinfo['argueid']) {
						$updatefld .= ',child_obverse_post=child_obverse_post-1';
					} else {
						$updatefld .= ',child_obverse_reply=child_obverse_reply-1';
					}
				} elseif (2 == intval($argueinfo['arguetype'])) {
					$updatefld .= ',child_reversed=child_reversed-1';
					if ($argueinfo['parentid'] == $argueinfo['argueid']) {
						$updatefld .= ',child_reversed_post=child_reversed_post-1';
					} else {
						$updatefld .= ',child_reversed_reply=child_reversed_reply-1';
					}
				} elseif (3 == intval($argueinfo['arguetype'])) {
					$updatefld .= ',child_third=child_third-1';
					if ($argueinfo['parentid'] == $argueinfo['argueid']) {
						$updatefld .= ',child_third_post=child_third_post-1';
					} else {
						$updatefld .= ',child_third_reply=child_third_reply-1';
					}
				}
				$db->query("UPDATE {$dv}argue_topic SET child=child-1{$updatefld} WHERE boardid='{$boardid}' AND rootid='{$id}'");
				$db->query("UPDATE {$dv}argue SET locktopic='{$boardid}', boardid=444 WHERE argueid='{$replyid}' AND boardid='{$boardid}'");
				if ($argueinfo['parentid'] != $argueinfo['argueid']) {
					$db->query("UPDATE {$dv}argue SET child=child-1 WHERE argueid='{$argueinfo['parentid']}' AND boardid='{$boardid}'");
				}
				isLastPost();//жǷΪ;
				LastCount($boardid);
				BoardNumSub($boardid,0,1,$todaynum);
				AllboardNumSub($todaynum,1,0);
				if(intval($arr['isupload'])==1){
					if($_GET['delupfile']<>'' and intval($_GET['delupfile'])==1){						
						delupfiles($boardid,$id."|".$replyid);
					}
					else{
						$sql=$db->query("UPDATE {$dv}upfile SET f_flag=4 WHERE f_boardid=".$boardid." AND f_announceid LIKE '%".$id."|".$replyid."%'");
					}				
				}
				if(intval($istop)>1){
					$sql=$db->query("UPDATE {$dv}topic SET child=child-1 WHERE boardid=".$boardid." AND topicid=".$id."");
				}
				else{
					$sql=$db->query("UPDATE {$dv}topic SET child=child-1,lastposttime='".$lastpostime."' WHERE boardid=".$boardid." AND topicid=".$id."");
				}
				//$GLOBALS['topicUserName']=$lang['Action.Info']['p_delete_single_argue_topic'];
				Insert_Forum_Log();
				if($checkbox!='checkbox'){
					Update_User_Point(",userpost=userpost-1,userdel=userdel+1");
				}
				//ɾ
				del_static_boards($boardid);
				Topic_Manage_Sms();
				$arguecachefile = CACHE_PATH.'argumentation/cache_'.$id.'.php';
				if (@is_file($arguecachefile)) {
					@unlink($arguecachefile);
				}
				If (intval($md)==1){
					lastpost();
					showmsg(SucMsgInfo($sucmsg));//ɾɹصϢ;
				}
			}
		}
	}
	else{
		showmsg($lang['Error.strings5']);
		exit;
	}
	Create_index_forumnum();//20070523
}//end function p_do_delete_single_argue_topic

function p_shield_single_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$dowealth,$douserep,$dousercp,$_topicInfo;
	$dowealth = $board_user[15];
	$douserep = $board_user[17];
	$dousercp = $board_user[16];
	if (-1 == $_topicInfo['isvote']) {
		if( CanAwardTopic() === false ){	//	ûǷн/ͷӵȨ
			$seldisable = ' disabled ';
		}
		if( CanLockTopic() === false ){	//	ûǷ/ӵȨ
			showmsg($lang['Error.strings5']);
			exit;
		}
		$funcargs = "&amp;replyid={$replyid}&amp;id={$id}&amp;boardid={$boardid}";
	} else {
		if( CanAwardTopic() === false ){
			$seldisable = ' disabled ';
		}
		if( CanBestTopic() === false ){
			showmsg($lang['Error.strings5']);
			exit;
		}
		Check_AnnounceInfo();
	}
	$reaction = 'p_do_shield_single_topic';
	require printout('admin_postings');
}//end function p_shield_single_topic
function p_do_shield_single_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$replyid,$lang,$fsetting,$userinfo,$arrUserToday,$tblName,$_topicInfo,$checkbox;
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 5;
	InitRequestInfo();
	if (-1 == $_topicInfo['isvote']) {
		$db->query("UPDATE {$dv}argue SET locktopic='2' WHERE argueid='{$replyid}' AND rootid='{$id}' AND boardid='{$boardid}'");
		$arguecachefile = CACHE_PATH.'argumentation/cache_'.$id.'.php';
		if (@is_file($arguecachefile)) {
			@unlink($arguecachefile);
		}
	} else {
		$db->query("UPDATE {$tblName} SET locktopic=2 WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	}
	GetUserID();
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_topic($boardid,$id);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_shield_single_topic

function GetUserID(){
	global $dv,$db,$boardid,$tblName,$replyid,$_topicInfo;
	if (-1 == $_topicInfo['isvote']) {
		$tmpRs[0]['postuerid'] = $_topicInfo['userid'];
		$tmpRs[0]['username'] = $_topicInfo['username'];
	} else {
		$tmpRs =& $db->getResultSet("SELECT postuserid,username FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	}
	if( $tmpRs !== false ){
		$_topicInfo['postuserid'] = $tmpRs[0]['postuerid'];
		$_topicInfo['postusername'] = $tmpRs[0]['username'];
		$GLOBALS['topicUserName']= $_topicInfo['postusername'];
	}
	else
		$GLOBALS['topicUserName']= '-';
}//end function GetUserID

function p_unshield_single_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$dowealth,$douserep,$dousercp;
	$dowealth = $board_user[15];
	$douserep = $board_user[17];
	$dousercp = $board_user[16];
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$reaction = 'p_do_unshield_single_topic';
	Check_AnnounceInfo();
	require printout('admin_postings');
}//end function p_unshield_single_topic
function p_do_unshield_single_topic(){//ύ
	global $db,$dv,$rootid,$boardid,$id,$replyid,$lang,$fsetting,$userinfo,$arrUserToday,$LogType,$tblName,$checkbox;
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$db->query("UPDATE {$tblName} SET locktopic=0 WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	GetUserID();
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	Topic_Manage_Sms();
	//ɾ
	del_static_topic($boardid,$id);
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_unshield_single_topic

function p_unshield_single_argue_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$dowealth,$douserep,$dousercp;
	$dowealth = $board_user[15];
	$douserep = $board_user[17];
	$dousercp = $board_user[16];
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	if( CanLockTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$reaction = 'p_do_unshield_single_argue_topic';
	$funcargs = "&amp;replyid={$replyid}&amp;id={$id}&amp;boardid={$boardid}";
	require printout('admin_postings');
}//end function p_unshield_single_topic
function p_do_unshield_single_argue_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$replyid,$lang,$fsetting,$userinfo,$arrUserToday,$tblName,$checkbox;
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$db->query("UPDATE {$dv}argue SET locktopic='0' WHERE argueid='{$replyid}' AND rootid='{$id}' AND boardid='{$boardid}'");
	GetUserID();
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_unshield_single_topic

function p_move_topic(){//ƶ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	$reaction = 'p_do_move_topic0';
	require printout('admin_postings');
}//end function p_move_topic
function p_do_move_topic0(){//ύƶ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo;
	$LogType = 3;
	InitRequestInfo();
	if (-1 == $_topicInfo['isvote']) {
		$reaction = 'p_do_move_argue_topic';
	} else {
		$reaction = 'p_do_move_topic';
	}
	//$reaction = 'p_do_move_topic';
	require printout('admin_postings.move');
}//end function p_do_move_topic
function p_do_move_topic(){//ύƶ
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday;
	global $UpdateBoardID_1,$_topicInfo,$membername,$newboardid,$boardinfo,$replyid,$checkbox;
	$LogType = 3;
	InitRequestInfo();
	if( $GLOBALS['checked'] != 'yes' ){
		return;
	}
	if( !is_numeric($newboardid) || $newboardid <= 0 ){
		showmsg($lang['Error.strings9']);
		exit;
	}
	if( $boardid == $newboardid ){
		showmsg($lang['Error.strings8']);
		exit;
	}
	if( canMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	//Ŀ̳ϼ̳ID
	$newboardInfo =& $db->getResultSet("SELECT boardtopstr,parentstr,allowpost FROM {$dv}board WHERE boardid='{$newboardid}'",array('pageSize'=>1));
	if( $newboardInfo !== false ){
		if( $newboardInfo[0]['allowpost'] == 0 ){
			showmsg($lang['Error.strings10']);
			exit;
		}
	}
	if( $_topicInfo['topicid'] != $id ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$UpdateBoardID_1 = $newboardInfo[0]['parentstr'].','.$newboardid;
	if( $GLOBALS['isdispmove'] == 'yes' ){
		$newtopic = $_POST['topic'].$db->escape_string($lang['template.strings12'].$membername.$lang['template.strings13']);
	} else{
		$newtopic = $_POST['topic'];
	}
	if( $GLOBALS['leavemessage'] == 'yes' ){
		$db->query("INSERT INTO {$dv}topic (title,boardid,postusername,postuserid,dateandtime,expression,lastpost,lastposttime,child,hits,isvote,isbest,votetotal,posttable,getmoney,usetools,getmoneytype) VALUES('{$newtopic}',{$newboardid},'".$db->escape_string($_topicInfo['postusername'])."',{$_topicInfo['postuserid']},'{$_topicInfo['dateandtime']}','".$db->escape_string($_topicInfo['expression'])."','".$db->escape_string($_topicInfo['lastpost'])."','".$_topicInfo['lastposttime']."','{$_topicInfo['child']}','{$_topicInfo['hits']}','{$_topicInfo['isvote']}','0','{$_topicInfo['votetotal']}','".$db->escape_string($GLOBALS['nowTotalUseTable'])."','{$_topicInfo['getmoney']}','".$db->escape_string($_topicInfo['usetools'])."','{$_topicInfo['getmoneytype']}')");
		//ɾ
		del_static_boards($newboardid);
	}
	//ƶȡר
	$db->query("UPDATE {$dv}topic SET mode=0 WHERE topicid='{$id}'");
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where topicid={$id}");
	if( $GLOBALS['leavemessage'] == 'yes' ){
		$db->query("UPDATE {$dv}topic SET locktopic=1 WHERE topicid='{$id}'");
		$newparentID = $db->scalar("SELECT MAX(topicid) FROM {$dv}topic WHERE boardid='{$newboardid}'");
		$db->query("DROP TEMPORARY TABLE IF EXISTS tmptbl1234567890");
		$db->query("CREATE TEMPORARY TABLE tmptbl1234567890 SELECT '{$newboardid}',parentid,username,topic,body,dateandtime,length,'{$newparentID}',layer,orders,ip,expression,locktopic,signflag,emailflag,0,postuserid,ubblist,getmoney,usetools,getmoneytype,postbuyuser FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' AND boardid<>444 AND boardid <>777 and forumtype=0 ORDER BY announceid");
		$db->query("INSERT INTO ".$db->escape_string($GLOBALS['nowTotalUseTable'])."(boardid,parentid,username,topic,body,dateandtime,length,rootid,layer,orders,ip,expression,locktopic,signflag,emailflag,isbest,postuserid,ubbList,getmoney,usetools,getmoneytype,postbuyuser) SELECT * FROM tmptbl1234567890");
		$db->query("DROP TEMPORARY TABLE IF EXISTS tmptbl1234567890");
		$id = $newparentID;
	} elseif( $GLOBALS['leavemessage'] == 'no' ){
		if( $GLOBALS['isdispmove'] == 'yes' ){
			$newtopic = $db->escape_string($GLOBALS['topic']).$lang['template.strings12'].$membername.$lang['template.strings13'];
		} else{
			$newtopic = $db->escape_string($GLOBALS['topic']);
		}
		//ƶҲʱԶ
		if( intval($_topicInfo['isbest']) == 1 ){
			$db->query("UPDATE {$dv}topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE topicid='{$id}'");
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET topic='{$newtopic}',isbest='0' WHERE announceid='{$replyid}'");
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET boardid='{$newboardid}',isbest='0' WHERE rootid='{$id}' AND  boardid<>444 AND boardid<>777 and forumtype=0");
			$db->query("DELETE FROM {$dv}besttopic WHERE rootid='{$id}'");
			//»վеĸԭ
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET locktopic='{$newboardid}' WHERE rootid='{$id}' AND (boardid=444 OR boardid=777) and forumtype=0");
		} else{
			$db->query("UPDATE {$dv}topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE topicid='{$id}'");
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET topic='{$newtopic}' WHERE announceid='{$replyid}'");
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET boardid='{$newboardid}' WHERE rootid='{$id}' AND boardid<>444 AND boardid<>777 and forumtype=0");
			//»վеĸԭ
			$db->query("UPDATE ".$db->escape_string($_topicInfo['posttable'])." SET locktopic='{$newboardid}' WHERE rootid='{$id}' AND (boardid=444 OR boardid=777) and forumtype=0");
		}
		//ƶʱжǷ̶ش
		if( $_topicInfo['istop'] > 0 ){
			//ȡ¾ɰĹ̶Ϣ
			$boardtopstr = $boardinfo['boardtopstr'];
			$newboardtopstr = $newboardInfo[0]['boardtopstr'];
			//ɾԭ̶ID
			$tmpTopicID = $_topicInfo['topicid'];
			$boardtopstr = str_replace($tmpTopicID,'',str_replace(','.$tmpTopicID,'',str_replace($tmpTopicID.',','',$boardtopstr)));
			if( $newboardtopstr == '' || is_null($newboardtopstr) ){
				$newboardtopstr = $tmpTopicID;
			} elseif( $newboardtopstr != $tmpTopicID && strpos($newboardtopstr,','.$tmpTopicID) === false ){
				$newboardtopstr .= ','.$tmpTopicID;
			}
			//µǰ̶Ϣ
			$db->query("UPDATE {$dv}board SET boardtopstr='".$db->escape_string($boardtopstr)."' WHERE boardid={$boardid}");
			//°̶Ϣ
			$db->query("UPDATE {$dv}board SET boardtopstr='".$db->escape_string($newboardtopstr)."' WHERE boardid={$newboardid}");
		}
		//ƶϴļ
		$F_announceID = $id.'|';
		$db->query("UPDATE {$dv}upfile SET f_readme='".$db->escape_string($newtopic)."',f_boardid={$newboardid} WHERE f_announceid LIKE '{$F_announceID}%'");
	} else{
		showmsg($lang['Error.strings11']);
		exit;
	}
	//ӵĻظͳƶӦ
	$postNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' AND boardid<>444 AND boardid<>777 and forumtype=0");
	//нջظ,8.6ɾboardid<>444 and boardID <>777
	$todayNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' AND dateandtime>='".TIME_NOW."' AND boardid<>444 AND boardid<>777 and forumtype=0");
	//Start ̳
	LastCount($boardid);
	BoardNumSub($boardid,1,$postNum,$todayNum);
	global $UpdateBoardID;
	$UpdateBoardID = $UpdateBoardID_1;
	LastCount($newboardid);
	BoardNumSub($newboardid,1,$postNum,$todayNum);
	//End ̳
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_move_topic'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	//ɾ
	del_static_topic($boardid,$id);
	del_static_boards($boardid);
	Topic_Manage_Sms();
	$boardid = $newboardid;
	$boardcache =& new BoardCache($db);
	$boardcache->createAll();
	$boardcache->createForumSetting();
	unset($boardcache);
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_move_topic
function p_do_move_argue_topic()	//	//ύƶ
{
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday;
	global $UpdateBoardID_1,$_topicInfo,$membername,$newboardid,$boardinfo,$replyid,$checkbox;
	$LogType = 3;
	InitRequestInfo();
	if( $GLOBALS['checked'] != 'yes' ){
		return;
	}
	if( !is_numeric($newboardid) || $newboardid <= 0 ){
		showmsg($lang['Error.strings9']);
		exit;
	}
	if( $boardid == $newboardid ){
		showmsg($lang['Error.strings8']);
		exit;
	}
	if( canMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	//Ŀ̳ϼ̳ID
	$newboardInfo =& $db->getResultSet("SELECT boardtopstr,parentstr,allowpost FROM {$dv}board WHERE boardid='{$newboardid}'",array('pageSize'=>1));
	if( $newboardInfo !== false ){
		if( $newboardInfo[0]['allowpost'] == 0 ){
			showmsg($lang['Error.strings10']);
			exit;
		}
	}
	if( $_topicInfo['topicid'] != $id ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$UpdateBoardID_1 = $newboardInfo[0]['parentstr'].','.$newboardid;
	if( $GLOBALS['isdispmove'] == 'yes' ){
		$newtopic = $_POST['topic'].$db->escape_string($lang['template.strings12'].$membername.$lang['template.strings13']);
	} else{
		$newtopic = $_POST['topic'];
	}
	$arguecachefile = CACHE_PATH.'argumentatoin/cache_'.$id.'.php';
	if (@is_file($arguecachefile)) {
		@unlink($arguecachefile);
	}
	if( $GLOBALS['leavemessage'] == 'yes' ){
		$db->query("INSERT INTO {$dv}topic(title,boardid,postusername,postuserid,dateandtime,expression,lastpost,lastposttime,child,hits,isvote,isbest,votetotal,posttable,getmoney,usetools,getmoneytype) SELECT '{$newtopic}',{$newboardid},postusername,postuserid,dateandtime,expression,lastpost,lastposttime,child,hits,isvote,isbest,votetotal,posttable,getmoney,usetools,getmoneytype FROM {$dv}topic WHERE topicid='{$id}' AND boardid='{$boardid}'");
		$newtopicid = $db->insert_id();
		$db->query("DROP TEMPORARY TABLE IF EXISTS __dv_argue_topic_do_move");
		$db->query("CREATE TEMPORARY TABLE __dv_argue_topic_do_move SELECT * FROM {$dv}argue_topic WHERE boardid='{$boardid}' AND rootid='{$id}'");
		$db->query("UPDATE __dv_argue_topic_do_move SET boardid='{$newboardid}', rootid='{$newtopicid}'  WHERE boardid='{$boardid}' AND rootid='{$id}'");
		$db->query("INSERT INTO {$dv}argue_topic SELECT * FROM __dv_argue_topic_do_move WHERE boardid='{$newboardid}' AND rootid='{$newtopicid}'");
		$db->query("DROP TEMPORARY TABLE IF EXISTS __dv_argue_topic_do_move");
		//ɾ
		del_static_boards($newboardid);
	}
	//ƶȡר
	$db->query("UPDATE {$dv}topic SET mode=0 WHERE topicid='{$id}'");
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where topicid={$id}");
	if( $GLOBALS['leavemessage'] == 'yes' ){
		$db->query("UPDATE {$dv}topic SET locktopic=1 WHERE topicid='{$id}'");
		$newparentID = $db->scalar("SELECT MAX(argueid) FROM {$dv}argue");
		$db->query("DROP TEMPORARY TABLE IF EXISTS __tmptbl1234567890");
		$db->query("CREATE TEMPORARY TABLE __tmptbl1234567890 SELECT '{$newboardid}',{$newtopicid},arguetype,{$newparentID},child,vote,expression,title,content,creation_date,postusername,postuserid,ip,length,locktopic,ubblist,isbest,isupload,voteid FROM {$dv}argue WHERE boardid='{$boardid}' AND rootid='{$id}'");
		$db->query("INSERT INTO {$dv}argue(boardid,rootid,arguetype,parentid,child,vote,expression,title,content,creation_date,postusername,postuserid,ip,length,locktopic,ubblist,isbest,isupload,voteid) SELECT * FROM __tmptbl1234567890");
		$db->query("DROP TEMPORARY TABLE IF EXISTS __tmptbl1234567890");
		//$id = $newparentID;
		$id = $newtopicid;
	} elseif( $GLOBALS['leavemessage'] == 'no' ){
		if( $GLOBALS['isdispmove'] == 'yes' ){
			$newtopic = $db->escape_string($GLOBALS['topic']).$lang['template.strings12'].$membername.$lang['template.strings13'];
		} else{
			$newtopic = $db->escape_string($GLOBALS['topic']);
		}
		//ƶҲʱԶ
		if( intval($_topicInfo['isbest']) == 1 ){
			$db->query("UPDATE {$dv}topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE topicid='{$id}'");
			$db->query("UPDATE {$dv}argue_topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE boardid='{$boardid}' AND rootid='{$id}'");
			$db->query("UPDATE {$dv}argue SET title='{$newtopic}',isbest='0' WHERE argueid='{$replyid}'");
			$db->query("UPDATE {$dv}argue SET boardid='{$newboardid}',isbest='0' WHERE boardid<>444 AND boardid<>777 AND rootid='{$id}'");
			$db->query("DELETE FROM {$dv}besttopic WHERE rootid='{$id}'");
			//»վеĸԭ
			$db->query("UPDATE {$dv}argue SET locktopic='{$newboardid}' WHERE rootid='{$id}' AND (boardid=444 OR boardid=777)");
		} else{
			$db->query("UPDATE {$dv}topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE topicid='{$id}'");
			$db->query("UPDATE {$dv}argue_topic SET title='{$newtopic}',boardid='{$newboardid}',isbest='0' WHERE boardid='{$boardid}' AND rootid='{$id}'");
			$db->query("UPDATE {$dv}argue SET title='{$newtopic}' WHERE argueid='{$replyid}'");
			$db->query("UPDATE {$dv}argue SET boardid='{$newboardid}' WHERE boardid<>444 AND boardid<>777 AND rootid='{$id}'");
			//»վеĸԭ
			$db->query("UPDATE {$dv}argue SET locktopic='{$newboardid}' WHERE (boardid=444 OR boardid=777) AND rootid='{$id}'");
		}
		//ƶʱжǷ̶ش
		if( $_topicInfo['istop'] > 0 ){
			//ȡ¾ɰĹ̶Ϣ
			$boardtopstr = $boardinfo['boardtopstr'];
			$newboardtopstr = $newboardinfo['boardtopstr'];
			//ɾԭ̶ID
			$tmpTopicID = $_topicInfo['topicid'];
			$boardtopstr = str_replace($tmpTopicID,'',str_replace(','.$tmpTopicID,'',str_replace($tmpTopicID.',','',$boardtopstr)));
			if( $newboardtopstr == '' || is_null($newboardtopstr) ){
				$newboardtopstr = $tmpTopicID;
			} elseif( $newboardtopstr != $tmpTopicID && strpos($newboardtopstr,','.$tmpTopicID) === false ){
				$newboardtopstr .= ','.$tmpTopicID;
			}
			//µǰ̶Ϣ
			$db->query("UPDATE {$dv}board SET boardtopstr='".$db->escape_string($boardtopstr)."' WHERE boardid={$boardid}");
			//°̶Ϣ
			$db->query("UPDATE {$dv}board SET boardtopstr='".$db->escape_string($newboardtopstr)."' WHERE boardid={$newboardid}");
			//Dvbbs.LoadBoardinformation  Dvbbs.Boardid
			//Dvbbs.LoadBoardinformation Newboardid
		}
		//ƶϴļ
		$F_announceID = $id.'|';
		$db->query("UPDATE {$dv}upfile SET f_readme='".$db->escape_string($newtopic)."',f_boardid={$newboardid} WHERE f_announceid LIKE '{$F_announceID}%'");
	} else{
		showmsg($lang['Error.strings11']);
		exit;
	}
	//ӵĻظͳƶӦ
	$postNum = $db->scalar("SELECT COUNT(1) FROM {$dv}argue WHERE boardid<>444 AND boardid<>777 AND rootid='{$id}'");
	//$count2 = $db->scalar("SELECT COUNT(1) FROM {$dv}argue WHERE rootid='{$id}'");
	//нջظ,8.6ɾboardid<>444 and boardID <>777
	$today_star = dv_gmtimestamp(gmdate('Y-m-d 00:00:00'));
	$today_end = dv_gmtimestamp(gmdate('Y-m-d 23:59:59'));
	$todayNum = $db->scalar("SELECT COUNT(1) FROM {$dv}argue WHERE boardid<>444 AND boardid<>777 AND rootid='{$id}' AND (creation_date BETWEEN {$today_star} AND {$today_end})");
	//Start ̳
	LastCount($boardid);
	BoardNumSub($boardid,1,$postNum,$todayNum);
	global $UpdateBoardID;
	$UpdateBoardID = $UpdateBoardID_1;
	LastCount($newboardid);
	BoardNumSub($newboardid,1,$postNum,$todayNum);
	//End ̳
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_move_argue_topic'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	Topic_Manage_Sms();
	$boardid = $newboardid;
	$boardcache =& new BoardCache($db);
	$boardcache->createAll();
	$boardcache->createForumSetting();
	unset($boardcache);
	//ɾ
	del_static_topic($boardid,$id);
	del_static_boards($boardid);
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_move_argue_topic

function p_placed_top_argue_topic(){//̶
	global $lang,$LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( CanTopTopic() === false && CanTopTopic_a() === false && CanTopTopic_m() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_placed_top_argue_topic0';
	require printout('admin_postings');
}//end function p_placed_top_argue_topic
function p_do_placed_top_argue_topic0(){//ύ̶ӡ̶ӣ̶̶ܹ͹̶
	if( CanTopTopic() === false && CanTopTopic_a() === false && CanTopTopic_m() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday;
	global $UpdateBoardID_1,$_topicInfo,$membername,$newboardid,$boardinfo,$replyid,$boardinfo;
	$LogType = 4;
	InitRequestInfo();
	$Body = $db->scalar("SELECT body FROM ".$db->escape_string($GLOBALS['nowTotalUseTable'])." WHERE boardid='{$boardid}' AND rootid='{$id}' AND parentid=0");
	if( $Body ){
		$content = substr(htmlspecialchars($Body),0,250).'...';
	}
	require printout('admin_postings.toptopic');
}//end function p_do_placed_top_argue_topic0

function p_placed_top_topic(){//̶
	global $lang,$LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	if( CanTopTopic() === false && CanTopTopic_a() === false && CanTopTopic_m() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_placed_top_topic0';
	require printout('admin_postings');
}//end function p_placed_top_topic
function p_do_placed_top_topic0(){//ύ̶ӡ̶ӣ̶̶ܹ͹̶
	if( CanTopTopic() === false && CanTopTopic_a() === false && CanTopTopic_m() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday;
	global $UpdateBoardID_1,$_topicInfo,$membername,$newboardid,$boardinfo,$replyid,$boardinfo;
	$LogType = 4;
	InitRequestInfo();
	$Body = $db->scalar("SELECT body FROM ".$db->escape_string($GLOBALS['nowTotalUseTable'])." WHERE boardid='{$boardid}' AND rootid='{$id}' AND parentid=0");
	if( $Body ){
		$content = substr(htmlspecialchars($Body),0,250).'...';
	}
	require printout('admin_postings.toptopic');
}//end function p_do_placed_top_topic0
function p_do_placed_top_topic(){//ύ̶ӡ̶ӣ̶̶ܹ͹̶
	global $checkbox;
	if( CanTopTopic() === false && CanTopTopic_a() === false && CanTopTopic_m() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday,$_POST;
	global $UpdateBoardID_1,$_topicInfo,$membername,$newboardid,$boardinfo,$replyid,$usergroupid,$getboard;
	$LogType = 4;
	InitRequestInfo();
	//ȼǰҪжǷиðĹȨ
	//ԭǹ̶̶̶ܹжǷҪ
	$IsTop = $db->scalar("SELECT istop FROM {$dv}topic WHERE topicid='{$id}'");
	//̶ܹҪ
	if( $IsTop == 3 && $GLOBALS['alltop'] == '' && CanTopTopic_a() === true ){
		$db->query("UPDATE {$dv}topic SET istop=0 WHERE boardid='{$boardid}' AND topicid='{$id}'");
		$IsTop = 0;
		//̶ܹIDñȥ
		$forum_alltopnum = $db->scalar("SELECT forum_alltopnum FROM {$dv}setup",array('pageSize'=>1));
		$forum_alltopnum = str_replace("{$id},", '', "{$forum_alltopnum},");
		if ($forum_alltopnum != '') {
			$forum_alltopnum = substr($forum_alltopnum, 0, -1);
		}
		$db->query("UPDATE {$dv}setup SET forum_alltopnum='{$forum_alltopnum}'");
		del_static_boards_all($db);
	}
	//й̶Ҫ
	if( $IsTop == 1 && empty($getboard) && CanTopTopic() === true ){
		$db->query("UPDATE {$dv}topic SET istop=0 WHERE boardid='{$boardid}' AND topicid='{$id}'");
		$IsTop = 0;
		//ӦеID
		if( empty($boardinfo) ){
			$tmpRs =& $db->getResultSet("SELECT boardid,boardtopstr FROM {$dv}board WHERE boardid='{$boardid}'",array('pageSize'=>1));
			if( $tmpRs !== false ){
				$boardinfo =& $tmpRs[0];
				unset($tmpRs);
			}
		}
		if( !empty($boardinfo) ){
			if( $boardinfo['boardtopstr'].'' === '' ){
				$iBoardTopStr = '';
			} else{
				if( strpos(",{$boardinfo['boardtopstr']},",",{$id},") !== false ){
					$iBoardTopStr = str_replace("{$id},", '', "{$boardinfo['boardtopstr']},");
					if ($iBoardTopStr != '') {
						$iBoardTopStr = substr($iBoardTopStr, 0, -1);
					}
				} else{
					$iBoardTopStr = $boardinfo['boardtopstr'];
				}
			}
			$db->query("UPDATE {$dv}board SET boardtopstr='{$iBoardTopStr}' WHERE boardid='{$boardid}'");
			//ɾ
			del_static_board($boardid);
			del_static_boards($boardid);
		}
	}
	//̶Ҫ
	if( $IsTop == 2 && CanTopTopic_m() === true ){
		//صgetboardΪգѾ̶ӦкиIDİ
		if( empty($getboard) ){
			$db->query("UPDATE {$dv}topic SET istop=0 WHERE boardid='{$boardid}' AND topicid='{$id}'");
			$IsTop = 0;
			$db->query("UPDATE {$dv}board SET boardtopstr=REPLACE(REPLACE(REPLACE(boardtopstr, ',{$id},' , ',' ) , ',{$id}' , '') , '{$id},' , '') WHERE CONCAT(',',boardtopstr,',') LIKE'%,{$id},%'");
		} else{
			//صgetboardΪգӦԭиIDҲڷصgetboardİĸID
			//ͬʱжϣûԭ̶Ϊ̶ܹȡбеİ棬ӦIDӦİ
			if( $_POST['alltop'] == 1 ){
				$db->query("UPDATE {$dv}topic SET istop=0 WHERE boardid='{$boardid}' AND topicid='{$id}'");
				$IsTop = 0;
				$db->query("UPDATE {$dv}board SET boardtopstr=REPLACE(REPLACE(REPLACE(boardtopstr, ',{$id},' , ',' ) , ',{$id}' , '') , '{$id},' , '') WHERE CONCAT(',',boardtopstr,',') LIKE'%,{$id},%'");
			} else{
				$getBoardIDList = implode(',',$getboard);
				if( !checkIDList($getBoardIDList) ){
					showmsg($lang['Error.strings12']);
					exit;
				}
				$db->query("UPDATE {$dv}board SET boardtopstr=REPLACE(REPLACE(REPLACE(boardtopstr, ',{$id},' , ',' ) , ',{$id}' , '') , '{$id},' , '') WHERE boardid NOT IN({$getBoardIDList}) AND CONCAT(',',boardtopstr,',') LIKE'%,{$id},%'");
				//ѡǰ棬ȡ̶ԭΪ̶ѡ
				if( count($getboard) === 1 && $getboard[0] == $boardid ){
					$db->query("UPDATE {$dv}topic SET istop=1 WHERE boardid='{$boardid}' AND topicid='{$id}'");
					$IsTop = 1;
				}
			}
		}
		//ɾ
		del_static_boards_all($db);
	}
	//̶ܹ
	$TimeAdd = 0;
	if( $_POST['alltop'] == 1 && CanTopTopic_a() === true ){
		$db->query("UPDATE {$dv}topic SET istop=3 WHERE boardid='{$boardid}' AND topicid='{$id}'");
		//̶ܹIDñ
		$forum_alltopnum = $db->scalar("SELECT forum_alltopnum FROM {$dv}setup",array('pageSize'=>1));
		if( strpos(",$forum_alltopnum,",",{$id},") === false ){
			if( $forum_alltopnum == '' ){
				$forum_alltopnum = $id;
			} else{
				$forum_alltopnum .= ",{$id}";
			}
			$db->query("UPDATE {$dv}setup SET forum_alltopnum='{$forum_alltopnum}'");
		}
		del_static_boards_all($db);
	} else{
		if( !empty($getboard) ){
			//ѡ
			if( count($getboard) === 1 && CanTopTopic() === true ){
				if ($getboard[0] == $boardid) {	//	ǰ̶
					$query = $db->query("UPDATE {$dv}board SET boardtopstr=(CASE WHEN boardtopstr IS NULL OR boardtopstr='' THEN '{$id}' WHEN CONCAT(',',boardtopstr,',') LIKE '%,{$id},%' THEN boardtopstr ELSE CONCAT(boardtopstr,',','{$id}') END) WHERE boardid='{$boardid}'");
					//ɾ
					del_static_board($boardid);
					$i = $db->affected_rows($query);
					$db->query("UPDATE {$dv}topic SET istop=1 WHERE boardid='{$boardid}' AND topicid='{$id}'");
				} else {	//	̶
					$boardtopstr = trim($db->scalar("SELECT boardtopstr FROM {$dv}board  WHERE boardid='{$boardid}'"));
					if ($boardtopstr !== '') {
						if (strpos("{$boardtopstr},", "{$id},") !== false) {
							$boardtopstr = str_replace("{$id},", '', $boardtopstr);
							if ($boardtopstr !== '') {
								$boardtopstr = substr($boardtopstr, 0, -1);
								$query = $db->query("UPDATE {$dv}board SET boardtopstr='".$db->escape_string($boardtopstr)."' WHERE boardid='{$boardid}'");
								//ɾ
								del_static_board($boardid);
								$i = $db->affected_rows($query);
							}
						}
					}
					$query = $db->query("UPDATE {$dv}board SET boardtopstr=(CASE WHEN boardtopstr IS NULL OR boardtopstr='' THEN '{$id}' WHEN CONCAT(',',boardtopstr,',') LIKE '%,{$id},%' THEN boardtopstr ELSE CONCAT(boardtopstr,',','{$id}') END) WHERE boardid='{$getboard[0]}'");

					//ɾ
					del_static_board($getboard[0]);
					$i = $db->affected_rows($query);
					$db->query("UPDATE {$dv}topic SET istop=1 WHERE boardid='{$getboard[0]}' AND topicid='{$id}'");
				}
			} else {
				/**
				 * ѡ̶ڵǰ̶еѡ
				 * ﲻжϵǰûȨ
				 * ΪֻҪûȨ޻ûȨжԵǰ̶ȨޣĬΪӹ̶
				 */
				$getBoardIDList = implode(',',$getboard);
				if( !checkIDList($getBoardIDList) ){
					showmsg($lang['Error.strings12']);
					exit;
				}
				if( CanTopTopic() === true || CanTopTopic_m() === true ){
					$query = $db->query("UPDATE {$dv}board SET boardtopstr=(CASE WHEN boardtopstr IS NULL OR boardtopstr='' THEN '{$id}' WHEN CONCAT(',',boardtopstr,',') LIKE '%,{$id},%' THEN boardtopstr ELSE CONCAT(boardtopstr,',','{$id}') END) WHERE boardid IN(".$getBoardIDList.','.$boardid.")");

					//ɾ
					del_static_boards($getBoardIDList.','.$boardid);
					$i = $db->affected_rows($query);
				}
				if( $i > 0 ){
					if( CanTopTopic_m() === true ){
						$db->query("UPDATE {$dv}topic SET istop=2 WHERE boardid='{$boardid}' AND topicid='{$id}'");
					} elseif( CanTopTopic() === true ){
						$db->query("UPDATE {$dv}topic SET istop=1 WHERE boardid='{$boardid}' AND topicid='{$id}'");
					}
				}
			}
		}
	}
	global $sucmsg,$lang,$action;
	$sucmsg = $lang['ActionInfo'][$action].$lang['template.strings1'].htmlspecialchars($GLOBALS['content']).$lang['template.strings2'];
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_placed_top_topic'];
	$GLOBALS['topicUserName']= $db->scalar("select postusername from {$dv}topic Where boardid={$boardid} And topicid={$id}");
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	Topic_Manage_Sms();
	$boardcache =& new BoardCache($db);
	$boardcache->createAll();
	$boardcache->createForumSetting();
	unset($boardcache);
	showmsg(SucMsgInfo($sucmsg));
}//end function p_do_placed_top_topic

function p_set_best_topic(){//Ϊ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$dowealth,$douserep,$dousercp;
	$dowealth = $board_user[15];
	$douserep = $board_user[17];
	$dousercp = $board_user[16];
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_set_best_topic';
	Check_AnnounceInfo();
	require printout('admin_postings');
}//end function p_set_best_topic
function p_do_set_best_topic(){//ύΪ
	global $dv,$db,$lang,$boardid,$replyid,$id,$tblName,$_topicInfo,$checkbox,$LogType;
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$tmpRs =& $db->getResultSet("SELECT announceid,parentid,boardid,username,postuserid,topic,body,dateandtime,length,rootid,layer,orders,isbest,ip,expression,locktopic,signflag,emailflag,isagree,isaudit,isupload,postbuyuser,ubblist,getmoney,usetools,getmoneytype FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$_topicInfo['title'] = $tmpRs[0]['topic'];
	$_topicInfo['postusername'] = $tmpRs[0]['username'];
	$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
	if( $_topicInfo['title'] == '' ){
		$_topicInfo['title'] = substr(str_replace(chr(10),',',$tmpRs[0]['body']),0,26);
	}
	$strDateTime = TIME_NOW;
	$db->query("UPDATE {$tblName} SET isbest='1' WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	$db->query("UPDATE {$dv}topic SET isbest='1' WHERE boardid='{$boardid}' AND topicid='{$id}'");
	$db->query("INSERT INTO {$dv}besttopic(title,boardid,announceid,rootid,postusername,postuserid,dateandtime,expression) VALUES('".$db->escape_string($_topicInfo['title'])."',{$tmpRs[0]['boardid']},{$tmpRs[0]['announceid']},". $tmpRs[0]['rootid'].",'".$db->escape_string($_topicInfo['postusername'])."',".$tmpRs[0]['postuserid'].",'{$strDateTime}','".$db->escape_string($tmpRs[0]['expression'])."')");
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_set_best_topic'];
	$GLOBALS['topicUserName']= $_topicInfo['postusername'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point(',userisbest=userisbest+1');
	}
	//ɾ
	del_static_topic($boardid,$id);
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_set_best_topic

function p_unset_best_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$board_user,$dowealth,$douserep,$dousercp;
	$dowealth = $board_user[15];
	$douserep = $board_user[17];
	$dousercp = $board_user[16];
	if( CanAwardTopic() === false ){
		$seldisable = ' disabled ';
	}
	$reaction = 'p_do_unset_best_topic';
	Check_AnnounceInfo();
	require printout('admin_postings');
}//end function p_unset_best_topic
function p_do_unset_best_topic(){//ύ
	global $dv,$db,$lang,$boardid,$replyid,$id,$tblName,$_topicInfo,$checkbox,$LogType;
	if( CanBestTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	$tmpRs =& $db->getResultSet("SELECT announceid,parentid,boardid,username,postuserid,topic,body,dateandtime,length,rootid,layer,orders,isbest,ip,expression,locktopic,signflag,emailflag,isagree,isaudit,isupload,postbuyuser,ubblist,getmoney,usetools,getmoneytype FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$_topicInfo['title'] = $tmpRs[0]['topic'];
	$_topicInfo['postusername'] = $tmpRs[0]['username'];
	$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
	if( $_topicInfo['title'] == '' ){
		$_topicInfo['title'] = substr(str_replace(chr(10),',',$tmpRs[0]['body']),0,26);
	}
	$strDateTime = TIME_NOW;
	$db->query("UPDATE {$tblName} SET isbest='0' WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	$db->query("UPDATE {$dv}topic SET isbest='0' WHERE boardid='{$boardid}' AND topicid='{$id}'");
	$db->query("DELETE FROM {$dv}besttopic WHERE announceid='{$replyid}'");
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_unset_best_topic'];
	$GLOBALS['topicUserName']= $_topicInfo['postusername'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point(',userisbest=userisbest-1');
	}
	//ɾ
	del_static_topic($boardid,$id);
	del_static_board($boardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_unset_best_topic

function p_copy_topic(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday;
	$reaction = 'p_do_copy_topic0';
	require printout('admin_postings');
}//end function p_copy_topic
function p_do_copy_topic0(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo,$replyid;
	if( canMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 3;
	InitRequestInfo();
	//$reaction = 'p_do_move_topic';
	require printout('admin_postings.copy');
}//end function p_do_copy_topic0
function p_do_copy_topic(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo,$UpdateBoardID,$replyid,$_POST,$membername,$checkbox;
	if( $boardid == $newboardid ){
		showmsg($lang['Error.strings8']);
		exit;
	} elseif( !is_numeric($newboardid) ){
		showmsg($lang['Error.strings1']);
		exit;
	}
	if( $GLOBALS['checked'] !== 'yes' ){
		showmsg($lang['Error.strings12']);
		exit;
	}
	if( canMoveTopic() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$tmpRs =& $db->getResultSet("SELECT topic,username,postuserid FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$GLOBALS['topicUserName']= $tmpRs[0]['username'];
	if( $tmpRs['topic'].'' === '' ){
		$tmpRs['topic'] = $lang['template.strings15'];
	}
	$LogType = 3;
	InitRequestInfo();
	$postNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' and forumtype=0");
	$todayNum = $db->scalar("SELECT COUNT(1) FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE rootid='{$id}' AND  dateandtime>'".TIME_NOW."' and forumtype=0");
	//Ŀ̳ϼ̳ID
	$tmpRs2 =& $db->getResultSet("SELECT parentstr,allowpost FROM {$dv}board WHERE boardid='{$newboardid}'");
	if( $tmpRs2 === false ){
		showmsg($lang['Error.strings13']);
		exit;
	}
	$destBoardInfo =& $tmpRs2[0];
	if( $destBoardInfo['allowpost'] == 0 ){
		showmsg($lang['Error.strings10']);
		exit;
	}
	$UpdateBoardID = $destBoardInfo['parentstr'].','.$newboardid;
	$tmp =& $db->scalar("SELECT boardid FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE announceid='{$replyid}' AND boardid='{$boardid}'");
	if( !is_numeric($tmp) || $tmp <= 0 ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$tmpRs2 =& $db->getResultSet("SELECT announceid,parentid,boardid,username,postuserid,topic,body,dateandtime,length,rootid,layer,orders,isbest,ip,expression,locktopic,signflag,emailflag,isagree,isaudit,isupload,postbuyuser,ubblist,getmoney,usetools,getmoneytype FROM ".$db->escape_string($_topicInfo['posttable'])." WHERE announceid='{$replyid}'",array('pageSize'=>1));
	if( $tmpRs2 === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$resultSet =& $tmpRs2[0];
	if( $GLOBALS['isdispmove'] === 'yes' ){
		$newtopic = $_POST['topic'].$db->escape_string($lang['template.strings12'].$membername.$lang['template.strings16']);
	} else{
		$newtopic = $_POST['topic'];
	}
	$nowDate = TIME_NOW;
	$db->query("INSERT INTO {$dv}topic(title,boardid,postusername,postuserid,dateandtime,expression,lastpost,lastposttime,child,hits,isvote,isbest,votetotal,posttable) VALUES('{$newtopic}','{$newboardid}','".$db->escape_string($resultSet['username'])."','".$resultSet['postuserid']."','".$nowDate."','".$db->escape_string($resultSet['expression'])."','".$db->escape_string($resultSet['username'])."$#$".$nowDate."$$$$','".$nowDate."',0,0,0,'0',0,'".$db->escape_string($GLOBALS['nowTotalUseTable'])."')");
	$maxTopicID = $db->scalar("SELECT MAX(topicid) FROM {$dv}topic WHERE boardid='{$newboardid}' AND postuserid='{$resultSet['postuserid']}'");
	if( $maxTopicID <= 0 ){
		$maxTopicID = 1;
	}
	$db->query("INSERT INTO ".$db->escape_string($GLOBALS['nowTotalUseTable'])."(boardid,parentid,username,topic,body,dateandtime,length,rootid,layer,orders,ip,expression,locktopic,signflag,emailflag,isbest,postuserid,ubbList) VALUES('{$newboardid}',0,'".$db->escape_string($resultSet['username'])."','{$newtopic}','".$db->escape_string($resultSet['body'])."','".$db->escape_string($resultSet['dateandime'])."','".$db->escape_string($resultSet['length'])."','{$maxTopicID}',1,0,'".$db->escape_string($resultSet['ip'])."','".$db->escape_string($resultSet['expression'])."','".$db->escape_string($resultSet['locktopic'])."','".$db->escape_string($resultSet['signflag'])."','".$db->escape_string($resultSet['emailflag'])."','0',".$db->escape_string($resultSet['postuserid']).",'".$db->escape_string($resultSet['ubblist'])."')");
	//ƶϴļ
	$F_announceID = $id.'|' .$replyid;
	$db->query("UPDATE {$dv}upfile SET f_readme='{$newtopic}',f_boardid='{$newboardid}' WHERE f_announceid='{$F_announceID}'");
	//̳	
	Create_index_forumnum();//20070523
	LastCount($newboardid);
	BoardNumAdd($newboardid,1,$postNum,$todayNum);
	AllboardNumAdd($todayNum,$postNum,1);
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_unset_best_topic'];
	Insert_Forum_Log();
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}

	//ɾ
	del_static_topic($newboardid,$newtopic);
	del_static_board($newboardid);
	Topic_Manage_Sms();
	showmsg(SucMsgInfo($GLOBALS['sucmsg']));
}//end function p_do_copy_topic

function p_reward_money(){//
	global $LogType,$db,$dv,$id,$boardid,$lang,$fsetting,$userinfo,$arrUserToday,$master;
	if( ChkRewardMoney() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( $master === false ){
	} else{
	}
	$reaction = 'p_do_reward_money';
	require printout('admin_postings');
}//end function p_reward_money
function p_do_reward_money(){//ύ
	global $LogType,$db,$dv,$id,$boardid,$newboardid,$lang,$fsetting,$userinfo,$arrUserToday,$_topicInfo,$UpdateBoardID,$replyid;
	global $givemoney,$_POST,$membername,$master,$tblName,$userid,$sucmsg,$checkbox;
	if( $master === false && $arrUserToday[4] > $fsetting['boardmaster_moneylimited'] ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	if( ChkRewardMoney() === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
	$LogType = 5;
	InitRequestInfo();
	if( !is_numeric($givemoney) ) $givemoney = 0;
	if( $givemoney < 0 ){
		$ReAct = 1;
		$givemoney = abs($givemoney);
	} else{
		$ReAct = 0;
	}
	$tmpRs =& $db->getResultSet("SELECT topic,username,postuserid,isagree,getmoney FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$GLOBALS['topicUserName']= $tmpRs[0]['username'];
	$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
	if( $_topicInfo['postuserid'] == $userid ){
		showmsg($lang['Error.strings14']);
		exit;
	}
	$_topicInfo['title'] = !$tmpRs[0]['topic'] ? $lang['template.strings15'] : $tmpRs[0]['topic'];
	$_topicInfo['postusername'] = $tmpRs[0]['username'];
	$TempString = $tmpRs[0]['isagree'];
	$UpGetMoney = $tmpRs[0]['getmoney'];
	//°ÿս
	if( $master === false && $ReAct == 0 ){
		$arrUserToday[4] += $givemoney;
		set_cookie('usertoday',implode('|',$arrUserToday), $GLOBALS['user_selected_cookiedate']);
		$db->query("UPDATE {$dv}user SET usertoday='".$db->escape_string(get_cookie('usertoday'))."' WHERE userid='{$userid}'");
	}
	//IsagreeֶΣΪ۽|ӽ ,GetMoneyΪõ
	if( $TempString == '' || strpos($TempString,'|') === false ){
		if( $ReAct == 1 ){
			$UpIsAgree = $givemoney.'|0';
		} else{
			$UpIsAgree = '0|'.$givemoney;
		}
	} else{
		$arrTmp = explode('|',$TempString);
		if( $ReAct == 1 ){
			$arrTmp[0] .= $givemoney;
		} else{
			$arrTmp[1] .= $givemoney;
		}
		$UpIsAgree = $arrTmp[0].'|'.$arrTmp[1];
	}
	if( $ReAct == 1 ){
		$UpGetMoney -= $givemoney;
		$db->query("UPDATE {$dv}user SET usermoney=usermoney-{$givemoney} WHERE userid={$_topicInfo['postuserid']}");
		$sucmsg .= str_replace('{$TopicUsername}',$_topicInfo['postusername'],str_replace('{GiveMoney}',$givemoney,$lang['template.strings19']));
	} else{
		$UpGetMoney += $givemoney;
		$db->query("UPDATE {$dv}user SET usermoney=usermoney+{$givemoney} WHERE userid={$_topicInfo['postuserid']}");
		$sucmsg .= str_replace('{$TopicUsername}',$_topicInfo['postusername'],str_replace('{GiveMoney}',$givemoney,$lang['template.strings20']));
	}	
	$db->query("UPDATE {$tblName} SET isagree='".$db->escape_string($UpIsAgree)."' WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if($checkbox!='checkbox'){
		Update_User_Point('');
	}
	Topic_Manage_Sms();
	//$GLOBALS['topicUserName']=$lang['Action.Info']['p_reward_money'];
	Insert_Forum_Log();
	showmsg(SucMsgInfo($sucmsg));
}//end function p_do_reward_money



/**
 ******************************************************
 *				ºڲ
 ******************************************************
 */

function CanLockTopic(){
	global $master,$boardmaster,$superboardmaster,$groupsetting,$LocalCanLockTopic,$usergroupid,$_topicInfo,$membername,$founduserper;
	if( ( $master===true || $boardmaster === true || $superboardmaster === true ) && $groupsetting[20] == 1 ){
		$LocalCanLockTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[20] == 1 ){
		$LocalCanLockTopic = true;
	}
	if( $groupsetting[13] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanLockTopic = true;
	}
	if( $founduserper === true && $groupsetting[13] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanLockTopic = true;
	} elseif( $founduserper === true && $groupsetting[13] == 0 && $_topicInfo['postusername'] == $membername ){
		$LocalCanLockTopic = false;
	}
	if( $founduserper === true && $groupsetting[20] == 1 && $_topicInfo['postusername'] != $membername ){
		$LocalCanLockTopic = true;
	} elseif( $founduserper === true && $groupsetting[20] == 0 && $_topicInfo['postusername'] != $membername ){
		$LocalCanLockTopic = false;
	}
	return $LocalCanLockTopic;
}//end function CanLockTopic

function InitRequestInfo(){
	global $sucmsg,$title,$content,$lang,$ActionInfo,$_topicInfo,$allmsg;
	$sucmsg = '';
	if( $title == '' && $content == '' ){
		showmsg($lang['Error.strings6']);
		exit;
	}
	$title = htmlspecialchars($title);
	$content = htmlspecialchars($content);
	$content = $lang['template.strings0'].$title.$content;
	$sucmsg = $ActionInfo.$lang['template.strings1'].htmlspecialchars($_topicInfo['title']).$lang['template.strings2'].$content.$lang['template.strings3'].$allmsg;
}

function Insert_Forum_Log(){
	global $dv,$db;
	$db->query("INSERT INTO {$dv}log (l_announceid,l_boardid,l_touser,l_username,l_content,l_ip,l_type,l_addtime) VALUES('{$GLOBALS['id']}',{$GLOBALS['boardid']},'".$GLOBALS['topicUserName']."','{$GLOBALS['membername']}','".$db->escape_string($GLOBALS['sucmsg'])."','{$GLOBALS['usertrueip']}','{$GLOBALS['LogType']}','".TIME_NOW."')");
}//end function Insert_Forum_Log

//жûǷн/ͷȨ
function CanAwardTopic(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanAwardTopic,$usergroupid;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	}
	if( $usergroupid > 13 && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	}
	if( $founduserper === true && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	} elseif( $founduserper === true && $groupsetting[22] == 0 ){
		$LocalCanAwardTopic = false;
	}
	return $LocalCanAwardTopic;
}//end function CanAwardTopic

function Update_User_Point($strsql){
	global $allmsg,$dv,$db, $_topicInfo, $topicUserID;
	//exit;
	if ('checkbox' === strtolower(trim($GLOBALS['checkbox']))) {	//	ûֵв
		return;
	}
	if( $allmsg != '' ){
		if (empty($topicUserID)) {
			$topicUserID = $_topicInfo['postuserid'];
		}
		if(strpos($strsql,'-')!==false){
			$db->query("UPDATE {$dv}user SET userwealth=userwealth+".intval($GLOBALS['dowealth']).",usercp=usercp+".intval($GLOBALS['dousercp'])." {$strsql} WHERE userid='{$topicUserID}'");
		}
		else{
			$db->query("UPDATE {$dv}user SET userwealth=userwealth+".intval($GLOBALS['dowealth']).",usercp=usercp+".intval($GLOBALS['dousercp']).",userep=userep+".intval($GLOBALS['douserep'])." {$strsql} WHERE userid='{$topicUserID}'");		
		}
	}
}//end function Update_User_Point

function Topic_Manage_Sms(){
	global $ismsg,$dv,$db,$_topicInfo,$lang;
	if( $ismsg == 1 ){
		$topic = urlencode($_topicInfo['title']);
		$content = str_replace($lang['template.strings0'],'',$GLOBALS['content']);
		$ActionInfo = $GLOBALS['ActionInfo'];
		$allmsg = str_replace($lang['template.strings8'],'',$GLOBALS['allmsg']);
		eval('$msgContent="'.addslashes($lang['template.strings10']).'";');
		if( $GLOBALS['msg'] != '' ){
			$msgContent .= "\n".$lang['template.strings11'].$GLOBALS['msg'];
		}
		$db->query("INSERT INTO {$dv}message(incept,sender,title,content,sendtime,flag,issend) VALUES('".$db->escape_string($_topicInfo['postusername'])."','{$GLOBALS['membername']}','".$db->escape_string($lang['tpl.common.str1'])."','".$db->escape_string($msgContent)."','".TIME_NOW."',0,1)");
		Update_User_Msg($_topicInfo['postusername']);
	}
}//end function Topic_Manage_Sms

function Update_User_Msg($user_name){
	global $dv,$db;
	$newincept = newincept($user_name);
	if( $newincept > 0 ){
		$msginfo = $newincept.'||'.inceptid(1,$user_name).'||'.inceptid(2,$user_name);
	} else{
		$msginfo = '0||0||null';
	}
	$db->query("UPDATE {$dv}user SET usermsg='".$db->escape_string($msginfo)."' WHERE username='".$db->escape_string($user_name)."'");
}//end function Update_User_Msg

//ͳ
function newincept($iusername){
	if( $iusername == '' ) return 0;
	global $dv,$db;
	return $db->scalar("SELECT COUNT(id) FROM {$dv}message WHERE flag=0 AND issend=1 AND delr=0 AND incept='".$db->escape_string($iusername)."'");
}//end function newincept

function inceptid($stype,$iusername){
	if( $iusername == '' ) return 0;
	global $dv,$db;
	if( $query = $db->query("SELECT id,sender FROM {$dv}message WHERE flag=0 AND issend=1 AND delr=0 AND incept ='".$db->escape_string($iusername)."'",array('pageSize'=>1)) ){
		$tmpResult =& $db->fetch_row($query);
	}
	if( empty($tmpResult) ){
		return 0;
	}
	if( $stype == 1 ){
		return $tmpResult[0];
	} else{
		return $tmpResult[1];
	}
}//end function inceptid

//жûǷƶȨ
function canMoveTopic(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanMoveTopic,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[19] == 1 ){
		$LocalCanMoveTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[19] == 1 ){
		$LocalCanMoveTopic = true;
	}
	if( $groupsetting[12] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanMoveTopic = true;
	}
	if( $founduserper === true && $groupsetting[12] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanMoveTopic = true;
	} elseif( $founduserper === true && $groupsetting[12] == 0 && $_topicInfo['postusername'] == $membername ){
		$LocalCanMoveTopic = false;
	}
	if( $founduserper === true && $groupsetting[19] == 1){
		$LocalCanMoveTopic = true;
	} elseif( $founduserper === true && $groupsetting[19] == 0){
		$LocalCanMoveTopic = false;
	}
	return $LocalCanMoveTopic;
}//end function canMoveTopic

//жûǷɾȨ
function CanDelTopic(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanDelTopic,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[18] == 1 ){
		$LocalCanDelTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[18] == 1 ){
		$LocalCanDelTopic = true;
	}
	if( $groupsetting[11] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanDelTopic = true;
	}
	if( $founduserper === true && $groupsetting[11] == 1 && $_topicInfo['postusername'] == $membername ){
		$LocalCanDelTopic = true;
	} elseif( $founduserper === true && $groupsetting[11] == 0 && $_topicInfo['postusername'] == $membername ){
		$LocalCanDelTopic = false;
	}
	if( $founduserper === true && $groupsetting[18] == 1){
		$LocalCanDelTopic = true;
	} elseif( $founduserper === true && $groupsetting[18] == 0){
		$LocalCanDelTopic = false;
	}
	return $LocalCanDelTopic;
}//end function CanDelTopic

//жûǷн/ͷȨ
function CanAwardTopic_backup(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanAwardTopic,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	}
	if( $founduserper === true && $groupsetting[22] == 1 ){
		$LocalCanAwardTopic = true;
	} elseif( $founduserper === true && $groupsetting[22] == 0 ){
		$LocalCanAwardTopic = false;
	}
	return $LocalCanAwardTopic;
}//end function CanAwardTopic_backup

//жûǷй̶/̶Ȩ
function CanTopTopic(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanTopTopic,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[21] == 1 ){
		$LocalCanTopTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[21] == 1 ){
		$LocalCanTopTopic = true;
	}
	if( $founduserper === true && $groupsetting[21] == 1 ){
		$LocalCanTopTopic = true;
	} elseif( $founduserper === true && $groupsetting[21] == 0 ){
		$LocalCanTopTopic = false;
	}
	return $LocalCanTopTopic;
}//end function CanTopTopic

//жûǷ̶ܹȨ
function CanTopTopic_a(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanTopTopic_a,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[38] == 1 ){
		$LocalCanTopTopic_a = true;
	}
	if( $usergroupid > 3 && $groupsetting[38] == 1 ){
		$LocalCanTopTopic_a = true;
	}
	if( $founduserper === true && $groupsetting[38] == 1 ){
		$LocalCanTopTopic_a = true;
	} elseif( $founduserper === true && $groupsetting[38] == 0 ){
		$LocalCanTopTopic_a = false;
	}
	return $LocalCanTopTopic_a;
}//end function CanTopTopic_a

//жûǷ̶Ȩ
function CanTopTopic_m(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanTopTopic_m,$usergroupid,$_topicInfo,$membername,$getboard;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[54] == 1 ){
		$LocalCanTopTopic_m = true;
	}
	if( $usergroupid > 3 && $groupsetting[54] == 1 ){
		$LocalCanTopTopic_m = true;
	}
	if( $founduserper === true && $groupsetting[54] == 1 ){
		$LocalCanTopTopic_m = true;
	} elseif( $founduserper === true && $groupsetting[54] == 0 ){
		$LocalCanTopTopic_m = false;
	}
	if (is_array($getboard) AND count($getboard) <= 1) {
		$LocalCanTopTopic_m = false;
	}
	return $LocalCanTopTopic_m;
}//end function CanTopTopic_m

//жûǷм/Ȩ
function CanBestTopic(){
	global $master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$LocalCanBestTopic,$usergroupid,$_topicInfo,$membername;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[24] == 1 ){
		$LocalCanBestTopic = true;
	}
	if( $usergroupid > 3 && $groupsetting[24] == 1 ){
		$LocalCanBestTopic = true;
	}
	if( $founduserper === true && $groupsetting[24] == 1 ){
		$LocalCanBestTopic = true;
	} elseif( $founduserper === true && $groupsetting[24] == 0 ){
		$LocalCanBestTopic = false;
	}
	return $LocalCanBestTopic;
}//end function CanBestTopic

//
function ChkRewardMoney(){
	global $lang,$master,$superboardmaster,$boardmaster,$groupsetting,$founduserper,$usergroupid,$_topicInfo,$fsetting,$arrUserToday;
	$CanRewardMoney = false;
	if( ( $master === true || $superboardmaster === true || $boardmaster === true ) && $groupsetting[22] == 1 ){
		$CanRewardMoney = true;
	}
	if( $usergroupid > 3 && $groupsetting[22] == 1 ){
		$CanRewardMoney = true;
	}
	if( $founduserper === true && $groupsetting[22] == 1 ){
		$CanRewardMoney = true;
	} elseif( $founduserper === true && $groupsetting[22] == 0 ){
		$CanRewardMoney = false;
	}
	if( $master === false ){
		if( $arrUserToday[4] >= $fsetting['boardmaster_moneylimited'] ){
			$CanRewardMoney = false;
		}
	}
	//return $CanRewardMoney;
	if( $CanRewardMoney === false ){
		showmsg($lang['Error.strings5']);
		exit;
	}
}//end function ChkRewardMoney

function SucMsgInfo($GetMsg){
	global $lang,$boardid,$id,$replyid,$rootid,$_topicInfo;
	$Topic = htmlspecialchars($_topicInfo['title']);
	if (-1 == $_topicInfo['isvote']) {
		$TPL_returntopic = 'dispargue.php';
	} else {
		$TPL_returntopic = 'dispbbs.php';
	}
	if ($boardid <= 0) {
		$boardid = ($_GET['boardid'] > 0 ? $_GET['boardid'] : $_POST['boardid']);
	}
	eval('$returnVal="'.addslashes($lang['SucMsgInfo']).'";');
	return $returnVal;
}//end function SucMsgInfo

//ָ̳Ϣ
function LastCount($boardID){
	global $dv,$db,$UpdateBoardID,$boardid,$lang,$Lasttopic,$LastRootid,$LastPostUser,$LastPost,$nowTotalUseTable;
	$tmpRs =& $db->getResultSet("SELECT T.title,b.announceid,b.dateandtime,b.username,b.postuserid,b.rootid FROM ".$db->escape_string($nowTotalUseTable)." b INNER JOIN {$dv}topic T ON b.rootid=T.topicid WHERE b.boardid={$boardid} ORDER BY b.announceid DESC",array('pageSize'=>1));
	if( $tmpRs !== false ){
		$Lasttopic = str_replace('$','',substr(preg_replace('/<(.[^>]*)>/i','',$tmpRs['title']),0,15));
		$LastRootid = $tmpRs['announceid'];
		$LastPostTime = $tmpRs['dateandtime'];
		$LastPostUser = $tmpRs['username'];
		$LastPostUserid = $tmpRs['postuserid'];
		$Lastid = $tmpRs['rootid'];
	} else{
		$Lasttopic = $lang['template.strings14'];
		$LastRootid = 0;
		$LastPostTime = TIME_NOW;
		$LastPostUser = $lang['template.strings14'];
		$LastPostUserid = 0;
		$Lastid = 0;
	}
	$LastPost = $LastPostUser.'$'.$LastRootid.'$'.$LastPostTime.'$'.$uploadpic_n.'$'.$LastPostUserid.'$'.$Lastid.'$'.$boardid;
	if( checkIDList($UpdateBoardID) ){
		$db->query("UPDATE {$dv}board SET lastpost='{$LastPost}' WHERE boardid IN('{$UpdateBoardID}')");
	}
}//end function LastCount

//淢
function BoardNumSub($boardID,$topicNum,$postNum,$todayNum){
	global $dv,$db,$UpdateBoardID,$boardid,$lang,$Lasttopic,$LastRootid,$LastPostUser,$LastPost,$nowTotalUseTable;
	$db->query("UPDATE {$dv}board SET postnum=postnum-'{$postNum}',topicnum=topicnum-'{$topicNum}',todaynum=todaynum-'{$todayNum}' WHERE boardid IN({$UpdateBoardID})");
	$tmpRs =& $db->getResultSet("SELECT T.title,b.announceid,b.dateandtime,b.username,b.postuserid,b.rootid FROM ".$db->escape_string($nowTotalUseTable)." b INNER JOIN {$dv}topic T ON b.rootid=T.topicid WHERE b.boardid={$boardid} ORDER BY b.announceid DESC",array('pageSize'=>1));
	if( $tmpRs !== false ){
		$Lasttopic = str_replace('$','',substr(preg_replace('/<(.[^>]*)>/i','',$tmpRs['title']),0,15));
		$LastRootid = $tmpRs['announceid'];
		$LastPostTime = $tmpRs['dateandtime'];
		$LastPostUser = $tmpRs['username'];
		$LastPostUserid = $tmpRs['postuserid'];
		$Lastid = $tmpRs['rootid'];
	} else{
		$Lasttopic = $lang['template.strings14'];
		$LastRootid = 0;
		$LastPostTime = TIME_NOW;
		$LastPostUser = $lang['template.strings14'];
		$LastPostUserid = 0;
		$Lastid = 0;
	}
	$LastPost = $LastPostUser.'$'.$LastRootid.'$'.$LastPostTime.'$'.$uploadpic_n.'$'.$LastPostUserid.'$'.$Lastid.'$'.$boardid;

	//ɾ
	del_static_boards($UpdateBoardID);
}//end function BoardNumSub

//̳
function AllboardNumSub($todayNum,$postNum,$topicNum){
	global $db,$dv;
	$db->query("UPDATE {$dv}setup SET forum_todaynum=forum_todaynum-{$todayNum},forum_postnum=forum_postnum-{$postNum},forum_topicnum=forum_topicnum-{$topicNum}");
}//end function AllboardNumSub
//淢
function BoardNumAdd($boardID,$topicNum,$postNum,$todayNum){
	global $dv,$db,$UpdateBoardID;
	$db->query("UPDATE {$dv}board SET postnum=postnum+{$postNum},topicnum=topicnum+{$topicNum},todaynum=todaynum+{$todayNum} WHERE boardid IN ({$UpdateBoardID})");

	//ɾ
	del_static_boards($UpdateBoardID);
}//end function BoardNumAdd

//̳
function AllboardNumAdd($todayNum,$postNum,$topicNum){
	global $dv,$db;
	$db->query("UPDATE {$dv}setup SET forum_todaynum=forum_todaynum+{$todayNum},forum_postnum=forum_postnum+{$postNum},forum_topicnum=forum_topicnum+{$topicNum}");
}//end function AllboardNumAdd

//ظûĿɹİID ԡ,ָ
function GetBoardMasterID($username){
	global $_DCACHE;
	if( $username.'' === '' ) return '';
	$arrReturnVal = array();
	if( !empty($_DCACHE['all_forums']) && is_array($_DCACHE['all_forums']) ){
		foreach( $_DCACHE['all_forums'] as $currBoardID => $currBoardInfo ){
			if( strpos('|'.$currBoardInfo['boardmaster'].'|',$username) !== false ){
				$arrReturnVal[] = $currBoardID;
				if( $currBoardInfo['child'] > 0 ){
					foreach( $_DCACHE['all_forums'] as $currBoardID2 => $currBoardInfo2 ){
						if( strpos(','.$currBoardInfo2['parentstr'].',',$currBoardID) !== false ){
							$arrReturnVal[] = $currBoardID2;
						}
					}
				}
			}
		}
	}
	if( empty($arrReturnVal) ){
		return '';
	} else{
		return implode(',',$arrReturnVal);
	}
}//end function GetBoardMasterID

function Check_topicInfo(){
	global $db,$dv,$boardid,$id,$_topicInfo,$tblName,$lang;
	//echo "SELECT topic,username,postuserid FROM {$tblName} WHERE parentid=0 AND boardid='{$boardid}' AND rootid='{$id}'";
	$tmpRs =& $db->getResultSet("SELECT topic,username,postuserid FROM {$tblName} WHERE parentid=0 AND boardid='{$boardid}' AND rootid='{$id}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$_topicInfo['title'] = $tmpRs[0]['topic'];
	$_topicInfo['postusername'] = $tmpRs[0]['username'];
	$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
}//end function Check_topicInfo

function Check_AnnounceInfo(){
	global $lang,$dv,$db,$boardid,$replyid,$tblName,$_topicInfo;
	$tmpRs =& $db->getResultSet("SELECT topic,username,postuserid FROM {$tblName} WHERE boardid='{$boardid}' AND announceid='{$replyid}'");
	if( $tmpRs === false ){
		showmsg($lang['Error.strings4']);
		exit;
	}
	$_topicInfo['title'] = $tmpRs[0]['topic'];
	$_topicInfo['postusername'] = $tmpRs[0]['username'];
	$_topicInfo['postuserid'] = $tmpRs[0]['postuserid'];
}//end function Check_AnnounceInfo

//ȡַָ
function cutStr($str,$strlen){
	//ȥHTML
	$str = preg_replace( '/<([^<>]*?)>/i' ,'' ,$str);
	$len = strlen($str);
	$t = 0;
	$returnVal = '';
	for( $i = 0 ; $i < $len ; $i++ ){
		$c = abs(ord($str{$i}));
		if( $c > 255 ){
			$t += 2;
		} else{
			$t++;
		}
		if( $t > $len ){
			$returnVal = substr($str,0,$i+1).'...';
			break;
		} else{
			$returnVal = $str;
		}
	}
	return str_replace("\r",'',str_replace("\n",'',$returnVal));
}//end function cutStr

//˲ҪUBB,HTML
function reUBBCode(&$strContent){
	if( $strContent == '' ){
		return '';
	}
	return preg_replace(
			 array(
			  '/&nbsp;/i'
			 ,'/(\[QUOTE\])(.|\n)*(\[\/QUOTE\])/i'
			 ,'/(\[point=*([0-9]*)\])(.|\n)*(\[\/point\])/i'
			 ,'/(\[post=*([0-9]*)\])(.|\n)*(\[\/post\])/i'
			 ,'/(\[power=*([0-9]*)\])(.|\n)*(\[\/power\])/i'
			 ,'/(\[usercp=*([0-9]*)\])(.|\n)*(\[\/usercp\])/i'
			 ,'/(\[money=*([0-9]*)\])(.|\n)*(\[\/money\])/i'
			 ,'/(\[replyview\])(.|\n)*(\[\/replyview\])/i'
			 ,'/(\[usemoney=*([0-9]*)\])(.|\n)*(\[\/usemoney\])/i'
			 ,'/<I><\/I>/i'
			 ,'/\n|\r/i'
			 ,'/'.chr(32).'/i'
			 ,'/'.chr(9).'/i'
			 ,'/<(.[^>]*)>/i'
			 )
			,array(
			 ''
			,''
			,'&nbsp;'
			,'&nbsp;'
			,'&nbsp;'
			,'&nbsp;'
			,'&nbsp;'
			,'&nbsp;'
			,'&nbsp;'
			,''
			,''
			,' '
			,' '
			,''
			)
			,$strContent
		   );
}//end function reUBBCode

function delupfiles($F_BoardID,$F_announceID) // ɾ
{
	global $dv, $db, $__REMOVED_FILE_ID_LIST;
	$documentroot = realpath(getenv('DOCUMENT_ROOT'));
	if ($query = $db->query("SELECT f_id, f_filename, f_viewname FROM {$dv}upfile WHERE f_boardid='{$F_BoardID}' AND f_announceid LIKE '{$F_announceID}%' AND f_flag=0")) {
		$fidlist = '';
		$comma = '';
		while ($dbinfo =& $db->fetch_array($query)) {
			$fidlist .= "{$comma}{$dbinfo['f_id']}";
			$comma = ',';
			if (!empty($dbinfo['f_filename'])) {
				if ($filepath = realpath($documentroot.'/'.$dbinfo['f_filename'])) {
					FileHandle::unlink($filepath);
				}
			}
			if (!empty($dbinfo['f_filename'])) {
				if ($viewfilepath = realpath($documentroot.'/'.$dbinfo['f_viewname'])) {
					FileHandle::unlink($viewfilepath);
				}
			}
		}
		if ($fidlist !== '') {
			$__REMOVED_FILE_ID_LIST = $fidlist;
			$db->query("DELETE FROM {$dv}upfile WHERE f_id IN({$fidlist})");
		}
	}
}

//ɾӺ¡ Add By xiaoD
function lastpost() {
	global $db, $dv, $boardid, $nowTotalUseTable;

	$query = $db->query("SELECT username, announceid, dateandtime, parentid, topic, postuserid, rootid FROM ".$db->escape_string($GLOBALS['nowTotalUseTable'])." WHERE boardid NOT IN (444,777) AND boardid='$boardid' ORDER BY dateandtime DESC");

	$rs = $db->fetch_array($query);
	$username = $rs['username'];
	$announceid = $rs['announceid'];
	$dateandtime = $rs['dateandtime'];
	$topic = $rs['topic'];
	$postuserid = $rs['postuserid'];
	$topicid = $rs['rootid'];
	$parentid = $rs['parentid'];
	if($parentid) {
		$topic = $db->scalar("SELECT topic FROM ".$db->escape_string($GLOBALS['nowTotalUseTable'])." WHERE announceid='$parentid'");
	}
	$lastpost = $username.'$'.$announceid.'$'.$dateandtime.'$'.$topic.'$$'.$postuserid.'$'.$topicid.'$'.$boardid;
	$db->query("UPDATE {$dv}board SET lastpost='$lastpost' WHERE boardid='$boardid'");
}

?>