<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2006 Dvbbs Enterprises Ltd. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # -------------------- DVPHP IS FREE SOFTWARE -------------------- # ||
|| # 					.:: Power by lfow(dvbbs xiaodu) ::.			  # ||
|| #################################################################### ||
\*======================================================================*/

if( !defined('ISDVBBS') ){
	//header('HTTP/1.0 401 Unauthorized');
	header('HTTP/1.0 400 Bad Request');
	exit;
}

error_reporting(E_ALL & ~E_NOTICE);

//ڣMutil Bytes Function
define('NON_MB_SUPPORT', false);
class DV_Encoding {
	var $_encodingName = 'utf-8';
	var $_isSupportedMB = false;
	var $_isSupportedIConv = false;
	var $_thisClassName = '';
	var $_notSupportedString = 'Not supported!Must be override by sub class!';

	function DV_Encoding($strEncName='utf-8'){
		$this->_encodingName = $strEncName;
		$this->_isSupportedMB = false;
		$this->_isSupportedIConv = false;
		$this->_thisClassName = get_class($this);
	}//end constructor function DV_Encoding

	function &GetEncoding($strEncName='utf-8'){
		if( !empty($this) ){
		}
		if( $strEncName == '' ){
			$strEncName = 'utf-8';
		}
		$isSupportedMB = false;
		$isSupportedIConv = false;
		if( (!defined('NON_MB_SUPPORT') OR false === NON_MB_SUPPORT) AND function_exists('mb_strlen') ){
			$isSupportedMB = true;
		}
		if( (!defined('NON_MB_SUPPORT') OR false === NON_MB_SUPPORT) AND function_exists('iconv') ){
			$isSupportedIConv = true;
		}
		if( $isSupportedMB === true && $isSupportedIConv === true ){
			$objEnc = new DV_Encoding($strEncName);
			$objEnc->_isSupportedMB = true;
			$objEnc->_isSupportedIConv = true;
			return $objEnc;
		}
		$subClassName = DV_Encoding::_GetSubClassNameBy($strEncName);
		if( $subClassName === false ){
			print 'Not supported encoding!';
			exit;
		}
		$objEnc = new $subClassName($strEncName);
		$objEnc->_isSupportedMB = false;
		$objEnc->_isSupportedIConv = false;
		return $objEnc;
	}//end function GetEncoding

	function StrLength(&$str,$destEncodingName=''){
		if( empty($destEncodingName) ){
			$destEncodingName = $this->_encodingName;
		}
		if( $this->_isSupportedMB === true ){
			return mb_strlen($str,$destEncodingName);
		} else{
			exit($this->_notSupportedString);
		}
	}//end funcion StrLength

	function &SubString(&$str,$start,$length=null){
		$returnval = '';
		if( empty($destEncodingName) ){
			$destEncodingName = $this->_encodingName;
		}
		if( $this->_isSupportedMB === true ){
			if( is_numeric($length) ){
				$returnval = mb_substr($str,$start,$length,$destEncodingName);
				return $returnval;
			} else{
				mb_internal_encoding($destEncodingName);
				$returnval = mb_substr($str,$start);
				return $returnval;
			}
		} else{
			exit($this->_notSupportedString);
		}
	}//end function SubString

	function &Convert(&$str,$destEncodingName='', $srcEncodingName=''){
		if (empty($srcEncodingName)) {
			$srcEncodingName = $this->_encodingName;
		}
		if( $destEncodingName == '' ){
			return '';
		}
		if( $this->_encodingName == $destEncodingName ){
			return $str;
		}
		if( $this->_isSupportedIConv === true ){
			return iconv($srcEncodingName,$destEncodingName,$str);
		} else{
			exit($this->_notSupportedString);
		}
	}//end function Convert

	function _GetSubClassNameBy($subClassName=''){
		if( empty($subClassName) ){
			return false;
		}
		if( strpos($subClassName,'-') !== false ){
			$subClassName = str_replace('-','',$subClassName);
		}
		$subClassName = '_DV_Encoding_'.strtolower(trim($subClassName));
		if( class_exists($subClassName) ){
			return $subClassName;
		} else{
			return false;
		}
	}//end function _GetSubClassNameBy
}

class _DV_Encoding_utf8 extends DV_Encoding {
	function StrLength(&$str){
		return strlen(utf8_decode($str));
	}//end function StrLength
	function &SubString(&$str,$start,$length=null){
		if( !is_numeric($start) ){
			return false;
		}
		$strLen = strlen($str);
		if( $strLen <= 0 ){
			return false;
		}
		if( $start < 0 || $length < 0 ){
			$mbStrLen = $this->StrLength($str);
		} else{
			$mbStrLen = $strLen;
		}
		if( !is_numeric($length) ){
			$length = $mbStrLen;
		} elseif( $length < 0 ){
			$length = $mbStrLen + $length - 1;
		}
		if( $start < 0 ){
			$start = $mbStrLen + $start;
		}
		$returnVal = '';
		$mbStart = 0;
		$mbCount = 0;
		for( $i = 0 ; $i < $strLen ; $i++ ){
			if( $mbCount >= $length ){
				break;
			}
			$currOrd = ord($str{$i});
			if( $mbStart >= $start ){
				$returnVal .= $str{$i};
				if( $currOrd > 0x7f ){
					$returnVal .= $str{$i+1}.$str{$i+2};
					$i += 2;
				}
				$mbCount++;
			} elseif( $currOrd > 0x7f ){
				$i += 2;
			}
			$mbStart++;
		}
		return $returnVal;
	}//end function SubString
	function &Convert(&$str,$destEncodingName=''){
		exit($this->_notSupportedString);
	}//end function Convert
}

class _DV_Encoding_gbk extends DV_Encoding {
	function StrLength(&$str){
		$rawLength = strlen($str);
		if( $rawLength <= 0 ) return 0;
		$gbkCount = (int)preg_match_all('/(?:[\x81-\xFE][\x40-\xFE])/i',$str,$arr);
		unset($arr);
		return intval(($rawLength-$gbkCount*2)+$gbkCount);
	}//end function StrLength
	function _IsGBKChar($firstChar,$secondChar){
		if( empty($firstChar) || !isset($firstChar) || is_null($firstChar) ){
			return false;
		}
		if( empty($secondChar) || !isset($secondChar) || is_null($secondChar) ){
			return false;
		}
		$firstOrd = ord($firstChar);
		$secondOrd = ord($secondChar);
		if( ($firstOrd >= 0x81 & $firstOrd <= 0xFE) & ($secondOrd >= 0x40 & $secondOrd <= 0xFE) ){
			return true;
		}
		return false;
	}
	function &SubString(&$str,$start,$length=null){
		if( !is_numeric($start) ){
			return false;
		}
		$strLen = strlen($str);
		if( $strLen <= 0 ){
			return false;
		}
		if( $start < 0 || $length < 0 ){
			$mbStrLen = $this->StrLength($str);
		} else{
			$mbStrLen = $strLen;
		}
		if( !is_numeric($length) ){
			$length = $mbStrLen;
		} elseif( $length < 0 ){
			$length = $mbStrLen + $length - 1;
		}
		if( $start < 0 ){
			$start = $mbStrLen + $start;
		}
		$returnVal = '';
		$mbStart = 0;
		$mbCount = 0;
		for( $i = 0 ; $i < $strLen ; $i++ ){
			if( $mbCount >= $length ){
				break;
			}
			$isGBK = $this->_IsGBKChar($str{$i},$str{$i+1});
			if( $mbStart >= $start ){
				$returnVal .= $str{$i};
				if( $isGBK === true ){
					$returnVal .= $str{$i+1};
					$i++;
				}
				$mbCount++;
			} elseif( $isGBK === true ){
				$i++;
			}
			$mbStart++;
		}
		return $returnVal;
	}//end function SubString
	function &Convert(&$str,$destEncodingName=''){
		exit($this->_notSupportedString);
	}//end function Convert
}

class _DV_Encoding_gb2312 extends _DV_Encoding_gbk {
}

class _DV_Encoding_big5 extends _DV_Encoding_gbk {
}

?>