<?php
//if(!defined('ISDVBBS')) exit('Access denied.Sorry, you can not access this file directly.');
if( !defined('ISDVBBS') ){
	//header('HTTP/1.0 401 Unauthorized');
	header('HTTP/1.0 400 Bad Request');
	exit;
}

/**
* ڽϵͳԴļڰȫģʽƵ⡣
* ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
* Ϊ˱֤Ŀɿԣڴļʱļ·ʹϵͳ realpath()ȡļ
*
*
* @package 		dvphp
* @author		
* @version		$Revision: 1.0 $
* @date 		$Date: 2006/07/27 $
* @copyright 	http://p.dvbbs.net/license.html
*
*/
class FileHandle
{
	/**
	 * Description ˺ڽ copy() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ԭļ
	 * @param string µļ
	 * @return boolean ļ source  destɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function chmod($filename, $mode)
	{
		if (false === FileHandle::file_exists($filename)) {
			trigger_error("FileHandle::chmod({$filename}): No such file or directory", E_USER_WARNING);
			return false;
		}
		if (FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			return chmod($filename, $mode);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@chmod('{$filename}', '{$mode}')){print 1;exit;};";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::chmod({$filename},{$mode}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
		return false;
	}
	/**
	 * Description ˺ڽ copy() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ԭļ
	 * @param string µļ
	 * @return boolean ļ source  destɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function copy($source, $dest)
	{
		if (!FileHandle::is_file($source)) {
			trigger_error("FileHandle::copy({$source}): failed to open stream: Is not a file.", E_USER_WARNING);
			return false;
		}
		if (FileHandle::is_dir($dest)) {
			trigger_error("FileHandle::copy({$dest}): failed to open stream: Is a directory.", E_USER_WARNING);
			return false;
		}
		$tmpsource = $source;
		if (false === ($source = realpath($source))) {
			trigger_error("FileHandle::copy({$tmpsource},{$dest}): No such file or directory.", E_USER_WARNING);
			return false;
		}
		if (false === ($srcisallowed = FileHandle::is_allowed_to_access_in_safe_mode($source))) {
			$srcisallowed = FileHandle::is_allowed_to_access_in_safe_mode(dirname($source));
		}
		$destdir = realpath(dirname($dest));
		if (false === ($destisallowed = FileHandle::is_allowed_to_access_in_safe_mode($dest))) {
			if (false === $destdir) {
				trigger_error("FileHandle::copy({$tmpsource},{$dest}): No such file or directory.", E_USER_WARNING);
				return false;
			}
			$destisallowed = FileHandle::is_allowed_to_access_in_safe_mode($destdir);
		}

		if (true === $srcisallowed AND true === $destisallowed) { //  source  dest  UID 뵱ǰű UID ͬʱִд˴
			return copy($source, $dest);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			if (true === $srcisallowed) { //  source  UID 뵱ǰű UID ͬʱִд˴(dest űʱ UID ͬſִгɹ)
				$tmpfile = $writabledir.'/'.strtolower(substr(base64_encode(md5(uniqid(strtotime('now'),true))),20,8));
				if (copy($source, $tmpfile)) {
					$operationcode = "if(@rename('{$tmpfile}', '{$dest}')) {print 1;exit;}";
					$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
					if ($execresult == 1) {
						return true;
					} else {
						@unlink($tmpfile);
						if (!empty($execresult)) {
							trigger_error("FileHandle::copy({$source},{$dest}): {$execresult}", E_USER_WARNING);
						}
						return false;
					}
				}
			} elseif (true === $destisallowed) {//  dest  UID 뵱ǰű UID ͬʱִд˴(source űʱ UID ͬſִгɹ)
				$destbackup = '';
				if (is_file($dest)) {
					$destbackup = $dest.'_backup_'.strtolower(substr(base64_encode(md5(uniqid(strtotime('now'),true))),20,8));
					if (!rename($dest, $destbackup)) {
						return false;
					}
				}
				if (touch($dest)) {
					$operationcode = "if(@copy('{$source}', '{$dest}')){print 1;exit;}";
					$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
					if ($execresult == 1) {
						if ($destbackup) {
							unlink($destbackup);
						}
						return true;
					} else {
						if ($destbackup) {
							rename($destbackup, $dest);
						}
						if (!empty($execresult)) {
							trigger_error("FileHandle::copy({$source},{$dest}): {$execresult}", E_USER_WARNING);
						}
						return false;
					}
				}
			} else { // source  dest  UID 뵱ǰű UID ͬʱִд˴루 source  dest űʱ UID ͬſִгɹ
				$operationcode = "if(@copy('{$source}', '{$dest}')){print 1;exit;}";
				$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
				if ($execresult == 1) {
					return true;
				} elseif (!empty($execresult)) {
					trigger_error("FileHandle::copy({$source},{$dest}): {$execresult}", E_USER_WARNING);
					return false;
				}
			}
		}
		return false;
	}//end function copy

	/**
	 * Description ˺ڽ file_exists() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ҪļĿ¼
	 * @return boolean ҪļĿ¼򷵻 TRUE򷵻 FALSE
	 */
	function file_exists($filename)
	{
		if (realpath($filename)) {
			return true;
		} else {
			return false;
		}
	}//end function file_exists

	/**
	 * Description ȡĿļݣ˺ϵͳ file_get_contents ʱֱӵֵ
	 * @author 
	 * @param string Ŀļ
	 * @return string ĿļݣʧܣFALSE
	 */
	function file_get_contents($file)
	{
		if (function_exists('file_get_contents')) {
			return file_get_contents($file);
		} else {
			if ($fp = fopen($file, 'rb')) {
				$filecontents = '';
				//@flock($fp, 1);
				$filesize = filesize($file);
				if ($filesize > 0) {
					$filecontents = @fread($fp, $filesize);
				} elseif (false !== $filesize) {
					while (!feof($fp)) {
						$filecontents .= fgets($fp);
					}
				}
				//@flock($fp, 3);
				@fclose($fp);
				return $filecontents;
			}
		}
		return false;
	}//end function file_get_contents

	/**
	 * Description Ŀļдݣ˺ϵͳ file_put_contents ʱֱӵֵ
	 * @author 
	 * @param string Ŀļ
	 * @param string Ҫд(ʹôݵ)
	 * @return int дļֽʧʱFALSE
	 */
	function file_put_contents($destfile, &$contents, $flags = null, $rescontext = null)
	{
		if (function_exists('file_put_contents')) {
			if (null !== $flags) {
				return @file_put_contents($destfile, $contents, $flags, $rescontext);
			} else {
				return @file_put_contents($destfile, $contents);
			}
		} else {
			$openmode = '';
			switch ($flags) {
				case 1: // FILE_USE_INCLUDE_PATH 
					$openmode = 'wb';
					break;
				case 0: // FILE_APPEND
				default:
					$openmode = 'ab';
					break;
			}
			if ($fp = fopen($destfile, $openmode)) {
				if (@flock($fp, 2|4)) {
					$writed = @fwrite($fp,$contents);
					@flock($fp, 3);
				} else {
					$writed = false;
				}
				@fclose($fp);
				return $writed;
			} else {
				return false;
			}
		}
	}//end function file_put_contents

	/**
	 * Description ˺ڽ ļڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ʱļҪִеPHP
	 * @return mixed 󣬷 FALSE򷵻PHPִн
	 */
	function filehandle_in_safe_mode(&$operationcode)
	{
		global $_SERVER;
		$writabledir = FileHandle::find_writable_dir();
		if (empty($writabledir)) {
			return false;
		}
		$writabledir = str_replace('\\', '/', $writabledir);
		$documentroot = str_replace('\\', '/', realpath($_SERVER['DOCUMENT_ROOT']));
		$tmpscriptname = strtolower(substr(base64_encode(md5(uniqid(strtotime('now'),true))),20,8)).'.php';
		$pathname = $writabledir.'/'.$tmpscriptname;
		$fwriteresult = false;
		if ($fp = fopen($pathname, 'w')) {
			if (flock($fp, 2)) {
			$urltokenid = md5(uniqid(rand().getmypid().getmyinode(), true));
			$phpcode = "<?php\r\n";
			$phpcode .= <<<EOT
				error_reporting(7);
				ini_set('track_errors', 'on');
				if (getenv('SERVER_ADDR') != getenv('REMOTE_ADDR')) {
					print('IP not match!');
					exit(0);
				}
				if (isset(\$_GET)) {
					\$httpget =& \$_GET;
				} elseif(isset(\$HTTP_GET_VARS)) {
					\$httpget =& \$HTTP_GET_VARS;
				} else {
					print('URL argument error!');
					exit(0);
				}
				if (empty(\$httpget)) {
					print('URL argument error!');
					exit(0);
				}
				if (\$httpget['urltokenid'] !== '{$urltokenid}') {
					print('URL token id error!');
					exit(0);
				}
				//------------------ Start user define code------------------
				\r\n{$operationcode}\r\n
				//------------------ End user define code------------------
				if (!empty(\$php_errormsg)) {
					print \$php_errormsg;
				}
				exit;
EOT;
				$phpcode .= "\r\n?>";
				$fwriteresult = fwrite($fp, $phpcode, strlen($phpcode));
			}
			fclose($fp);
		}
		if (false === $fwriteresult) {
			return false;
		}
		$scriptpath = str_replace($documentroot, '', $pathname);
		if ($scriptpath{0} !== '/') {
			$scriptpath = '/'.$scriptpath; 
		}
		$execresult = 0;
		$httpfile = 'http://'.getenv('SERVER_NAME').':'.getenv('SERVER_PORT').$scriptpath.'?urltokenid='.$urltokenid;
		if ($fp = fopen($httpfile, 'rb')) {
			$execresult = trim(fgets($fp));
			fclose($fp);
			chmod($pathname, 0777);
		}
		unlink($pathname);
		return $execresult;
	}//end function filehandle_in_safe_mode

	/**
	 * Description ˺վĿ¼ѰҿдĿ¼
	 * @author 
	 * @param string ѡĲָĿ¼ǷԱǰűд
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function find_writable_dir($writabledir = '')
	{
		global $_SERVER;
		static $cachewritabledir = null;
		if (!empty($writabledir) AND is_dir($writabledir) AND FileHandle::is_writable($writabledir)) {
			$writable = realpath($writabledir);
			if (false !== strpos($writable, realpath($_SERVER['DOCUMENT_ROOT']))) {
				$cachewritabledir = $writable;
			}
		}
		if (null === $cachewritabledir) {
			$documentroot = realpath($_SERVER['DOCUMENT_ROOT']);
			$LIFO_queue = array();
			if ($tmpobj = @dir($documentroot)) {
				$LIFO_index = 0;
				$LIFO_queue[0] =& $tmpobj;
				$dir =& $tmpobj;
				while ($LIFO_index >= 0 AND !empty($dir)) {
					if (false === ($entry = $dir->read())) {
						$dir->close();
						unset($LIFO_queue[$LIFO_index]);
						$LIFO_index--;
						$dir =& $LIFO_queue[$LIFO_index];
						continue;
					}
					if ('..' == $entry) {
						continue;
					}
					$currfullentry = $dir->path.'/'.$entry;
					if (is_dir($currfullentry) AND FileHandle::is_writable($currfullentry)) {
						$cachewritabledir = realpath($currfullentry);
						break;
					}
				}
				if (!empty($LIFO_queue) AND is_array($LIFO_queue)) {
					for ( ; $LIFO_index >= 0 ; $LIFO_index--) {
						$LIFO_queue[$LIFO_index]->close();
						unset($LIFO_queue[$LIFO_index]);
					}
				}
			}
		}
		if (empty($cachewritabledir) OR !is_dir($cachewritabledir)) {
			trigger_error("FileHandle::find_writable_dir({$writabledir}): Cannot find writable directory. ", E_USER_WARNING);
			$cachewritabledir = false;
		}
		return $cachewritabledir;
	}//end function find_writable_dir

	/**
	 * Description ˺ڽ fileperms() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ĿļĿ¼
	 * @return int ļķȨޣ򷵻 FALSE
	 */
	function fileperms($filename)
	{
		if (FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			return fileperms($filename);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@fileperms('{$filename}')){print 1;exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::file_exists({$filename}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
	}

	/**
	 * Description ļĿ¼ source  dest֧Ŀ¼ݲַ֧ӡ
	 * @author 
	 * @param string ԭļĿ¼
	 * @param string µĻĿ¼ļ
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function icopy($source, $dest)
	{
		$srcisallowed = FileHandle::is_allowed_to_access_in_safe_mode($source);
		$destisallowed = FileHandle::is_allowed_to_access_in_safe_mode($dest);
		if (FileHandle::is_file($source)) {
			return FileHandle::copy($source, $dest);
		} elseif (FileHandle::is_dir($source)) {
			if (FileHandle::is_file($dest)) {
				trigger_error("FileHandle::icopy({$dest}): failed to open stream: Is a file", E_USER_WARNING);
				return false;
			}
			if (!FileHandle::is_dir($dest) AND !FileHandle::mkdir($dest)) {
				return false;
			}
			$LIFO_queue = array(); // ͺȳ
			if ($LIFO_queue[0] =& FileHandle::scandir($source)) {
				$LIFO_index = 0;
				$sourcedir = $source;
				$destdir = realpath($dest);
				while ($LIFO_index >= 0) {
					if (isset($LIFO_queue[$LIFO_index]['files'])) {
						foreach ($LIFO_queue[$LIFO_index]['files'] AS $entry) {
							FileHandle::copy($sourcedir.'/'.$entry, $destdir.'/'.$entry);
						}
						unset($LIFO_queue[$LIFO_index]['files']);
					}
					$emptydirectories = true;
					if (isset($LIFO_queue[$LIFO_index]['directories'])) {
						foreach ($LIFO_queue[$LIFO_index]['directories'] AS $index => $entry) {
							unset($LIFO_queue[$LIFO_index]['directories'][$index]);
							if ($entry == '.' OR $entry == '..') {
								continue;
							}
							$srcfullentry = $sourcedir.'/'.$entry;
							$destfullentry = $destdir.'/'.$entry;
							if (!FileHandle::is_dir($destfullentry) AND !FileHandle::mkdir($destfullentry)) {
								continue;
							}
							if ($filelist =& FileHandle::scandir($srcfullentry)) {
								$sourcedir = $srcfullentry;
								$destdir = $destfullentry;
								$LIFO_index++;
								$LIFO_queue[$LIFO_index] =& $filelist;
								$emptydirectories = false;
								break;
							}
						}
					}
					if (true === $emptydirectories) {
						unset($LIFO_queue[$LIFO_index]['directories']);
						$LIFO_index--;
						$sourcedir = dirname($sourcedir);
						$destdir = dirname($destdir);
						if ($LIFO_index < 0) {
							unset($LIFO_queue);
							break;
						}
					}
				}
			}
		} else {
			trigger_error("FileHandle::icopy({$source}): No such file or directory", E_USER_WARNING);
			return false;
		}
	}//end function icopy

	/**
	 * Description ǷĿļĿ¼ִļ
	 * @author 
	 * @param string ҪִвļĿ¼
	 * @param boolean ÿһļĿ¼һصļ黺
	 * @return boolean ļTRUE򷵻 FALSE
	 */
	function is_allowed_to_access_in_safe_mode($destination, $clearcache = false)
	{
		static $cachetest = array();
		if (false !== $clearcache) {
			unset($cachetest[$destination]);
		} elseif (isset($cachetest[$destination])) {
			return $cachetest[$destination];
		}
		$cachetest[$destination] = false;
		if (!get_cfg_var('safe_mode')) {
			$cachetest[$destination] = true;
		} elseif (false === realpath($destination)) {// realpath ܰȫģʽ
			if (false !== ($parentdir = realpath(dirname($destination)))) {// realpath  dirname ܰȫģʽ
				$tmpfilename = $parentdir.'/'.md5(uniqid(rand().getmypid().getmyinode(), true));
				if (@touch($tmpfilename)) {
					$cachetest[$destination] = true;
					unlink($tmpfilename);
				}
			}
		} else {
			$myuid = @getmyuid();
			if (is_numeric($myuid) AND @fileowner($destination) == $myuid) {// fileowner ܰȫģʽƷ false
				$cachetest[$destination] = true;
			} elseif (is_dir($destination)) {// is_dir ܰȫģʽƷ false
				$tmpfilename = $destination.'/'.md5(uniqid(rand(), true));
				if (@touch($tmpfilename)) {
					$cachetest[$destination] = true;
					unlink($tmpfilename);
				}
			} elseif (is_file($destination)) {// is_file ܰȫģʽƷ false
				$cachetest[$destination] = @touch($destination);
			}
		}
		return $cachetest[$destination];
	}//end function is_allowed_to_access_in_safe_mode

	/**
	 * Description ˺ڽ is_dir() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ҪĿ¼
	 * @return boolean Ŀ¼Ϊļ򷵻 TRUE򷵻 FALSE
	 */
	function is_dir($filename)
	{
		if (FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			return is_dir($filename);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@is_dir('{$filename}')){print 1;exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::is_dir({$filename}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
	}//end function is_dir

	/**
	 * Description ˺ڽ is_file() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string Ҫļ
	 * @return boolean ļΪļ򷵻 TRUE򷵻 FALSE
	 */
	function is_file($filename)
	{
		if (FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			return is_file($filename);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@is_file('{$filename}')){print 1;exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::is_file({$filename}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
	}//end function is_file

	/**
	 * Description ĿļǷͨ HTTP POST ύļ
	 * @author 
	 * @param string Ҫļ
	 * @return boolean ɹTRUE򷵻FALSE
	 */
	function is_uploaded_file($filename)
	{
		if( function_exists('is_uploaded_file') ){
			return is_uploaded_file($filename);
		} else{
			if (!$tmp_file = get_cfg_var('upload_tmp_dir')) {
				$tmp_file = dirname(tempnam('', ''));
			}
			$tmp_file .= '/' . basename($filename);
			/* User might have trailing slash in php.ini... */
			return (ereg_replace('/+', '/', $tmp_file) == $filename);
		}
	}//end function is_uploaded_file

	/**
	 * Description Բ밲ȫģʽĿļĿ¼Ƿд
	 * @author 
	 * @param string PHP5˲һǷдĿ¼
	 * @return boolean дTRUE򷵻FALSE
	 */
	function is_writable($filename)
	{
		static $cache = array();
		if (isset($cache[$filename])) {
			return $cache[$filename];
		}
		static $versioncompare = '4.4.2';
		$cache[$filename] = false;
		if (FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			if (version_compare(PHP_VERSION, $versioncompare) >= 0 OR is_file($filename)) {
				$cache[$filename] = is_writable($filename);
			} elseif (is_dir($filename)) {
				$testfile = "{$filename}/".md5(uniqid(rand(), true));
				if (@touch($testfile)) {
					@unlink($testfile);
					$cache[$filename] = true;
				}
			}
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = <<<EOT
				if (version_compare(PHP_VERSION, '{$versioncompare}') >= 0 OR is_file('{$filename}')) {
					print(is_writable('{$filename}'));
					exit;
				} elseif (is_dir('{$filename}')) {
					\$testfile = "{$filename}/".md5(uniqid(rand(), true));
					if (@touch(\$testfile)) {
						@unlink(\$testfile);
						print(1);
						exit;
					}
				}
EOT;
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				$cache[$filename] = true;
			}
		}
		return $cache[$filename];
	}//end function is_writable

	/**
	 * Description ˺ڽ mkdir() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ҪĿ¼
	 * @param int ָĿ¼ɹҪıļģʽ
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function mkdir($pathname, $mode = 0777)
	{
		if (true === FileHandle::is_allowed_to_access_in_safe_mode($pathname)) {
			if (mkdir($pathname, $mode)) {
				return chmod($pathname, $mode);
			}
		} else {
			$parentdir = realpath(dirname($pathname));
			if (false === $parentdir) {
				trigger_error("FileHandle::mkdir({$pathname}): No such file or directory.", E_USER_WARNING);
				return false;
			}
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				if (false === ($writabledir = FileHandle::find_writable_dir($parentdir))) {
					return false;
				}
			}
			$mkdircode = "if(@mkdir('{$pathname}', '{$mode}') AND @chmod('{$pathname}', '{$mode}')){print(1);exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($mkdircode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle:mkdir({$pathname}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
		return false;
	}//end function mkdir

	/**
	 * Description ˺ڽ move_uploaded_file() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ϴļļ
	 * @param string Ŀļ
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */ 
	function move_uploaded_file($filename, $destination)
	{
		if (true === FileHandle::is_allowed_to_access_in_safe_mode($destination)) {
			return move_uploaded_file($filename, $destination);
		} else {
			$destdir = realpath(dirname($destination));
			if (false === $destdir) {
				trigger_error("FileHandle::move_uploaded_file({$destination}): No such file or directory", E_USER_WARNING);
				return false;
			}
			$writabledir = FileHandle::find_writable_dir($destdir);
			if (empty($writabledir)) {
				return false;
			}

			$destfile = $writabledir.'/'.basename($destination);
			if (move_uploaded_file($filename, $destfile)) {
				@chmod($destfile, 0777);
				$operationcode = "if(@rename('{$destfile}', '{$destination}')){print(1);exit;}";
				$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			}
			@unlink($destfile);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::move_uploaded_file(): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
		return false;
	}//end function move_uploaded_file

	/**
	 * Description ݹɾĿ¼ѡ$optsѡɾʹѭ洫ͳĵݹ㷨ٶȸЧ(ʱȫְ֧ȫģʽɾ)
	 * @author 
	 * @param string ĿĿ¼
	 * @param int ɾѡֵΪ0,1,2,3
	 * @return array ĿĿ¼ڣ򲻿д򷵻FALSE򣬷һĸԪصļֵ飻ֱʾsubdircount ʾļеsubdirremovednum ʾѳɹɾļеsubfilecount ʾļsubfileremovednum ʾѳɹɾļ
	 */
	function recursion_removedir($destdir, $rmopts = 0)
	{
		if ($rmopts < 0 OR $rmopts > 3) {
			$rmopts = 0;
		}
		if ($rmopts == 0) { // ȫɾ
			$rmself = true;
			$rmsubfile = true;
			$rmsubdir = true;
		} elseif ($rmopts == 1) { // ֻɾļ
			$rmself = false;
			$rmsubfile = true;
			$rmsubdir = false;
		} elseif ($rmopts == 2) { // ֻɾļ
			$rmself = false;
			$rmsubfile = false;
			$rmsubdir = true;
		} elseif ($rmopts == 3) { // ֻɾļļ
			$rmself = false;
			$rmsubfile = true;
			$rmsubdir = true;
		}
		if (false === $rmself AND false === $rmsubfile AND false === $rmsubdir) {
			return false;
		}

		$destdir = realpath($destdir);
		if ((false === $destdir)) {
			trigger_error("FileHandle::recursion_removedir(): No such directory ", E_USER_WARNING);
			return false;
		}
		if (!FileHandle::is_writable($destdir)) {
			trigger_error("FileHandle::recursion_removedir(): Unable to access file {$destdir} because Permission denied ", E_USER_WARNING);
			return false;
		}

		$subdircount = 0;
		$subdirremovednum = 0;
		$subfilecount = 0;
		$subfileremovednum = 0;
		$LIFO_queue = array();
		if ($filelist =& FileHandle::scandir($destdir)) {
			$LIFO_index = 0;
			$LIFO_queue[0] =& $filelist;
			$dir_removelist = array();
			while ($LIFO_index >= 0) {
				if (isset($LIFO_queue[$LIFO_index]['files'])) {
					$subfilecount += count($LIFO_queue[$LIFO_index]['files']);
					if (true === $rmsubfile) {
						foreach ($LIFO_queue[$LIFO_index]['files'] AS $entry) {
							if (FileHandle::unlink($destdir.'/'.$entry)) {
								$subfileremovednum++;
							}
						}
					}
					unset($LIFO_queue[$LIFO_index]['files']);
				}
				$emptydirectories = true;
				if (isset($LIFO_queue[$LIFO_index]['directories'])) {
					if ($count = count($LIFO_queue[$LIFO_index]['directories'])) {
						$subdircount += $count - 2;
					}
					foreach ($LIFO_queue[$LIFO_index]['directories'] AS $index => $entry) {
						unset($LIFO_queue[$LIFO_index]['directories'][$index]);
						if ($entry == '.' OR $entry == '..') {
							continue;
						}
						$currdirrealpath = $destdir.'/'.$entry;
						if (true === $rmsubdir) {
							$dir_removelist[] = $currdirrealpath;
						}
						if ($filelist =& FileHandle::scandir($currdirrealpath)) {
							$destdir = $currdirrealpath;
							$LIFO_index++;
							$LIFO_queue[$LIFO_index] =& $filelist;
							$emptydirectories = false;
							break;
						}
					}
				}
				if (true === $emptydirectories) {
					unset($LIFO_queue[$LIFO_index]['directories']);
					$LIFO_index--;
					$destdir = dirname($destdir);
					if ($LIFO_index < 0) {
						unset($LIFO_queue);
						break;
					}
				}
			}
			if (!empty($dir_removelist) AND is_array($dir_removelist)) {
				for ($i = count($dir_removelist) - 1 ; $i >= 0 ; $i--) {
					if (FileHandle::rmdir($dir_removelist[$i])) {
						$subdirremovednum++;
					}
				}
				unset($cachedir);
			}
			if (true === $rmself) {
				FileHandle::rmdir($destdir);
			}
		}
		return array('subdircount' => $subdircount, 'subdirremovednum' => $subdirremovednum, 'subfilecount' => $subfilecount, 'subfileremovednum' => $subfileremovednum);
	}//end function recursion_rmdir
	
	/**
	 * Description ɾļĿ¼֧ɾĿ¼ļ
	 * @author 
	 * @param string ҪִвļĿ¼
	 * @param boolean ÿһļĿ¼һصļ黺
	 * @return boolean ļTRUE򷵻 FALSE
	 */
	function remove($dest, $opts = array())
	{
		//Start ѡóʼ
			//Start ݹɾĿ¼ѡ
				if (!isset($opts['recursion'])) {
					$opts['recursion'] = false;
				} else {
					$opts['recursion'] = true;
				}
			//End ݹɾĿ¼ѡ
		//End ѡóʼ
		if (FileHandle::is_file($dest)) {
			return FileHandle::unlink($dest);
		} elseif (FileHandle::is_dir($dest)) {
			if (false === $opts['recursion']) {
				return FileHandle::rmdir($dest);
			} else {
				return FileHandle::recursion_removedir($dest);
			}
		} else {
			trigger_error("FileHandle::remove({$dest}): No such file or directory.", E_USER_WARNING);
			return false;
		}
	}//end function remove

	/**
	 * Description ˺ڽ rename() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ԭļ
	 * @param string µļ
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function rename($oldname, $newname)
	{
		$tmpoldname = $oldname;
		$oldname = realpath($oldname);
		if (false === $oldname) {
			trigger_error("FileHandle::rename({$tmpoldname},{$newname}): No such file or directory.", E_USER_WARNING);
			return false;
		}
		if (false === ($oldisallowed = FileHandle::is_allowed_to_access_in_safe_mode($oldname))) {
			$oldisallowed = FileHandle::is_allowed_to_access_in_safe_mode(dirname($oldname));
		}
		$newdir = realpath(dirname($newname));
		if (false === ($newisallowed = FileHandle::is_allowed_to_access_in_safe_mode($newname))) {
			if (false === $newdir) {
				trigger_error("FileHandle::rename({$tmpoldname},{$newname}): No such file or directory.", E_USER_WARNING);
				return false;
			}
			$newisallowed = FileHandle::is_allowed_to_access_in_safe_mode($newdir);
		}

		if (true === $oldisallowed AND true === $newisallowed) {
			return rename($oldname, $newname);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			if (true === $oldisallowed) {
				$tmpfile = $writabledir.'/'.strtolower(substr(base64_encode(md5(uniqid(strtotime('now'),true))),20,8));
				if (FileHandle::icopy($oldname, $tmpfile)) {
					$operationcode = "if(@rename('{$tmpfile}', '{$newname}')){print(1);exit;}";
					$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
					if ($execresult == 1) {
						FileHandle::remove($oldname, array('recursion' => true));
						return true;
					} else {
						FileHandle::remove($tmpfile, array('recursion' => true));
						if (!empty($execresult)) {
							trigger_error("FileHandle::rename({$oldname}, {$newname}): {$execresult}", E_USER_WARNING);
						}
						return false;
					}
				}
			} elseif (true === $newisallowed) {
				$tmpfile = $newdir.'/'.strtolower(substr(base64_encode(md5(uniqid(strtotime('now'),true))),20,8));
				if (touch($tmpfile)) {
					$operationcode = "if(@rename('{$oldname}', '{$tmpfile}')){print(1);exit;}";
					$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
					if ($execresult == 1) {
						rename($tmpfile, $newname);
						return true;
					} else {
						FileHandle::remove($tmpfile, array('recursion'=>true));
						if (!empty($execresult)) {
							trigger_error("FileHandle::rename({$oldname}, {$newname}): {$execresult}", E_USER_WARNING);
						}
						return false;
					}
				}
			} else {
				$operationcode = "if(@rename('{$oldname}', '{$newname}')){print(1);exit;}";
				$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
				if ($execresult == 1) {
					return true;
				} elseif (!empty($execresult)) {
					trigger_error("FileHandle::rename({$oldname}, {$newname}): {$execresult}", E_USER_WARNING);
					return false;
				}
			}
		}
		return false;
	}//end function rename

	/**
	 * Description ˺ڽ rmdir() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ԭļ
	 * @param string µļ
	 * @param string 0777ԵĿ¼Ŀ¼͵ǰűͬUIDģҿͨhttpʸĿ¼
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function rmdir($destdir)
	{
		if (FileHandle::is_allowed_to_access_in_safe_mode($destdir)) {
			return rmdir($destdir);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@rmdir('{$destdir}')){print(1);exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::rmdir({$destdir}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
	}//end function rmdir

	/**
	 * Description гָ·еļĿ¼
	 * @author 
	 * @param string ĿĿ¼
	 * @return array һ array directory еļĿ¼ directory һĿ¼򷵻زֵ FALSEһ E_WARNING Ĵ
	 */
	function &scandir($directory)
	{
		$returnval = false;
		if (false === ($directory = realpath($directory))) {
			return $returnval;
		}
		if (!FileHandle::is_dir($directory)) {
			trigger_error("FileHandle::scandir({$directory}): No suche directory.", E_WARNING);
			return $returnval;
		}
		if (FileHandle::is_allowed_to_access_in_safe_mode($directory)) {
			if ($res_dir = dir($directory)) {
				$returnval = array();
				while (false !== ($entry = $res_dir->read())) {
					$fullentry = $res_dir->path.'/'.$entry;
					if (is_file($fullentry)) {
						$returnval['files'][] = $entry;
					} elseif (is_dir($fullentry)) {
						$returnval['directories'][] = $entry;
					}
				}
				$res_dir->close();
			}
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return $returnval;
			}
			$operationcode = <<<EOT
				if (\$res_dir = @dir('{$directory}')) {
					\$returnval = array();
					while (false !== (\$entry = \$res_dir->read())) {
						\$fullentry = \$res_dir->path.'/'.\$entry;
						if (is_file(\$fullentry)) {
							\$returnval['files'][] = \$entry;
						} elseif (is_dir(\$fullentry)) {
							\$returnval['directories'][] = \$entry;
						}
					}
					\$res_dir->close();
					print serialize(\$returnval);
				}
EOT;
			if ($execresult = FileHandle::filehandle_in_safe_mode($operationcode)) {
				$returnval = @unserialize(stripslashes($execresult));
			}
			if (!$returnval) {
				trigger_error("FileHandle::scandir({$directory}): {$execresult}", E_USER_WARNING);
			}
		}
		return $returnval;
	}

	/**
	 * Description ˺ڽ touch() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string ԭļ
	 * @param string µļ
	 * @return boolean ļ source  destɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function touch($filename, $time = null, $atime = null)
	{
		if (!FileHandle::file_exists(dirname($filename))) {
			trigger_error("FileHandle::touch({$filename}): No such file or directory.", E_USER_WARNING);
			return false;
		}
		$writabledir = FileHandle::find_writable_dir();
		if (empty($writabledir)) {
			return false;
		}
		if (true === FileHandle::is_allowed_to_access_in_safe_mode($filename)) {
			return touch($filename, $time, $atime);
		} else {
			$operationcode = "if(@touch('{$filename}', '{$time}', '{$atime}')){print(1);exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::touch({$filename},{$time},{$atime}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
		return false;
	}//end function touch

	/**
	 * Description ˺ڽ unlink() ڰȫģʽƵ⡣ֻҪļĿ¼UIDűUIDʱUIDͬͿڰȫģʽ²ƵС
	 * @author 
	 * @param string Ŀļ
	 * @return boolean ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function unlink($destfile)
	{
		if (FileHandle::is_allowed_to_access_in_safe_mode($destfile)) {
			return unlink($destfile);
		} else {
			$writabledir = FileHandle::find_writable_dir();
			if (empty($writabledir)) {
				return false;
			}
			$operationcode = "if(@unlink('{$destfile}')){print(1);exit;}";
			$execresult = FileHandle::filehandle_in_safe_mode($operationcode);
			if ($execresult == 1) {
				return true;
			} elseif (!empty($execresult)) {
				trigger_error("FileHandle::unlink({$destfile}): {$execresult}", E_USER_WARNING);
				return false;
			}
		}
	}//end function unlink
	
}//end class FileHandle

/**
 * Description ˺ FileHandle::file_put_contents() ı
 */
function FilePubContents($destfile, &$contents, $isappend=false)
{
	return FileHandle::file_put_contents($destfile, $contents, $isappend);
}//end function FilePubContents

/**
 * Description ˺ FileHandle::file_get_contents() ı
 */
function FileGetContents($file)
{
	return FileHandle::file_get_contents($file);
}//end function FileGetContents

/**
 * Description ĿĿ¼Ƿд
 * @author 
 * @param string ĿĿ¼
 * @return boolean дTRUE򷵻FALSE
 */
function dir_is_writable($testdir)
{
	if (!is_dir($testdir)) {
		return false;
	} else {
		return FileHandle::is_writable($testdir);
	}
}
/**
 * Description ˺ dir_is_writable() ı
 */
function dir_iswritable($testdir)
{
	return dir_is_writable($testdir);
}

/**
 * Description ˺ FileHandle::recursion_rmdir() ı
 */
function recursionRemoveDir($destdir, $rmopts = 7)
{
	return FileHandle::recursion_removedir($destdir, $rmopts);
}

function isUploadedFile($filename)
{
	return FileHandle::is_uploaded_file($filename);
}//end function isUploadedFile

?>