<?php
if( !defined('ISDVBBS') ){
	header('HTTP/1.0 400 Bad Request');
	exit;
}

error_reporting(E_ALL & ~E_NOTICE);

$exitthisscript = !function_exists('gd_info');
if (true === $exitthisscript AND !get_cfg_var('safe_mode') AND function_exists('dl')) {
	$extension_dir = ini_get('extension_dir');
	if (strtoupper(substr(PHP_OS, 0, 3) == 'WIN')) {
		$extension_file1 = 'php_gd.dll';
		$extension_file2 = 'php_gd2.dll';
	} else {
		$extension_file1 = 'php_gd.so';
		$extension_file2 = 'php_gd2.so';
	}
	if ($extension_dir AND file_exists($extension_dir . '/' . $extension_file)) {
		@ini_set('display_errors', true);
		@dl($extension_file);
	}
	$exitthisscript = false;
}


 function canmakethumbnail()
{
	static $canmakethumbnail = null;
	if (null === $canmakethumbnail) {
		if (true === $GLOBALS['exitthisscript']) {
			$canmakethumbnail = false;
		} elseif (!function_exists('imagejpeg')) {
			$canmakethumbnail = false;
		} elseif (!function_exists('imagecopyresampled') OR !function_exists('imagecreatetruecolor')) {
			if (!function_exists('imagecreate') OR !function_exists('imagecopyresized')) {
				$canmakethumbnail = false;
			}
		} else {
			$canmakethumbnail = true;
		}
	}
	return $canmakethumbnail;
} 
/**
 * Description ĿͼƬͼ
 * @author xiaodu@dvbbs
 * @param mixed ĿͼļͼԴʶ
 * @param int ͼĿ
 * @param int ͼĸ߶
 * @param string ͼļԶڸļ.jpgչ
 * @return boolean ɹ TRUEʧ򷵻 FALSE
 */
function image_thumbnail($srcimg, $newwidth, $newheight, $newname, $quality = 75)
{

	if (!canmakethumbnail()) {
		return false;
	}
	if ($newwidth <=0 OR $newheight <= 0) {
		return false;
	}
	include_once "bmp.php";

	$srcwidth = 0;
	$srcheight = 0;
	if (false !== ($srcimg = @realpath($srcimg))) {
		$arrimg = getimagesize($srcimg);
		switch ($arrimg[2]) {
			case 1: // GIF
				$srcimg = imagecreatefromgif($srcimg);
				break;
			case 2: // JPG
				$srcimg = imagecreatefromjpeg($srcimg);
				break;
			case 3: // PNG
				$srcimg = imagecreatefrompng($srcimg);
				break;
			case 6:	//BMP
				$srcimg = imagecreatefrombmp($srcimg);
				break;
			default:
				return false;
		}
		if (!$srcimg) {
			return false;
		}
		$srcwidth = $arrimg[0];
		$srcheight = $arrimg[1];
	} else {
		$srcwidth = @imagesx($srcimg);
		$srcheight = @imagesy($srcimg);
	}
	if ($srcwidth <=0 OR $srcheight <= 0) {
		return false;
	}

	if ($srcwidth < $newwidth OR $srcheight < $newheight) {
		return imagejpeg($srcimg, $newname.".jpg", $quality); 
	} else {
		if (function_exists('imagecopyresampled') AND function_exists('imagecreatetruecolor')) {
			$resnewimg = imagecreatetruecolor($newwidth, $newheight);
			imagecopyresampled($resnewimg, $srcimg, 0, 0, 0, 0, $newwidth, $newheight, $srcwidth, $srcheight); 
		} elseif (function_exists('imagecreate') AND function_exists('imagecopyresized')) {
			$resnewimg = imagecreate($newwidth, $newheight); 
			imagecopyresized($resnewimg, $srcimg, 0, 0, 0, 0, $newwidth, $newheight, $srcwidth, $srcheight); 
		} else {
			return false;
		}
		if (imagejpeg($resnewimg, $newname.'.jpg', $quality)) {
			imagedestroy($resnewimg);
			return true;
		}
	}

	return false;
}//end function dv_image_thumbnail


function canmakewatermark()
{
	static $canmakewatermark = null;
	if (null === $canmakewatermark) {
		if (true === $GLOBALS['exitthisscript']) {
			$canmakewatermark = false;
		} elseif (!function_exists('gd_info')) {
			$canmakewatermark = false;
		}
		$canmakewatermark = true;
	}
	return $canmakewatermark;
}

/* 
* ܣPHPͼƬˮӡ (ˮӡ֧ͼƬ) 
*  
*      $groundImage    ͼƬҪˮӡͼƬֻ֧GIF,JPG,PNGʽ 
*      $waterPos        ˮӡλã10״̬0Ϊλã 
*                        1Ϊ˾2Ϊ˾У3Ϊ˾ң 
*                        4Ϊв5ΪвУ6Ϊвң 
*                        7Ϊ׶˾8Ϊ׶˾У9Ϊ׶˾ң 
*      $waterImageOrText  ͼƬˮӡΪˮӡͼƬֻ֧GIF,JPG,PNGʽ   ˮӡΪΪˮӡ֧ASCII룬֧
*      $textFont        ִСֵΪ12345ĬΪ5 
*      $textColor        ɫֵΪʮɫֵĬΪ#FF0000(ɫ) 
* 
* ע⣺Support GD 2.0Support FreeTypeGIF ReadGIF CreateJPG PNG 
*      $waterImage  $waterText òҪͬʱʹãѡ֮һɣʹ $waterImage 
*      $waterImageЧʱ$waterString$stringFont$stringColorЧ 
*      ˮӡͼƬļ $groundImage һ 
* ߣlongware @ 2004-11-3 14:15:13 
*/ 
//function imageWaterMark($groundImage, $waterPos=0, $waterImageOrText="", $textFont=5, $textColor="#FF0000", $imagePercent, $textType)
function imageWaterMark($groundImage,$waterPos=0,$waterImageOrText="",$textFont=5,$textColor="#FF0000", $imagePercent, $textType)
{
	$waterImageOrText = gb2utf8($waterImageOrText);
	if (empty($waterImageOrText)) {
		return false;
	}
	global $lang;
    $isWaterImage = FALSE; 
    $formatMsg = $lang['misc.str1']; 
    include_once "bmp.php";

    //ȡˮӡļ 
    if(!empty($waterImageOrText) && file_exists($waterImageOrText)) 
    { 
        $isWaterImage = TRUE; 
        $water_info = getimagesize($waterImageOrText); 
        $water_w    = $water_info[0];//ȡˮӡͼƬĿ 
        $water_h    = $water_info[1];//ȡˮӡͼƬĸ 

        switch($water_info[2])//ȡˮӡͼƬĸʽ 
        { 
            case 1:$water_im = imagecreatefromgif($waterImageOrText);break; 
            case 2:$water_im = imagecreatefromjpeg($waterImageOrText);break; 
            case 3:$water_im = imagecreatefrompng($waterImageOrText);break; 
            case 6:$water_im = imagecreatefrombmp($waterImageOrText);break;
            default:die($formatMsg); 
        } 
    } 

    //ȡͼƬ 
    if(!empty($groundImage) && file_exists($groundImage))
    { 
        $ground_info = getimagesize($groundImage); 
        $ground_w    = $ground_info[0];//ȡñͼƬĿ 
        $ground_h    = $ground_info[1];//ȡñͼƬĸ 

        switch($ground_info[2])//ȡñͼƬĸʽ 
        { 
            case 1:$ground_im = imagecreatefromgif($groundImage);break; 
            case 2:$ground_im = imagecreatefromjpeg($groundImage);break; 
            case 3:$ground_im = imagecreatefrompng($groundImage);break; 
            case 6:$ground_im = imagecreatefrombmp($groundImage);break;
            default:die($formatMsg); 
        } 
    } 
    else 
    { 
        trigger_error($lang['misc.str2'], E_USER_ERROR);
		return false;
    } 

    //ˮӡλ 
    if($isWaterImage)//ͼƬˮӡ 
    { 
        $w = $water_w; 
        $h = $water_h; 
        $label = $lang['misc.str3']; 
    } 
    else//ˮӡ 
    {	
		switch($textType){
			case '':
			case '_GB2312':
			$font = 'simkai.ttf';
			break;
			
			case '':
			$font = 'simsun.ttc';
			break;
			
			case '':
			$font = 'simhei.ttf';
			break;
			
			case '':
			$font = 'SIMLI.ttf';
			break;
			
			case 'Arial':
			$font = 'arial.ttf';
			break;
			
			case 'Arial Black':
			$font = 'ariblk.ttf';
			break;
			
			case 'Book Antiqua':
			$font = 'BKANT.TTF';
			break;
			
			case 'Century Gothic':
			$font = 'GOTHIC.TTF';
			break;
			
			case 'Comic Sans MS':
			$font = 'comic.ttf';
			break;
			
			case 'Courier New':
			$tem_font = 'cour.ttf';
			break;
		
			case 'Georgia':
			$font = 'georgia.ttf';
			break;
			
			case 'Impact':
			$font = 'impact.ttf';
			break;
			
			case 'Tahoma':
			$font = 'tahoma.ttf';
			break;
			
			case 'Times New Roman':
			$font = 'times.ttf';
			break;
			
			case 'Trebuchet MS':
			$font = 'trebuc.ttf';
			break;
			
			case 'Stencil':
			$font = 'script.fon';
			break;
			
			case 'Verdana':
			$font = 'verdana.ttf';
			break;
			case 'Lucida Console':
			$font = 'lucon.ttf	';
			break;		
			
			default:
			case '':
			$font = 'simfang.ttf';
			break;				
		} 	
		$font = ROOT_PATH.'images/getcode/'.$font;
		if(!file_exists($font)){
			$font = ROOT_PATH."images/getcode/".rand(1,4).".ttf";
		}
		$temp = imagettfbbox($textFont,0,$font,$waterImageOrText);//ȡʹ TrueType ıķΧ 
        $w = $temp[2] - $temp[6];
        $h = $temp[3] - $temp[7];
        unset($temp); 
        $label = $lang['misc.str4']; 
    } 
    if( ($ground_w<$w) || ($ground_h<$h) ) 
    { 
		$lang['misc.str5'] = str_replace('$label', $label, $lang['misc.str5']);
        trigger_error($lang['misc.str5'], E_USER_WARNING);
        return false; 
    } 
    switch($waterPos) 
    {
        case 0:// 
            $posX = rand(0,($ground_w - $w)); 
            $posY = rand(0,($ground_h - $h)); 
            break; 
        case 1://1Ϊ˾ 
            $posX = 0; 
            $posY = 0; 
            break; 
        case 2://2Ϊ˾ 
            $posX = ($ground_w - $w) / 2; 
            $posY = 0;  
            break; 
        case 3://3Ϊ˾ 
            $posX = $ground_w - $w; 
            $posY = 30; 
            break; 
        case 4://4Ϊв 
            $posX = 0; 
            $posY = ($ground_h - $h) / 2; 
            break; 
        case 5://5Ϊв 
            $posX = ($ground_w - $w) / 2; 
            $posY = ($ground_h - $h) / 2; 
            break; 
        case 6://6Ϊв 
            $posX = $ground_w - $w; 
            $posY = ($ground_h - $h) / 2; 
            break; 
        case 7://7Ϊ׶˾ 
            $posX = 0; 
            $posY = $ground_h - $h; 
            break; 
        case '8'://8Ϊ׶˾ 
            $posX = ($ground_w - $w) / 2; 
            $posY = $ground_h - $h; 
            break; 
        case 9://9Ϊ׶˾ 
            $posX = $ground_w - $w; 
            $posY = $ground_h - $h;
            break; 
        default:// 
            $posX = rand(0,($ground_w - $w)); 
            $posY = rand(0,($ground_h - $h)); 
            break;     
    } 
	if($posY < 15)
		$posY= 15;

    //趨ͼĻɫģʽ 
    imagealphablending($ground_im, true); 

    if($isWaterImage)//ͼƬˮӡ 
    {
		if($imagePercent == 1)
			imagecopy($ground_im, $water_im, $posX, $posY, 0, 0, $water_w,$water_h);//ˮӡĿļ         
		else
			imagecopymerge($ground_im, $water_im,$posX,$posY,0,0,$water_w,$water_h,$imagePercent*100);
    } 
    else//ˮӡ 
    { 
        if( !empty($textColor) && (strlen($textColor)==7) ) 
        { 
            $R = hexdec(substr($textColor,1,2)); 
            $G = hexdec(substr($textColor,3,2)); 
            $B = hexdec(substr($textColor,5)); 
        } 
        else 
        { 
            trigger_error($lang['misc.str6'], E_USER_ERROR);
			return false;
        } 
		
		imagettftext($ground_im, $textFont, 0, $posX, $posY, imagecolorallocate($ground_im, $R, $G, $B), $font, $waterImageOrText);
    } 

    //ˮӡͼƬ 
    @unlink($groundImage); 
    switch($ground_info[2])//ȡñͼƬĸʽ
    { 
        case 1:imagegif($ground_im,$groundImage);break; 
        case 2:imagejpeg($ground_im,$groundImage);break; 
        case 3:imagepng($ground_im,$groundImage);break; 
        case 6:imagebmp($ground_im,$groundImage);break;
        default:die($errorMsg); 
    } 

    //ͷڴ 
    if(isset($water_info)) unset($water_info); 
    if(isset($water_im)) imagedestroy($water_im); 
    unset($ground_info); 
    imagedestroy($ground_im);
	return true;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
gb2utf8                ָתΪUTF-8ʽӢĻ
ڲ
*/
function gb2utf8($gb)
{
	if(!trim($gb))
		return $gb;
	$filename=ROOT_PATH."inc/gb2312.txt";
	$tmp=file($filename);
	$codetable=array();
	while(list($key,$value)=each($tmp))
	$codetable[hexdec(substr($value,0,6))]=substr($value,7,6);

	$utf8="";
	while($gb)
	{
		if (ord(substr($gb,0,1))>127)
		{
			$tthis=substr($gb,0,2);
			$gb=substr($gb,2,strlen($gb)-2);
			$utf8.=u2utf8(hexdec($codetable[hexdec(bin2hex($tthis))-0x8080]));
		}
		else
		{
			$tthis=substr($gb,0,1);
			$gb=substr($gb,1,strlen($gb)-1);
			$utf8.=u2utf8($tthis);
		}
	}

return $utf8;
}

function u2utf8($c)
{
	$str="";
	if ($c < 0x80)
	{
		$str.=$c;
	}
	else if ($c < 0x800)
	{
		$str.=chr(0xC0 | $c>>6);
		$str.=chr(0x80 | $c & 0x3F);
	}
	else if ($c < 0x10000)
	{
		$str.=chr(0xE0 | $c>>12);
		$str.=chr(0x80 | $c>>6 & 0x3F);
		$str.=chr(0x80 | $c & 0x3F);
	}
	else if ($c < 0x200000)
	{
		$str.=chr(0xF0 | $c>>18);
		$str.=chr(0x80 | $c>>12 & 0x3F);
		$str.=chr(0x80 | $c>>6 & 0x3F);
		$str.=chr(0x80 | $c & 0x3F);
	}
return $str;
}
?>