<?php
function initUploadDirectories($opts = array('init_tmpdir'=>true, 'init_updestdir'=>true, 'init_preview_dir'=>true, 'init_space_updestdir'=>true, 'init_space_preview_dir'=>true, 'destdir'=>''))
{
	require_once INC_PATH.'image_misc.functions.php';
	require_once INC_PATH.'FileHandler.class.php';
	global $lang, $_SERVER, $fsetting, $spaceSystemUpSetting;
	if (!isset($opts['init_tmpdir'])) {
		$opts['init_tmpdir'] = true;
	}
	if (!isset($opts['init_updestdir'])) {
		$opts['init_updestdir'] = true;
	}
	if (true !== $opts['init_updestdir']) {
		$opts['init_preview_dir'] = false;
	}
	if (!isset($opts['init_preview_dir'])) {
		$opts['init_preview_dir'] = true;
	}
	if (!isset($opts['init_space_updestdir'])) {
		$opts['init_space_updestdir'] = true;
	}
	if (true !== $opts['init_space_updestdir']) {
		$opts['init_space_preview_dir'] = false;
	}
	if (!isset($opts['init_space_preview_dir'])) {
		$opts['init_space_preview_dir'] = true;
	}

	if (empty($fsetting)) {
		require_once CACHE_PATH.'forum_setting.php';
		$fsetting =& $_DCACHE['settings'];
	}
	if (true === $opts['init_space_updestdir'] AND empty($spaceSystemUpSetting)) {
		require_once CACHE_PATH.'space/space_config.php';
		$spaceSystemSetting =& $_DCACHE['spaceConfig_system'];
		$spaceSystemUpSetting = explode('|',$spaceSystemSetting[12]);
	}

//Start ʼվϴĿ¼
	$Tpl_dir = $uptopdir = (!empty($fsetting['forumuploadname']) ? $fsetting['forumuploadname'] : './uploadfile');
	if (false === ($uptopdir = realpath($uptopdir))) {
		exit('Cannot find upload base directory!');
	}
	$uptopdir = str_replace('\\', '/', $uptopdir);
//End ʼվϴĿ¼

//Start ʼ洢ʱϴļĿ¼
	if (true === $opts['init_tmpdir']) {
		$uptmpdir = $uptopdir.'/tempimage';
		if (!is_dir($uptmpdir)) {
			exit('Cannot find upload temporary directory!');
		}
	}
//End ʼ洢ʱϴļĿ¼

	if (!empty($opts['destdir'])) {
		$destdir = basename(trim($opts['destdir']));
	} else {
		$destdir = date('Y-m');
	}
	$forumuploadsettings = explode('|', $fsetting['uploadsetting']);
	$forum_dir = $uptopdir.'/forum';

//Start ʼ̳ϴĿĿ¼date('Y-m')Ŀ¼
	if (true === $opts['init_preview_dir'] OR true === $opts['init_updestdir']) {
		if (!is_dir($forum_dir)) {
			exit('No such directory '.$forum_dir.'!');
		}
		$updestdir = $forum_dir.'/'.$destdir;
		if (!is_dir($updestdir) AND !FileHandler::mkdir($updestdir)) {
			exit('Cannot make directory '.$updestdir.'!');
		}
		@chmod($updestdir, 0777);
	}
//End ʼ̳ϴĿĿ¼date('Y-m')Ŀ¼

//Start ʼ̳ͼĿ¼
	$canmakethumbnail = (true === $opts['init_preview_dir'] AND $forumuploadsettings[17] != 0 AND canmakethumbnail());
	if (true === $canmakethumbnail) {
		$previewdir = $forum_dir.'/previewimage';
		if (!is_dir($previewdir)) {
			exit('Cannot find preview directory '.$previewdir.'!');
		}
		@chmod($previewdir, 0777);
		$previewdestdir = $previewdir.'/'.$destdir;
		if (!is_dir($previewdestdir) AND !mkdir($previewdestdir, 0777)) {
			exit('Cannot make preview directory '.$previewdestdir.'!');
		}
		@chmod($previewdestdir, 0777);
	}
//End ʼ̳ͼĿ¼

//Start ʼ˿ռϴĿ¼
	$spaceuptopdir = $uptopdir.'/'.(!empty($spaceSystemUpSetting[19]) ? $spaceSystemUpSetting[19] : 'space');
	if (!is_dir($spaceuptopdir)) {
		exit('Cannot find space upload base directory '.$spaceuptopdir.'!');
	}
//End ʼ˿ռϴĿ¼

//Start ʼ˿ռϴĿĿ¼date('Y-m')Ŀ¼
	if (true === $opts['init_space_preview_dir'] OR true === $opts['init_space_updestdir']) {
		$spacedestdir = $spaceuptopdir.'/'.$destdir;
		if (!is_dir($spacedestdir) AND !FileHandler::mkdir($spacedestdir, 0777)) {
			exit('Cannot make space directory '.$spacedestdir.'!');
		}
		@chmod($spacedestdir, 0777);
	}
//End ʼ˿ռϴϴĿĿ¼date('Y-m')Ŀ¼

//Start ʼ˿ռͼĿ¼
	$canmakethumbnail = (true === $opts['init_space_preview_dir'] AND $spaceSystemUpSetting[17] != 0 AND canmakethumbnail());
	if (true === $canmakethumbnail) {
		$spacepreviewdir = $spaceuptopdir.'/previewimage';
		if (!is_dir($spacepreviewdir)) {
			exit('Cannot find space preview directory '.$spacepreviewdir.'!');
		}
		@chmod($spacepreviewdir, 0777);
		$spacepreviewdestdir = $spacepreviewdir.'/'.$destdir;
		if (!is_dir($spacepreviewdestdir) AND !FileHandler::mkdir($spacepreviewdestdir)) {
			exit('Cannot make space preview directory '.$spacepreviewdestdir.'!');
		}
		@chmod($spacepreviewdestdir, 0777);
	}
//End ʼ˿ռͼĿ¼
	$documentroot = str_replace(array('\\', '//'), '/', realpath(FileHandler::getDocumentRoot(false)));

	return array('uptopdir'=>$uptopdir, 'uptmpdir'=>$uptmpdir, 'documentroot'=>$documentroot, 'updestdir'=>$updestdir, 'previewdir'=>$previewdir, 'previewdestdir'=>$previewdestdir, 'spaceuptopdir'=>$spaceuptopdir, 'spacedestdir'=>$spacedestdir, 'spacepreviewdir'=>$spacepreviewdir, 'spacepreviewdestdir'=>$spacepreviewdestdir);
}//end function initUploadDirectories
?>