#<?php exit(); ?>
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET character_set_client=binary, character_set_connection=gbk, character_set_results=gbk */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='SYSTEM' */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES */;

DROP TABLE IF EXISTS `dv_active`;
CREATE TABLE `dv_active` (
  `activeid` int(11) unsigned NOT NULL auto_increment,
  `postuserid` int(11) unsigned NOT NULL default '0',
  `activename` varchar(250) NOT NULL default '',
  `activecity` varchar(250) default '',
  `activeclass` varchar(250) NOT NULL default '',
  `timemode` tinyint(3) unsigned NOT NULL default '0',
  `starttime` varchar(50) NOT NULL default '',
  `endtime` varchar(50) NOT NULL default '',
  `location` varchar(250) NOT NULL default '',
  `cost` varchar(50) default '',
  `sex` varchar(100) NOT NULL default '',
  `strength` varchar(50) default '',
  `expiretime` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`activeid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_activeuser`;
CREATE TABLE `dv_activeuser` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `activeid` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `joindate` varchar(50) NOT NULL default '',
  `costmode` tinyint(3) unsigned NOT NULL default '0',
  `costnum` varchar(100) default '',
  `systemmode` text,
  `message` text,
  `isexamine` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_admin`;
CREATE TABLE `dv_admin` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(50) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `flag` text,
  `lastlogin` int(10) unsigned NOT NULL default '0',
  `lastloginip` varchar(20) default NULL,
  `adduser` varchar(50) default NULL,
  `acceptip` varchar(255) default NULL,
  `sessioncode` varchar(6) default NULL,
  `errcount` smallint(6) default '0',
  `mysession` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_argue`;
CREATE TABLE `dv_argue` (
  `argueid` int(10) unsigned NOT NULL auto_increment,
  `boardid` int(10) unsigned NOT NULL default '0',
  `rootid` int(10) unsigned NOT NULL default '0',
  `arguetype` enum('0','1','2','3') default '0',
  `parentid` int(10) unsigned NOT NULL default '0',
  `child` int(10) unsigned NOT NULL default '0',
  `vote` int(10) unsigned NOT NULL default '0',
  `expression` varchar(100) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `creation_date` int(10) unsigned NOT NULL default '0',
  `postusername` varchar(50) NOT NULL default '',
  `postuserid` int(10) unsigned NOT NULL default '0',
  `ip` varchar(40) NOT NULL default '',
  `length` int(10) unsigned NOT NULL default '0',
  `locktopic` int(10) unsigned NOT NULL default '0',
  `ubblist` varchar(255) NOT NULL default '',
  `isbest` enum('0','1') NOT NULL default '0',
  `isupload` enum('0','1') NOT NULL default '0',
  `voteid` int(10) unsigned NOT NULL default '0',
  `forumtype` int(2) unsigned NULL default '0',
  PRIMARY KEY  (`argueid`),
  UNIQUE KEY `arguelist` (`boardid`,`rootid`,`arguetype`,`parentid`,`argueid`,`postuserid`),
  KEY `today_post_num` (`boardid`,`rootid`,`creation_date`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_argue_topic`;
CREATE TABLE `dv_argue_topic` (
  `boardid` int(10) unsigned NOT NULL default '0',
  `rootid` int(10) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `title_obverse` varchar(255) NOT NULL default '',
  `title_reversed` varchar(255) NOT NULL default '',
  `title_third` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `creation_date` int(10) unsigned NOT NULL default '0',
  `start_time` int(10) unsigned NOT NULL default '0',
  `end_time` int(10) unsigned NOT NULL default '0',
  `postuserid` int(10) unsigned NOT NULL default '0',
  `postusername` varchar(50) NOT NULL default '',
  `child` int(10) unsigned NOT NULL default '0',
  `child_obverse` int(10) unsigned NOT NULL default '0',
  `child_obverse_post` int(10) unsigned NOT NULL default '0',
  `child_obverse_reply` int(10) unsigned NOT NULL default '0',
  `child_reversed` int(10) unsigned NOT NULL default '0',
  `child_reversed_post` int(10) unsigned NOT NULL default '0',
  `child_reversed_reply` int(10) unsigned NOT NULL default '0',
  `child_third` int(10) unsigned NOT NULL default '0',
  `child_third_post` int(10) unsigned NOT NULL default '0',
  `child_third_reply` int(10) unsigned NOT NULL default '0',
  `vote` int(10) unsigned NOT NULL default '0',
  `vote_obverse` int(10) unsigned NOT NULL default '0',
  `vote_reversed` int(10) unsigned NOT NULL default '0',
  `vote_third` int(10) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  `ip` varchar(40) NOT NULL default '',
  `locktopic` int(10) unsigned NOT NULL default '0',
  `ubblist` varchar(255) NOT NULL default '',
  `isbest` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`boardid`,`rootid`,`postuserid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;


DROP TABLE IF EXISTS `dv_banklog`;
CREATE TABLE `dv_banklog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `userid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(18) NOT NULL default '',
  `acttime` datetime NOT NULL default '0000-00-00 00:00:00',
  `action` varchar(255) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`,`username`),
  KEY `userid_2` (`userid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bankstatus`;
CREATE TABLE `dv_bankstatus` (
  `id` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  `username` varchar(16) NOT NULL default '',
  `bankstatus` int(11) NOT NULL default '0',
  `bankpass` varchar(40) NOT NULL default '',
  `money` float NOT NULL default '0',
  `loanmoney` float NOT NULL default '0',
  `enddate` int(11) NOT NULL default '0',
  `begdatetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `updatetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`,`username`),
  KEY `userid_2` (`userid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bbs1`;
CREATE TABLE `dv_bbs1` (
  `announceid` int(11) unsigned NOT NULL auto_increment,
  `parentid` int(11) NOT NULL default '0',
  `boardid` int(11) NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `postuserid` int(11) NOT NULL default '0',
  `topic` varchar(255) NOT NULL default '',
  `body` text,
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `length` int(11) NOT NULL default '0',
  `rootid` int(11) NOT NULL default '0',
  `layer` smallint(6) NOT NULL default '0',
  `orders` int(11) NOT NULL default '0',
  `isbest` tinyint(3) unsigned NOT NULL default '0',
  `ip` varchar(40) default NULL,
  `expression` varchar(100) default NULL,
  `locktopic` int(11) unsigned NOT NULL default '0',
  `signflag` tinyint(3) unsigned NOT NULL default '0',
  `emailflag` tinyint(3) unsigned NOT NULL default '0',
  `isagree` varchar(50) default NULL,
  `isaudit` tinyint(3) unsigned NOT NULL default '0',
  `isupload` tinyint(3) unsigned NOT NULL default '0',
  `postbuyuser` text,
  `ubblist` varchar(255) default NULL,
  `getmoney` int(11) unsigned NOT NULL default '0',
  `usetools` varchar(255) default NULL,
  `getmoneytype` tinyint(3) unsigned NOT NULL default '0',
  `savvy_comment` text,
  `forumtype` int(2) unsigned default '0',
  `ask_solve` int(2) unsigned default '0',
  PRIMARY KEY  (`announceid`),
  KEY `dispbbs` (`boardid`,`rootid`),
  KEY `postuserid` (`postuserid`),
  KEY `save_1` (`rootid`,`orders`),
  KEY `dateandtime` (`dateandtime`),
  KEY `rootid` (`rootid`),
  KEY `audit_list` (`boardid`,`locktopic`),
  KEY `forumtype` (`forumtype`),
  KEY `ask_solve` (`ask_solve`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bbs_ft`;
CREATE TABLE `dv_bbs_ft` (
  `announceid` int(11) unsigned NOT NULL default '0',
  `rootid` int(11) unsigned NOT NULL default '0',
  `boardid` int(11) unsigned NOT NULL default '0',
  `locktopic` int(11) unsigned NOT NULL default '0',
  `posttable` varchar(100) NOT NULL default '',
  `topicindex` tinytext NOT NULL,
  `bodyindex` text NOT NULL,
  `issavvytopic` tinyint(1) NOT NULL default '0',
  PRIMARY KEY (`announceid`,`rootid`,`boardid`,`locktopic`,`posttable`),
  KEY `rootid` (`rootid`),
  KEY `boardid` (`boardid`,`locktopic`),
  KEY `posttable` (`posttable`),
  FULLTEXT KEY `ft_search` (`topicindex`,`bodyindex`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bbslink`;
CREATE TABLE `dv_bbslink` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `boardname` varchar(50) default NULL,
  `readme` varchar(255) default NULL,
  `url` varchar(150) default NULL,
  `logo` varchar(255) default NULL,
  `islogo` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bbsnews`;
CREATE TABLE `dv_bbsnews` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `boardid` int(11) unsigned NOT NULL default '0',
  `title` varchar(50) default NULL,
  `content` text,
  `username` varchar(50) default NULL,
  `addtime` int(10) unsigned NOT NULL default '0',
  `bgs` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_besttopic`;
CREATE TABLE `dv_besttopic` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `announceid` int(11) unsigned NOT NULL default '0',
  `rootid` int(11) unsigned NOT NULL default '0',
  `boardid` int(11) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `postusername` varchar(50) NOT NULL default '',
  `postuserid` int(11) unsigned NOT NULL default '0',
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `expression` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `postuserid` (`postuserid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_board`;
CREATE TABLE `dv_board` (
  `boardid` int(11) NOT NULL default '0',
  `boardtype` varchar(50) NOT NULL default '',
  `boardname` varchar(50) NOT NULL default '',
  `showtype` tinyint(1) unsigned NOT NULL default '0',
  `parentid` int(11) unsigned NOT NULL default '0',
  `parentstr` varchar(255) NOT NULL default '',
  `depth` smallint(6) unsigned NOT NULL default '0',
  `rootid` int(11) unsigned NOT NULL default '0',
  `child` smallint(6) unsigned NOT NULL default '0',
  `readme` varchar(250) default NULL,
  `boardmaster` varchar(250) NOT NULL default '',
  `postnum` int(11) unsigned NOT NULL default '0',
  `topicnum` int(11) unsigned NOT NULL default '0',
  `indeximg` varchar(255) NOT NULL default '',
  `todaynum` int(11) unsigned NOT NULL default '0',
  `boarduser` text,
  `lastpost` varchar(255) NOT NULL default '',
  `orders` int(11) unsigned NOT NULL default '0',
  `board_setting` text NOT NULL,
  `board_user` text NOT NULL,
  `isgroupsetting` varchar(200) NOT NULL default '',
  `boardtopstr` varchar(255) NOT NULL default '',
  `cid` varchar(100) NOT NULL default '',
  `rules` text NOT NULL,
  `allowpost` tinyint(1) unsigned NOT NULL default '1',
  `ishidden` tinyint(1) unsigned NOT NULL default '0',
  `ischeckout` enum('0','1') NOT NULL default '0',
  `ads_id` int(11) unsigned NOT NULL default '1',
  `setting_id` int(11) unsigned NOT NULL default '1',
  `audit_settings_id` int(11) unsigned NOT NULL default '0',
  `showboard` int(1) unsigned NOT NULL default '0',
  `showboardmaster` int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`boardid`),
  KEY `board` (`rootid`,`orders`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_gather_url`;
CREATE TABLE `dv_gather_url` (
  `id` int(11) NOT NULL auto_increment,
  `boardtype` mediumint(9) default '0',
  `noteid` int(11) NOT NULL default '0',
  `url` varchar(255) default NULL,
  `title` text,
  `gatherdate` int(11) default NULL,
  `isdone` tinyint(3) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url` (`url`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;


DROP TABLE IF EXISTS `dv_boardpermission`;
CREATE TABLE `dv_boardpermission` (
  `pid` int(11) unsigned NOT NULL default '0',
  `boardid` int(11) unsigned NOT NULL default '0',
  `groupid` int(11) unsigned NOT NULL default '0',
  `psetting` text
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_bookmark`;
CREATE TABLE `dv_bookmark` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(125) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `topic` varchar(255) NOT NULL default '',
  `addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_chanorders`;
CREATE TABLE `dv_chanorders` (
  `o_id` int(10) unsigned NOT NULL auto_increment,
  `o_type` smallint(6) unsigned NOT NULL default '0',
  `o_mobile` varchar(20) default NULL,
  `o_username` varchar(50) default NULL,
  `o_isapply` tinyint(4) unsigned NOT NULL default '0',
  `o_issuc` tinyint(4) unsigned NOT NULL default '0',
  `o_paymoney` float unsigned NOT NULL default '0',
  `o_paycode` varchar(30) default NULL,
  `o_boardid` int(11) unsigned NOT NULL default '0',
  `o_topicid` int(11) unsigned NOT NULL default '0',
  `o_addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`o_id`),
  KEY `o_username` (`o_username`,`o_issuc`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_friend`;
CREATE TABLE `dv_friend` (
  `f_id` int(11) unsigned NOT NULL auto_increment,
  `f_username` varchar(50) NOT NULL default '',
  `f_friend` varchar(50) NOT NULL default '',
  `f_addtime` int(10) unsigned NOT NULL default '0',
  `f_mod` tinyint(3) unsigned NOT NULL default '0',
  `f_userid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`f_id`),
  KEY `f_userid` (`f_userid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_fsettings`;
CREATE TABLE `dv_fsettings` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `type` varchar(200) default NULL,
  `setting` text,
  `description` varchar(200) default NULL,
  `s_class` int(11) default '1',
  `c_orders` int(11) unsigned default '1',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_gather_info`;
CREATE TABLE `dv_gather_info` (
  `g_id` int(11) unsigned NOT NULL auto_increment,
  `g_title` varchar(80) default NULL,
  `g_body` text,
  `g_write` varchar(40) default NULL,
  `g_datetime` int(10) unsigned NOT NULL default '0',
  `g_from` varchar(80) default NULL,
  `g_notename` varchar(40) default NULL,
  `board_type` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`g_id`),
  KEY `g_id_2` (`g_id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_group_bbs1`;
CREATE TABLE `dv_group_bbs1` (
  `announceid` int(11) NOT NULL auto_increment,
  `parentid` int(11) NOT NULL default '0',
  `groupid` int(11) NOT NULL default '0',
  `boardid` int(11) NOT NULL default '0',
  `username` varchar(255) NOT NULL default '',
  `postuserid` int(11) NOT NULL default '0',
  `topic` varchar(255) NOT NULL default '',
  `body` text,
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `length` int(11) NOT NULL default '0',
  `rootid` int(11) NOT NULL default '0',
  `layer` int(11) NOT NULL default '0',
  `orders` int(11) NOT NULL default '0',
  `isbest` int(11) NOT NULL default '0',
  `ip` varchar(40) NOT NULL default '',
  `expression` varchar(255) NOT NULL default '',
  `locktopic` int(11) NOT NULL default '0',
  `signflag` tinyint(4) NOT NULL default '0',
  `isagree` varchar(255) NOT NULL default '',
  `isupload` tinyint(4) NOT NULL default '0',
  `ubblist` varchar(255) default NULL,
  PRIMARY KEY  (`announceid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_group_board`;
CREATE TABLE `dv_group_board` (
  `id` int(11) NOT NULL auto_increment,
  `boardname` varchar(255) NOT NULL default '',
  `boardinfo` text,
  `indeximg` varchar(255) NOT NULL default '',
  `topicnum` int(11) NOT NULL default '0',
  `todaynum` int(11) NOT NULL default '0',
  `postnum` int(11) NOT NULL default '0',
  `rootid` int(11) NOT NULL default '0',
  `lastpost` varchar(255) default NULL,
  `founddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `rules` text,
  `boardstats` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_group_name`;
CREATE TABLE `dv_group_name` (
  `id` int(11) NOT NULL auto_increment,
  `groupname` varchar(255) NOT NULL default '',
  `groupinfo` text,
  `appuserid` int(11) NOT NULL default '0',
  `appusername` varchar(255) NOT NULL default '',
  `usernum` int(11) NOT NULL default '0',
  `stats` tinyint(4) NOT NULL default '0',
  `postnum` int(11) NOT NULL default '0',
  `topicnum` int(11) NOT NULL default '0',
  `todaynum` int(11) NOT NULL default '0',
  `yesterdaynum` int(11) NOT NULL default '0',
  `limituser` int(11) NOT NULL default '0',
  `appdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `passdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `visidate` datetime NOT NULL default '0000-00-00 00:00:00',
  `locked` tinyint(4) NOT NULL default '0',
  `viewflag` tinyint(4) NOT NULL default '0',
  `groupface` varchar(255) NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_group_topic`;
CREATE TABLE `dv_group_topic` (
  `topicid` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `groupid` int(11) NOT NULL default '0',
  `boardid` int(11) NOT NULL default '0',
  `pollid` int(11) NOT NULL default '0',
  `locktopic` int(11) NOT NULL default '0',
  `child` int(11) NOT NULL default '0',
  `postusername` varchar(255) NOT NULL default '',
  `postuserid` int(11) NOT NULL default '0',
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `expression` varchar(255) NOT NULL default '0',
  `lastpost` varchar(255) NOT NULL default '',
  `istop` tinyint(4) NOT NULL default '0',
  `lastposttime` int(11) unsigned NOT NULL default '0',
  `isbest` tinyint(4) NOT NULL default '0',
  `mode` tinyint(4) NOT NULL default '0',
  `topicmode` tinyint(1) NOT NULL default '0',
  `topicfont` varchar(6) NULL,
  PRIMARY KEY  (`topicid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_group_user`;
CREATE TABLE `dv_group_user` (
  `id` int(11) NOT NULL auto_increment,
  `groupid` int(11) NOT NULL default '0',
  `userid` int(11) NOT NULL default '0',
  `username` varchar(255) NOT NULL default '',
  `islock` tinyint(4) NOT NULL default '0',
  `intro` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_groupname`;
CREATE TABLE `dv_groupname` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `groupname` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_help`;
CREATE TABLE `dv_help` (
  `h_id` int(11) unsigned NOT NULL auto_increment,
  `h_parentid` int(11) unsigned NOT NULL default '0',
  `h_title` varchar(250) NOT NULL default '',
  `h_content` text,
  `h_type` tinyint(3) unsigned default '0',
  `h_stype` int(11) unsigned NOT NULL default '0',
  `h_bgimg` varchar(100) default NULL,
  `h_addtime` int(10) unsigned NOT NULL default '0',
  `h_fileurl` varchar(100) default NULL,
  PRIMARY KEY  (`h_id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_honor_list`;
CREATE TABLE `dv_honor_list` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `honorname` varchar(40) default NULL,
  `honorpic` varchar(255) default NULL,
  `honorread` tinytext,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_honor_user`;
CREATE TABLE `dv_honor_user` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(40) default NULL,
  `honorname` varchar(255) default NULL,
  `honorpic` varchar(255) default NULL,
  `issueuser` varchar(40) default NULL,
  `reason` tinytext,
  `honortime` int(10) unsigned default NULL,
  `pos` int(2) unsigned default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_log`;
CREATE TABLE `dv_log` (
  `l_id` int(11) unsigned NOT NULL auto_increment,
  `l_announceid` int(11) unsigned NOT NULL default '0',
  `l_boardid` int(11) unsigned NOT NULL default '0',
  `l_touser` varchar(50) default NULL,
  `l_username` varchar(50) default NULL,
  `l_content` varchar(255) default NULL,
  `l_addtime` int(10) unsigned NOT NULL default '0',
  `l_ip` varchar(40) default NULL,
  `l_type` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`l_id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;


DROP TABLE IF EXISTS `dv_message`;
CREATE TABLE `dv_message` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sender` varchar(50) default NULL,
  `incept` varchar(50) default NULL,
  `title` varchar(127) default NULL,
  `content` text,
  `flag` int(11) unsigned NOT NULL default '0',
  `sendtime` int(10) unsigned NOT NULL default '0',
  `delr` tinyint(3) unsigned NOT NULL default '0',
  `dels` tinyint(3) unsigned NOT NULL default '0',
  `issend` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `sender` (`sender`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_moneylog`;
CREATE TABLE `dv_moneylog` (
  `log_id` int(11) unsigned NOT NULL auto_increment,
  `toolsid` int(11) unsigned NOT NULL default '0',
  `countnum` int(11) unsigned NOT NULL default '0',
  `log_money` int(11) unsigned NOT NULL default '0',
  `log_ticket` int(11) unsigned NOT NULL default '0',
  `addusername` varchar(50) default NULL,
  `adduserid` int(11) unsigned NOT NULL default '0',
  `log_ip` varchar(40) default NULL,
  `log_time` int(10) unsigned NOT NULL default '0',
  `log_type` tinyint(3) unsigned default NULL,
  `boardid` int(11) unsigned NOT NULL default '0',
  `conect` text,
  `hmoney` varchar(250) default NULL,
  PRIMARY KEY  (`log_id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_note_info`;
CREATE TABLE `dv_note_info` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `note_name` varchar(40) NOT NULL default '',
  `coding` int(2) NOT NULL default '0',
  `bordertype` int(11) unsigned NOT NULL default '0',
  `from_url` varchar(80) default NULL,
  `last_gather_date` int(10) unsigned default NULL,
  `note_datetime` int(10) unsigned default NULL,
  `down_pic` int(2) default NULL,
  `web_num` int(11) unsigned default NULL,
  `sp_page` tinytext,
  `article_title` tinytext,
  `article_from` tinytext,
  `article_write` tinytext,
  `article_time` tinytext,
  `article_body` tinytext,
  `gatherid` tinytext,
  `includeurl` varchar(125) default NULL,
  `pagevar` varchar(125) default NULL,
  `color_style` int(2) unsigned NOT NULL default '1',
  `board_setup` int(2) unsigned NOT NULL default '1',
  `title_inhere_swap` tinytext,
  `body_inhere_swap` tinytext,
  `script_leach` tinytext,
  `news_time` int(2) unsigned default '0',
  `keyword` tinytext,
  `page_class` int(2) unsigned default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_online`;
CREATE TABLE `dv_online` (
  `id` bigint(11) unsigned NOT NULL auto_increment,
  `username` varchar(50) default NULL,
  `userclass` varchar(20) default NULL,
  `stats` varchar(250) default NULL,
  `ip` varchar(20) default NULL,
  `actforip` varchar(30) default NULL,
  `startime` int(10) unsigned NOT NULL default '0',
  `lastimebk` int(10) unsigned NOT NULL default '0',
  `boardid` int(11) unsigned NOT NULL default '0',
  `browser` varchar(200) default NULL,
  `usergroupid` int(11) unsigned NOT NULL default '0',
  `actCome` varchar(50) default NULL,
  `userhidden` tinyint(3) unsigned NOT NULL default '2',
  `userid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `userid` (`userid`,`boardid`)
) TYPE=MyISAM  /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_plus`;
CREATE TABLE `dv_plus` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `plus_type` varchar(100) default NULL,
  `plus_name` varchar(100) default NULL,
  `isuse` tinyint(3) unsigned NOT NULL default '0',
  `plus_setting` text,
  `mainpage` varchar(100) default NULL,
  `isshowmenu` tinyint(3) unsigned NOT NULL default '0',
  `plus_copyright` varchar(200) default NULL,
  `plus_adminpage` varchar(100) default NULL,
  `plus_id` varchar(100) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_plus_tools_buss`;
CREATE TABLE `dv_plus_tools_buss` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `toolsid` int(11) unsigned NOT NULL default '0',
  `toolsname` varchar(50) default NULL,
  `toolscount` int(11) unsigned NOT NULL default '0',
  `salecount` int(11) unsigned NOT NULL default '0',
  `updatetime` int(10) unsigned NOT NULL default '0',
  `salemoney` int(11) unsigned NOT NULL default '0',
  `saleticket` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_plus_tools_info`;
CREATE TABLE `dv_plus_tools_info` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `toolsname` varchar(50) default NULL,
  `toolsinfo` varchar(255) default NULL,
  `toolsimg` varchar(150) default NULL,
  `isstar` smallint(6) unsigned NOT NULL default '0',
  `sysstock` int(11) unsigned NOT NULL default '0',
  `userstock` int(11) unsigned NOT NULL default '0',
  `userticket` int(11) unsigned NOT NULL default '0',
  `usermoney` int(11) unsigned NOT NULL default '0',
  `userpost` int(11) unsigned NOT NULL default '0',
  `userwealth` int(11) unsigned NOT NULL default '0',
  `userep` int(11) unsigned NOT NULL default '0',
  `usercp` int(11) unsigned NOT NULL default '0',
  `usergroupid` varchar(255) default NULL,
  `boardid` text,
  `buytype` tinyint(3) unsigned NOT NULL default '0',
  `toolssetting` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_plus_tools_magicface`;
CREATE TABLE `dv_plus_tools_magicface` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `magicface_s` int(11) unsigned NOT NULL default '0',
  `magicface_l` int(11) unsigned NOT NULL default '0',
  `magictype` smallint(6) unsigned NOT NULL default '0',
  `imoney` int(11) unsigned NOT NULL default '0',
  `iticket` int(11) unsigned NOT NULL default '0',
  `tmoney` int(11) unsigned NOT NULL default '0',
  `tticket` int(11) unsigned NOT NULL default '0',
  `magicsetting` varchar(250) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_querycache`;
CREATE TABLE `dv_querycache` (
  `boardid` int(11) unsigned NOT NULL default '0',
  `keyword` varchar(25) NOT NULL default '0',
  `stype` enum('1','2','7') NOT NULL default '2',
  `creation_datetime` int(10) unsigned NOT NULL default '0',
  `qid_list` text NOT NULL,
  `id_count` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`boardid`,`keyword`,`stype`,`creation_datetime`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_savvy_integral`;
CREATE TABLE `dv_savvy_integral` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `userid` int(10) unsigned default NULL,
  `username` varchar(40) default NULL,
  `answercount` int(11) unsigned default '0',
  `answeradopt` int(11) unsigned default '0',
  `askcount` int(11) unsigned default '0',
  `askdonecount` int(11) unsigned default '0',
  `askdoningcount` int(11) unsigned default '0',
  `asknodonecount` int(11) unsigned default '0',
  `wealthcount` int(11) unsigned default '0',
  `answerwealth` int(11) unsigned default '0',
  `savvy_hortation` int(11) unsigned default '0',
  `offer_pay` int(11) unsigned default '0',
  `anonymity_ask` int(11) unsigned default '0',
  `punishother` int(11) unsigned default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_savvy_topic`;
CREATE TABLE `dv_savvy_topic` (
  `topicid` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `boardid` int(11) unsigned NOT NULL default '0',
  `pollid` int(11) unsigned NOT NULL default '0',
  `locktopic` int(11) unsigned NOT NULL default '0',
  `child` int(11) unsigned NOT NULL default '0',
  `postusername` varchar(50) default NULL,
  `postuserid` int(11) unsigned NOT NULL default '0',
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `expression` varchar(100) default NULL,
  `votetotal` int(11) unsigned NOT NULL default '0',
  `lastpost` varchar(255) default NULL,
  `lastposttime` int(10) unsigned NOT NULL default '0',
  `istop` tinyint(3) unsigned NOT NULL default '0',
  `isvote` tinyint(3) default '0',
  `isbest` enum('0','1') NOT NULL default '0',
  `posttable` varchar(50) NOT NULL default '',
  `smsuserlist` text,
  `issmstopic` tinyint(1) unsigned NOT NULL default '0',
  `lastsmstime` int(10) unsigned default NULL,
  `topicmode` tinyint(1) unsigned NOT NULL default '0',
  `topicfont` varchar(6) NULL,
  `mode` smallint(6) unsigned NOT NULL default '0',
  `getmoney` int(11) unsigned NOT NULL default '0',
  `usetools` varchar(255) default NULL,
  `getmoneytype` tinyint(1) unsigned default '0',
  `hidename` tinyint(1) unsigned NOT NULL default '0',
  `solve` int(2) unsigned default '0',
  `anonymity` int(2) unsigned default '0',
  `againmoney` tinyint(3) unsigned NOT NULL default '0',
  
  PRIMARY KEY  (`topicid`),
  KEY `rssindex` (`dateandtime`,`boardid`),
  KEY `board_topic_list` (`istop`,`boardid`,`lastposttime`),
  KEY `audit_list` (`boardid`,`locktopic`),
  KEY `postuserid` (`postuserid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_savvy_wealth`;
CREATE TABLE `dv_savvy_wealth` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `forumid` int(11) unsigned NOT NULL default '0',
  `title` varchar(255) default NULL,
  `wealth` int(11) unsigned default '0',
  `dateandtime` int(10) unsigned default NULL,
  `position` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_setup`;
CREATE TABLE `dv_setup` (
  `id` int(11) default '0',
  `forum_setting` text,
  `forum_ads` text,
  `forum_badwords` text,
  `forum_rbadword` text,
  `forum_maxonline` int(11) unsigned NOT NULL default '0',
  `forum_maxonlinedate` int(10) unsigned NOT NULL default '0',
  `forum_topicnum` int(11) unsigned NOT NULL default '0',
  `forum_postnum` int(11) unsigned NOT NULL default '0',
  `forum_todaynum` int(11) unsigned NOT NULL default '0',
  `forum_usernum` int(11) unsigned NOT NULL default '0',
  `forum_yesterdaynum` int(11) unsigned NOT NULL default '0',
  `forum_maxpostnum` int(11) unsigned NOT NULL default '0',
  `forum_maxpostdate` int(10) unsigned NOT NULL default '0',
  `forum_lastuser` varchar(25) default NULL,
  `forum_lastpost` varchar(255) default NULL,
  `forum_birthuser` text,
  `forum_sid` int(11) unsigned NOT NULL default '0',
  `forum_version` varchar(100) default NULL,
  `forum_nowusebbs` varchar(50) default NULL,
  `forum_isinstall` tinyint(3) unsigned NOT NULL default '0',
  `forum_challengepassword` varchar(25) default NULL,
  `forum_channame` varchar(50) default NULL,
  `forum_chansetting` varchar(250) default NULL,
  `forum_lockip` text,
  `forum_cookiespath` varchar(50) default NULL,
  `forum_boards` text,
  `forum_alltopnum` varchar(250) default NULL,
  `forum_pack` varchar(250) default NULL,
  `forum_cid` int(11) unsigned NOT NULL default '0',
  `forum_avasiteid` varchar(50) default NULL,
  `forum_avasign` varchar(50) default NULL,
  `forum_adminfolder` varchar(50) default NULL,
  `forum_boardxml` text,
  `forum_css` text,
  `forum_face` text,
  `forum_tpl` varchar(128) default NULL,
  `forum_adsid` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_smallpaper`;
CREATE TABLE `dv_smallpaper` (
  `s_id` int(11) unsigned NOT NULL auto_increment,
  `s_boardid` int(11) unsigned NOT NULL default '0',
  `s_username` varchar(50) default NULL,
  `s_title` varchar(100) default NULL,
  `s_content` text,
  `s_hits` int(11) unsigned NOT NULL default '0',
  `s_addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`s_id`),
  KEY `S_Addtime` (`s_addtime`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_apply_today_star`;
CREATE TABLE `dv_space_apply_today_star` (
  `userid` int(11) unsigned NOT NULL default '0',
  `apply_timestamp` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `nickname` varchar(50) NOT NULL default '',
  `user_photo` varchar(255) NOT NULL default '',
  `user_preview_photo` varchar(255) NOT NULL default '',
  `status` enum('0','1') NOT NULL default '0',
  `apply_desc` varchar(255) default NULL,
  PRIMARY KEY  (`userid`),
  UNIQUE KEY `status` (`status`,`userid`,`apply_timestamp`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_keyword`;
CREATE TABLE `dv_space_keyword` (
  `keyid` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `keyword` varchar(50) default NULL,
  `nkeyword` varchar(50) default NULL,
  `linkurl` varchar(250) default NULL,
  `linktitle` varchar(50) default NULL,
  `newwindows` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`keyid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_post`;
CREATE TABLE `dv_space_post` (
  `postid` int(11) unsigned NOT NULL auto_increment,
  `spaceuserid` int(11) unsigned NOT NULL default '0',
  `catid` int(11) unsigned NOT NULL default '0',
  `scatid` int(11) unsigned NOT NULL default '0',
  `parentid` int(11) unsigned NOT NULL default '0',
  `rootid` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) default NULL,
  `title` varchar(250) NOT NULL default '',
  `content` text NOT NULL,
  `jointime` int(10) unsigned NOT NULL default '0',
  `ip` varchar(40) default NULL,
  `stype` tinyint(3) unsigned NOT NULL default '0',
  `isupfile` tinyint(3) unsigned NOT NULL default '0',
  `islock` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`postid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_skins`;
CREATE TABLE `dv_space_skins` (
  `s_id` int(11) unsigned NOT NULL auto_increment,
  `s_skinname` char(50) default NULL,
  `s_path` char(150) default NULL,
  `s_viewpic` char(50) default NULL,
  `s_info` char(255) default NULL,
  `s_builder` char(50) default NULL,
  PRIMARY KEY  (`s_id`),
  KEY `PRIMARY_KEY` (`s_id`),
  KEY `S_id` (`s_id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_syscat`;
CREATE TABLE `dv_space_syscat` (
  `scatid` int(11) unsigned NOT NULL auto_increment,
  `scattitle` varchar(20) default NULL,
  `scatnote` longtext,
  `stype` tinyint(3) unsigned NOT NULL default '0',
  `ucatnum` int(11) unsigned NOT NULL default '0',
  `topicnum` int(11) unsigned NOT NULL default '0',
  `postnum` int(11) unsigned NOT NULL default '0',
  `todaynum` int(11) unsigned NOT NULL default '0',
  `lastuptime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`scatid`),
  KEY `PostNum` (`postnum`),
  KEY `PRIMARY_KEY` (`scatid`),
  KEY `sCatID` (`scatid`),
  KEY `TodayNum` (`todaynum`),
  KEY `TopicNum` (`topicnum`),
  KEY `uCatNum` (`ucatnum`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_system`;
CREATE TABLE `dv_space_system` (
  `s_id` int(11) unsigned NOT NULL auto_increment,
  `s_name` varchar(50) default NULL,
  `s_note` text,
  `s_lastposttime` int(10) unsigned NOT NULL default '0',
  `s_topicnum` int(11) NOT NULL default '0',
  `s_photonum` int(11) NOT NULL default '0',
  `s_favnum` int(11) NOT NULL default '0',
  `s_usernum` int(11) NOT NULL default '0',
  `s_todaynum` int(11) NOT NULL default '0',
  `s_postnum` int(11) NOT NULL default '0',
  `s_medianum` int(11) unsigned NOT NULL default '0',
  `s_setting` text,
  `s_url` varchar(250) default NULL,
  `s_sdomain` varchar(50) default NULL,
  `skinid` int(11) unsigned NOT NULL default '0',
  `s_topnews` text,
  `s_managenews` text,
  `today_recommend` text,
  `today_star` text,
  PRIMARY KEY  (`s_id`),
  KEY `FavNum` (`s_favnum`),
  KEY `id` (`s_id`),
  KEY `PhotoNum` (`s_photonum`),
  KEY `PRIMARY_KEY` (`s_id`),
  KEY `S_PostNum` (`s_postnum`),
  KEY `SkinID` (`skinid`),
  KEY `TodayNum` (`s_todaynum`),
  KEY `TopicNum` (`s_topicnum`),
  KEY `UserNum` (`s_usernum`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_topic`;
CREATE TABLE `dv_space_topic` (
  `topicid` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) unsigned NOT NULL default '0',
  `scatid` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) default NULL,
  `title` varchar(250) default NULL,
  `titlenote` text,
  `posttime` int(10) unsigned NOT NULL default '0',
  `child` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `isview` tinyint(3) unsigned default NULL,
  `islock` tinyint(3) unsigned NOT NULL default '0',
  `stype` tinyint(3) unsigned NOT NULL default '0',
  `lastposttime` int(10) unsigned NOT NULL default '0',
  `isbest` int(11) unsigned NOT NULL default '0',
  `s_key` varchar(250) default NULL,
  `weather` smallint(6) unsigned NOT NULL default '0',
  `visituser` text,
  `paymoney` decimal(19,4) unsigned NOT NULL default '0.0000',
  `paynumber` smallint(6) unsigned NOT NULL default '0',
  `paytime` smallint(6) default NULL,
  `trackbacks` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`topicid`),
  UNIQUE KEY `sort_topic_list` (`stype`,`islock`,`topicid`),
  UNIQUE KEY `newly_topic_by_user` (`userid`,`stype`,`islock`,`topicid`),
  KEY `diary_topic` (`userid`,`posttime`,`topicid`),
  KEY `child` (`child`),
  KEY `topic_list_by_type` (`stype`,`scatid`,`catid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_upfile`;
CREATE TABLE `dv_space_upfile` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `spaceuserid` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `catid` int(11) unsigned NOT NULL default '0',
  `stype` tinyint(3) unsigned NOT NULL default '0',
  `topicid` int(11) unsigned NOT NULL default '0',
  `postid` int(11) unsigned NOT NULL default '0',
  `istopic` int(11) unsigned NOT NULL default '0',
  `title` varchar(250) default NULL,
  `filename` varchar(100) default NULL,
  `sfilename` varchar(100) default NULL,
  `filetype` int(11) unsigned NOT NULL default '0',
  `filesize` int(11) unsigned NOT NULL default '0',
  `filenote` varchar(250) default NULL,
  `downnum` int(11) unsigned NOT NULL default '0',
  `viewnum` int(11) unsigned NOT NULL default '0',
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `previewimage` varchar(250) default NULL,
  `islock` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `newly_photo_list` (`stype`,`islock`,`filetype`,`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_user`;
CREATE TABLE `dv_space_user` (
  `userid` int(11) NOT NULL default '0',
  `username` varchar(50) default NULL,
  `nickname` varchar(50) default NULL,
  `spacename` varchar(50) default NULL,
  `password` varchar(40) default NULL,
  `spacetitle` varchar(150) default NULL,
  `spacechildtitle` varchar(250) default NULL,
  `spacenote` text,
  `joinspacetime` int(10) unsigned NOT NULL default '0',
  `pageview` int(11) unsigned NOT NULL default '0',
  `topicnum` int(11) unsigned NOT NULL default '0',
  `favnum` int(11) unsigned NOT NULL default '0',
  `photonum` int(11) unsigned NOT NULL default '0',
  `postnum` int(11) unsigned NOT NULL default '0',
  `medianum` int(11) unsigned NOT NULL default '0',
  `todaynum` int(11) unsigned NOT NULL default '0',
  `trackbacks` int(11) default '0',
  `spacesize` double default NULL,
  `xmldata` text,
  `syscatid` int(11) unsigned NOT NULL default '0',
  `spacesetting` text,
  `lastuptime` int(10) unsigned NOT NULL default '0',
  `skinid` int(11) unsigned NOT NULL default '0',
  `stats` int(11) unsigned NOT NULL default '0',
  `diary_topic` text NOT NULL,
  `today_star` int(11) unsigned NOT NULL default '0',
  `myphoto_path` varchar(255) NOT NULL default '',
  `myphoto_desc` varchar(150) NOT NULL default '',
  `myphoto_preview_path` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`userid`),
  KEY `joinboketime` (`joinspacetime`),
  KEY `topicnum` (`topicnum`),
  KEY `today_star` (`today_star`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_usercat`;
CREATE TABLE `dv_space_usercat` (
  `ucatid` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `ucattitle` varchar(50) default NULL,
  `ucatnote` text,
  `opentime` int(10) unsigned NOT NULL default '0',
  `utype` tinyint(3) unsigned default NULL,
  `topicnum` int(11) unsigned NOT NULL default '0',
  `postnum` int(11) unsigned NOT NULL default '0',
  `todaynum` int(11) unsigned NOT NULL default '0',
  `isview` tinyint(3) unsigned NOT NULL default '0',
  `lastuptime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ucatid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_space_usersave`;
CREATE TABLE `dv_space_usersave` (
  `userid` int(11) unsigned NOT NULL default '0',
  `savedate` int(11) unsigned NOT NULL default '0',
  `savenum` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_styles`;
CREATE TABLE `dv_styles` (
  `styleid` int(11) NOT NULL auto_increment,
  `name` varchar(25) NOT NULL default '',
  `ename` varchar(250) NOT NULL default '',
  `content` text NOT NULL,
  `directory` varchar(100) NOT NULL default '',
  `copyright` varchar(25) NOT NULL default '',
  `stype` tinyint(3) NOT NULL default '0',
  `tpl_type` enum('0','1') NOT NULL default '0',
  `parentid` smallint(6) unsigned NOT NULL default '0',
  `charset` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`styleid`,`stype`),
  KEY `parentid` (`parentid`,`stype`),
  KEY `stype` (`stype`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_sysfiles`;
CREATE TABLE `dv_sysfiles` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `script` char(3) NOT NULL default 'php',
  `version` int(4) NOT NULL default '200',
  `database` varchar(10) NOT NULL default 'mysql',
  `charset` varchar(20) NOT NULL default 'gbk',
  `encode` varchar(10) NOT NULL default 'gb2312',
  `filename` varchar(255) default '',
  `fileext` varchar(10) default 'php',
  `filepath` varchar(255) default '',
  `filesize` int(4) NOT NULL default '0',
  `filebinary` MEDIUMTEXT,
  `rawbinary` MEDIUMTEXT,
  `securitylevel` int(2) NOT NULL default '0',
  `securityalert` varchar(255) default NULL,
  `lastupdate` int(4) default '0',
  `isdone` int(1) default '0',
  `lastmodified` int(4) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `filepath` (`filepath`),
  KEY `lastupdate` (`lastupdate`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_sysupgrade`;
CREATE TABLE `dv_sysupgrade` (
  `id` int(1) NOT NULL default '1',
  `script` char(3) NOT NULL default 'php',
  `version` int(4) NOT NULL default '204',
  `database` varchar(10) NOT NULL default 'mysql',
  `charset` varchar(20) NOT NULL default 'gbk',
  `encode` varchar(10) NOT NULL default 'gbk',
  `lastupdate` int(4) NOT NULL default '0',
  `autoupgrade` tinyint(1) default '1',
  `autorun` varchar(16) NOT NULL default '0',
  `lastmodified` int(4) default NULL,
  `query_interval` int(4) default '0',
  `last_query` int(4) default '0',
  `upgradeserver` varchar(255) default 'http://update.dvbbs.net/',
  `auth` tinyint(1) default '1',
  `rpkey` varchar(255) default NULL,
  `ftpserver` varchar(255) default '127.0.0.1',
  `ftpport` smallint(4) default '21',
  `ftpuser` varchar(255) default NULL,
  `ftppass` varchar(255) default NULL,
  `ftproot` varchar(255) default '/',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_tablelist`;
CREATE TABLE `dv_tablelist` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `tablename` varchar(50) default NULL,
  `tabletype` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_topic`;
CREATE TABLE `dv_topic` (
  `topicid` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `boardid` int(11) unsigned NOT NULL default '0',
  `pollid` int(11) unsigned NOT NULL default '0',
  `locktopic` int(11) unsigned NOT NULL default '0',
  `child` int(11) unsigned NOT NULL default '0',
  `postusername` varchar(50) default NULL,
  `postuserid` int(11) unsigned NOT NULL default '0',
  `dateandtime` int(10) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `expression` varchar(100) default NULL,
  `votetotal` int(11) unsigned NOT NULL default '0',
  `lastpost` varchar(255) default NULL,
  `lastposttime` int(10) unsigned NOT NULL default '0',
  `istop` tinyint(3) unsigned NOT NULL default '0',
  `isvote` tinyint(3) default '0',
  `isbest` enum('0','1') NOT NULL default '0',
  `posttable` varchar(50) NOT NULL default '',
  `smsuserlist` text,
  `issmstopic` tinyint(1) unsigned NOT NULL default '0',
  `lastsmstime` int(10) unsigned NOT NULL default '0',
  `topicmode` tinyint(1) unsigned NOT NULL default '0',
  `topicfont` varchar(6) NULL,
  `mode` smallint(6) unsigned NOT NULL default '0',
  `getmoney` int(11) unsigned NOT NULL default '0',
  `usetools` varchar(255) default NULL,
  `getmoneytype` tinyint(1) unsigned default '0',
  `hidename` tinyint(1) unsigned NOT NULL default '0',
  `activeid` int(11) default NULL,
  
  PRIMARY KEY  (`topicid`),
  KEY `rssindex` (`dateandtime`,`boardid`),
  KEY `board_topic_list` (`istop`,`boardid`,`lastposttime`),
  KEY `audit_list` (`boardid`,`locktopic`),
  KEY `postuserid` (`postuserid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_topic_ft`;
CREATE TABLE `dv_topic_ft` (
  `topicid` int(11) unsigned NOT NULL default '0',
  `boardid` int(11) NOT NULL default '0',
  `locktopic` int(11) unsigned NOT NULL default '0',
  `posttable` varchar(250) NOT NULL default '',
  `topicindex` tinytext NOT NULL,
  `issavvytopic` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`topicid`,`boardid`,`locktopic`,`posttable`),
  KEY `boardid` (`boardid`,`locktopic`),
  KEY `posttable` (`posttable`),
  FULLTEXT KEY `ft_search` (`topicindex`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_upfile`;
CREATE TABLE `dv_upfile` (
  `f_id` int(11) unsigned NOT NULL auto_increment,
  `f_announceid` varchar(50) default NULL,
  `f_boardid` int(11) unsigned NOT NULL default '0',
  `f_userid` int(11) unsigned NOT NULL default '0',
  `f_username` varchar(50) default NULL,
  `f_filename` varchar(255) default NULL,
  `f_filetype` varchar(10) default NULL,
  `f_type` smallint(6) unsigned NOT NULL default '0',
  `f_filesize` int(11) unsigned NOT NULL default '0',
  `f_readme` varchar(255) default NULL,
  `f_downnum` int(11) unsigned NOT NULL default '0',
  `f_viewnum` int(11) unsigned NOT NULL default '0',
  `f_downuser` text,
  `f_flag` tinyint(3) unsigned NOT NULL default '0',
  `f_addtime` int(10) unsigned NOT NULL default '0',
  `f_viewname` varchar(255) default NULL,
  PRIMARY KEY  (`f_id`),
  KEY `f_addtime` (`f_addtime`),
  KEY `f_username` (`f_username`,`f_boardid`),
  KEY `f_userid` (`f_userid`,`f_boardid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_user`;
CREATE TABLE `dv_user` (
  `userid` int(11) NOT NULL auto_increment,
  `username` varchar(50) NOT NULL default '',
  `userpassword` varchar(32) NOT NULL default '',
  `useremail` varchar(255) default NULL,
  `userpost` int(11) unsigned NOT NULL default '0',
  `posttimelimit` int(11) unsigned NOT NULL default '0',
  `usertopic` int(11) unsigned NOT NULL default '0',
  `usersign` varchar(255) default NULL,
  `usersex` tinyint(3) unsigned NOT NULL default '0',
  `userface` varchar(255) default NULL,
  `userwidth` int(11) unsigned NOT NULL default '0',
  `userheight` int(11) unsigned NOT NULL default '0',
  `userim` text,
  `joindate` int(10) unsigned NOT NULL default '0',
  `lastlogin` int(10) unsigned NOT NULL default '0',
  `userlogins` int(11) unsigned NOT NULL default '0',
  `userviews` int(11) unsigned NOT NULL default '0',
  `lockuser` tinyint(3) unsigned default NULL,
  `userclass` varchar(20) default NULL,
  `usergroup` varchar(50) default NULL,
  `userwealth` int(11) unsigned NOT NULL default '0',
  `userep` int(11) unsigned NOT NULL default '0',
  `usercp` int(11) unsigned NOT NULL default '0',
  `userpower` int(11) unsigned NOT NULL default '0',
  `userdel` int(11) unsigned NOT NULL default '0',
  `userisbest` int(11) unsigned NOT NULL default '0',
  `usertitle` varchar(50) default NULL,
  `userbirthday` int(11) unsigned NOT NULL default '0',
  `userquesion` varchar(50) default NULL,
  `useranswer` varchar(50) default NULL,
  `userlastip` varchar(30) default NULL,
  `userphoto` varchar(255) default NULL,
  `userfav` varchar(255) default NULL,
  `userinfo` text,
  `usersetting` varchar(255) default NULL,
  `usergroupid` int(11) unsigned NOT NULL default '0',
  `userhidden` tinyint(3) unsigned NOT NULL default '0',
  `titlepic` varchar(50) default NULL,
  `usermsg` varchar(100) default NULL,
  `ischallenge` tinyint(3) unsigned NOT NULL default '0',
  `usermobile` varchar(20) default NULL,
  `truepassword` varchar(20) default NULL,
  `usertoday` varchar(250) default NULL,
  `userisava` tinyint(3) unsigned NOT NULL default '0',
  `useravasetting` text,
  `usermoney` int(11) unsigned NOT NULL default '0',
  `userticket` int(11) unsigned NOT NULL default '0',
  `followmsgid` varchar(128) default NULL,
  `vip_startime` int(10) unsigned NOT NULL default '0',
  `vip_endtime` int(10) unsigned NOT NULL default '0',
  `passport` varchar(50) default NULL,
  `userupfiledate` int(10) unsigned default NULL,
  `userhonor` varchar(255) default NULL,
  PRIMARY KEY  (`userid`),
  UNIQUE KEY `backend_vip_list` (`vip_endtime`,`userid`),
  UNIQUE KEY `userbirthday` (`userbirthday`,`userid`),
  KEY `userinfo` (`usergroupid`,`userid`),
  KEY `lastlogin` (`lastlogin`),
  KEY `joindate` (`joindate`),
  KEY `userpost` (`userpost`),
  KEY `userwealth` (`userwealth`),
  KEY `usergroupid` (`usergroupid`),
  KEY `useremail` (`useremail`),
  KEY `search_name` (`username`)
) TYPE=MyISAM  /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_useraccess`;
CREATE TABLE `dv_useraccess` (
  `uc_userid` int(11) unsigned NOT NULL default '0',
  `uc_boardid` int(11) unsigned NOT NULL default '0',
  `uc_setting` longtext NOT NULL,
  PRIMARY KEY  (`uc_userid`,`uc_boardid`,`uc_setting`(5))
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_usergroups`;
CREATE TABLE `dv_usergroups` (
  `usergroupid` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(50) default NULL,
  `usertitle` varchar(50) default NULL,
  `groupsetting` text,
  `orders` smallint(6) unsigned NOT NULL default '0',
  `minarticle` int(11) unsigned NOT NULL default '0',
  `titlepic` varchar(50) default NULL,
  `grouppic` varchar(50) default NULL,
  `parentgid` int(11) unsigned NOT NULL default '0',
  `issetting` varchar(50) default NULL,
  PRIMARY KEY  (`usergroupid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_vote`;
CREATE TABLE `dv_vote` (
  `voteid` int(11) unsigned NOT NULL auto_increment,
  `vote` text,
  `votenum` varchar(100) default NULL,
  `votetype` int(11) unsigned NOT NULL default '0',
  `lockvote` int(11) unsigned NOT NULL default '0',
  `voters` int(11) unsigned NOT NULL default '0',
  `timeout` int(10) unsigned NOT NULL default '0',
  `uarticle` int(11) unsigned NOT NULL default '0',
  `uwealth` int(11) unsigned NOT NULL default '0',
  `uep` int(11) unsigned NOT NULL default '0',
  `ucp` int(11) unsigned NOT NULL default '0',
  `upower` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`voteid`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

DROP TABLE IF EXISTS `dv_voteuser`;
CREATE TABLE `dv_voteuser` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `voteid` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `votedate` int(10) unsigned NOT NULL default '0',
  `voteoption` char(50) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM /*!40101 DEFAULT CHARSET=gbk */;

#------------------init setting-----------------#

INSERT INTO `dv_admin` VALUES (1,'admin','469e80d32c0559f8','1,2,3,4,5,6,7,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,',0,'','admin','',NULL,0,NULL);


INSERT INTO `dv_sysupgrade` VALUES(1,'php',204,'mysql','gbk','gbk',1206066763,1,0,UNIX_TIMESTAMP(),'0',0,'http://update.dvbbs.net/',1,NULL,'127.0.0.1',21,NULL,NULL,'/');


INSERT INTO `dv_fsettings` VALUES (1,'Ĭϰ','<>/images/logo.gif<>1<>0<>0<>0<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>5<>200<>2<>65353<>1<>gif|jpg|jpeg|bmp|png|rar|txt|zip|mid|swf|mp3|rm|wav|wma<>1<>10<>10<>0<>1<>0<>1<>65<>25<>10<>1<>0<>0<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>1<>9<>0<>23<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>0<>ˮ|||ͷ||ݲ|ظ<><><><><><>1<>0<>','Ĭϰ',1,1);

INSERT INTO `dv_fsettings` VALUES (2,'ĬϹ÷','<iframe src="http://server.dvbbs.net/dvbbs/dvbbs_soft_top.html" height="60" width="468" marginwidth="0" marginheight="0" frameborder="0" scrolling="no"></iframe><><iframe src="http://server.dvbbs.net/dvbbs/dvbbs_soft_end.html" height="60" width="468" marginwidth="0" marginheight="0"  frameborder="0" scrolling="no"></iframe><>0<><>http://<>80<>33<>0<><>http://<>80<>33<>1<><a href="http://www.dvbbs.net/buy.asp" target="_blank">̳ҵ</a>
<a href="http://p.dvbbs.net/" target="_blank"><font color="red">̳PHPٷվ</font></a>
<a href="http://www.aspsky.cn" target="_blank"><font color="blue">̳ר</font></a>
<a href="http://www.cndw.com" target="_blank"><b><font color="#941AE6">Դ</font></b></a><>1<>0<>4<><a href="http://www.dvbbs.net/buy.asp" target="_blank">̳ҵ</a>
<a href="http://p.dvbbs.net/" target="_blank"><font color="red">̳PHPٷվ</font></a>
<a href="http://www.aspsky.cn" target="_blank"><font color="blue">̳ר</font></a>
<a href="http://www.cndw.com" target="_blank"><font color="#941AE6">Դ</font></a>
<a href="http://www.dvbbs.net/buy.asp" target="_blank">̳ҵ</a>
<a href="http://p.dvbbs.net/" target="_blank"><font color="red">̳PHPٷվ</font></a>
<a href="http://www.aspsky.cn" target="_blank"><font color="blue">̳ר</font></a>
<a href="http://www.cndw.com" target="_blank"><font color="#941AE6">Դee</font></a><>1<><a href="http://www.dvbbs.net/buy.asp" target="_blank">̳ҵ</a>
<a href="http://p.dvbbs.net/" target="_blank"><font color="red">̳PHPٷվ</font></a><>1<><a href="http://p.dvbbs.net/dispbbs-11-0-1-20932-0-0-0" target="_blank"><font><b> PHP 2.0ʽ</b></font></a>
<a href="http://p.dvbbs.net/" target="_blank"><font color="red"><b>̳PHPٷվ</b></font></a>','ĬϹ÷',2,1);


INSERT INTO `dv_board` (`boardid`, `boardtype`, `boardname`, `showtype`, `parentid`, `parentstr`, `depth`, `rootid`, `child`, `readme`, `boardmaster`, `postnum`, `topicnum`, `indeximg`, `todaynum`, `boarduser`, `lastpost`, `orders`, `board_setting`, `board_user`, `isgroupsetting`, `boardtopstr`, `cid`, `rules`, `allowpost`, `ishidden`, `ischeckout`, `ads_id`, `setting_id`, `audit_settings_id`, `showboard`, `showboardmaster`) VALUES (1, ' dvphp2.0++', 'dvphp', 0, 0, '0', 0, 1, 1, '', '', 0, 0, '', 0, '', '$0$1205748316$$0$0$2', 1, '', '', '', '', 'templates/default/images/style_css_1.css', '', 0, 0, '0', 2, 1, 0, 0, 0);

INSERT INTO `dv_board` (`boardid`, `boardtype`, `boardname`, `showtype`, `parentid`, `parentstr`, `depth`, `rootid`, `child`, `readme`, `boardmaster`, `postnum`, `topicnum`, `indeximg`, `todaynum`, `boarduser`, `lastpost`, `orders`, `board_setting`, `board_user`, `isgroupsetting`, `boardtopstr`, `cid`, `rules`, `allowpost`, `ishidden`, `ischeckout`, `ads_id`, `setting_id`, `audit_settings_id`, `showboard`, `showboardmaster`) VALUES (2, 'Ĭϰ', 'default', 0, 1, '1', 1, 1, 0, '\r\n', '', 0, 0, '', 0, '', '$$$$$$$2', 2, '', '', '', '', 'templates/default/images/style_css_1.css', '', 1, 0, '0', 2, 1, 0, 0, 0);

INSERT INTO `dv_bbslink` (`id`, `boardname`, `readme`, `url`, `logo`, `islogo`) VALUES (1, 'ȷ', 'aspsky|dvbbs||̳|asp|̳|', ' http://www.cndw.com', ' http://www.dvbbs.net/link/images/logo_2.gif', 1);

INSERT INTO `dv_bbslink` (`id`, `boardname`, `readme`, `url`, `logo`, `islogo`) VALUES  (2, 'php̳', 'aspsky|dvbbs||̳|asp|̳|', ' http://p.dvbbs.net', '', 0);

INSERT INTO `dv_help` VALUES (1,0,'','@@<a href=setting.asp target=main></a> | <a href=forumads.asp target=main></a>@@<a href=log.asp target=main>̳־</a> | <a href=help.asp target=main></a>@@<a href=wealth.asp target=main></a> | <a href=message.asp target=main>Ź</a>@@<a href=../announcements.asp?boardid=0&action=AddAnn target=_blank></a> | <a href=menpai.asp target=main>ɹ</a>@@<a href=\"ForumPay.asp\" target=main>׹</a> | <a href=\"ForumNewsSetting.asp\" target=main>ҳ</a>\r\n||̳@@<a href=board.asp?action=add target=main>()</a> | <a href=board.asp target=main></a>@@<a href=board.asp?action=permission target=main>ְûȨ</a>@@<a href=boardunite.asp target=main>ϲ</a>@@<a href=update.asp target=main>ؼ̳ݺ޸</a>@@<a href=link.asp?action=add target=main>̳</a> | <a href=link.asp target=main></a>||û@@<a href=user.asp target=main>û(Ȩ)</a>@@<a href=group.asp target=main>̳û(ȼ)</a>@@<a href=admin.asp?action=add target=main>Ա</a> | <a href=admin.asp target=main></a>@@<a href=update.asp?action=updateuser target=main>ؼû</a>@@<a href=SendEmail.asp target=main>ûʼȺ</a>||@@<a href=template.asp target=main>ģܹ</a>@@<a href=loadskin.asp target=main>ģ嵼</a> | <a href=loadskin.asp?action=load target=main></a>||̳ӹ@@<a href=alldel.asp target=main>ɾ</a> | <a href=alldel.asp?action=moveinfo target=main>ƶ</a>@@<a href=../recycle.asp target=_blank>վ</a>@@<a href=postdata.asp?action=Nowused target=main>ǰݱ</a>@@<a href=postdata.asp target=main>ݱת</a>||滻/ƴ@@<a href=badword.asp?reaction=badword target=main>໰</a>@@<a href=badword.asp?reaction=splitreg target=main>עַ</a>@@<a href=lockip.asp?action=add target=main>IP޶</a> | <a href=lockip.asp target=main></a>@@<a href=address.asp?action=add target=main>̳IP</a> | <a href=address.asp target=main></a>||ݴ(Access)@@<a href=data.asp?action=CompressData target=main>ѹݿ</a>@@<a href=data.asp?action=BackupData target=main>ݿ</a>@@<a href=data.asp?action=RestoreData target=main>ָݿ</a>@@<a href=data.asp?action=SpaceSize target=main>ϵͳϢ</a>||ļ@@<a href=upUserface.asp target=main>ϴͷ</a>@@<a href=uploadlist.asp target=main>ϴļ</a>@@<a href=\"bbsface.asp?Stype=3\" target=\"main\">עͷ</a>@@<a href=\"bbsface.asp?Stype=2\" target=\"main\"></a>@@<a href=\"bbsface.asp?Stype=1\" target=\"main\"></a>||˵@@<a href=plus.asp target=main>̳˵</a>||Ĺ@@<a href=\"plus_Tools_Info.asp?action=Setting\" target=main></a>@@<a href=\"plus_Tools_Info.asp?action=List\" target=main></a>@@<a href=\"plus_Tools_User.asp\" target=main>û߹</a>@@<a href=\"plus_Tools_User.asp?action=paylist\" target=main>Ϣ</a>@@<a href=\"MoneyLog.asp\" target=main>־</a>@@<a href=\"plus_Tools_Magicface.asp\" target=main>ħ</a>|||<!--̨̳CSSʽ--> \r\n<style type=text/css>\r\nbody {\r\n\tbackground:#CAD7F7; font-size: 12px; margin-top:0px;\r\n\tSCROLLBAR-FACE-COLOR: #799AE1; SCROLLBAR-HIGHLIGHT-COLOR: #799AE1; \r\n\tSCROLLBAR-SHADOW-COLOR: #799AE1; SCROLLBAR-DARKSHADOW-COLOR: #799AE1; \r\n\tSCROLLBAR-3DLIGHT-COLOR: #799AE1; SCROLLBAR-ARROW-COLOR: #FFFFFF;\r\n\tSCROLLBAR-TRACK-COLOR: #AABFEC;\r\n}\r\nTD {\r\n\tFONT-SIZE: 12px\r\n}\r\nINPUT {\r\n\tBORDER-TOP-WIDTH: 1px; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 12px; BORDER-BOTTOM-WIDTH: 1px; BORDER-RIGHT-WIDTH: 1px\r\n}\r\nTEXTAREA {\r\n\tBORDER-TOP-WIDTH: 1px; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 12px; BORDER-BOTTOM-WIDTH: 1px; BORDER-RIGHT-WIDTH: 1px\r\n}\r\nSELECT {\r\n\tBORDER-TOP-WIDTH: 1px; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 12px; BORDER-BOTTOM-WIDTH: 1px; BORDER-RIGHT-WIDTH: 1px\r\n}\r\nSPAN {\r\n\tFONT-SIZE: 12px; POSITION: static\r\n}\r\nA {\r\n\tCOLOR: #000000; TEXT-DECORATION: none\r\n}\r\nA:hover { color:#428EFF;text-decoration:underline; }\r\nA.highlight {\r\n\tCOLOR: red; TEXT-DECORATION: none\r\n}\r\nA.highlight:hover {\r\n\tCOLOR: red\r\n}\r\nA.thisclass {\r\n\tFONT-WEIGHT: bold; TEXT-DECORATION: none\r\n}\r\nA.thisclass:hover {\r\n\tFONT-WEIGHT: bold\r\n}\r\nA.navlink {\r\n\tCOLOR: #000000; TEXT-DECORATION: none\r\n}\r\nA.navlink:hover {\r\n\tCOLOR: #003399; TEXT-DECORATION: none\r\n}\r\n.twidth {\r\n\tWIDTH: 760px\r\n}\r\n.content {\r\n\tFONT-SIZE: 14px; MARGIN: 5px 20px; LINE-HEIGHT: 140%; FONT-FAMILY: Tahoma,\r\n}\r\n.aTitle {\r\n\tFONT-WEIGHT: bold; FONT-SIZE: 15px\r\n}\r\nTD.forumHeaderBackgroundAlternate {\r\n\tBACKGROUND-IMAGE: url({$path}admin_top_bg.gif); COLOR: #000000; BACKGROUND-COLOR: #799ae1\r\n}\r\n#TableTitleLink A:link {\r\n\tCOLOR: #ffffff; TEXT-DECORATION: none\r\n}\r\n#TableTitleLink A:visited {\r\n\tCOLOR: #ffffff; TEXT-DECORATION: none\r\n}\r\n#TableTitleLink A:active {\r\n\tCOLOR: #ffffff; TEXT-DECORATION: none\r\n}\r\n#TableTitleLink A:hover {\r\n\tCOLOR: #ffffff; TEXT-DECORATION: underline\r\n}\r\nTD.forumRow {\r\n\tPADDING-RIGHT: 3px; PADDING-LEFT: 3px; BACKGROUND: #F1F3F5; PADDING-BOTTOM: 3px; PADDING-TOP: 3px\r\n}\r\nTH {\r\n\tFONT-WEIGHT: bold; FONT-SIZE: 12px; BACKGROUND-IMAGE: url({$path}admin_bg_1.gif); COLOR: white; BACKGROUND-COLOR: #4455aa\r\n}\r\nTD.bodytitle {\r\n\tBACKGROUND-IMAGE: url({$path}admin_bg_2.gif)\r\n}\r\nTD.bodytitle1 {\r\n\tBACKGROUND-IMAGE: url({$path}admin_bg_3.gif)\r\n}\r\nTD.tablebody1 {\r\n\tPADDING-RIGHT: 3px; PADDING-LEFT: 3px; BACKGROUND: #bebbdb; PADDING-BOTTOM: 3px; PADDING-TOP: 3px\r\n}\r\nTD.forumRowHighlight {\r\n\tPADDING-RIGHT: 3px; PADDING-LEFT: 3px; BACKGROUND: #E4EDF9; PADDING-BOTTOM: 3px; PADDING-TOP: 3px\r\n}\r\n.tableBorder {\r\n\tBORDER-RIGHT: #183789 1px solid; BORDER-TOP: #183789 1px solid; BORDER-LEFT: #183789 1px solid; WIDTH: 98%; BORDER-BOTTOM: #183789 1px solid; BACKGROUND-COLOR: #ffffff\r\n}\r\n.tableBorder1 {WIDTH: 98%; }\r\n.helplink {\r\n\tFONT: 10px verdana,arial,helvetica,sans-serif; CURSOR: help; TEXT-DECORATION: none\r\n}\r\n.copyright {\r\n\tPADDING-RIGHT: 1px; BORDER-TOP: #6595d6 1px dashed; PADDING-LEFT: 1px; PADDING-BOTTOM: 1px; FONT: 11px verdana,arial,helvetica,sans-serif; COLOR: #4455aa; PADDING-TOP: 1px; TEXT-DECORATION: none\r\n}\r\n.menuskin {\r\n\tBORDER: #666666 1px solid; VISIBILITY: hidden; FONT: 12px Verdana;\r\n\tPOSITION: absolute; \r\n\tBACKGROUND-COLOR:#EFEFEF;\r\n\tbackground-image:url(\"../skins/default/dvmenubg3.gif\");\r\n\tbackground-repeat : repeat-y;\r\n\t}\r\n.menuskin A {\r\n\tPADDING-RIGHT: 10px; PADDING-LEFT: 25px; COLOR: black; TEXT-DECORATION: none; behavior:url(inc/noline.htc);\r\n\t}\r\n#mouseoverstyle {\r\n\tBACKGROUND-COLOR: #C9D5E7; margin:2px; padding:0px; border:#597DB5 1px solid;\r\n\t}\r\n#mouseoverstyle A {\r\n\tCOLOR: black\r\n}\r\n.menuitems{\r\n\tmargin:2px;padding:1px;word-break:keep-all;\r\n}\r\n</style>|||@@@|||@@@|||',1,0,'skin/default/admin_left_1.gif',1061049600,'');
INSERT INTO `dv_help` VALUES (2,0,'û֪','',0,1,'',1070812800,'');
INSERT INTO `dv_help` VALUES (3,2,'ע˲̳','ȡڹԱ̳ûȨѡпܱעʽûӡȻͨ£Ӧʽûܷͻظӡ <a href=reg.asp></a> עΪǵû\r<br>\r<br>ǿҽעᣬõܶο޷ʵֵĹܡ ',0,1,'',1070812800,'');
INSERT INTO `dv_help` VALUES (4,2,'Dvbbs ̳ʹ Cookies ','Dvbbs  Session+Cookie ˫طʽûϢȷڸֻ Cookie ȫ޷ʹõʹ̳ܡ Cookies ʹȻΪһϵеķͺôǿҽ²Ҫֹ Cookie ӦãDvbbs İȫƽȫ֤ϰȫ\r<br>\r<br>ڵ¼ҳУѡ Cookie ¼ʱ䣬ڸʱ䷶Χ̳ʼձһηʱĵ¼״̬ÿζ롣ڰȫǣڹ̳ѡ̡(Ĭ)뿪ǰѡ˳(<a href=logout.asp></a> ˳̳)ԶžϱǷʹõĿܡ ',0,1,'',1070812800,'');
INSERT INTO `dv_help` VALUES (5,2,'ʹǩ','ǩǼС֣ע֮ͿԼĸǩˡ\r<br>\r<br><a href=usermanager.asp ></a> 壬ǩǩ֣ȷҪԱõ(ͼ)ϵͳԶѡ¼ҳʾǩѡĵǩԶʾ ',0,1,'',1070812800,'');
INSERT INTO `dv_help` VALUES (6,2,'룬ô죿','Dvbbs ṩȡӵ Email ķ񣬵¼ҳе ȡ ܣΪȡķ͵עʱд Email С Email ʧЧ޷յż̳Աϵ ',0,0,'',1070899200,'');
INSERT INTO `dv_help` VALUES (7,0,'̳ʹ','',0,1,'',1070899200,'');
INSERT INTO `dv_help` VALUES (8,2,'ʲôǡϢ','Ϣ̳עû佻ĹߣϢֻзռ˿ԿյϢϵͳӦʾͨϢͬһ̳ϵû˽ϵռ  û ṩ˶Ϣշ ',0,1,'',1070899200,'');
INSERT INTO `dv_help` VALUES (9,7,'Ե¼̳','δ¼Ͻǵġ¼û룬ȷɡҪֵ¼ѡӦ Cookie ʱ䣬ڴʱ䷶ΧԲϴεĵ¼״̬㻹ѡǷ½Ļ˽㡣',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (10,7,'԰ȫ˳̳','Ѿ¼˵ұߵġ˳ϵͳ Cookie˳¼״̬',0,1,'',1071072000,'');
INSERT INTO `dv_help` VALUES (11,7,'ҪӦô','˵ ĹؼֲѡһΧͿԼȨ޷̳еصӡ',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (12,7,'˷͡Ϣ','ѵ¼˵ϻʾ û Ϣ󵯳ϢڣͨƷʼһд,עռ˱ǶԷ̳ʺŶ㡰͡ϢͱԷռˡԷ̳ҪҳʱϵͳʾԷϢ  \r<br>',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (13,7,'ȫĻԱ','Աÿôʱͨ <a href=./toplist.asp?orders=7 target=_blank>ûб</a> 鿴еĻԱϡ  \r<br>',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (14,7,'ηӣ','̳ĸУ㡰⣩ɽ빦ȫķ档ȻҲʹðġ(ѡ)ע⣬һ̳ΪҪ¼ܷ ',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (15,7,'λظӣ','ʱ㡰ظӡɽ빦ȫĻظ档ȻҲʹʱġٻظظ(ѡ)ע⣬һ̳ΪҪ¼ܻظ ',0,1,'',1071072000,'');
INSERT INTO `dv_help` VALUES (16,7,'α༭ɾӣ','ʱ԰ġ༭ԼӣԺ׵ı༭ǰԱ༭ɾ˵ӣʱɾȫظ༭ԼӣԱ̳ͨýεٿԽд˲',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (17,7,'ɲϴ','Եġκ֧ϴİУͨ߻ظķʽϴֻҪȨ㹻ܳϵͳ޶ߴ磬ڿ͵ķΧڲϴ \r<br>',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (18,7,'һͶƱ','һڰзͶƱÿһܵѡͨĶͶƱѡԼĴ𰸣ÿֻͶƱһΣ֮󽫲ٶѡġ\r<br>\r<br>Աӵʱرպ޸ͶƱѡȨ',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (19,0,'','',0,1,'',1071072000,'');
INSERT INTO `dv_help` VALUES (20,19,'ͨûγΪ','̳İԸģԱܻҪҪﵽһ֣̳עᳬһʱȡӦǳʵšˡ˽ıʣͬʱҪϤݣḻõĿڱȷѾﵽ漸㣬ϣαվİԱϵ  \r<br>',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (21,2,'̳иȨޣ','վʹõ Dvbbs ̳ĳǰϵͳͷκûֵģֿԲοķû֣ۺִﵽһȼҪʱϵͳԶΪͨµȨޣӦ־ˣӵнϸߵĻڱ̳Ծ̶ȣͬʱҲζܹӵбûĸ߼Ȩޡ  \r<br>',0,0,'',1071072000,'');
INSERT INTO `dv_help` VALUES (28,2,'̳̳ķʵַʾʽ','̳̳ķʵַʾʽź̳Ĵ̳ҳļվҳվҳʵַ̳ԱEmailϵǵӣдΪMailtoԱ̳ҳLogoͼƬַʾ̳Ͻǣ·߾·վؼֽվĹؼÿؼúŷָվ˵վҪݽ벻ҪӢĵĶ̳ȨϢ̳øˣʹûԭ̳Ĭ̳Ĭʹ÷  Ĭģ(̳)Ĭģ(˿ռ)2006ʥģ(̳)2007Ԫģ(̳)2007ĬCSS(̳)2006ʥCSS(̳)2007ԪCSS(̳)2007(̳)(˿ռ)̳淽޸Ĺ˴  ĬϹ÷̳Ĭģʽѡƽṹ(ͳ) ҷṹ̳ǰ״̬άڼùر̳ά˵̳رʾ֧html﷨ ̳ͣʹ̳ʱ ر ʱرնʱֻʱøҪѡ񿪻̳Ա̳̳̳շ̳շʱʷͬʱ߼¼ʷͬʱ߼¼ʱ¶Ϣڷ̳ϢǷ֤뿪ԷֹϢ¶Ϣʾûյ¶Ϣʱҳ½ǵһСʾҳʾ̳ǷʾջԱǷʾҳҲ(,ʾ) ǷʾҳҲ []ǷʾҳҲ [] ǷʾҳҲ [Ȧ] ǷʾҳҲ [̳֪]  Ƿûעرպ̳עעǷ֤뿪Էֹע¼Ƿ֤뿪Էֹ¼½ԱȡǷ֤뿪Էֹ¼½֤ʾFlashGIFGIFͼƬJPGͼƬԱȡ0ʾƣȡʴ󳬹ƣֹͣ24Сʱٴʹȡ빦ܡͬһIPעʱEmail֪ͨȷվַ֧mailΪϵͳһEmailֻעһʺעҪԱ֤עϢʼȷʼܿŻӭעû ̳ʱĬΪ300һ㲻Ƿʾҳִʱֹʼַָʼַֹעᣬÿʼַá|ŷָ֧ģewayֹֹeway@aspsky.neteway@dvbbs.netע̳űչôΪHTML͵ʱԽűʶãԸҪԶĹ˸ʽǣ| 磺abc|efg abcefgĹʾûIPرպû顢̳ȨޡûȨûɼʾûԴرպû顢̳ȨޡûȨûɼܽԴбʾûǰλбʾû¼ͻʱбʾûͲϵͳʾΪʡԴʾûΪʡԴɾûʱɾٷڲûλӣ̳ͬʱ粻ƣΪչûбÿҳʾû ߹ܿص׵Ĳöݿ(Ϊ޸inc/config.phpļöݿ·)ħ飨ͷܿظùݿõݿ⣬ܿɶڵ֮⿪ǷҵĿռ书ܿcache/space/space.config.phpļǷ(δͨ)Ƿ̳֪̳֪ǶƳһ㹦ܣشģʽ̳Ĺ㷺ӦáһֹǷøȦȦǷҪȦȦӰĬϰ̳һýǮһʾһһʵȯһðÿտɽҸʼʽķ֧ʼͷʽѡ֧  ֧ ϵͳ() Dvbbs Smtpģʽ ϵͳSmtpģʽSMTP ServerַֻѡڶʼͷʽдݷЧʼַֻѡڶʼͷʽдݷЧʼ¼ûڵ¼SMTPûʼ¼ֻѡڶʼͷʽдݷЧͷϴͷļСϴÿԤͼƬÿԤͼƬСԤͼƬСѡͼƬˮӡÿ:  رˮӡЧ ˮӡЧ ˮӡͼƬЧϴͼƬˮӡϢϴˮӡСϴˮӡɫϴˮӡǷϴͼƬˮӡLOGOͼƬϢдLOGOͼƬ·ϴͼƬˮӡ͸ˮӡͼƬȥɫ˴Ϊ:0,ˮӡͼƬȥɫˮӡֻͼƬĳ:ˮӡͼƬĿȺ͸߶ȡϴͼƬˮӡLOGOλǷļͼƬϴĿ¼趨ǩûʹͷͷߴ綨Ϊͷ߶ȺͿĬͷȶΪ̳ͷĬϿĬͷ߶ȶΪ̳ͷĬϸ߶ʹԶͷٷվͷǷֱʹhttp...urlֱʾͷûǩǷUBBûǩǷHTMLûǷͼǩûǷFlashǩûͷǷûԶͷûͷ󳤶ԶͷٷƲΪԶͷעƲΪԶͷһԶͷҪεĴÿַʾҳǷʾ֧͸ûͼǷûȼ˹,ûﵽҪ,Ҫȵ´ε½ܸµȼΪŻֵ׼Ϊظ༭ʾ\"xxxyyy༭\"ϢԱ༭ʾ\"XXX༭\"Ϣȴ\"XXX༭\"Ϣʾʱû༭ԼӶӵײʾ\"XXX༭\"Ϣʱ(ԷΪλ)༭ʱޱ༭ӵʱ(ԷΪλ, 11440) ʱ, ֻйԱͰܱ༭ɾ. ʹ, Ϊ/ٷûʱṩûѡ񷵻ҳأֱӷظ ˢ»ѡдˢʱ԰͹ԱЧˢʱдĿȷ˷ˢ»ƽбʾҳ÷ˢ¹Чҳȷ˷ˢ¹ָҳ潫зˢãû޶ʱڲظ򿪸ҳ棬һԴĵÿҳǷ̳ǷVIPû鹦VIPû鹦ܣȷ̳û(ȼ)ǷVIPû顣',0,1,'',1199353128,'forum_settings.php');
INSERT INTO `dv_help` VALUES (29,2,'潨齨鴴´µ̳','潨齨鴴´µ̳棬\"½̳\",ĳ̳´棬Ӧ\"Ӱ\"Ϣ,,˵,,ȵãԼϸá֧HTML֣ҪʹHTMLעһҪȷӰ쵽̳ҳ档ܸðֵĴֻҪͷͼ꣬ύ̳޸ĹҪ̳ݣֲܳȷ鷳ָ̳ΪǰҲָΪǰ̳̳÷Ű÷ ĬϰtestҪ޸İã淽 ĬϹ÷Ҫ޸Ĺ淽÷ Ҫ޸˷ҳʾ̳ͼƬַҳ̳ұ߷ģðΪһ಻ŵİİǷΪذǷΪ֤ǰʾʽϵͳĬź˵ð͵Ĭòͬûڲ̳ͬڵȨޣɫʾΪ̳ûʹõûԡȨ޲ܼ̳Уһ¼̳İ棬ôֻõİЧ̳Ч Чҳ ѡԶãѡԶúõȨ޽ûãûĬϲܹӣ˸ûɹӣôûͿԹӡ ',0,1,'',1199353454,'board.php');
INSERT INTO `dv_help` VALUES (30,2,'ѡû','ɾťɾѡû˲ǲģƶûӦ飻\r\nûӦϲû¼IPɽIPûEmailûEmail޸ӽ޸ûݲɾIDû޸',0,1,'',1199353883,'user.php');
INSERT INTO `dv_help` VALUES (31,2,'½޸ģ','½޸ģ壬Ա༭̳԰ͷ񣬿½ģҳ棬ʱ밴ҳʾдϢ ̳ǰʹõĬģ岻ɾ CSSÿɽΪĸ̳塢ɫ߿ɫá ',0,1,'',1199354028,'template.php');
INSERT INTO `dv_help` VALUES (32,2,'ϵͳϢ','ϵͳϢǶԵǰĵԼPHPм⡣\r\nĽ֪ĿǰĵüPHPװĲӶ˽̳װļܼPHPҪ',0,1,'',1199354090,'sysinfo.php');
INSERT INTO `dv_help` VALUES (33,2,'Զٷ','Զٷ£̳°汾\r\nķΪlinuxϵͳwebĿ¼д,FTPʻ\r\nǿҽ֮ǰòԺFTP\r\nӰݿ⣬ָԵ־',0,1,'',1199354140,'upgrade.php');
INSERT INTO `dv_help` VALUES (34,2,'ǷȫļǷ','ǷȫļǷ⹦ҳǷ⹦ҳǷȫļҳǷ⡢ӵȫļ ',0,1,'',1199354216,'fulltext_settings.php');
INSERT INTO `dv_help` VALUES (35,2,'α̬','URL RewriteҪ֧֣ô֮ǰȷȷã÷ο±ߵġApacheµ÷͡IISµ÷α̬',0,1,'',1199354291,'bogushtml_settings.php');
INSERT INTO `dv_help` VALUES (36,2,'̳ϵͳ־鿴','̳ϵͳ־鿴',0,1,'',1199354343,'forum_log.php');
INSERT INTO `dv_help` VALUES (37,2,'»Ϣ','»Ϣ',0,1,'',1199354406,'reloadcache.php');
INSERT INTO `dv_help` VALUES (38,2,'ӹԱ˺ʱ','ӹԱ˺ʱû̳ĻԱ\r\nΪ˰ǫ̈̄ûòͬǰ̨û롣\r\nӵĹԱΪܣȨʱҪԡԱ | 򹴡\r\nͬһĹԱ໥޸Ȩޡ',0,1,'',1199378264,'admin.php');
INSERT INTO `dv_help` VALUES (39,2,'ݱݷ','ݱݷΪṩݱݹܡMysqlDump־ݡSymLinkݡpackݡ \r\nMysqlDumpݣԶķǷ֧mysqldumpбݣmysqldumpãƼʹΪ⽫ȷ־ݿܶࡣ \r\n־ݣŵǣֺ֧ݵ߱ݣݵκΰ汾Mysql϶УȱǣݵԽ󣬱ʱԽ \r\nSymLinkݣַʽֱӱļyour_table.MYDϵͳΪԶķǷִַ֧ʽıݣ \r\npackݣıݷʽ,бݿ졢ļСȫ֧ݡַ޹ءڼ䲻Ӱ̳ʹõŵ\r\npackÿһ:.rec.phpļһ:.data.phpļ \r\nΪṩõļԼݵԣṩˡַѡֶ޸ĻʹñΪԶַ ',0,1,'',1199378344,'db_maintance.php');
INSERT INTO `dv_help` VALUES (40,2,'̳֪','ڲ֮ǰϸĶ˵Ϣ\r\nղعؼ趨Ϊÿղعؼûسָ\r\nΪ𵽷㣬дղعؼֺѡ̳档\r\n̳ɶѡסCTRLţѡ\r\nʱӱ̳֪ղعؼֵֻղص̳֪ӣֻдӱ',0,1,'',1199378448,'forum_savvy.php');
INSERT INTO `dv_help` VALUES (41,2,'Ȧ','ڲĲ˵һ˵Ȧӡ \r\n޸Ļɾ̳Ȧӡ',0,1,'',1199378566,'indivgroup.php');
INSERT INTO `dv_help` VALUES (42,2,'ҵĿռ','ɾҵĿռϵͳĿǰȽ¡ۺûתƵĿУҪ»ۿϢɾ \r\n ɾûҵĿռĿǰȽºתƵûĿִɾ ',0,1,'',1199378637,'spaceadmin.php');
INSERT INTO `dv_help` VALUES (43,2,'forum_DownLoad','ɶԸְ趨档\r\n2ϴ֧swfgifjpg׺ļ\r\n3Զر֧루ͣʱ䣩\r\n4ֹ֧ͣʱͣرͣ\r\n5˹̳ܰļӣûļʾ棨ˢҳ棩ͬʱӰûļû˹ݡЧ˹ԤӰ쵽ûЧ\r\n6ǰֻ̨ϵͳԱûϴĸЧ\r\n7ǿֹѡ,ͼƬHTML,ѡͼƬô浥ʾϴļ(ͼƬflash),ļӺϢ.ѡHTML,ϴͼƬflashԲ뵽HTML. ',0,1,'',1199378829,'forum_DownLoad_benefit.php');
INSERT INTO `dv_help` VALUES (44,2,'Ҳ','趨̳ҳҲ档\r\n2ϴ֧swfgifjpg׺ļ\r\n3Ŀ240,̫ĹᵼҳΡ',0,1,'',1199378887,'index_right_ads.php');
INSERT INTO `dv_help` VALUES (45,2,'̳û','̳ûΪϵͳû顢û顢עû顢û\r\nϵͳûΪù̶û飬ӣ̳֮ãģɾ̳쳣\r\nû鲻ûȼͨһЩ̳⹱׻Ա\r\nû鲻ûȼûжͬûȨޣͨһЩ̳⹱׻Ա\r\nעû鼴Ϊͳûȼÿ(ȼ)趨ͬȨ\r\nĬȨΪµûʱʹһЩõȨãͨûҪٴζȨ',0,1,'',1199378949,'group.php');
INSERT INTO `dv_help` VALUES (46,2,'̳','̳ﴴ޸̳Ĺ淽',0,1,'',1199378988,'forum_ads.php');
INSERT INTO `dv_help` VALUES (47,2,'ⲿд˰潫','ⲿд˰潫ԶлַдURL·\r\n̳LOGOдͼƬ·дǰLOGOΪ̳LOGO\r\nǷð̳ƶȷǸӰǷйȨ\r\n̳¼еĲ߷Ƿ񹫿̳¼еĲ\r\nȨ\r\n̳ʱù նʱرնʱֻֻдãʱòЧ\r\nû\r\nûٻ\r\nûٽǮ\r\nû\r\nû\r\nûپ\r\nûɾ\r\nעʱ䣨λΪӣ\r\nϴļ\r\n֤߼(עΪ֤ʱòЧ)\r\n ûҪǮúð潫Ҫ֧һĽ\r\nûҪȯúð潫Ҫ֧һĵȯ \r\nVIPȡҵȯúð潫Ҫ֧һĵȯ\r\n֧Чд1999һȯЧΪٸ\r\nǰ̨\r\n ɾ\r\n޸Ĺ÷\r\nа޸Ĺ\r\nѡÿĿ\r\n\r\n Ƿ֤\r\nƳByte\r\n󷵻ҳ̳\r\nֽֽ\r\nСֽֽ\r\nͶƱӷͶƱǷͶƱб\r\nϴļÿļ\r\nǷ÷ˮƷ\r\nÿη\r\nͶƱĿ\r\n죬ǰ⣬Ϊ0\r\nǷʹħ\r\n֧\r\n\r\nбʾ\r\n бʾַ\r\nбÿҳ¼\r\n͵Ĭʾʾ\r\n̳/ÿҳ¼\r\nбĬ϶ȡ\r\nʾͼƬʾʽ ظʱ ʱ\r\nͼƬʶʱ\r\nʾͼƬֵַΪ0ʱʾд׼ȷַ\r\nʾ\r\n HTML\r\nUBB\r\nͼǩ\r\nǩ\r\nFlashǩ\r\nýǩRM,AVI\r\nǷ񿪷ŽǮ\r\nǷ񿪷Ż\r\nǷ񿪷\r\nǷ񿪷\r\nǷ񿪷\r\nǷ񿪷Żظɼ\r\nǷ񿪷ųӹ\r\nǷ񿪷ŶԱӹ\r\nֺ\r\nм\r\n\r\nʾ\r\nظ\r\n û\r\nûٻ\r\nûٽǮ \r\nû\r\nû\r\nûپ\r\nûɾ\r\nעʱ\r\nϴļ \r\n̳\r\n ʾȫʾʾʾʾͷ\r\n̶Ӻͨӷֿ\r\n ̶Ӻͨӷֿ',0,1,'',1199423175,'board_setting.php');
INSERT INTO `dv_help` VALUES (48,2,'̳','̳ù޸е̳ݡ̳ñȽ⣬ȽԼݣȻ޸ذãԱذӦôá',0,1,'',1199423392,'audit_settings.php');
INSERT INTO `dv_help` VALUES (49,2,'Ӻϲ','в棬ز\r\nͬһڽвܽһϲ̳С\r\nϲָ̳̳߰ɾӽתƵָĿ̳  \r\nϲ̳ѡ\r\n̳ӶתĿ̳ɾ̳ \r\n',0,1,'',1199423494,'boardunite.php');
INSERT INTO `dv_help` VALUES (50,2,'·ְ','еĲܽǳķԴҸʱܳϸȷÿһִС ̳ ·ְ ̳ղؼ  ޸',0,1,'',1199423609,'update.php');
INSERT INTO `dv_help` VALUES (51,2,'',' ûɹ޸Ļɾ̳ɡ',0,1,'',1199423713,'menpai.php');
INSERT INTO `dv_help` VALUES (52,2,'','ѡѡΪǰʹģ壬ɲ鿴ģãģֱӲ鿴ģ岢޸áԽñڶ̳С\r\n 2ҲԽ趨Ϣ沢Ӧõķ̳Уɶѡ\r\n 3һñİãֻҪðƣʱѡҪ浽İƼɡ\r\n 4ĬģеĻΪ̳ҳ棨̳棩ʹã¼עطֵ̳вͬĻã緢ɾȣȻҲԸ趨趨аĻöһġ',0,1,'',1199423780,'forum_wealth.php');
INSERT INTO `dv_help` VALUES (53,2,'Ϣ','ɾĳûϢҪɾϵͳϢС飩  \r\nɾûָڶϢĬΪɾѶϢ\r\n һǰ һǰ ǰ ǰ Ϣ  δϢ   \r\nɾĳؼֶţע⣺ɾѶδϢ\r\n \r\n',0,1,'',1199423865,'forum_message.php');
INSERT INTO `dv_help` VALUES (54,2,'ע','עַûעַݣҪ˵ַ룬жַá,ָӹַ עIP ֹעIP עַ ΥϢɨ ',0,1,'',1199423934,'badword.php');
INSERT INTO `dv_help` VALUES (55,2,'¼','еĲܽǳķԴҸʱܳϸȷÿһִС ¼û ûȼ ûǮ// ',0,1,'',1199424042,'update.php');
INSERT INTO `dv_help` VALUES (56,2,'ʼ','ٷʼбֻᱣʮ¼\r\nÿηʼ벻Ҫù࣬Ҫݷ\r\nʼб͵ļ¼δĿһִз͡\r\nʼռ÷Դ뾡ڷٵʱ',0,1,'',1199424453,'sendemail.php');
INSERT INTO `dv_help` VALUES (57,2,'ӹԱ','ӹԱ˺ʱû̳ĻԱ\r\nΪ˰ǫ̈̄ûòͬǰ̨û롣\r\nӵĹԱΪܣȨʱҪԡԱ | 򹴡\r\nͬһĹԱ໥޸Ȩޡ',0,1,'',1199424486,'admin.php');
INSERT INTO `dv_help` VALUES (58,2,'½޸ģ','½޸ģ壬Ա༭̳԰ͷ񣬿½ģҳ棬ʱ밴ҳʾдϢ \r\n̳ǰʹõĬģ岻ɾ \r\nCSSÿɽΪĸ̳塢ɫ߿ɫá ',0,1,'',1199424546,'template.php');
INSERT INTO `dv_help` VALUES (59,2,'/','/һXMLļ\r\nڵ/ʱϸĶ˵Ϣ \r\n  񵼳    \r\nϴ /  XML ļ \r\nԴĵϴ XML ļ  \r\nߴķϵ XML ļ  \r\nǷģ塪Ѵڵķģ壬ѡǡǣѡ½ \r\n',0,1,'',1199424643,'template_maintance.php');
INSERT INTO `dv_help` VALUES (60,2,'ɾ','ɾ̳ӣвɻָȷϸϢ\r\nֻƶӣǿɾ\r\nɾԭ̳ӣƶָ̳СȷϸϢ\r\nԽһ̳̳ƶϼ̳ҲԽϼ̳ƶ¼̳Ϊ̳̳úܷܿܲӣֻ',0,1,'',1199424723,'alldel.php');
INSERT INTO `dv_help` VALUES (61,2,'ӵ','ӵúбеӦԤԿЧô븴ƵҳͿˡ\r\nҳǺֿ̳дģʱϾԵַ·\r\nҪⲿƺʱļ޸dv_news.phpļļ︽˵\r\nܽݲͬĵ趨ʱ粻ǾµİÿóһЩʱЧؼġ',0,1,'',1199425529,'forumnews_setting.php');
INSERT INTO `dv_help` VALUES (62,2,'̳ʾ','ݱѡеΪǰ̳ʹݵıһÿеԽ̳ʾٶԽ죬еݱегʱһݱݣSQL汾ûÿݴﵽ20Ժӱ̳ᷢٶȿܶܶࡣ\r\nҲԽǰʹõݱݱлǰʹõݱǰ̳ûʱĬϵıݱ',0,1,'',1199425578,'postdata.php');
INSERT INTO `dv_help` VALUES (63,2,'ɼϢ','ĶɼϢйعȻٽв\r\n2ҪɼϢҪɼڵ㣬дɼйع\r\n3ɼڵϢǶԵǰĽڵṩַвɼɼĹдԽãɼϢԽȫ档\r\n4ɼϢҪм鼰һЩȷϲɼϢԼҪٽ⡣',0,1,'',1199425771,'gather.php');
INSERT INTO `dv_help` VALUES (64,2,'ӶIP','ӶIPÿIPûسָIPдʽ202.152.12.1202.152.12.1IPķʣ202.152.12.*202.152.12ͷIPʣͬ*.*.*.*IPķʡӶIPʱ',0,1,'',1199425958,'lockip.php');
INSERT INTO `dv_help` VALUES (65,2,'Թ̳ûԶͷϴļ','ע⣺ҪFSOȨޣFSOذ뿴΢ĵ\r\nԹ̳ûԶͷϴļûͷûID\r\nûIDĻÿͨûϢû,ȻƵûϣ鿴ԣUserID = ûID',0,1,'',1199778339,'upuserface.php');
INSERT INTO `dv_help` VALUES (66,2,'ܱϴĿ¼֧ļд','١ܱϴĿ¼֧ļдȨ޷ʹãĿ¼дȨĵֶ֧\r\nڡϴԶŵԶļУļĿ¼ԵҪռ֧ļдȨޣ\r\nۡԶļϴļкʵ緢ļûбʹãִԶ',0,1,'',1199778399,'uploadlist.php');
INSERT INTO `dv_help` VALUES (67,2,'עͷ','עͷ../images/userface/Ŀ¼УҪҲ뽫ͼƬڸĿ¼\r\nڡұ߸ѡΪɾѡѡ㱣ãɾӦͼƬ\r\nۡ޸ļ޸Ӧѡֱӵöѡұ߸ѡ',0,1,'',1199778538,'bbsface.php?stype=3');
INSERT INTO `dv_help` VALUES (68,2,'','../images/userface/Ŀ¼УҪҲ뽫ͼƬڸĿ¼\r\nڡұ߸ѡΪɾѡѡ㱣ãɾӦͼƬ\r\nۡ޸ļ޸Ӧѡֱӵöѡұ߸ѡ',0,1,'',1199778585,'bbsface.php?stype=2');
INSERT INTO `dv_help` VALUES (69,2,'','../images/userface/Ŀ¼УҪҲ뽫ͼƬڸĿ¼\r\nڡұ߸ѡΪɾѡѡ㱣ãɾӦͼƬ\r\nۡ޸ļ޸Ӧѡֱӵöѡұ߸ѡ',0,1,'',1199778694,'bbsface.php?stype=1');
INSERT INTO `dv_help` VALUES (70,2,'˵','ע⣺ݽԶʾ̳ǰ̨Ķ˵˵',0,1,'',1199778868,'plus.php');
INSERT INTO `dv_help` VALUES (71,2,'֤ͨ','֤ͨϵͳͬע½phpcmsphp168lonmo\r\nûվ,ʹҳٶȱ',0,0,'',1199779457,'passport.php');
INSERT INTO `dv_help` VALUES (72,2,'CCƵ','CCƵ,ҪעһCCƵʺ\r\n˹ܺ,ûϴƵ,ϴƵᱣCC',0,1,'',1199779386,'ccvideo.php');
INSERT INTO `dv_help` VALUES (73,2,'Ȧ','ڲĲ˵һ˵Ȧӡ \r\n޸Ļɾ̳Ȧӡ',0,1,'',1199779519,'indivgroup.php');
INSERT INTO `dv_help` VALUES (74,2,'̳֪','ڲ֮ǰϸĶ˵Ϣ\r\nղعؼ趨Ϊÿղعؼûسָ\r\nΪ𵽷㣬дղعؼֺѡ̳档\r\n̳ɶѡסCTRLţѡ\r\nʱӱ̳֪ղعؼֵֻղص̳֪ӣֻдӱ',0,1,'',1199779577,'forum_savvy.php');
INSERT INTO `dv_help` VALUES (75,2,'˿ռ','ɾҵĿռϵͳĿǰȽ¡ۺûתƵĿУҪ»ۿϢɾ \r\n ɾûҵĿռĿǰȽºתƵûĿִɾ  \r\nѡ   Ŀ    û  ûĿ    ϴ  ؼ  ģ  ݸ  Ƽ  ֮ǹ  \r\n',0,1,'',1199779662,'spaceadmin.php');
INSERT INTO `dv_help` VALUES (76,2,'ѫ','ʹѫ֮ȣȵ˵б༭<Ƿڵʾ> ѡǰ䷢ѫ֮ǰѫ¡',0,1,'',1199779721,'adminhonor.php');
INSERT INTO `dv_help` VALUES (77,2,'','˵в̨',0,1,'',1199781609,'bank.php');
INSERT INTO `dv_help` VALUES (78,2,'߹','߹ܿ\r\n   \r\nĲöݿ\r\n(Ϊ޸inc/config.phpļöݿ·)    \r\nħ飨ͷܿ\r\nùݿõݿ⣬ܿɶڵ֮⿪   \r\nǷҵĿռ书\r\ncache/space/space.config.phpļ   \r\nǷ(δͨ)   \r\nǷ̳֪\r\n̳֪ǶƳһ㹦ܣشģʽ̳Ĺ㷺Ӧáһֹ\r\nǷøȦ \r\nȦǷҪ  \r\nȦ   \r\nȦӰ  Ĭϰtest  \r\n ̳һ \r\nǮһ һһ ȯһ   \r\nÿտɽҸ \r\n',0,1,'',1199781702,'forum_settings.php?doaction=plus');
INSERT INTO `dv_help` VALUES (79,2,'','˵\r\n1Աӿ棬밴̳гʵеڣƵӡͨڵӵǳٵ½ӿ棬ֹԱû̧߼۸񡣣\r\n2ϵͳΪ-1ʾõΪϵͳߣϵͳۣһΪ̳ʹù̲ûõԼתû',0,1,'',1199781753,'plus_tools_info.php?action=list');
INSERT INTO `dv_help` VALUES (80,2,'беĽҺ͵ȯָû','˵\r\n1беĽҺ͵ȯָûӵǵ߼۸񣬲鿴ûϢû\r\n2ؼ:ûģ  \r\n  û߹ҳ   еû   ûӵ߻ ',0,1,'',1199781801,'plus_tools_user.php');
INSERT INTO `dv_help` VALUES (81,2,'־','־̳еĻԱ߽׵ļ¼\r\nռǷΪ6ͣɵÿһ͵ռǲ ',0,1,'',1199781859,'moneylog.php');
INSERT INTO `dv_help` VALUES (82,2,'ħ','ħ飨ͷĬϵͼƬFlashЧͼ·ֱǣdv_plus/tools/magicface/gif/dv_plus/tools/magicface/swf/ӻͼƬflashЧʱýļϴλá\r\nԷֱ趨ʹÿħҪĽҺ͵ȯõĽҺ͵ȯΪûҪʹÿħ飨ͷҪӡǮ顢ƣЩֻƴﵽ˱׼Ĳʹã۳Ӧõֵ\r\nͼƬFlash˵ĬĿ¼ͼƬдͼƬflashļֻʾʱ׺ͬڴΪͳһƣͼƬԤЧ\r\n޸ħ飨ͷdv_plus/tools/plus_tools_const.phpļ޸magicfacetype \r\n1͵ȯ1ǹħļ۸񣬽2͵ȯ2ǹħͷļ۸\r\nħ飨ͷԤ׼ļӦĿ¼gifͼƬֱСʹͼƬСͼƬûѡʾͼƬûħͷӼʾһswfļħЧ',0,1,'',1199781902,'plus_tools_magicface.php');

INSERT INTO `dv_plus_tools_info` VALUES (1,'ת','ɽнһߵת','dv_plus/tools/pic/tools6.jpg',1,99,1,20,100,100,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (2,'ҩ','ɾ','dv_plus/tools/pic/tools5.jpg',1,100,0,30,150,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (3,'һ','ɽ','dv_plus/tools/pic/tools19.jpg',1,100,0,30,150,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (4,'','ɽ','dv_plus/tools/pic/tools20.jpg',1,100,0,50,250,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (5,'','ɽѵλ״̬','dv_plus/tools/pic/tools21.jpg',1,100,0,400,2000,200,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (6,'߹ۼ','ɽ÷ְ̳ĵһҳ','dv_plus/tools/pic/tools4.jpg',1,100,0,50,250,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (7,'Ŀ','ɷЧı⡣','dv_plus/tools/pic/tools3.jpg',1,99,1,50,250,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (8,'ˮ','ɲ鿴ûIP','dv_plus/tools/pic/tools2.jpg',1,100,0,30,150,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (9,'׷','ɲ鿴ûIPԴ','dv_plus/tools/pic/tools18.jpg',1,100,0,50,250,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (10,'һ','ɽûиתΪ0','dv_plus/tools/pic/tools15.jpg',1,100,0,400,2000,100,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'100,-1000,-1000,-1000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (11,'','ɽ鸺תΪ0','dv_plus/tools/pic/tools16.jpg',1,99,1,200,1000,50,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (12,'ж','һʱ֪Ƿߣĳû½ʱö֪ͨѡ','dv_plus/tools/pic/tools8.jpg',1,100,0,50,250,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (13,'Ȧ','ɽӹ̶6Сʱ','dv_plus/tools/pic/tools14.jpg',1,98,0,100,500,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25','1,2,3,4,5,6,7,8',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (14,'Ȧ','ɽӹ̶12Сʱ','dv_plus/tools/pic/tools13.jpg',1,100,0,200,1000,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (15,'ʱתƻ','ɽѵƶ棨޶⣩','dv_plus/tools/pic/tools9.jpg',1,0,0,0,0,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (16,'','ɲ鿴û','dv_plus/tools/pic/tools17.jpg',1,0,0,0,0,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (17,'̽','ɽûϢֱתΪʵϢʾ״̬','dv_plus/tools/pic/tools22.jpg',1,0,0,0,0,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (18,'鹭','ƻСȦЧԴȦЧƻ1/6','dv_plus/tools/pic/tools11.jpg',1,100,9,30,150,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (19,'ˮ֮ĸ','ӳСȦ̶Чʱ޵1/6','dv_plus/tools/pic/tools12.jpg',1,100,5,30,150,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (20,'ת֮','ɽ̳û','dv_plus/tools/pic/tools7.jpg',1,100,0,1000,5000,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (21,'Ⱥ','ɷ̳Ϣû','dv_plus/tools/pic/tools10.jpg',1,100,0,1000,5000,100,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',2,'100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (22,'͵','ɲ鿴Աҡȯ͵ߵȱϢ','dv_plus/tools/pic/tools24.jpg',1,98,0,100,500,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25','1,2,3,4,5,6,7,8',3,'0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (23,'˰','ɶûĽִһ˰գʹߣϵͳ','dv_plus/tools/pic/tools23.jpg',1,100,0,1000,5000,200,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',2,'200,0,0,0,0.1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (24,'','ʹʹûĽĿûĽͬ','dv_plus/tools/pic/tools25.jpg',1,100,0,1000,5000,500,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',2,'500,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (25,'ƶ','ʹĿûʹûͬٵһΪ׼','dv_plus/tools/pic/tools26.jpg',1,100,0,1000,5000,100,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25',' ',2,'100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (26,'Ῠ','Ŀû1/31/2ĿƬ','dv_plus/tools/pic/tools27.jpg',1,0,0,0,0,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25','1,2,3,4,5,6,7,8',3,'0,0,0,0,0.1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');
INSERT INTO `dv_plus_tools_info` VALUES (27,'','ʹöԵʧ˵߻ԶʹòͷʹöԵ߷û','dv_plus/tools/pic/tools28.jpg',1,0,0,0,0,0,0,0,0,'1,2,3,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25','1,2,3,4,5,6,7,8',3,'0,0,0,0,0.1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0');

INSERT INTO `dv_plus_tools_magicface` VALUES (1,'',1,1,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (2,'',2,2,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (3,'',3,3,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (4,'',8,8,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (5,'΢',9,9,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (6,'ҡ',10,10,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (7,'',11,11,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (8,'',12,12,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (9,'',13,13,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (10,'',15,15,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (11,'',16,16,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (12,'',17,17,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (13,'Ǳ',18,18,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (14,'',19,19,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (15,'',20,20,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (16,'',21,21,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (17,'',22,22,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (18,'',23,23,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (19,'ͨ',24,24,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (20,'',25,25,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (21,'',26,26,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (22,'',27,27,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (23,'',28,28,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (24,'',29,29,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (25,'˼',30,30,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (26,'T',31,31,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (27,'',32,32,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (28,'',33,33,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (29,'',34,34,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (30,'',35,35,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (31,'',36,36,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (32,'',37,37,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (33,'',38,38,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (34,'',39,39,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (35,'',40,40,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (36,'',41,41,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (37,'',42,42,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (38,'',43,43,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (39,'',44,44,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (40,'',45,45,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (41,'û',46,46,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (42,'',47,47,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (43,'',48,48,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (44,'',49,49,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (45,'',50,50,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (46,'ǿ',51,51,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (47,'',52,52,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (48,'ǿ',53,53,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (49,'',54,54,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (50,'',55,55,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (51,'',56,56,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (52,'',57,57,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (53,'˫',58,58,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (54,'',59,59,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (55,'Ż',60,60,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (56,'',61,61,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (57,'',62,62,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (58,'',63,63,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (59,'',64,64,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (60,'',65,65,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (61,'',66,66,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (62,'',67,67,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (63,'ż',68,68,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (64,'',69,69,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (65,'',70,70,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (66,'',71,71,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (67,'',72,72,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (68,'Ĩ',73,73,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (69,'',74,74,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (70,'',75,75,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (71,'',76,76,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (72,'',77,77,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (73,'û',78,78,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (74,'',79,79,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (75,'',80,80,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (76,'',81,81,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (77,'',82,82,3,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (78,'',83,83,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (79,'',84,84,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (80,'',85,85,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (81,'',86,86,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (82,'',87,87,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (83,'',88,88,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (84,'',89,89,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (85,'',90,90,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (86,'',91,91,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (87,'',92,92,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (88,'',93,93,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (89,'',94,94,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (90,'',95,95,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (91,'',96,96,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (92,'',97,97,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (93,'',98,98,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (94,'',99,99,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (95,'',100,100,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (96,'',101,101,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (97,'',102,102,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (98,'С',103,103,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (99,'С',104,104,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (100,'С',105,105,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (101,'С',106,106,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (102,'С',107,107,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (103,'С',108,108,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (104,'С',109,109,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (105,'С',110,110,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (106,'С',111,111,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (107,'С',112,112,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (108,'',113,113,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (109,'',114,114,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (110,'',115,115,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (111,'',116,116,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (112,'',117,117,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (113,'',118,118,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (114,'',119,119,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (115,'',120,120,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (116,'',121,121,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (117,'',122,122,2,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (118,'',123,123,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (119,'',124,124,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (120,'',125,125,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (121,'',126,126,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (122,'',127,127,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (123,'',128,128,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (124,'',129,129,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (125,'',130,130,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (126,'',131,131,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (127,'',132,132,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (128,'',133,133,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (129,'',134,134,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (130,'',135,135,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (131,'',136,136,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (132,'',137,137,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (133,'',138,138,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (134,'',139,139,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (135,'',140,140,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (136,'',141,141,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (137,'',142,142,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (138,'',143,143,3,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (139,'',144,144,3,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (140,'',145,145,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (141,'',146,146,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (142,'',147,147,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (143,'',148,148,0,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (144,'',149,149,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (145,'',150,150,0,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (146,'',151,151,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (147,'',152,152,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (148,'',153,153,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (149,'ί',154,154,0,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (150,'',155,155,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (151,'',156,156,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (152,'',157,157,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (153,'',158,158,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (154,'û',159,159,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (155,'',160,160,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (156,'',161,161,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (157,'',162,162,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (158,'',163,163,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (159,'',164,164,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (160,'ǿ',165,165,1,1000,100,10,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (161,'',166,166,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (162,'',167,167,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (163,'',168,168,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (164,'˼',169,169,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (165,'',170,170,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (166,'',171,171,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (167,'',172,172,1,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (168,'',173,173,1,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (169,'',174,174,1,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (170,'',175,175,1,1000,100,0,0,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (171,'Ǳ',176,176,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (172,'ˤ',177,177,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (173,'',178,178,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (174,'',179,179,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (175,'',180,180,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (176,'',181,181,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (177,'',182,182,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (178,'',183,183,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (179,'',184,184,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (180,'',185,185,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (181,'',186,186,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (182,'ż',187,187,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (183,'',188,188,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (184,'',189,189,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (185,'',190,190,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (186,'',191,191,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (187,'',192,192,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (188,'',193,193,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (189,'Ǯ',194,194,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (190,'',195,195,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (191,'',196,196,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (192,'',197,197,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (193,'',198,198,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (194,'ɢ',199,199,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (195,'',200,200,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (196,'',201,201,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (197,'',202,202,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (198,'',203,203,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (199,'',204,204,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (200,'',205,205,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (201,'',206,206,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (202,'',207,207,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (203,'',208,208,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (204,'Ц',209,209,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (205,'',210,210,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (206,'',211,211,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (207,'Ż',212,212,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (208,'',213,213,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (209,'',214,214,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (210,'',215,215,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (211,'',216,216,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (212,'',217,217,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (213,'',218,218,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (214,'',219,219,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (215,'',220,220,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (216,'',221,221,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (217,'',222,222,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (218,'',223,223,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (219,'',224,224,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (220,'',225,225,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (221,'',226,226,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (222,'',227,227,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (223,'',228,228,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (224,'',229,229,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (225,'',230,230,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (226,'΢',231,231,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (227,'',232,232,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (228,'',233,233,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (229,'',234,234,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (230,'',235,235,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (231,'ż',236,236,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (232,'',237,237,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (233,'Ц',238,238,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (234,'',239,239,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (235,'',240,240,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (236,'',241,241,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (237,'',242,242,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (238,'',243,243,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (239,'',244,244,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (240,'',245,245,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (241,'',246,246,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (242,'',247,247,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (243,'˧',248,248,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (244,'ԭ',249,249,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (245,'',250,250,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (246,'',251,251,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (247,'',252,252,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (248,'',253,253,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (249,'ȼ',254,254,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (250,'',255,255,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (251,'',256,256,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (252,'',257,257,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (253,'',258,258,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (254,'8',259,259,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (255,'N',260,260,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (256,'l',261,261,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (257,'',262,262,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (258,'',263,263,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (259,'',264,264,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (260,'',265,265,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (261,'ŭ',266,266,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (262,'',267,267,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (263,'',268,268,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (264,'C',269,269,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (265,'',270,270,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (266,'h',271,271,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (267,'',272,272,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (268,'',273,273,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (269,'',274,274,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (270,'',275,275,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (271,'',276,276,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (272,'',278,278,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (273,'1',279,279,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (274,'',280,280,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (275,'',281,281,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (276,'',282,282,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (277,'',283,283,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (278,'',284,284,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (279,'',285,285,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (280,'',286,286,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (281,'',289,289,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (282,'Ŭ',290,290,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (283,'͵',291,291,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (284,'С',292,292,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (285,'',293,293,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (286,'',294,294,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (287,'',295,295,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (288,'',296,296,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (289,'',297,297,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (290,'',298,298,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (291,'',299,299,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (292,'',300,300,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (293,'N',301,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (294,'',302,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (295,'ɢ',303,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (296,'',304,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (297,'',305,0,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (298,'',306,0,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (299,'',307,0,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (300,'B',308,0,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (301,'',309,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (302,'͵',310,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (303,'',311,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (304,'',312,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (305,'',313,0,4,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (306,'',315,0,1,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (307,'',316,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (308,'',317,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (309,'˵',318,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (310,'T',319,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (311,'',320,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (312,'',321,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (313,'',322,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (314,'',323,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (315,'ʥ',324,0,4,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (316,'ʥ',325,0,4,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (317,'ʥ',326,0,4,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (318,'',327,0,0,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (319,'ѩ',328,0,4,1000,100,100,10,'10|100|20|10|0');
INSERT INTO `dv_plus_tools_magicface` VALUES (320,'ѩ',329,0,4,1000,100,100,10,'10|100|20|10|0');

INSERT INTO `dv_setup` VALUES (1,'̳PHP,,ȷ,http://www.cndw.com/,smtp.126.com,dvbbs@cndw.com,images/logo.gif,http://www.aspsky.cn/email.asp,aspsky|dvbbs||̳|asp|̳|,ʱ,̳ʹࡢ̳Ҳǹ֪ļվ㣬ϣŬΪܶ෽,index.php,,,0|||0,300,0,60,2|20,1,1,2|100|1|1|bbs.dvbbs.net|12|#FF0000|Andale Mono|0|images/watermap.gif|0.7|110|35|0|120|100|0|0|#0066cc||,40,dvbbs|sql|aspsky|asp|php|cgi|jsp|htm,0,20,500,20|200,0,0,1,0,1,0,30,0,7200,0,0,0,0,1,1,0,1,1,1,1,1,1,0,1,32,32,1,10,1,1,10,0,1,0,1,1,0,0,0,1,10,1,0,120,30,9,15,4,0,0,0,1,0,1,20,0,0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0,0,0,0,2008-1-31,0,uploadfile/,iframe|frameset|object|EMBED,1,0,1,1,0,0,5,0,0,1,8,0,1,1,0,50,30,20,5,100,1,1,0,0|0|0,0,0,1,#CC0000,0,0,0,1,1,1,200,1|||100,15,12,12,8,60,10,5,5,6,30,6,2,2,3,25,15,20||| &copy;2000 - 2006  <a href=http://www.dvbbs.net><font face=Verdana, Arial, Helvetica, sans-serif><b>Dvbbs<font color=#CC0000>.Net</font></b></font></a>|||!,@,#,$,%,^,&,*,(,),{,},[,],|,,.,/,?,`,~|||̳ͣʹ','','ҿ|fuck|־|ֹ|ɫ|fuck|FUCK|bitch||԰|ֹ|falundafa|falun|||Ƭ||','*|****|***|***|**|f***|f***|b****|***|**|f***|f***|f***|f***|f***|f***|f***|f***',0,1154257854,0,0,0,1,0,0,0,'admin','','',1,'2.0++','dv_bbs1',1,'x973KsxeVc4fGoYEodMZ','dvbbs','0,0,1,0,pay@aspsky.net,0,b63uvb8nsvsmbsaxszgvdr6svyus0l4t,1,1,1,1,1,1,0,100,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1','','/','','514','1|||admin|||admin888',1,'','','admin/','','','images/userface/|||image1.gif|||image2.gif|||image3.gif|||image4.gif|||image5.gif|||image6.gif|||image7.gif|||image8.gif|||image9.gif|||image10.gif|||image11.gif|||image12.gif|||image13.gif|||image14.gif|||image15.gif|||image16.gif|||image17.gif|||image18.gif|||image19.gif|||image20.gif|||image21.gif|||image22.gif|||image23.gif|||image24.gif|||image25.gif|||image26.gif|||image27.gif|||image28.gif|||image29.gif|||image30.gif|||image31.gif|||image32.gif|||image33.gif|||image34.gif|||image35.gif|||image36.gif|||image37.gif|||image38.gif|||image39.gif|||image40.gif|||image41.gif|||image42.gif|||image43.gif|||image44.gif|||image45.gif|||image46.gif|||image47.gif|||image48.gif|||image49.gif|||image50.gif|||image51.gif|||image52.gif|||image53.gif|||image54.gif|||image55.gif|||image56.gif|||image57.gif|||image58.gif|||image59.gif|||image60.gif|||@@@images/topicface/|||face1.gif|||face2.gif|||face3.gif|||face4.gif|||face5.gif|||face6.gif|||face7.gif|||face8.gif|||face9.gif|||face10.gif|||face11.gif|||face12.gif|||face13.gif|||face14.gif|||face15.gif|||face16.gif|||face17.gif|||face18.gif|||@@@images/emot/|||em01.gif|||em02.gif|||em03.gif|||em04.gif|||em05.gif|||em06.gif|||em07.gif|||em08.gif|||em09.gif|||em10.gif|||em11.gif|||em12.gif|||em13.gif|||em14.gif|||em15.gif|||em16.gif|||em17.gif|||em18.gif|||em19.gif|||em20.gif|||em21.gif|||em22.gif|||em23.gif|||em24.gif|||em25.gif|||em26.gif|||em27.gif|||em28.gif|||em29.gif|||em30.gif|||em31.gif|||em32.gif|||em33.gif|||em34.gif|||em35.gif|||em36.gif|||em37.gif|||em38.gif|||em39.gif|||em40.gif|||em41.gif|||em42.gif|||em43.gif|||em44.gif|||em45.gif|||em46.gif|||em47.gif|||em48.gif|||em49.gif|||em50.gif|||em51.gif|||em52.gif|||em53.gif|||em54.gif|||em55.gif|||em56.gif|||em57.gif|||em58.gif|||em59.gif|||em60.gif|||em61.gif|||em62.gif|||em63.gif|||em64.gif|||em65.gif|||em66.gif|||em67.gif|||em68.gif|||em69.gif|||em70.gif|||em71.gif|||em72.gif|||em73.gif|||em74.gif|||em75.gif|||em76.gif|||em77.gif|||em78.gif|||em79.gif|||em80.gif|||em81.gif|||em82.gif|||em83.gif|||em84.gif|||em85.gif|||em86.gif|||em87.gif|||em88.gif|||em89.gif|||em90.gif|||em91.gif|||em92.gif|||em93.gif|||em94.gif|||em95.gif|||em96.gif|||em97.gif|||em98.gif|||em99.gif|||em100.gif|||em101.gif|||em102.gif|||em103.gif|||em104.gif|||em105.gif|||em106.gif|||em107.gif|||em108.gif|||em109.gif|||em110.gif|||em111.gif|||em112.gif|||em113.gif|||em114.gif|||em115.gif|||em116.gif|||em117.gif|||em118.gif|||em119.gif|||em120.gif|||em121.gif|||em122.gif|||em123.gif|||em124.gif|||em125.gif|||em126.gif|||em127.gif|||em128.gif|||em129.gif|||em130.gif|||em131.gif|||em132.gif|||em133.gif|||em134.gif|||em135.gif|||em136.gif|||em137.gif|||em138.gif|||em139.gif|||em140.gif|||em141.gif|||em142.gif|||em143.gif|||em144.gif|||em145.gif|||em146.gif|||em147.gif|||em148.gif|||em149.gif|||em150.gif|||em151.gif|||em152.gif|||em153.gif|||em154.gif|||em155.gif|||em156.gif|||em157.gif|||em158.gif|||em159.gif|||em160.gif|||em161.gif|||em162.gif|||em163.gif|||em164.gif|||em165.gif|||em166.gif|||em167.gif|||em168.gif|||em169.gif|||em170.gif|||em171.gif|||em172.gif|||em173.gif|||em174.gif|||em175.gif|||em176.gif|||em177.gif|||em178.gif|||em179.gif|||em180.gif|||em181.gif|||em182.gif|||em183.gif|||em184.gif|||em185.gif|||em186.gif|||em187.gif|||em188.gif|||em189.gif|||em190.gif|||em191.gif|||em192.gif|||em193.gif|||em194.gif|||em195.gif|||em196.gif|||em197.gif|||em198.gif|||em199.gif|||em200.gif|||em201.gif|||em202.gif|||em203.gif|||em204.gif|||em205.gif|||em206.gif|||em207.gif|||em208.gif|||em209.gif|||em210.gif|||em211.gif|||em212.gif|||em213.gif|||em214.gif|||em215.gif|||em216.gif|||em217.gif|||em218.gif|||em219.gif|||em220.gif|||em221.gif|||em222.gif|||em223.gif|||em224.gif|||em225.gif|||em226.gif|||em227.gif|||em228.gif|||em229.gif|||em230.gif|||em231.gif|||em232.gif|||em233.gif|||em234.gif|||em235.gif|||em236.gif|||em237.gif|||@@@images/birth/|||z1.gif|||z2.gif|||z3.gif|||z4.gif|||z5.gif|||z6.gif|||z7.gif|||z8.gif|||z9.gif|||z10.gif|||z11.gif|||z12.gif|||','default|templates/default/images/style_css_1.css|zh-cn',2);

INSERT INTO `dv_space_skins` VALUES (1,'MySpaceĬϷ','space/skins/default/','space/skins/default/images/viewlogo.gif','','AspSky.Net');
INSERT INTO `dv_space_skins` VALUES (2,'MySpace','space/skins/style2/','space/skins/style2/images/viewlogo.gif','','AspSky.Net');


INSERT INTO `dv_space_syscat` VALUES (1,'˿ռ','',0,14,71,54,0,1156904405);
INSERT INTO `dv_space_syscat` VALUES (2,'','',0,0,6,0,0,1156665343);
INSERT INTO `dv_space_syscat` VALUES (3,'ý','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (4,'ѧϰ','',0,0,0,0,0,1156667228);
INSERT INTO `dv_space_syscat` VALUES (5,'','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (6,'','',0,0,0,0,0,1155546863);
INSERT INTO `dv_space_syscat` VALUES (7,'ٶ԰','',0,0,0,0,0,1156243808);
INSERT INTO `dv_space_syscat` VALUES (8,'ԭѧ','',0,0,1,0,0,1156478821);
INSERT INTO `dv_space_syscat` VALUES (9,'ٿ','',0,0,1,0,0,1156486932);
INSERT INTO `dv_space_syscat` VALUES (10,'','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (11,'','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (12,'Ȼ','',0,0,0,0,0,1156495401);
INSERT INTO `dv_space_syscat` VALUES (13,'Ϸ','',0,0,0,0,0,1156496207);
INSERT INTO `dv_space_syscat` VALUES (14,'༶','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (15,'','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (16,'','',0,0,0,0,0,1150453674);
INSERT INTO `dv_space_syscat` VALUES (17,'','',1,1,27,21,0,1156829593);
INSERT INTO `dv_space_syscat` VALUES (18,'ѧ','',1,0,1,2,0,1156242236);
INSERT INTO `dv_space_syscat` VALUES (19,'ɽˮ','',1,0,1,0,0,1155263978);
INSERT INTO `dv_space_syscat` VALUES (20,'Ӱ','',1,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (21,'','',1,0,1,0,0,1156486932);
INSERT INTO `dv_space_syscat` VALUES (22,'Ц','',1,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (23,'','',1,0,1,4,0,1156495563);
INSERT INTO `dv_space_syscat` VALUES (24,'ٿ','',1,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (25,'','',1,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (26,'ʷ','',1,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (27,'ͨ','ͼƬ',5,0,0,18,0,1156760111);
INSERT INTO `dv_space_syscat` VALUES (28,'','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (29,'仳','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (30,'Ȼ羰','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (31,'ż','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (32,'ɸЦ','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (33,'ʵ','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (34,'ɫ','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (35,'ҵ','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (36,'Ʒ','ͼƬ',5,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (37,'鱦','',4,0,0,0,0,1156652994);
INSERT INTO `dv_space_syscat` VALUES (38,'ͨѶ豸','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (39,'','',4,0,0,0,0,1156314944);
INSERT INTO `dv_space_syscat` VALUES (40,'Ϸ','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (41,'е','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (42,'ʿƷ','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (43,'Ůʿ','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (44,'ˮ','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (45,'鱦','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (46,'','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (47,'õ','',4,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (48,'Ц','',6,0,0,2,0,1156904405);
INSERT INTO `dv_space_syscat` VALUES (49,'Ѷ','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (50,'','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (51,'峪','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (52,'','',6,0,0,0,0,1156667228);
INSERT INTO `dv_space_syscat` VALUES (53,'ԭ','',6,0,1,4,0,1156226387);
INSERT INTO `dv_space_syscat` VALUES (54,'Ů','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (55,'Ƭ','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (56,'MV','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (57,'MTV','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (58,'Ӱ','',6,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (59,'ռ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (60,'ŵѧ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (61,'Ӱ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (62,'λ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (63,'ԿƼ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (64,'','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (65,'ѵ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (66,'ǰѶ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (67,'ý廥','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (68,'','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (69,'ѧϰʼ','ղ',2,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (70,'ų','ǩ',3,0,1,0,0,1155551323);
INSERT INTO `dv_space_syscat` VALUES (71,'','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (72,'','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (73,'ƾѶ','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (74,'Ƽ','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (75,'','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (76,'','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (77,'ѧϰ','ǩ',3,0,0,0,0,1155707897);
INSERT INTO `dv_space_syscat` VALUES (78,'Ϸ','ǩ',3,0,0,0,0,1155707897);

INSERT INTO `dv_space_system` VALUES (1,'ҵĿռ',' ',1156904405,70,43,0,14,0,53,13,'1,1,0,0,0,1,20,20,15,3,1,1,1|0|999|999|bbs.dvbbs.net|12|1|Andale Mono|0|images/watermap.gif|0.7|95|24|1|120|100|0|2|1|space|0,|||ˬ|||С|||ʺ|||Сѩ|ѩ|Բ|ȱ444|ddd|aaaa,sun.gif|sun2.gif|yin.gif|yin.gif|yun.gif|wu.gif|xiaoyu.gif|yinyu.gif|leiyu.gif|caihong.gif|sun.gif|feng.gif|xue.gif|daxue.gif|moon.gif|moon2.gif|moon2.gif|daxue.gif,1,gif|jpg|jpeg|png|bmp|tif|iff|swf|swi|mid|wav|mp3|rmi|cda|avi|mpg|mpeg|ra|ram|wov|asf|rar,ӭҵĿռ,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1','http://www.iboker.com/','',2,'<div><img alt=\"\" src=\"space/images/index_img.gif\" align=\"left\"/>&nbsp;<font color=\"#ff0000\">վҵĿռʽ⿪<br/>\r\nӭվҵĿռϵͳԼϼ԰<br/>\r\n</font><hr class=\"post\"/>ע̹ϡƽȽ²ˣر˿вȫĵط<br/>\r\n</div>','&lt;b&gt;ϵͳ֪ͨ&lt;/b&gt;\r\n&lt;li&gt;̳ҵĿռϵͳʽ&amp;nbsp;&lt;br/&gt;\r\nע̹ϡƽȽ²ˣر˿вȫĵط111&lt;/li&gt;','YTo1OntpOjA7YToyOntpOjA7czo0MToic3BhY2Uvc2tpbnMvZGVmYXVsdC9hZF9pbWFnZXMvcGhvdG8wMS5naWYiO2k6MTtzOjE4OiJodHRwOi8vcC5kdmJicy5uZXQiO31pOjE7YToyOntpOjA7czo0MToic3BhY2Uvc2tpbnMvZGVmYXVsdC9hZF9pbWFnZXMvcGhvdG8wMi5naWYiO2k6MTtzOjE4OiJodHRwOi8vcC5kdmJicy5uZXQiO31pOjI7YToyOntpOjA7czo0MToic3BhY2Uvc2tpbnMvZGVmYXVsdC9hZF9pbWFnZXMvcGhvdG8wMy5naWYiO2k6MTtzOjE4OiJodHRwOi8vcC5kdmJicy5uZXQiO31pOjM7YToyOntpOjA7czo0MToic3BhY2Uvc2tpbnMvZGVmYXVsdC9hZF9pbWFnZXMvcGhvdG8wNC5naWYiO2k6MTtzOjE4OiJodHRwOi8vcC5kdmJicy5uZXQiO31pOjQ7YToyOntpOjA7czo0MToic3BhY2Uvc2tpbnMvZGVmYXVsdC9hZF9pbWFnZXMvcGhvdG8wNS5naWYiO2k6MTtzOjE4OiJodHRwOi8vcC5kdmJicy5uZXQiO319','');

INSERT INTO `dv_tablelist` VALUES (1,'dv_bbs1','ݱ1');

INSERT INTO `dv_user` VALUES (1,'admin','469e80d32c0559f8','admin@aspsky.net',0,0,0,'',0,'images/userface/image1.gif',32,32,'||||||||||||||||||',1162354077,1190018528,0,0,0,'Ա','',100,60,30,0,0,0,'','','','','127.0.0.1','','İ,ҵĺ,',' ','',1,0,'level20.gif','',0,'','Y1tGw3i876XsB846','0|0|0|0|0',0,'',0,0,0,'',0,0,'',NULL);


INSERT INTO `dv_usergroups` VALUES (1,'Ա','Ա','1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,4000,100,1,1,1,1,50,1,1,1,500,1,50,0,1,1,100,1,0,0,1,1,255,1,<b><font color=\"#FF0000\"></font></b>,1,0,1,0,0,1,1,5,3,1,1,1,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',1,0,'ao1.gif','level20.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (2,'','','1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3000,100,1,1,1,1,3,1,0,1,300,1,50,0,1,1,45,1,0,0,1,1,0,1,<font color=#DA2549 face=\"Verdana\"><b></b></font>,1,0,1,0,0,0,1,3,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',2,0,'ao2.gif','level19.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (3,'','','1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,1,5,2000,100,1,1,0,1,2,1,0,1,200,1,50,0,1,1,40,1,0,0,0,1,0,1,<font color=#DA2549 face=\"Verdana\"><b></b></font>,1,0,1,0,0,0,1,2,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',3,0,'ao.gif','level18.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (4,'עû','עû','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',6,0,'messages1.gif','level0.gif',0,'');
INSERT INTO `dv_usergroups` VALUES (5,'ȴ֤(COPPA)Ա','COPPA','1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,300,100,0,0,0,0,3,0,0,0,100,0,50,0,0,0,0,0,0,0,0,0,0,0,,0,0,0,0,0,0,0,0,0,0,0,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',0,0,'messages1.gif','level0.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (6,'ȴʼ֤ĻԱ','ȴ֤','1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,300,100,0,0,0,0,3,0,0,0,100,0,50,0,0,0,0,0,0,0,0,0,0,0,,0,0,0,0,0,0,0,0,0,0,0,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',0,0,'messages1.gif','level0.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (7,'δע/δ¼û','','1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,300,100,0,0,0,0,3,0,0,0,100,0,50,0,0,0,0,0,0,0,0,0,0,0,,0,0,0,0,0,0,0,0,0,0,0,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',7,0,'messages2.gif','level0.gif',1,'');
INSERT INTO `dv_usergroups` VALUES (8,'','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,5,1000,100,0,1,0,1,2,1,0,0,100,0,50,0,0,1,5,1,0,0,0,1,0,1,<font color=#DA2549 face=\"Verdana\"><b></b></font>,1,0,1,0,0,1,1,2,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',4,0,'gb(1).gif','level17.gif',2,'');
INSERT INTO `dv_usergroups` VALUES (9,'עû','·','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0',0,0,'messages1.gif','level0.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (10,'עû','̳','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,100,'messages1.gif','level1.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (11,'עû','̳','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,200,'messages1.gif','level2.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (12,'עû','ҵ','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,300,'messages1.gif','level3.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (13,'עû','ְҵ','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,400,'messages1.gif','level4.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (14,'עû','֮','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,500,'messages1.gif','level5.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (15,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,600,'messages1.gif','level6.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (16,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,800,'messages1.gif','level7.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (17,'עû','֩','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,1000,'messages1.gif','level8.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (18,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,1200,'messages1.gif','level9.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (19,'עû','С','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,1500,'messages1.gif','level10.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (20,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,1800,'messages1.gif','level11.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (21,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,2100,'messages1.gif','level12.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (22,'עû','','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,2500,'messages1.gif','level13.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (23,'עû','ޱ','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,3000,'messages1.gif','level14.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (24,'עû','ŵ','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,3500,'messages1.gif','level15.gif',3,'');
INSERT INTO `dv_usergroups` VALUES (25,'עû','ʥ','1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,011,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,1000,100,0,0,0,1,2,1,0,0,100,0,50,0,0,1,5,0,20,20,0,1,0,1,<font color=\"#61B713\" face=\"Verdana\"><b></b></font>,1,0,1,200,200,0,0,0,3,0,1,0,0000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,01',0,4000,'messages1.gif','level16.gif',3,'');

INSERT INTO `dv_plus` VALUES (9,'0','',0,'0|0|0|||0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,|||ֶ1,ֶ2,ֶ3,ֶ4,ֶ5,ֶ6,ֶ7,ֶ8,ֶ9,ֶ10,ֶ11,ֶ12,ֶ13,ֶ14,ֶ15,ֶ16,ֶ17,ֶ18,ֶ19|||0,0|24,1@30@7@6@5@3@2@8@26@20@21@22@23@24@25@19@18@17@9@10@11@12@13@14@15@16@28@27,admin,0,0,0,0,0,0,0,0,0','bank.php',1,'','bank.php','dv_bank');
INSERT INTO `dv_plus` VALUES (10,'0','ѫ',0,'0|0|0|||0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,|||ֶ1,ֶ2,ֶ3,ֶ4,ֶ5,ֶ6,ֶ7,ֶ8,ֶ9,ֶ10,ֶ11,ֶ12,ֶ13,ֶ14,ֶ15,ֶ16,ֶ17,ֶ18,ֶ19|||0,0|24,1@30@7@6@5@3@2@8@26@20@21@22@23@24@25@19@18@17@9@10@11@12@13@14@15@16@28@27,,0,0,0,0,0,0,0,0,0','honor.php',1,'ѫ','adminhonor.php','honor');

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
