<?php
define('THIS_SCRIPT', 'space');
require_once 'space_global.php';

$lang = load_lang($lang,'space.error');
$lang = load_lang($lang,'space');

if( count($arrArchiveLink) < 2 ){
	$_strArchiveLink = 'ShowAll';
} else{
	$_strArchiveLink = $arrArchiveLink[1];
}
$_strStats = '';
switch($_strArchiveLink){
	case 'showtopic':
		$_strStats = $lang['HeaderTitle2'];
		break;
	case 'showchannel':
		$_strStats = $lang['HeaderTitle3'];
		break;
	default:
		$_strStats = $lang['HeaderTitle1'];
		break;
}
spaceHeader(array('stats'=>$_strStats,'isSystem'=>false,'topEnable'=>true,'navEnable'=>true));
require printout('space');
spaceFooter();

function &getTopicList()
{
	global $dv, $db, $arrArchiveLink, $spaceUserInfo, $spaceUserCat;
	$count = count($arrArchiveLink);
	$topiclist = false;
	if (!isset($arrArchiveLink[2]) OR !isDate($arrArchiveLink[2])) {
		if (!empty($spaceUserCat['spacetopic']) AND is_array($spaceUserCat['spacetopic'])) {
			$topiclist = array('ResultSet' => &$spaceUserCat['spacetopic']);
		}
	} else {
		if(!empty($spaceUserInfo['diary_topic']) AND is_array($spaceUserInfo['diary_topic'])) {
			$timestamp = dv_gmtimestamp(dateFormat($arrArchiveLink[2],'Ymd')) - getUserTimeZoneOffset();
			if (!empty($spaceUserInfo['diary_topic'][$timestamp]) AND is_array($spaceUserInfo['diary_topic'][$timestamp])) {
				$absolutepage = abs(intval($arrArchiveLink[3]));
				if ($absolutepage < 1) {
					$absolutepage = 1;
				}
				$pagesize = 20;
				$recordcount = count($spaceUserInfo['diary_topic'][$timestamp]);
				$pagecount = ceil((float)$recordcount / (float)$pagesize);
				if ($absolutepage > $pagecount ) {
					$absolutepage = $pagecount;
				}
				$topiclist = array('AbsolutePage' =>$absolutepage, 'PageSize' => $pagesize, 'RecordCount' =>$recordcount, 'PageCount' => $pagecount, 'ResultSet' => false);
				$rowoffset = ($absolutepage - 1) * $pagesize;
				$rowlength = $rowoffset + $pagesize;
				$comma = '';
				$topicidlist = '';
				$index = -1;
				foreach ($spaceUserInfo['diary_topic'][$timestamp] AS $topicid => $val) {
					$index++;
					if ($topicid <= 0) {
						continue;
					}
					if ($index >= $rowoffset AND $index < $rowlength) {
						$topicidlist .= "{$comma}{$topicid}";
						$comma = ',';
					}
				}
				if ('' !== $topicidlist) {
					$topiclist['ResultSet'] =& $db->getResultSet("SELECT topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather FROM {$dv}space_topic WHERE topicid IN({$topicidlist})");
				}
			}
		}
	}
	return $topiclist;
}

function &getSpaceTopicBy($_argTopicID){
	global $dv,$db;
	$_arrReturnVal = false;
	if( $query = $db->query("SELECT topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather,visituser,paymoney,paynumber,paytime,trackbacks FROM {$dv}space_topic WHERE userid='{$GLOBALS['spaceUserID']}' AND topicid='{$_argTopicID}'",array('pageSize'=>1)) ){
		$_arrReturnVal =& $db->fetch_array($query);
	}
	return $_arrReturnVal;
}

function &getSpacePostBy($_argTopicID,$_argPage){
	global $spaceSetting,$dv,$db,$spaceSetting;
	if ($spaceSetting[8] < 1) {
		$spaceSetting[8] = 20;
	}
	$_arrReturnVal = array('RecordCount'=>0,'AbsolutePage'=>$_argPage,'PageSize'=>$spaceSetting[8],'PageCount'=>0, 'ResultSet'=>false);
	$_arrReturnVal['RecordCount'] = $db->scalar("SELECT COUNT(1) FROM {$dv}space_post WHERE rootid='{$_argTopicID}'");
	if( $_arrReturnVal['RecordCount'] > 0 ){
		$_arrReturnVal['PageCount'] = ceil((float)$_arrReturnVal['RecordCount']/$_arrReturnVal['PageSize']);
		if( $_arrReturnVal['AbsolutePage'] > $_arrReturnVal['PageCount'] ){
			$_arrReturnVal['AbsolutePage'] = $_arrReturnVal['PageCount'];
		}
		if( $_arrReturnVal['AbsolutePage'] < 1 ){
			$_arrReturnVal['AbsolutePage'] = 1;
		}
		$_arrReturnVal['ResultSet'] = $db->getResultSet("SELECT postid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype FROM {$dv}space_post WHERE rootid='{$_argTopicID}' ORDER BY postid",array('absolutePage'=>$_arrReturnVal['AbsolutePage'],'pageSize'=>$_arrReturnVal['PageSize']));
	}
	return $_arrReturnVal;
}

function &getSpaceUpFile($_argPage,$_argCat_tID,$_argCatID){//ģʽ
	global $dv,$db,$isSpaceOwner,$spaceUserID,$spaceSetting;
	if( $_argPage < 1 ) $_argPage = 1;
	if ($spaceSetting[7] < 1) {
		$spaceSetting[7] = 20;
	}
	$_arrReturnVal = array('RecordCount'=>0,'AbsolutePage'=>$_argPage,'PageSize'=>$spaceSetting[7],'PageCount'=>0,'ResultSet'=>false);
	if( $_argCat_tID != 4 ){
		return $_arrReturnVal;
	}
	$_strWhere = '';
	if( $_argCatID > 0 ){
		$_strWhere = " AND catid='{$_argCatID}' ";
	}
	if( $isSpaceOwner===true ){
		$_strWhere .= "  AND islock<3 ";
	}
	$_arrReturnVal['RecordCount'] = $db->scalar("SELECT COUNT(1) FROM {$dv}space_upfile WHERE stype='{$_argCat_tID}' {$_strWhere} AND userid='{$spaceUserID}'");
	if( $_arrReturnVal['RecordCount'] > 0 ){
		$_arrReturnVal['PageCount'] = ceil((float)$_arrReturnVal['RecordCount']/(float)$_arrReturnVal['PageSize']);
		if( $_arrReturnVal['AbsolutePage'] > $_arrReturnVal['PageCount'] ){
			$_arrReturnVal['AbsolutePage'] = $_arrReturnVal['PageCount'];
		}
		if( $_arrReturnVal['AbsolutePage'] < 1 ){
			$_arrReturnVal['AbsolutePage'] = 1;
		}
		$_arrReturnVal['ResultSet'] =& $db->getResultSet("SELECT id,spaceuserid,username,catid,stype,topicid,postid,istopic,title,filename,sfilename,filetype,filesize,filenote,downnum,viewnum,dateandtime,previewimage,islock FROM {$dv}space_upfile WHERE stype='{$_argCat_tID}' {$_strWhere} AND spaceuserid='{$spaceUserID}' AND istopic=0 ORDER BY dateandtime DESC ",array('absolutePage'=>$_arrReturnVal['AbsolutePage'],'pageSize'=>$_arrReturnVal['PageSize']));
	}
	return $_arrReturnVal;
}
function &getSpaceNewPic(){ //Ƭ

	global $dv,$db,$spaceUserID;

		$_arrReturnVal['ResultSet'] =& $db->getResultSet("SELECT id,spaceuserid,username,catid,stype,topicid,postid,istopic,title,filename,sfilename,filetype,filesize,filenote,downnum,viewnum,dateandtime,previewimage,islock FROM {$dv}space_upfile WHERE spaceuserid='{$spaceUserID}' AND istopic=0 ORDER BY dateandtime DESC limit 5 ");
	
	return $_arrReturnVal;
}

function &getSpaceTopic_link($_argPage,$_argCat_tID,$_argCatID){//ģʽ
	global $dv,$db,$isSpaceOwner,$spaceUserID,$spaceSetting;
	if( $_argPage < 1 ) $_argPage = 1;
	if ($spaceSetting[7] < 1) {
		$spaceSetting[7] = 20;
	}
	$_arrReturnVal = array('RecordCount'=>0,'AbsolutePage'=>$_argPage,'PageSize'=>$spaceSetting[7],'PageCount'=>0,'ResultSet'=>false);
	$_strWhere = '';
	if( $_argCatID > 0 ){
		$_strWhere = " AND T.catid='{$_argCatID}' ";
	}
	if( $isSpaceOwner===true ){
		$_strWhere .= "  AND T.islock<3 ";
	}
	$_arrReturnVal['RecordCount'] = $db->scalar("SELECT COUNT(1) FROM {$dv}space_topic T INNER JOIN {$dv}space_post P ON P.rootid=T.topicid WHERE P.parentid=0 AND T.stype='{$_argCat_tID}' {$_strWhere} AND T.userid='{$spaceUserID}'");
	if( $_arrReturnVal['RecordCount'] > 0 ){
		$_arrReturnVal['PageCount'] = ceil((float)$_arrReturnVal['RecordCount']/(float)$_arrReturnVal['PageSize']);
		if( $_arrReturnVal['AbsolutePage'] > $_arrReturnVal['PageCount'] ){
			$_arrReturnVal['AbsolutePage'] = $_arrReturnVal['PageCount'];
		}
		if( $_arrReturnVal['AbsolutePage'] < 1 ){
			$_arrReturnVal['AbsolutePage'] = 1;
		}
		$_arrReturnVal['ResultSet'] =& $db->getResultSet("SELECT T.topicid,T.catid,T.scatid,T.userid,T.username,T.title,T.titlenote,T.posttime,T.child,T.hits,T.isview,T.islock,T.stype,T.lastposttime,T.isbest,T.s_key,T.weather,P.postid FROM {$dv}space_topic T INNER JOIN {$dv}space_post P ON P.rootid=T.topicid WHERE P.parentid=0 AND T.stype='{$_argCat_tID}' {$_strWhere} AND T.userid='{$spaceUserID}' ORDER BY T.lastposttime DESC",array('absolutePage'=>$_arrReturnVal['AbsolutePage'],'pageSize'=>$_arrReturnVal['PageSize']));
	}
	return $_arrReturnVal;
}

function &getSpaceTopic_Other($_argPage,$_argCat_tID,$_argCatID){//ģʽ
	global $dv,$db,$isSpaceOwner,$spaceUserID,$spaceSetting;
	if( $_argPage < 1 ) $_argPage = 1;
	if ($spaceSetting[7] < 1) {
		$spaceSetting[7] = 20;
	}
	$_arrReturnVal = array('RecordCount'=>0,'AbsolutePage'=>$_argPage,'PageSize'=>$spaceSetting[7],'PageCount'=>0,'ResultSet'=>false);
	$_strWhere = '';
	if( $_argCatID > 0 ){
		$_strWhere = " AND catid='{$_argCatID}' ";
	}
	if( $isSpaceOwner===true ){
		$_strWhere .= "  AND islock<3 ";
	}
	$_arrReturnVal['RecordCount'] = $db->scalar("SELECT COUNT(1) FROM {$dv}space_topic WHERE stype='{$_argCat_tID}' {$_strWhere} AND userid='{$spaceUserID}'");
	if( $_arrReturnVal['RecordCount'] > 0 ){
		$_arrReturnVal['PageCount'] = ceil((float)$_arrReturnVal['RecordCount']/(float)$_arrReturnVal['PageSize']);
		if( $_arrReturnVal['AbsolutePage'] > $_arrReturnVal['PageCount'] ){
			$_arrReturnVal['AbsolutePage'] = $_arrReturnVal['PageCount'];
		}
		if( $_arrReturnVal['AbsolutePage'] < 1 ){
			$_arrReturnVal['AbsolutePage'] = 1;
		}
		$_arrReturnVal['ResultSet'] =& $db->getResultSet("SELECT topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather FROM {$dv}space_topic WHERE stype='{$_argCat_tID}' {$_strWhere} AND userid='{$spaceUserID}' ORDER BY lastposttime DESC",array('absolutePage'=>$_arrReturnVal['AbsolutePage'],'pageSize'=>$_arrReturnVal['PageSize']));
	}
	return $_arrReturnVal;
}
?>