<?php
define('THIS_SCRIPT', 'spacepostings');
require 'space_global.php';
require_once INC_PATH.'BoardCache.class.php';
require_once INC_PATH.'dv_code.php';
require_once INC_PATH.'space.functions.php';
require_once INC_PATH.'DV_Encoding.class.php';
require_once INC_PATH.'FileHandler.class.php';
require_once INC_PATH.'image_misc.functions.php';

$lang = load_lang($lang,'space.error');
$lang = load_lang($lang,'spacepostings');

$action = strtolower($action);
$_func = "Admin_{$action}";
if (function_exists($_func) === true) {
	$_strStats = $lang['HeaderTitle'][$action];
	spaceHeader(array('stats'=>$_strStats, 'isSystem'=>false, 'topEnable'=>true, 'navEnable'=>true));
	$_func();
} else {
	spaceshowmsg($lang['spaceError.str2']);
	exit;
}

spaceFooter();

function Admin_isbest()//
{
	global $userid, $dv, $db, $isSpaceMaster, $lang, $spaceUserInfo, $_GET;
	if ($userid <= 0) {
		spaceshowmsg($lang['spaceError.str12']);
		exit;
	}
	$rootid = intval($_GET['rootid']);
	if ($rootid <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	$spacetopic = false;
	if ($query = $db->query("SELECT userid,isbest,title FROM {$dv}space_topic WHERE topicid='{$rootid}'", array('pageSize'=>1))) {
		$spacetopic = $db->fetch_array($query);
	}
	if ($spacetopic === false) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($isSpaceMaster === false) {
		spaceshowmsg($lang['spaceError.str34']);
		exit;
	}
	if (intval($spacetopic['isbest']) == 0) {
		$spacetopic['isbest'] = 1;
		$actmsg = str_replace('{$Tpl_Title}', $spacetopic['title'], $lang['tpl.str3']);
	} else {
		$spacetopic['isbest'] = 0;
		$actmsg = str_replace('{$Tpl_Title}', $spacetopic['title'], $lang['tpl.str4']);
	}
	$db->query("UPDATE {$dv}space_topic SET isbest='{$spacetopic['isbest']}' WHERE topicid='{$rootid}'");
	spaceshowmsg($actmsg, 1);
	exit;
}

function Admin_delete()//ɾ
{
	global $userid, $dv, $db, $isSpaceMaster, $isSpaceOwner, $lang, $spaceUserInfo, $_GET;
	if ($userid <= 0) {
		spaceshowmsg($lang['spaceError.str12']);
		exit;
	}

	$rootid = is_numeric($_GET['rootid']) ? $_GET['rootid'] : 0;
	$postid = is_numeric($_GET['postid']) ? $_GET['postid'] : 0;
	if ($rootid <= 0 OR $postid <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}

	$spacepost = false;
	if ($query = $db->query("SELECT postid,catid,scatid,parentid,rootid,userid,title,stype,isupfile,jointime FROM {$dv}space_post WHERE postid='{$postid}'", array('pageSize'=>1))) {
		$spacepost = $db->fetch_array($query);
		if ($spacepost !== false) {
			$db->free_result($query);
		}
	}
	if ($spacepost === false) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($isSpaceOwner === false OR $isSpaceMaster === false) {
		if ($spacepost['userid'] != $userid OR $spacepost['userid'] == 0) {
			spaceshowmsg($lang['spaceError.str34']);
			exit;
		}
	}
	$rootid = $spacepost['rootid'];
	$Num_T = $Num_F = $Num_L = $Num_P = 0;
	$topictitle = $db->scalar("SELECT title FROM {$dv}space_topic WHERE topicid='{$spacepost['rootid']}'");
	if (0 == $spacepost['parentid']) {
		$topicnum = 1;
		$numcount = $db->scalar("SELECT COUNT(1) FROM {$dv}space_post WHERE parentid>0 AND rootid='{$rootid}'");
		$time1 = dv_gmtimestamp(gmdate('Y-m-d 00:00:00'));
		$time2 = $time1 + (24 * 3600) - 1;
		$dtodaynum = $db->scalar("SELECT COUNT(1) FROM {$dv}space_post WHERE rootid='{$rootid}' AND jointime BETWEEN '{$time1}' AND '{$time2}'");
		if ($query = $db->query("SELECT postid,isupfile FROM {$dv}space_post WHERE rootid='{$rootid}'")) {
			while ($topspacepost = $db->fetch_array($query)) {
				if ($topspacepost['isupfie'] == 1) {
					SysDeleteFile($topspacepost['postid']);
				}
			}
			unset($topspacepost);
		}
		if ($db->query("DELETE FROM {$dv}space_topic WHERE topicid='{$spacepost['rootid']}'")) {
		//ڸ⻺
			global $spaceUserInfo;
			updateDiaryTopic(array('Action' => 'delete', 'userid' => $spacepost['userid'], 'DiaryTopic' => &$spaceUserInfo['diary_topic'], 'PostTime' => $spacepost['jointime'], 'TopicID' => $spacepost['rootid']));
		}
		$db->query("DELETE FROM {$dv}space_post WHERE rootid='{$spacepost['rootid']}'");
		$actmsg = str_replace('', $topictitle, $lang['tpl.str5']);
	} else {
		$topicnum = 0;
		$numcount = 1;
		$time1 = dv_gmtimestamp(gmdate('Y-m-d 00:00:00'));
		$time2 = $time1 + (24 * 3600) - 1;
		$dtodaynum = $db->scalar("SELECT COUNT(1) FROM {$dv}space_post WHERE postid='{$postid}' AND jointime BETWEEN '{$time1}' AND '{$time2}'");
		if ($spacepost['isupfile'] == 1) {
			SysDeleteFile($postid);
		}
		$db->query("DELETE FROM {$dv}space_post WHERE postid='{$postid}'");
		$db->query("UPDATE {$dv}space_topic SET child=child-1 WHERE topicid='{$rootid}'");
		$actmsg = str_replace('{$Tpl_Title}', $topictitle, $lang['tpl.str6']);
	}
	switch ($spacepost['stype']) {
		case 0:
			$Num_T = $topicnum;
			break;
		case 1:
			$Num_F = $topicnum;
			break;
		case 2:
			$Num_L = $topicnum;
			break;
		case 4:
			$Num_P = $topicnum;
			break;
	}
	$db->query("UPDATE {$dv}space_user SET TopicNum = TopicNum - '{$Num_T}',FavNum=FavNum - '{$Num_F}',PhotoNum=PhotoNum - '{$Num_P}',PostNum= PostNum -'{$numcount}',TodayNum=TodayNum - '{$dtodaynum}' WHERE userid='{$GLOBALS['spaceUserID']}'");
	$db->query("UPDATE {$dv}space_syscat SET TopicNum = TopicNum - '{$topicnum}' ,PostNum=PostNum-'{$numcount}',TodayNum=TodayNum-'{$dtodaynum}' WHERE scatid IN({$spacepost['scatid']},{$spaceUserInfo['syscatid']})");
	$db->query("UPDATE {$dv}space_usercat SET TopicNum = TopicNum - '{$topicnum}',PostNum=PostNum-'{$numcount}',TodayNum=TodayNum-'{$dtodaynum}' WHERE ucatid='{$spacepost['catid']}'");
	$db->query("UPDATE {$dv}space_system SET S_PostNum = S_PostNum-'{$numcount}',S_TopicNum=S_TopicNum- '{$Num_T}',S_PhotoNum=S_PhotoNum-'{$Num_P}',S_FavNum=S_FavNum- '{$Num_F}',S_TodayNum=S_TodayNum-'{$dtodaynum}'");
	//ûҳ
	Update_TopicToXml();
	Update_PostToXml();
	updatespaceConfigCache();
	spaceshowmsg($actmsg, 1);
}

function Admin_edit()
{
	global $dv,$db,$lang,$userid,$isSpaceMaster;
	if ($userid <= 0) {
		spaceshowmsg($lang['spaceError.str12']);
		exit;
	}

	$_Rootid = is_numeric($GLOBALS['rootid']) ? $GLOBALS['rootid'] : 0 ;
	$_PostID = is_numeric($GLOBALS['postid']) ? $GLOBALS['postid'] : 0 ;
	if ($_Rootid <= 0 || $_PostID <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}

	$_arrspacePost = false;
	if ($_query = $db->query("SELECT postid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype FROM {$dv}space_post WHERE postid='{$_PostID}'", array('pageSize'=>1, 'debug' => false))) {
		$_arrspacePost = $db->fetch_array($_query);
	}
	if ($_arrspacePost === false) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}

	if ($_arrspacePost['userid'] != $userid AND false === $isSpaceMaster) {
		spaceshowmsg($lang['spaceError.str34']);
		exit;
	}

	$_ParentID = $_arrspacePost['parentid'];
	$_PostID = $_arrspacePost['postid'];
	$_RootID = $_arrspacePost['rootid'];
	$_CatID = $_arrspacePost['catid'];
	$_sCatID = $_arrspacePost['scatid'];
	$_PostUserID = $_arrspacePost['userid'];
	$_Title =& $_arrspacePost['title'];
	$_Content =& $_arrspacePost['content'];
	$_JoinTime = $_arrspacePost['jointime'];
	$_sType = $_arrspacePost['stype'];
	$_PostUserName = $_arrspacePost['username'];
	unset($_arrspacePost);

	if ($_ParentID == 0) {
		if ($_query = $db->query("SELECT titlenote,islock,isbest,s_key,weather FROM {$dv}space_topic WHERE topicid='{$_RootID}'")) {
			if ($_result = $db->fetch_array($_query)) {
				$_TitleNote = $_result['titlenote'];
				$_IsLock = $_result['islock'];
				$_IsBest = $_result['isbest'];
				$_S_Key = $_result['s_key'];
				$_Weather = $_result['weather'];
				$db->free_result($_query);
			}
			unset($_result);
		}
	}

	$_Content =& spaceFomatPostCode($_Content);
	$_arrOpts = array('Action'=>"spacepostings.php?user={$GLOBALS['spaceName']}&action=save_edit" ,'EditMode'=>'Default' ,'Show_Upload'=>1);
	if ($_ParentID == 0) {
		$_arrOpts['IsTopic'] = 1;
		$_arrOpts['IsBest'] = $_IsBest;
		$_arrOpts['IsLock'] = $_IsLock;
		$_arrOpts['Weather'] = $_Weather;
		$_arrOpts['SearchKey'] = $_S_Key;
		$_arrOpts['PostTitleNote'] = $_TitleNote;
	}
	$_arrOpts['PostID'] = $_PostID;
	$_arrOpts['RootID'] = $_RootID;
	$_arrOpts['sType'] = $_sType;
	$_arrOpts['CatID'] = $_CatID;
	$_arrOpts['sCatID'] = $_sCatID;
	$_arrOpts['Title'] =& $_Title;
	$_arrOpts['Content'] =& $_Content;
	$_arrOpts['PostUserName'] = $_PostUserName;
	$_arrOpts['JoinTime'] = $_JoinTime;
	$_arrOpts['PostTitleNote'] = $_TitleNote;
	spacepostform($_arrOpts);
}

function Admin_save_edit()
{
	global $dv,$db,$lang,$userid,$isSpaceMaster,$spaceSystemSetting,$spaceUserCat,$spaceSetting;
	if ($userid <= 0) {
		spaceshowmsg($lang['spaceError.str12']);
		exit;
	}
	//POSTԴ
	if (ChkPost() === false) {
		spaceshowmsg($lang['spaceError.str0'],0);
		return false;
	}
	//ʼ$_objEnc
	require_once INC_PATH.'DV_Encoding.class.php';
	if (empty($_objEnc) === true) {
		$_objEnc =& DV_Encoding::GetEncoding($GLOBALS['charset']);
	}
	//
	$_P_Title = trim($GLOBALS['title']);
	if ($_P_Title === '' || $_objEnc->StrLength($_P_Title) > 250) {
		spaceshowmsg($lang['spaceError.str28'],0);
		return false;
	}
	//PostTitleNote
	$_P_PostTitleNote = trim($GLOBALS['posttitlenote']);
	if ($_P_PostTitleNote !== '' && $_objEnc->StrLength($_P_PostTitleNote) > 250) {
		spaceshowmsg($lang['spaceError.str28'],0);
		return false;
	}
	//ؼ
	$_P_SearchKey = trim($GLOBALS['searchkey']);
	//
	$_P_DDateTime = trim($GLOBALS['ddatetime']);
	if ($_P_DDateTime === '' || !isDate($_P_DDateTime)) {
		$_P_DDateTime = TIME_NOW;
	} else {
		$_P_DDateTime = (dv_gmtimestamp(dateFormat($_P_DDateTime,'Y-m-d')) - getUserTimeZoneOffset()).gmdate(' H:i:s');
	}
	//
	require_once INC_PATH.'space.functions.php';
	$_P_PostContent =& CheckAlipay();
	if( empty($_P_PostContent) ){
		$_P_PostContent = trim($GLOBALS['postcontent']);
	}
	if (empty($_P_PostContent) === true) {
		spaceshowmsg($lang['spaceError.str33'],0);
		return false;
	}
	$_P_PostContent = str_replace(array("\r","\n"),'',$_P_PostContent);
	$_P_PostContent =& spaceFormatCode($_P_PostContent);

	$_P_sType = trim($GLOBALS['stype']);
	$_P_sCatID = trim($GLOBALS['scatid']);
	$_P_Catid = trim($GLOBALS['catid']);
	$_P_Lock = trim($GLOBALS['lock']);
	$_P_Best = trim($GLOBALS['best']);
	$_PostID = trim($GLOBALS['postid']);
	$_RootID = trim($GLOBALS['rootid']);
	$_P_Weather = trim($GLOBALS['weather']);

	$_arrspacePost = false;
	if ($_query = $db->query("SELECT postid,spaceuserid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype,isupfile,islock FROM {$dv}space_post WHERE postid='{$_PostID}'", array('pageSize'=>1))) {
		set_magic_quotes_runtime(1);
		$_arrspacePost = $db->fetch_array($_query);
		set_magic_quotes_runtime(0);
	}
	if ($_arrspacePost === false) {
		spaceshowmsg($lang['spaceError.str34'],0);
		return false;
	}
	if ($_arrspacePost['userid'] != $userid && $isSpaceMaster === false) {
		spaceshowmsg($lang['spaceError.str34'],0);
		return false;
	}
	if (0 == $_arrspacePost['parentid']) {
		if ($_P_SearchKey === '') {
			spaceshowmsg($lang['spaceError.str29_1'],0);
			return false;
		}
		if ($_objEnc->StrLength($_P_SearchKey) > 250) {
			spaceshowmsg($lang['spaceError.str29'],0);
			return false;
		}
	}
	$_ParentID = $_arrspacePost['parentid'];
	//֤
	if ($_ParentID <= 0) {		
		if (1 == $spaceSystemSetting[4] AND CodeIsTrue() !== true) {
			spaceshowmsg($lang['spaceError.str5'],0);
			return false;
		}
	} else {
		if (1== $spaceSystemSetting[5] AND CodeIsTrue() !== true) {
			spaceshowmsg($lang['spaceError.str5'],0);
			return false;
		}
	}
	//ϴļ
	if ($upfileinfo = uploadedFilesProc($_P_PostContent)) {
		$_HaveUpFile = $upfileinfo[0];
		$_P_UpFileID = $upfileinfo[1];
	} else {
		$_HaveUpFile = 0;
		$_P_UpFileID = 0;
	}

	$_arrspacePost['title'] =& $_P_Title;
	$_arrspacePost['content'] =& $_P_PostContent;
	if (0 == $_ParentID) {
		if ($_P_sType < 0 || $_P_sType > 5) {
			spaceshowmsg($lang['spaceError.str30'],0);
			return false;
		}
		if ($_P_sCatID == -1) {
			spaceshowmsg($lang['spaceError.str31'],0);
			return false;
		}
		if ($_P_Catid == -1 || $_P_Catid == '' || !is_numeric($_P_Catid)) {
			$_P_Catid = 0;
		} else {
			$_P_Catid = intval($_P_Catid);
		}
		$_arrspacePost['catid'] = $_P_Catid;
		$_arrspacePost['scatid'] = $_P_sCatID;
		$_arrspacePost['stype'] = $_P_sType;
		$_arrspacePost['jointime'] = $_P_DDateTime;
		$_arrspacePost['isupfile'] = $_HaveUpFile;
	}
	$_arrspacePost['title'] = $db->escape_string(cross_site_html_proc(stripslashes($_arrspacePost['title']), $errcode, $errstr));
	$_arrspacePost['content'] = $db->escape_string(cross_site_html_proc(stripslashes($_arrspacePost['content']), $errcode, $errstr));
	$db->query("UPDATE {$dv}space_post SET title='{$_arrspacePost['title']}',content='{$_arrspacePost['content']}',catid='{$_arrspacePost['catid']}',scatid='{$_arrspacePost['scatid']}',stype='{$_arrspacePost['stype']}',jointime='{$_arrspacePost['jointime']}',isupfile='{$_arrspacePost['isupfile']}' WHERE postid='{$_arrspacePost['postid']}'");

	$_ActMsg = '';

	if ($_ParentID == 0) {
		$_IsTopic = 0;
		$_arrspaceTopic = false;
		if( $_query = $db->query("SELECT topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather,visituser,paymoney,paynumber,paytime,trackbacks FROM {$dv}space_topic WHERE topicid='{$_RootID}'",array('pageSize'=>1)) ){
			set_magic_quotes_runtime(1);
			$_arrSpaceTopic = $db->fetch_array($_query);
			set_magic_quotes_runtime(0);
		}
		if ($_arrSpaceTopic === false) {
			spaceshowmsg($lang['spaceError.str34'],0);
			return false;
		}
		$_arrSpaceTopic['catid'] = $_P_Catid;
		$_arrSpaceTopic['scatid'] = $_P_sCatID;
		$_arrSpaceTopic['title'] = $_P_Title;
		$_arrSpaceTopic['titlenote'] = $_P_PostTitleNote;
		$_arrSpaceTopic['islock'] = $_P_Lock;
		$_arrSpaceTopic['stype'] = $_P_sType;
		$_arrSpaceTopic['isbest'] = $_P_Best;
		$_arrSpaceTopic['s_key'] = $_P_SearchKey;
		$_arrSpaceTopic['weather'] = $_P_Weather;
		$_arrSpaceTopic['title'] = $db->escape_string(cross_site_html_proc(stripslashes($_arrSpaceTopic['title']), $errcode, $errstr));
		//ڸ⻺
		global $spaceUserInfo;
		updateDiaryTopic(array('Action' => 'update', 'userid' => $_arrSpaceTopic['userid'], 'DiaryTopic' => &$spaceUserInfo['diary_topic'], 'RawPostTime' => $_arrSpaceTopic['posttime'], 'NewPostTime' => $_P_DDateTime, 'TopicID' => $_arrSpaceTopic['topicid']));

		$_arrSpaceTopic['posttime'] = $_P_DDateTime;
		$db->query("UPDATE {$dv}space_topic SET catid='{$_arrSpaceTopic['catid']}',scatid='{$_arrSpaceTopic['scatid']}',title='{$_arrSpaceTopic['title']}',titlenote='{$_arrSpaceTopic['titlenote']}',islock='{$_arrSpaceTopic['islock']}',stype='{$_arrSpaceTopic['stype']}',isbest='{$_arrSpaceTopic['isbest']}',s_key='{$_arrSpaceTopic['s_key']}',weather='{$_arrSpaceTopic['weather']}',posttime='{$_arrSpaceTopic['posttime']}' WHERE topicid='{$_arrSpaceTopic['topicid']}'");

		$db->query("UPDATE {$dv}space_post SET catid='{$_P_Catid}',scatid='{$_P_sCatID}',stype='{$_P_sType}',islock='{$_P_Lock}' WHERE rootid='{$_Rootid}'");
		$_ActMsg .= str_replace('{$Tpl_P_Title}',$_P_Title,$lang['tpl.str0']);
	} else {
		$_IsTopic = 1;
		$_ActMsg .= $lang['tpl.str1'];
	}

	if ($_HaveUpFile == 1 AND $_P_UpFileID) {
		$db->query("UPDATE {$dv}space_upfile SET catid='{$_P_Catid}',stype='{$_P_sType}',topicid='{$_RootID}',postid='{$_PostID}',istopic='{$_IsTopic}',title='{$_P_Title}',filenote='{$_P_PostTitleNote}',islock='{$_P_Lock}' WHERE id IN({$_P_UpFileID})");
	}

	$_arrSpaceTopic = false;
	if (!empty($spaceUserCat['spacetopic']) AND is_array($spaceUserCat['spacetopic'])) {
		foreach( $spaceUserCat['spacetopic'] as $_index => $_val ){
			if( $_val['topicid'] == $_RootID ){
				$_arrSpaceTopic =& $spaceUserCat['spacetopic'][$_index];
				break;
			}
		}
	}
	if ($_arrSpaceTopic !== false) {
		if (0 == $_ParentID) {
			if (empty($_P_PostTitleNote)) {
				if ($_objEnc->StrLength($_P_PostTitleNote) > 250) {
					$_P_PostTitleNote = $_objEnc->SubString($_P_PostTitleNote, 0, 500);
				} else {
					$_P_PostTitleNote = $_P_PostContent;
				}
			}
			global $spaceSetting;
			$_ubbcode = stripslashes(spaceUbbCode($_P_PostTitleNote, false));
			$_P_PostTitleNote =& getTitleNote($_ubbcode, 0, $spaceSetting[2]);
			$_P_PostTitleNote =& _imgaddjscode($_P_PostTitleNote);
			$_arrSpaceTopic['titlenote'] =& $_P_PostTitleNote;
			$_arrSpaceTopic['title'] =& $_P_Title;
		}
		$_arrSpaceTopic['lastposttime'] = TIME_NOW;
		$db->query("UPDATE {$dv}space_user SET xmldata='".$db->escape_string(base64_encode(serialize($spaceUserCat)))."' WHERE userid='{$GLOBALS['spaceUserID']}'");
		$db->query("UPDATE {$dv}space_topic SET titlenote='".$db->escape_string($_P_PostTitleNote)."' WHERE topicid='{$_arrSpaceTopic['topicid']}'");
	}
	spaceshowmsg($_ActMsg, 1);
	exit;
}

function Admin_reply()
{
	global $dv, $db, $lang, $userid, $isSpaceMaster, $isSpaceOwner, $spaceSystemSetting, $spaceSetting, $_GET;
	if ($spaceSystemSetting[2] != 1 AND $userid <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($isSpaceOwner === false AND $spaceSetting[4] == 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	$rootid = is_numeric($_GET['rootid']) ? $_GET['rootid'] : 0;
	$postid = is_numeric($_GET['postid']) ? $_GET['postid'] : 0;
	if ($rootid <= 0 OR $postid <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($userid > 0 AND $userid == $GLOBALS['spaceUserID']) {
		$P_PostUserName = $GLOBALS['spaceUserName'];
	} else {
		$P_PostUserName = $GLOBALS['membername'];
	}
	$postformopts = array('Action'=>"spacepostings.php?user={$GLOBALS['spaceName']}&action=save_reply");
	if ($isSpaceOwner === true OR $isSpaceMaster === true) {
		$postformopts['EditMode'] = 'Default';
		$postformopts['Show_Upload'] = 1;
	} else {
		$postformopts['EditMode'] = 'Basic';
	}
	$postformopts['PostID'] = $postid;
	$postformopts['RootID'] = $rootid;
	$postformopts['PostUserName'] = $P_PostUserName;
	$postformopts['PostTitleNote'] = $GLOBALS['posttitlenote'];
	spacepostform($postformopts);
}

function Admin_save_reply()
{
	global $dv, $db, $lang, $userid, $isSpaceMaster, $isSpaceOwner, $spaceSystemSetting, $spaceSetting, $spaceUserCat, $spaceUserInfo, $_GET, $_POST;
	if ($spaceSystemSetting[2] != 1 AND $userid <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($isSpaceOwner === false AND $spaceSetting[4] == 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	$P_PostUserName = trim($_POST['postusername']);
	$P_Title = trim($_POST['title']);
	$P_PostContent =& CheckAlipay();
	if (empty($P_PostContent)) {
		$P_PostContent = trim($_POST['postcontent']);
	}
	if (empty($P_PostContent)) {
		spaceshowmsg($lang['spaceError.str33']);
		exit;
	} else {
		$P_PostContent = str_replace(array("\r","\n"),'',$P_PostContent);
	}
	$RootID = is_numeric($_POST['rootid']) ? $_POST['rootid'] : 0;
	if ($RootID <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	if ($spaceSystemSetting[5] == 1 AND CodeIsTrue() === false) {
		spaceshowmsg($lang['spaceError.str5']);
		exit;
	}
	$P_UpFileID = $_POST['upfilerename'];
	$IsTopic = 1;
	if (empty($P_UpFileID) === false AND is_array($P_UpFileID) === true) {
		$HaveUpFile = 1;
		$upfileidlist = implode(',',$P_UpFileID);
		if (checkIDList() !== true) {
			$HaveUpFile = 0;
		}
	} else {
		$HaveUpFile = 0;
	}
	if ($userid <= 0) {
		if ($P_PostUserName === '' OR checkText($P_PostUserName) === false) {
			spaceshowmsg($lang['spaceError.str37']);
			exit;
		} else {
			$FoundUser = false;
			$count = $db->scalar("SELECT COUNT(1) FROM {$dv}space_user WHERE username='{$P_PostUserName}'");
			if ($count > 0) {
				$FoundUser = true;
			}
			$count = $db->scalar("SELECT COUNT(1) FROM {$dv}space_user WHERE nickname='{$P_PostUserName}'");
			if ($count > 0) {
				$FoundUser = true;
			}
			if ($FoundUser === true) {
				spaceshowmsg($lang['spaceError.str38']);
				exit;
			}
		}
	} else {
		if ($userid == $GLOBALS['spaceUserID']) {
			$P_PostUserName = $GLOBALS['spaceUserName'];
		} else {
			$P_PostUserName = $GLOBALS['membername'];
		}
	}
	$P_PostContent =& spaceFormatCode($P_PostContent);
	$spacetopic = false;
	if ($query = $db->query("SELECT title,userid,catid,scatid,stype,islock,child,lastposttime FROM {$dv}space_topic WHERE topicid='{$RootID}'", array('pageSIze'=>1))) {
		$spacetopic = $db->fetch_array($query);
		$db->free_result($query);
	}
	if ($spacetopic === false) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	switch ($spacetopic['islock']) {
		case 3://ֻ߿Իظ
			if ($isSpaceOwner === false) {
				spaceshowmsg($lang['spaceError.str36']);
				exit;
			}
			break;
		case 2://ֻйԱ߿Իظ
			if ($isSpaceOwner === false OR $isSpaceMaster === false) {
				spaceshowmsg($lang['spaceError.str36']);
				exit;
			}
			break;
		case 1://֤
			//Nothing to do
			break;
		default:
			//Nothing to do
			break;
	}
	$TopicUserID = $spacetopic['userid'];
	$Topic = $spacetopic['title'];
	$CatID = $spacetopic['catid'];
	$sCatID = $spacetopic['scatid'];
	$Stype = $spacetopic['stype'];
	$IsLock = $spacetopic['islock'];
	$TopicChild = $spacetopic['child'] + 1;

	$datenow = TIME_NOW;//date('Y-m-d H:i:s');
	$db->query("UPDATE {$dv}space_topic SET child=child+1, lastposttime='{$datenow}' WHERE topicid='{$RootID}'");

	$ParentID = $db->scalar("SELECT postid FROM {$dv}space_post WHERE rootid='{$RootID}' AND parentid=0");
	$db->query("INSERT INTO {$dv}space_post (ParentID,spaceUserID,CatID,sCatID,RootID,UserID,UserName,Title,Content,JoinTime,IP,sType,IsUpfile,IsLock) VALUES ('{$ParentID}','{$TopicUserID}','{$CatID}','{$sCatID}','{$RootID}','{$GLOBALS['userid']}','{$P_PostUserName}','{$P_Title}','{$P_PostContent}','{$datenow}','{$GLOBALS['usertrueip']}','{$Stype}','{$HaveUpFile}','{$IsLock}')");

	$PostID = $db->scalar("SELECT postid FROM {$dv}space_post ORDER BY postid DESC");
	//ûռ
	$db->query("UPDATE {$dv}space_user SET postnum=postnum+1,TodayNum=TodayNum+1,LastUpTime='{$datenow}' WHERE UserID='{$TopicUserID}'");
	//ռ仰
	$db->query("UPDATE {$dv}space_syscat SET PostNum=PostNum+1,TodayNum=TodayNum+1,LastUpTime='{$datenow}' WHERE sCatID='{$sCatID}'");
	//SysCatID ҵĿռķ
	$db->query("UPDATE {$dv}space_syscat SET PostNum=PostNum+1,TodayNum=TodayNum+1,LastUpTime='{$datenow}' WHERE sCatID='{$spaceUserInfo['syscatid']}'");
	//ûĿ
	$db->query("UPDATE {$dv}space_usercat SET PostNum=PostNum+1,TodayNum=TodayNum+1,LastUpTime='{$datenow}' WHERE uCatID='{$Catid}'");
	//ҵĿռϵͳ
	$db->query("UPDATE {$dv}space_system SET S_TodayNum=S_TodayNum+1,S_PostNum=S_PostNum+1,S_LastPostTime='{$datenow}'");

	if ($HaveUpFile == 1) {
		$db->query("UPDATE {$dv}space_upfile SET CatID='{$CatID}',sType='{$Stype}',TopicID='{$RootID}',PostID='{$PostID}',IsTopic='{$IsTopic}',Title='{$P_Title}',IsLock='{$IsLock}' WHERE id IN(".implode(',', $P_UpFileID).")");
	}
	$usercatconfig =& getUserCatFromXmlData();
	$usercat_spacetopic = false;
	if (is_array($usercatconfig['spacetopic']) === true) {
		foreach ($usercatconfig['spacetopic'] AS $index => $val) {
			if ($val['topicid'] == $RootID) {
				$usercat_spacetopic =& $usercatconfig['spacetopic'][$index];
				break;
			}
		}
	}
	if ($usercat_spacetopic !== false) {
		$usercat_spacetopic['child']++;
		$usercat_spacetopic['lastposttime'] = $datenow;
	}
	$usercat_resultset = false;
	if (is_array($usercatconfig['result_set']) === true) {
		foreach ($usercatconfig['result_set'] AS $index => $val) {
			if ($val['ucatid'] == $Catid) {
				$usercat_resultset =& $usercatconfig['result_set'][$index];
				break;
			}
		}
	}
	if ($usercat_resultset !== false) {
		$usercat_resultset['postnum']++;
		$usercat_resultset['lastposttime'] = $datenow;
	}
	Update_PostToXml();
	$db->query("UPDATE {$dv}space_syscat SET todaynum=todaynum+1, postnum=postnum+1, lastuptime='{$datenow}' WHERE scatid IN({$sCatID},{$spaceUserInfo['syscatid']})");
	$db->query("UPDATE {$dv}space_system SET s_todaynum=s_todaynum+1, s_postnum=s_postnum+1, s_lastposttime='{$datenow}'");
	updatespaceConfigCache();
	$actmsg = str_replace('{$Tpl_Topic}', $Topic, $lang['tpl.str7']);
	spaceshowmsg($actmsg, 1);
	exit;
}

function Admin_visit()
{
	global $dv, $db, $lang, $userid, $isSpaceMaster, $isSpaceOwner, $spaceSystemSetting, $spaceSetting, $spaceUserCat, $spaceUserInfo, $userinfo, $_GET;
	if ($userid <= 0) {
		spaceshowmsg($lang['spaceError.str12']);
		exit;
	}
	$RootID = is_numeric($_GET['rootid']) ? $_GET['rootid'] : 0;
	if ($RootID <= 0) {
		spaceshowmsg($lang['spaceError.str2']);
		exit;
	}
	$VisitDoc = $db->scalar("SELECT visituser FROM {$dv}space_topic WHERE topicid='{$RootID}'");
	if ($VisitDoc === false) {
		spaceshowmsg($lang['spaceError.str34']);
		exit;
	}
	$unserializedoc = unserialize($VisitDoc);
	if ($unserializedoc = false) {
		$unserializedoc = array('userlist' => array());
	}
	if (isset($unserializedoc['userlist'][$userid]) === true) {//벻Ҫظӡ
		spaceshowmsg($lang['error.str1']);
		exit;
	}
	$unserializedoc['userlist'][$userid] = array('uid'=>$userid, 'uname'=>$GLOBALS['membername'], 'uip'=>$GLOBALS['usertrueip'], 'usex'=>$userinfo['usersex'], 'utime'=>TIME_NOW);
	$db->query("UPDATE {$dv}space_topic SET visituser='".$db->escape_string(serialize($unserializedoc))."' WHERE topicid='{$RootID}'");
	header("Location:{$_SERVER['HTTP_REFERER']}");
	exit;
}

function Admin_spacestats()//ҵĿռ״̬
{
	global $dv, $db, $lang, $isSpaceMaster, $spaceUserInfo;
	if ($isSpaceMaster === false) {
		spaceshowmsg($lang['spaceError.str40']);
		exit;
	}
	if ($spaceUserInfo['stats'] == 0) {
		$Stats = 2;
	} else {
		$Stats = 0;
	}
	$db->query("UPDATE {$dv}space_user SET stats='{$Stats}' WHERE userid='{$GLOBALS['spaceUserID']}'");
	spaceshowmsg($lang['tpl.str8'],1);
	exit;
}


function updatespaceConfigCache(){
	global $db;
	static $_blnspaceConfigUpdated = false;
	static $_objCache;
	if( $_blnspaceConfigUpdated === false ){
		$_blnspaceConfigUpdated = true;
		if (!isset($_objCache)) {
			$_objCache = new BoardCache($db);
		}
		$_objCache->createspaceConfig();
	}
}

function Update_PostToXml($_argUpdateDataBase=true)//ҳ
{
	global $dv,$db;
	if( !is_numeric($spaceSetting[3]) ){
		$spaceSetting[3] = 10;
	}
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['spacepost'] =& $db->getResultSet("SELECT postid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype FROM {$dv}space_post WHERE spaceuserid='{$GLOBALS['spaceUserID']}' AND parentid>0 AND stype<>2 /*stype in(0,3,4)*/ ORDER BY jointime DESC",array('pageSize'=>$spaceSetting[3]));
	if( $_arrspaceConfig_UserCat['spacepost'] === false ){
		$_arrspaceConfig_UserCat['spacepost'] = array();
	} else{
		if( empty($_objEnc) ){
			$_objEnc =& DV_Encoding::GetEncoding($GLOBALS['charset']);
		}
		foreach( $_arrspaceConfig_UserCat['spacepost'] as $_index => $_val ){
			$_arrspaceConfig_UserCat['spacepost'][$_index]['content'] = $_objEnc->SubString($_val['content'],0,50);
		}
	}
	if( $_argUpdateDataBase === true ){
		saveUserCatToXmlData();
	}
}
//ûĿ
function Update_UserCatToXml(){
	global $lang,$dv,$db;
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['result_set'] =& $db->getResultSet("SELECT ucatid, userid, ucattitle, ucatnote, opentime, utype, topicnum, postnum, todaynum, isview, lastuptime FROM {$dv}space_usercat WHERE userid='{$GLOBALS['userid']}' ORDER BY utype, ucatid");
	if( $_arrspaceConfig_UserCat['result_set'] === false ){
		$_arrspaceConfig_UserCat['result_set'] = array();
	}

	//ҳ
	Update_TopicToXml(false);
	//ҳ
	Update_LinkToXml(false);
	//ҳͼƬ
	Update_PhotoToXml(false);
	//ҳ
	Update_PostToXml(false);
	//¹ؼת
	Update_KeyWordToXml(false);
	//
	Update_MusicToXml(false);
	
	saveUserCatToXmlData();

	spaceShowMsg($lang['spaceError.str25'],1);
	return true;
}//end function Update_UserCatToXml


//ҳ
function Update_TopicToXml($mustupdatedb=true){
	global $dv,$db,$lang,$spaceUserCat,$spaceSetting,$spaceName,$_objEnc;
	if( !is_numeric($spaceSetting[6]) ){
		$spaceSetting[6] = 10;
	}
	$spaceconfig_usercat =& getUserCatFromXmlData();
	if ($spaceSetting[6] < 1) {
		$spaceSetting[6] = 20;
	}
	unset($spaceconfig_usercat['spacetopic']);
	if ($query = $db->query("SELECT /*!40001 SQL_CACHE */ topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather FROM {$dv}space_topic /*!32312 USE INDEX(newly_topic_by_user) */ WHERE userid='{$GLOBALS['spaceUserID']}' AND stype>=0 AND islock<3 ORDER BY topicid DESC",array('pageSize'=>$spaceSetting[6]))) {
		while ($topicinfo =& $db->fetch_array($query)) {
			$titlenote = trim($topicinfo['titlenote']);
			if('' === $titlenote) {
				$titlenote = trim($db->scalar("SELECT SUBSTRING(content, 1, 500) FROM {$dv}space_post WHERE parentid=0 AND rootid='{$topicinfo['topicid']}'"));
			}
			if ('' !== $titlenote) {
				$titlenote = spaceUbbCode($titlenote).str_replace('{$Tpl_TopicID}',$topicinfo['topicid'],$titlenot_postfix);
				$topicinfo['titlenote'] = $titlenote;
				$db->query("UPDATE {$dv}space_topic SET titlenote='".$db->escape_string($titlenote)."' WHERE topicid='{$topicinfo['topicid']}'");
			}
			$spaceconfig_usercat['spacetopic'][] =& $topicinfo;
		}
		$db->free_result($query);
	}
	if (empty($spaceconfig_usercat['spacetopic'])) {
		$spaceconfig_usercat['spacetopic'] = array();
	}
	if (true === $mustupdatedb) {
		saveUserCatToXmlData();
	}
}//end function Update_TopicToXml

function Update_LinkToXml($_argUpdateDataBase=true){//ҳ
	global $dv,$db;
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['spacelink'] =& $db->getResultSet("SELECT topicid,catid,scatid,userid,username,title,titlenote,posttime,child,hits,isview,islock,stype,lastposttime,isbest,s_key,weather,title AS content FROM {$dv}space_topic WHERE userid='{$GLOBALS['spaceUserID']}' AND stype=2 AND islock<3 ORDER BY lastposttime DESC",array('pageSize'=>5));
	if( $_arrspaceConfig_UserCat['spacelink'] === false ){
		$_arrspaceConfig_UserCat['spacelink'] = array();
	} else{
		foreach( $_arrspaceConfig_UserCat['spacelink'] as $_index => $_val ){
			$_strContent = $_val['content'].'';
			if( $_strContent === '' ){
				$_strContent = $db->scalar("SELECT content FROM {$dv}space_post WHERE parentid=0 AND rootid='{$_val['topicid']}'");
			}
			$_arrspaceConfig_UserCat['spacelink'][$_index]['content'] = $_strContent;
		}
	}
	if( $_argUpdateDataBase === true ){
		saveUserCatToXmlData();
	}
}//end function Update_LinkToXml

function Update_PhotoToXml($_argUpdateDataBase=true){//ҳͼƬ
	global $dv,$db;
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['spacephoto'] =& $db->getResultSet("SELECT id,spaceuserid,username,catid,stype,topicid,postid,istopic,title,filename,filetype,filesize,filenote,downnum,viewnum,dateandtime,previewimage,islock FROM {$dv}space_upfile WHERE stype=4 AND istopic=0 AND islock<3 AND spaceuserid='{$GLOBALS['spaceUserID']}' ORDER BY dateandtime DESC",array('pageSize'=>5));
	if( $_arrspaceConfig_UserCat['spacephoto'] === false ){
		$_arrspaceConfig_UserCat['spacephoto'] = array();
	}
	if( $_argUpdateDataBase === true ){
		saveUserCatToXmlData();
	}
}

function Update_KeyWordToXml($_argUpdateDataBase=true){//¹ؼת
	global $dv,$db;
	if( !is_numeric($spaceSetting[3]) ){
		$spaceSetting[3] = 10;
	}
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['spacekeyword'] =& $db->getResultSet("SELECT postid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype FROM {$dv}space_post WHERE spaceuserid='{$GLOBALS['spaceUserID']}' AND parentid>0 AND stype IN(0,3,4) ORDER BY jointime DESC",array('pageSize'=>$spaceSetting[3]));
	if( $_arrspaceConfig_UserCat['spacekeyword'] === false ){
		$_arrspaceConfig_UserCat['spacekeyword'] = array();
	}
	if( $_argUpdateDataBase === true ){
		saveUserCatToXmlData();
	}
}

function Page_UserInput_Cat_Save(){//ûĿ
	global $dv,$db,$lang,$spaceUserCat,$spaceSetting,$spaceName,$_objEnc;
	$_uCatTitle = trim($GLOBALS['ucattitle']);
	if( $_uCatTitle === '' ){
		spaceShowMsg($lang['spaceError.str23'],0);
		return false;
	} else{
		$_uCatTitle = htmlspecialchars($_uCatTitle);
	}
	$_uCatID = trim($GLOBALS['ucatid']);
	if( !is_numeric($_uCatID) ){
		$_uCatID = 0;
	}
	$_uCatNote = trim($GLOBALS['ucatnote']);
	if( $_uCatNote !== '' ){
		$_uCatNote = htmlspecialchars($_uCatNote);
	}
	$_isView = trim($GLOBALS['isview']);
	if( !is_numeric($_isView) ){
		$_isView = 0;
	}
	$_sType = trim($GLOBALS['stype']);
	if( !is_numeric($_sType) ){
		$_sType = 0;
	}
	if( $_uCatID > 0 ){
		$db->query("UPDATE {$dv}space_usercat SET ucattitle='{$_uCatTitle}',ucatnote='{$_uCatNote}',isview='{$_isView}',utype='{$_sType}' WHERE ucatid='{$_uCatID}' AND userid='{$GLOBALS['userid']}'");
	} else{
		$db->query("INSERT INTO {$dv}space_usercat(ucattitle,ucatnote,isview,userid,utype) VALUES('{$_uCatTitle}','{$_uCatNote}','{$_isView}','{$GLOBALS['userid']}','{$_sType}')");
	}
	Update_UserCatToXml();
	spaceShowMsg($lang['spaceError.str22'],1);
	return false;
}
function Update_MusicToXml($_argUpdateDataBase = true)	//	
{
	global $dv,$db;
	if( !is_numeric($spaceSetting[3]) ){
		$spaceSetting[3] = 10;
	}
	$_arrspaceConfig_UserCat =& getUserCatFromXmlData();
	$_arrspaceConfig_UserCat['spacemusic'] =& $db->getResultSet("SELECT postid,catid,scatid,parentid,rootid,userid,username,title,SUBSTRING(content, 1, 50),jointime,ip,stype FROM {$dv}space_post WHERE spaceuserid='{$GLOBALS['spaceUserID']}' AND parentid>0 AND stype='5' ORDER BY jointime DESC",array('pageSize'=>$spaceSetting[3]));
	if( $_arrspaceConfig_UserCat['spacemusic'] === false ){
		$_arrspaceConfig_UserCat['spacemusic'] = array();
	} else{
	}
	if( $_argUpdateDataBase === true ){
		saveUserCatToXmlData();
	}
}//end function Update_MusicToXml


function uploadedFilesProc(&$arg_postcontent) // ѳɹϴļдԤͼƬ
{
	global $fsetting, $spaceSystemUpSetting, $upfileinfo, $ihaveupfile, $uploadedfilesinfo, $fsetting, $boardid, $userid, $membername, $db, $dv, $__upfileinfo;
	if (empty($_P_PostContent)) {
		$_P_PostContent =& $GLOBALS['postcontent'];
	}
	$ihaveupfile = 0;
	$upfileinfo = '';
	//Start ϴʱĿ¼Ƿд˴ϴļ
		if (false !== strpos($__upfileinfo, '||')) {
			if ($tmparr = explode('||', $__upfileinfo)) {
				foreach ($tmparr AS $val) {
					$tmp1 = unserialize(base64_decode($val));
					foreach ($tmp1 AS $tmp2) {
						$uploadedfilesinfo[] = $tmp2;
					}
				}
				unset($tmparr, $tmp);
			}
		} else {
			$uploadedfilesinfo = unserialize(base64_decode($__upfileinfo));
		}
		if (empty($uploadedfilesinfo) OR !is_array($uploadedfilesinfo)) {
			return false;
		}
	//End ϴʱĿ¼Ƿд˴ϴļ

	//Start ʼĿ¼
		require_once INC_PATH.'upload.functions.php';
		$updirs = initUploadDirectories(array('init_updestdir'=>false, 'destdir'=>$uploadedfilesinfo[0]['subuploaddir']));
		FileHandler::find_writable_dir($uptopdir); // ÿдĿ¼
		$tempdir = $updirs['uptmpdir'];
		$destdir = $updirs['spacedestdir'];
		$canmakethumbnail = (($spaceSystemUpSetting[17] != 0) AND canmakethumbnail());
		$previewimgdir = $updirs['spacepreviewdestdir'];
	//End ʼĿ¼

	$documentroot = $updirs['documentroot'];
	$comma = '';
	$insert_stmt = $renamelist_src = $renamelist_dest = array();
	$nowdate = TIME_NOW;
	$arrtmpname = array();
	foreach ($uploadedfilesinfo AS $val) {
		$val['ext'] = strtolower($val['ext']);
		//ļ׺/ļչһݵķ˵ͼƬļļĩβ׷һ»"_"߰ȫ
		if ($val['ftype'] != 1 OR false === strpos('|gif|jpg|jpeg|png|bmp|tif|iff|', '|'.strtolower(trim($val['ext'])).'|')) {
			$val['ext'] .= '_';
		}
		$val['name'] = strtolower($val['name']);
		$thumbnailfile = $tempdir.'/__dv_tmp_preview_file__'.$val['name'];
		$destfile = $destdir.'/'.$val['name'].'.'.$val['ext'];			// ƶʽ洢λ
		$tmpfile = realpath($tempdir.'/'.$val['uploaded_tmpfile']);	// ɹϴʱ洢Ŀ¼ڵļ
		if (false === $tmpfile) {
			continue;
		}
		$previewfile = '';
		if ($val['ftype'] == 1 AND true === $canmakethumbnail) {			
			if (@image_thumbnail($tmpfile, $spaceSystemUpSetting[14], $spaceSystemUpSetting[15], $thumbnailfile)) {
				$previewfile = $previewimgdir.'/'.$val['name'].'.jpg';
				$renamelist_src[] = $thumbnailfile.'.jpg';
				$renamelist_dest[] = $previewfile;
			}
		}
		$renamelist_src[] = $tmpfile;
		$renamelist_dest[] = $destfile;
		$arrtmpname[] = $val['name'];
		$destfile = $db->escape_string(str_replace($updirs['spaceuptopdir'].'/', '', $destfile));
		$previewfile = $db->escape_string(str_replace($updirs['spaceuptopdir'].'/', '', $previewfile));
		$insert_stmt[] = "INSERT INTO {$dv}space_upfile(spaceuserid,userid,username,filename,sfilename,filetype,filesize,previewimage,islock,istopic,dateandtime) VALUES('{$GLOBALS['spaceUserID']}', '{$GLOBALS['userid']}', '{$GLOBALS['spaceUserName']}', '{$destfile}', '".$db->escape_string(basename($destfile))."', '".$db->escape_string($val['ftype'])."', '".$db->escape_string($val['size'])."', '".$db->escape_string($previewfile)."', 4, -1, '{$nowdate}')";
	}
	if (!empty($renamelist_src) AND !empty($renamelist_dest)) {
		if (count($renamelist_src) == count($renamelist_dest)) {
			if (FileHandler::rename($renamelist_src, $renamelist_dest)) {
				$arrfind = $arrrepl = array();
				foreach ($insert_stmt AS $index => $stmt) {
					if ($db->query($stmt)) {
						$insertedid = $db->insert_id();
						if ($insertedid <= 0) {
							$insertedid = $db->scalar("SELECT MAX(f_id) FROM {$dv}upfile");
						}
						if ($insertedid > 0) {
							$ihaveupfile = 1;
							$upfileinfo .= $comma.$insertedid;
							$comma =',';
							$arrfind[] = ']viewfile.php?src=space&amp;id=ViewFileID_'.$arrtmpname[$index].'[/upload]';
							$arrrepl[] = ']viewfile.php?src=space&id='.$insertedid.'[/upload]';
						}
					}
				}//end foreach
				if (!empty($arg_postcontent)) {
					$arg_postcontent = str_replace($arrfind, $arrrepl, $arg_postcontent);
				}
				@FileHandler::chmod($renamelist_dest, 0755);
			}
		}
	}
	return array($ihaveupfile, $upfileinfo);
}//end function uploadedFilesProc
?>