<?php

define('THIS_SCRIPT', 'spacesearch');
require_once 'space_global.php';
$lang = load_lang($lang, 'spacesearch' );
$lang = load_lang($lang, 'space.error' );

spaceHeader(array('stats'=>$_strStats,'isSystem'=>false,'topEnable'=>true,'navEnable'=>true));
require printout('spacesearch');
spaceFooter();

function &getSearchResult(){
	global $dv,$db,$spaceSetting,$spaceUserID,$isSpaceOwner;
	$_keyword = trim($GLOBALS['keyword']);
	if( $_keyword === '' ){
		return false;
	}
	$_stype = trim($GLOBALS['stype']);
	$_selType = is_numeric($GLOBALS['sel']) ? intval($GLOBALS['sel']) : 0 ;
	$_dYear = is_numeric($GLOBALS['dy']) ? $GLOBALS['dy'] : '' ;
	$_dMonth = is_numeric($GLOBALS['dm']) ? $GLOBALS['dm'] : '' ;
	$_dDay = is_numeric($GLOBALS['dd']) ? $GLOBALS['dd'] : '' ;
	$_strWhereStmt = '';
	if( $_stype >= 0 ){
		$_stype = intval($_stype);
		$_strWhereStmt .= " AND stype='{$_stype}' ";
	} else{
		$_stype = -1;
	}
	if ($_dYear > 0 AND $_dMonth > 0 AND $_dDay > 0) {
		$time1 = gmmktime(0, 0, 0, $_dMonth, $_dDay, $_dYear) - getUserTimeZoneOffset();
		$time2 = $time1 + (24 * 3600) - 1;
		$_strWhereStmt .= " AND (jointime BETWEEN '{$time1}' AND '{$time2}') ";
	} else {
		if ($_dYear > 0 AND $_dMonth > 0) {
			$time1 = gmmktime(0, 0, 0, $_dMonth, 1, $_dYear) - getUserTimeZoneOffset();
			$time2 = gmmktime(23, 59, 59, $_dMonth + 1, 0, $_dYear) - getUserTimeZoneOffset();
			$_strWhereStmt .= " AND jointime BETWEEN '{$time1}' AND '{$time2}' ";
		} elseif ($_dYear > 0) {
			$time1 = gmmktime(0, 0, 0, 1, 1, $_dYear) - getUserTimeZoneOffset();
			$time2 = gmmktime(23, 59, 59, 1, 0, $_dYear + 1) - getUserTimeZoneOffset();
			$_strWhereStmt .= " AND jointime BETWEEN '{$time1}' AND '{$time2}' ";
		}
	}
	if( $_selType == 0 ){
		$_strWhereStmt .= " AND title LIKE '%{$_keyword}%' ";
	} elseif( $_selType == 1 ){
		$_strWhereStmt .= " AND username LIKE '%{$_keyword}%' ";
	} elseif( $_selType == 2 ){
		$_strWhereStmt .= " AND content LIKE '%{$_keyword}%' ";
	} else{
		return false;
	}
	if( $isSpaceOwner !== true ){
		$_strWhereStmt .= " AND islock<3 ";
	} else{
	}
	$page = $GLOBALS['page'];
	if( $page < 1 ) $page = 1;
	if ($spaceSetting[7] < 1) {
		$spaceSetting[7] = 20;
	}
	$_arrReturnVal = array('RecordCount'=>0,'AbsolutePage'=>$page,'PageSize'=>$spaceSetting[7],'PageCount'=>0,'ResultSet'=>false);
	$_arrReturnVal['RecordCount'] = $db->scalar("SELECT COUNT(1) FROM {$dv}space_post WHERE spaceuserid='{$spaceUserID}' {$_strWhereStmt}");
	if( $_arrReturnVal['RecordCount'] > 0 ){
		$_arrReturnVal['PageCount'] = ceil((float)$_arrReturnVal['RecordCount']/(float)$_arrReturnVal['PageSize']);
		if( $_arrReturnVal['AbsolutePage'] > $_arrReturnVal['PageCount'] ){
			$_arrReturnVal['AbsolutePage'] = $_arrReturnVal['PageCount'];
		}
		if( $_arrReturnVal['AbsolutePage'] < 1 ){
			$_arrReturnVal['AbsolutePage'] = 1;
		}
		$_arrReturnVal['ResultSet'] =& $db->getResultSet("SELECT postid,spaceuserid,catid,scatid,parentid,rootid,userid,username,title,content,jointime,ip,stype,isupfile FROM {$dv}space_post WHERE spaceuserid='{$spaceUserID}' {$_strWhereStmt} ORDER BY jointime DESC",array('absolutePage'=>$_arrReturnVal['AbsolutePage'],'pageSize'=>$_arrReturnVal['PageSize']));
	}
	return $_arrReturnVal;
}
?>