<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: public.inc.php 28 2014-01-29 03:12:01Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
if(!$auth[open_public_file]){
	exit;
}
switch($action){
	case 'add_cate':

		if($task =='add_cate'){
			form_auth(gpc('formhash','P',''),formhash());

			$cate_name = trim(gpc('cate_name','P',''));
			$pid = (int)gpc('pid','P',0);
			$is_hidden = (int)gpc('is_hidden','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($cate_name,1,60)){
				$error = true;
				$sysmsg[] = __('cate_name_error');
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}categories where cate_name='$cate_name'");
			if($rs['total']){
				$error = true;
				$sysmsg[] = __('cate_name_exists');
			}
			if(!$error){
				$ins = array(
				'cate_name' => $cate_name,
				'pid' => $pid,
				'is_hidden' => $is_hidden,
				);
				$db->query("insert into {$tpf}categories set ".$db->sql_array($ins).";");
				$sysmsg[] = __('cate_add_success');
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);

			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$q = $db->query("select * from {$tpf}categories where pid=0 order by show_order asc,cate_id asc");
			$cate_arr = array();
			while($rs = $db->fetch_array($q)){
				$cate_arr[] = $rs;
			}
			$db->free($q);
			unset($rs);
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'modify_cate':
		$cate_id = (int)gpc('cate_id','GP',0);

		if($task =='modify_cate'){
			form_auth(gpc('formhash','P',''),formhash());

			$cate_name = trim(gpc('cate_name','P',''));
			$pid = (int)gpc('pid','P',0);
			$is_hidden = (int)gpc('is_hidden','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($cate_name,1,60)){
				$error = true;
				$sysmsg[] = __('cate_name_error');
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}categories where cate_name='$cate_name' and cate_id<>'$cate_id'");
			if($rs['total']){
				$error = true;
				$sysmsg[] = __('cate_name_exists');
			}
			if(!$error){
				$ins = array(
				'cate_name' => $cate_name,
				'pid' => $pid,
				'is_hidden' => $is_hidden,
				);
				$db->query_unbuffered("update {$tpf}categories set ".$db->sql_array($ins)." where cate_id='$cate_id' and cate_id<>'$pid';");
				$sysmsg[] = __('cate_modify_success');
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);

			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$q = $db->query("select * from {$tpf}categories where pid=0 order by show_order asc,cate_id asc");
			$cate_arr = array();
			while($rs = $db->fetch_array($q)){
				$cate_arr[] = $rs;
			}
			$db->free($q);
			unset($rs);

			$rs = $db->fetch_one_array("select * from {$tpf}categories where cate_id='$cate_id'");
			if($rs){
				$cate_name = $rs['cate_name'];
				$pid = $rs['pid'];
				$is_hidden = $rs['is_hidden'];
			}
			unset($rs);
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'category':

		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$show_order = gpc('show_order','P',array());
			$cate_ids = gpc('cate_ids','P',array());
			$cate_names = gpc('cate_names','P',array());

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!$error){
				for($i =0;$i<count($cate_ids);$i++){
					$title = trim(replace_js($cate_names[$i]));
					if($title){
						$db->query_unbuffered("update {$tpf}categories set show_order='".(int)$show_order[$i]."',cate_name='$title' where cate_id='".(int)$cate_ids[$i]."'");
					}
				}
				redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),'',0);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$cate_tree = get_cate_tree();
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}

		break;

	case 'del_cate':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = __('online_demo_deny');
		}
		if(!$error){
			$cate_id = (int)gpc('cate_id','G',0);
			if($cate_id){
				$db->query_unbuffered("update {$tpf}files set is_del=0 where cate_id='$cate_id'");
				$db->query_unbuffered("delete from {$tpf}categories where cate_id='$cate_id'");
			}
			$sysmsg[] = __('del_cate_success');
			redirect(urr(ADMINCP,"item=$item&menu=file&action=category"),$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;

	case 'viewfile':
		$cate_id = (int)gpc('cate_id','GP','');
		if($task){
			$file_ids = gpc('file_ids','P',array());

			$ids_arr = get_ids_arr($file_ids,__('please_select_operation_files'));
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
		}
		if($task == 'check_file' || $task=='uncheck_file'){
			form_auth(gpc('formhash','P',''),formhash());

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!$error){
				if($task == 'check_file'){
					$db->query_unbuffered("update {$tpf}files set is_checked=1 where file_id in ($file_str)");
					$sysmsg[] = __('check_file_success');
				}else{
					$db->query_unbuffered("update {$tpf}files set cate_id=0,pub_time=0,is_checked=1 where file_id in ($file_str)");
					$sysmsg[] = '退回推送公共文件成功';
				}

				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}elseif($task == 'move_to'){
			form_auth(gpc('formhash','P',''),formhash());
			$to_cate_id = (int)gpc('to_cate_id','P',0);

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set cate_id='$to_cate_id' where file_id in ($file_str)");

				$sysmsg[] = '移动分类公共文件成功';
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			if($cate_id){
				if($cate_id==-1){
					$sql_ext = " {$tpf}files f,{$tpf}users u,{$tpf}categories c where f.is_checked=0 and f.userid=u.userid and c.cate_id=f.cate_id";
				}else{
					$sql_ext = " {$tpf}files f,{$tpf}users u,{$tpf}categories c where c.cate_id=$cate_id and f.userid=u.userid and c.cate_id=f.cate_id";
				}
				$db->query_unbuffered("update {$tpf}categories set cate_num=(select count(*) from {$tpf}files where cate_id='$cate_id') where cate_id='$cate_id'");
			}else{
				$sql_ext = " {$tpf}files f,{$tpf}users u,{$tpf}categories c where c.cate_id>0 and f.userid=u.userid and c.cate_id=f.cate_id";
			}
			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select f.*,u.username,c.cate_id,c.cate_name from {$sql_ext} order by pub_time desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
				$rs['pub_time'] = date("Y-m-d H:i:s",$rs['pub_time']);
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs[a_cate] = urr(ADMINCP,"item=public&menu=file&action=viewfile&cate_id=$rs[cate_id]");
				$rs['a_recycle_delete'] = urr(ADMINCP,"item=files&menu=file&action=recycle_delete&file_id={$rs['file_id']}");
				$rs['status_txt'] = $rs['is_checked'] ? '<span class="txtblue">'.__('checked').'</span>' : '<span class="txtred">'.__('unchecked').'</span>';
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=$item&menu=file&action=$action&cate_id=$cate_id"));
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	default:

		if($task == 'update'){
			form_auth(gpc('formhash','P',''),formhash());

			$setting = array(
			'open_public_file' => 0,
			);
			$settings = gpc('setting','P',$setting);

			if(!$error){

				settings_cache($settings);

				$sysmsg[] = __('public_update_success');
				redirect(urr(ADMINCP,"item=$item&menu=file"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$setting = $settings;			

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}

}
function get_cate_tree($pid=0,$lv=0){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}categories order by show_order asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '<tr>'.LF;
		foreach($data as $v){
			if($v['pid'] == $pid){
				$a_modify = urr(ADMINCP,"item=public&menu=file&action=modify_cate&cate_id={$v['cate_id']}");
				$a_cate_href = urr("public","cate_id={$v['cate_id']}");
				$a_del_cate = urr(ADMINCP,"item=public&menu=file&action=del_cate&cate_id={$v['cate_id']}");

				$html .= "<td>".LF;
				$html .= '<input type="text" name="show_order[]" value="'.$v['show_order'].'" style="width:20px; text-align:center" maxlength="2" />'.LF;
				$html .= '<input type="hidden" name="cate_ids[]" value="'.$v['cate_id'].'" />'.LF;
				$html .= str_repeat('&nbsp;',$lv*4).'<input type="text" name="cate_names[]" size="30" value="'.$v['cate_name'].'" /></td>'.LF;
				$html .= '	<td align="center">';
				$html .= '	<a href="'.$a_cate_href.'" target="_blank">'.$v[cate_num].'</a>';
				$html .= '	</td>'.LF;
				$html .= '	<td align="right">';
				$html .= '	<a href="'.$a_modify.'">'.__('modify').'</a>&nbsp;';
				$html .= '	<a href="javascript:;" onclick="aconfirm(\''.__('del_category_confirm').'\',\''.$a_del_cate.'\');">'.__('delete').'</a></td>'.LF;
				$lv++;
				$html .= get_cate_tree($v['cate_id'],$lv);
				$lv--;
			}
		}
		$html .= '</tr>'.LF;
		return $html;
	}else{
		return '';
	}
}

?>