<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: dl.php 64 2016-07-30 14:01:18Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/
error_reporting(0);
if(strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
	define('OS_WIN',true);
	define('LF',"\r\n");
}else{
	define('OS_WIN',false);
	define('LF',"\n");
}
define('PHPDISK_ROOT', dirname(__FILE__).'/');
require_once(PHPDISK_ROOT.'system/settings.inc.php');
define('SERVER_KEY',$settings['encrypt_key']);
define('FILE_PATH',$settings['file_path']);
define('IN_PHPDISK',TRUE);

@set_time_limit(0);
@ignore_user_abort(true);
@set_magic_quotes_runtime(0);

function check_ref(){
	global $settings;
	$arr = explode('/',$_SERVER['HTTP_REFERER']);
	$arr2 = explode('/',$settings['phpdisk_url']);
	if($_SERVER['HTTP_HOST']!='localhost'){
		if(!$_SERVER['HTTP_REFERER'] || $arr[2]!=$arr2[2]){
			header('Location: '.$settings['phpdisk_url']);
			exit;
		}
	}
}
//check_ref();

function pd_encode($string, $operation = 'ENCODE',$key = ''){
	global $settings;
	$ckey_length = 4;
	$key = md5($key ? $key : ($settings['encrypt_key'] ? $settings['encrypt_key'] : 'PHPDisk=Rc9o'));

	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d',0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);
	$result = '';
	$arr = range(0, 255);
	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}
	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $arr[$i] + $rndkey[$i]) % 256;
		$tmp = $arr[$i];
		$arr[$i] = $arr[$j];
		$arr[$j] = $tmp;
	}
	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $arr[$a]) % 256;
		$tmp = $arr[$a];
		$arr[$a] = $arr[$j];
		$arr[$j] = $tmp;

		$result .= chr(ord($string[$i]) ^ ($arr[($arr[$a] + $arr[$j]) % 256]));
	}
	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {

		return $keyc.str_replace('=', '', base64_encode($result));
	}
}
function filter_name($str){
	return str_ireplace(array(' ','&amp;','・'),'_',$str);
}
function get_real_ext($file_extension){
	if($file_extension){
		$exts = explode(',','asp,asa,aspx,ascx,dtd,xsd,xsl,xslt,as,wml,java,vtm,vtml,jst,asr,php,php3,php4,php5,vb,vbs,jsf,jsp,pl,cgi,js,html,htm,xhtml,xml,css,shtm,cfm,cfml,shtml,bat,sh,lock');
		if(in_array($file_extension,$exts)){
			$file_ext = '.txt';
		}
	}else{
		$file_ext = '.txt';
	}
	return $file_ext;
}
function get_extension($name){
	return strtolower(trim(strrchr($name, '.'), '.'));
}

$str = $_SERVER['QUERY_STRING'];

parse_str(pd_encode($str,'DECODE'));
$pp = $pp.get_real_ext(get_extension($pp));
if(!file_exists(PHPDISK_ROOT.FILE_PATH.'/'.$pp)){
	header("Content-Type: text/html; charset=utf-8");
	echo '<p style="padding:10px; font-size:12px;">文件ID： '.$file_id.'<br>';
	echo '['.$file_name.'] 文件不存在，请联系网站管理员处理。<br><br>';
	echo '联系方式：'.$settings['contact_us'].'</p>';
}else{
	$file_name = filter_name(str_replace("+", "%20",$file_name));

	ob_end_clean();
	$ua = $_SERVER["HTTP_USER_AGENT"];
	if(preg_match("/MSIE/i", $ua)){
		//header('Content-disposition: attachment;filename="'.rawurlencode(str_replace("+", "%20",$file_name)).'"');
		header('Content-disposition: attachment;filename="'.iconv('utf-8','gbk',$file_name).'"');
	}else{
		header('Content-disposition: attachment;filename="'.$file_name.'"');
	}
	//header('Connection: close');
	header('Content-type: application/octet-stream');
	if($settings['open_xsendfile']==2){
		header('X-Accel-Redirect: /'.FILE_PATH.'/'.$pp);
	}elseif($settings['open_xsendfile']==1){
		header('X-sendfile: ./'.FILE_PATH.'/'.$pp);
	}else{
		header('Content-Encoding: none');
		header('Content-Transfer-Encoding: binary');
		header('Content-length: '.$fs);
		@readfile('./'.FILE_PATH.'/'.$pp);
	}
}
exit;
?>