<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: share.inc.php 64 2016-07-30 14:01:18Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}
$nav_tit = array(
'buddy_folders'=>'好友',
'corp_folders'=>'公司',
'depart_folders'=>'部门',
'other_depart_folders'=>'其他部门',
'buddy_files'=>'好友',
'corp_files'=>'公司',
'depart_files'=>'部门',
'other_depart_files'=>'其他部门',
);

switch($action){
	case 'buddy_folders':
	case 'corp_folders':
	case 'depart_folders':
	case 'other_depart_folders':
		$tmp_action = array('buddy_folders'=>'buddy','corp_folders'=>'corp','depart_folders'=>'depart','other_depart_folders'=>'other_depart');
		$folder_id = (int)gpc('folder_id','G',0);

		if(!$folder_id){
			if($action=='corp_folders'){
				$q = $db->query("select fd.* from {$tpf}folders fd,{$tpf}shares s where fd.folder_id=s.share_fid and s.userid='$pd_uid' and is_file=0 and depart_id=-1 group by share_fid order by fd.folder_id asc");
			}elseif($action=='depart_folders'){
				$q = $db->query("select fd.* from {$tpf}folders fd,{$tpf}shares s where fd.folder_id=s.share_fid and s.userid='$pd_uid' and is_file=0 and depart_id='$pd_depart_id' and depart_id>0 group by share_fid order by fd.folder_id asc");
			}elseif($action=='other_depart_folders'){
				$q = $db->query("select fd.* from {$tpf}folders fd,{$tpf}shares s where fd.folder_id=s.share_fid and s.userid='$pd_uid' and is_file=0 and depart_id>0 and depart_id<>'$pd_depart_id' group by share_fid order by fd.folder_id asc");
			}else{
				$q = $db->query("select fd.* from {$tpf}folders fd,{$tpf}shares s where fd.folder_id=s.share_fid and s.userid='$pd_uid' and is_file=0 and s.touserid>0 group by share_fid order by fd.folder_id asc");
			}

			$folders = array();
			while ($rs = $db->fetch_array($q)) {
				$rs[folder_size] = get_size($rs[folder_size]);
				$rs[in_time] = date('Y-m-d H:i:s',$rs[in_time]);
				$rs[a_folder] = urr("mydisk","item=share&menu=$menu&action=$action&folder_id={$rs[folder_id]}");
				$rs['a_folder_unshare'] = urr("mydisk","item=share&action=unshare_folder&sel_type={$tmp_action[$action]}&folder_id={$rs['folder_id']}");
				$folders[] = $rs;
			}
			$db->free($q);
			unset($rs);

		}else{
			$fd_sql = $folder_id ? " and folder_id='$folder_id'" : '';
			$q = $db->query("select * from {$tpf}files where 1 $fd_sql and userid='$pd_uid' and is_del=0 order by file_id desc ");
			$files = array();
			while ($rs = $db->fetch_array($q)) {
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);

				$rs['file_name'] = $rs['file_name'].$tmp_ext;
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_description'] = cutstr($rs['file_description'],80);
				$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
				$rs['a_downfile'] = urr("downfile","file_id={$rs['file_id']}&file_key={$rs['file_key']}");
				$rs['a_viewfile'] = urr("mydisk","item=files&action=download&file_id={$rs['file_id']}");
				$rs['a_file_unshare'] = urr("mydisk","item=share&action=unshare_file&sel_type={$tmp_action[$action]}&file_id={$rs['file_id']}");
				$files[] = $rs;
			}
			$db->free($q);
			unset($rs);
		}
		require_once template_echo('share',$user_tpl_dir);
		break;

	case 'buddy_files':
	case 'corp_files':
	case 'depart_files':
	case 'other_depart_files':
		$tmp_action = array('buddy_files'=>'buddy','corp_files'=>'corp','depart_files'=>'depart','other_depart_files'=>'other_depart');
		$folder_id = (int)gpc('folder_id','G',0);

		$fd_sql = $folder_id ? " and folder_id='$folder_id'" : '';

		$perpage = 20;
		if($action=='corp_files'){
			$sql_do = " {$tpf}files f,{$tpf}shares s where f.file_id=s.share_fid and is_file=1 $fd_sql and s.userid='$pd_uid' and depart_id=-1 and is_del=0 group by share_fid";
		}elseif($action=='depart_files'){
			$sql_do = " {$tpf}files f,{$tpf}shares s where f.file_id=s.share_fid and is_file=1 $fd_sql and s.userid='$pd_uid' and depart_id>0 and depart_id='$pd_depart_id' and is_del=0 group by share_fid";
		}elseif($action=='other_depart_files'){
			$sql_do = " {$tpf}files f,{$tpf}shares s where f.file_id=s.share_fid and is_file=1 $fd_sql and s.userid='$pd_uid' and depart_id>0 and depart_id<>'$pd_depart_id' and is_del=0 group by share_fid";
		}else{
			$sql_do = " {$tpf}files f,{$tpf}shares s where f.file_id=s.share_fid and is_file=1 $fd_sql and s.userid='$pd_uid' and s.touserid>0 and is_del=0 group by share_fid";
		}
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select f.* from $sql_do order by file_id desc limit $start_num,$perpage");
		$files = array();
		while ($rs = $db->fetch_array($q)) {
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs['file_thumb'] = get_file_thumb($rs);

			$rs['file_name'] = $rs['file_name'].$tmp_ext;
			$rs['file_size'] = get_size($rs['file_size']);
			$rs['file_description'] = cutstr($rs['file_description'],80);
			$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
			$rs['a_viewfile'] = urr("mydisk","item=files&action=download&file_id={$rs['file_id']}");
			$rs['a_file_unshare'] = urr("mydisk","item=share&action=unshare_file&sel_type={$tmp_action[$action]}&file_id={$rs['file_id']}");
			$files[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=share&menu=$menu&action=$action"));

		require_once template_echo('share',$user_tpl_dir);
		break;
	case 'cancle_public_file2':
		if(!get_group_power($pd_gid,'cancle_public_file',1) || !$settings[open_public_file]){
			tb_redirect('','您的帐号没有【取消公共文件共享】权限或系统功能未开启',0);
			exit;
		}
		$file_id = (int)gpc('file_id','G',0);
		$file_id && $db->query_unbuffered("update {$tpf}files set cate_id='0',is_checked=1,pub_time=0 where file_id='$file_id' and userid='$pd_uid'");
		$sysmsg[] = '取消文件公共共享成功';
		redirect('back',$sysmsg);
		break;
	case 'cancle_public_file':
		$file_ids = trim(gpc('file_ids','GP',''));
		if(!$file_ids || !preg_match("/^[0-9,]/",$file_ids)){
			exit('Error ');
		}else{
			$file_ids = substr($file_ids,-1)==',' ? substr($file_ids,0,-1) : $file_ids;
		}
		if(!get_group_power($pd_gid,'cancle_public_file',1) || !$settings[open_public_file]){
			tb_redirect('','您的帐号没有【取消公共文件共享】权限或系统功能未开启',0);
			exit;
		}
		if($task=='cancle_public_file'){
			form_auth(gpc('formhash','P',''),formhash());
			$ref = gpc('ref','P','');

			if(!$file_ids){
				$error = true;
				$sysmsg[] = 'ID错误';
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set cate_id='0',is_checked=1,pub_time=0 where file_id in ($file_ids) and userid='$pd_uid'");
				$sysmsg[] = '取消文件公共共享成功';
				tb_redirect(str_replace('&amp;','&',$ref),$sysmsg);
			}else{
				tb_redirect('back',$sysmsg);
			}
		}else{
			if($file_ids){
				$q = $db->query("select file_name,file_extension,file_id from {$tpf}files where file_id in ($file_ids) and is_del=0 order by file_id desc");
				$file_arr = array();
				while($rs = $db->fetch_array($q)){
					$rs[file_name] = get_file_name($rs[file_name],$rs[file_extension]);
					$file_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
			}
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;
	case 'public_file':
		$file_ids = trim(gpc('file_ids','GP',''));
		if(!$file_ids || !preg_match("/^[0-9,]/",$file_ids)){
			exit('Error ');
		}else{
			$file_ids = substr($file_ids,-1)==',' ? substr($file_ids,0,-1) : $file_ids;
		}
		if(!get_group_power($pd_gid,'can_public_file',1) || !$settings[open_public_file]){
			tb_redirect('','您的帐号没有【允许发布公共共享】权限或系统功能未开启',0);
			exit;
		}
		if($task=='public_file'){
			form_auth(gpc('formhash','P',''),formhash());
			$ref = gpc('ref','P','');
			$cate_id = (int)gpc('cate_id','P',0);

			if(!$cate_id){
				$error = true;
				$sysmsg[] = '请选择文件分类';
			}
			if(!$file_ids){
				$error = true;
				$sysmsg[] = 'ID错误';
			}
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set cate_id='$cate_id',is_checked=0,pub_time='$timestamp' where file_id in ($file_ids) and userid='$pd_uid'");
				$sysmsg[] = '设置公共共享成功';
				tb_redirect(str_replace('&amp;','&',$ref),$sysmsg);
			}else{
				tb_redirect('back',$sysmsg);
			}
		}else{
			if($file_ids){
				$q = $db->query("select file_name,file_extension,file_id from {$tpf}files where file_id in ($file_ids) and is_del=0 order by file_id desc");
				$file_arr = array();
				while($rs = $db->fetch_array($q)){
					$rs[file_name] = get_file_name($rs[file_name],$rs[file_extension]);
					$file_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
			}
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;
	case 'share_file':
		$sel_type = trim(gpc('sel_type','GP',''));
		$file_ids = trim(gpc('file_ids','GP',''));
		if(!$file_ids || !preg_match("/^[0-9,]/",$file_ids)){
			exit('Error ');
		}else{
			$file_ids = substr($file_ids,-1)==',' ? substr($file_ids,0,-1) : $file_ids;
		}
		if(!get_group_power($pd_gid,'can_share_file_to_corp',1) && $sel_type=='corp'){
			tb_redirect('','您的帐号没有【允许共享文件给公司】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_file_to_depart',1) && $sel_type=='depart'){
			tb_redirect('','您的帐号没有【允许共享文件给自己部门】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_file_to_other_depart',1) && $sel_type=='other_depart'){
			tb_redirect('','您的帐号没有【允许共享文件给其他部门】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_folder_to_buddy',1) && $sel_type=='buddy'){
			tb_redirect('','您的帐号没有【允许共享文件给好友】权限',0);
			exit;
		}
		if($task=='share_file'){
			form_auth(gpc('formhash','P',''),formhash());
			$ref = gpc('ref','P','');

			if($sel_type=='buddy'){
				$touserids = gpc('touserids','P',array());
				if(!count($touserids)){
					$error = true;
					$sysmsg[] = '请选择接收文件的用户。';
				}
			}elseif($sel_type=='depart'){
				if(!$pd_depart_id){
					$error = true;
					$sysmsg[] = '您的帐号暂时没有部门，无法指定文件部门共享';
				}
			}elseif($sel_type=='other_depart'){
				$depart_ids = gpc('depart_ids','P',array());
				if(!count($depart_ids)){
					$error = true;
					$sysmsg[] = '请选择接收文件的部门。';
				}
			}
			if(!$file_ids){
				$error = true;
				$sysmsg[] = 'ID错误';
			}
			if(!$error){
				$ins = '';
				if($sel_type=='corp'){
					$arr = explode(',',$file_ids);
					for($j=0;$j<count($arr);$j++){
						$num = @$db->result_first("select count(*) from {$tpf}shares where userid='$pd_uid' and depart_id=-1 and share_fid='{$arr[$j]}' and is_file=1 limit 1");
						if(!$num){
							$ins .= "('$pd_uid',-1,'{$arr[$j]}',1,'$timestamp'),";
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");

				}elseif($sel_type=='depart'){
					$arr = explode(',',$file_ids);
					for($j=0;$j<count($arr);$j++){
						$num = @$db->result_first("select count(*) from {$tpf}shares where userid='$pd_uid' and depart_id='$pd_depart_id' and share_fid='{$arr[$j]}' and is_file=1 limit 1");
						if(!$num){
							$ins .= "('$pd_uid','$pd_depart_id','{$arr[$j]}',1,'$timestamp'),";
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");

				}elseif($sel_type=='other_depart'){
					for ($i=0;$i<count($depart_ids);$i++){
						$arr = explode(',',$file_ids);
						for($j=0;$j<count($arr);$j++){
							$num = @$db->result_first("select count(*) from {$tpf}shares where depart_id='{$depart_ids[$i]}' and share_fid='{$arr[$j]}' and is_file=1 limit 1");
							if(!$num){
								$ins .= "('$pd_uid','{$depart_ids[$i]}','{$arr[$j]}',1,'$timestamp'),";
							}
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");
				}else{
					for ($i=0;$i<count($touserids);$i++){
						$arr = explode(',',$file_ids);
						for($j=0;$j<count($arr);$j++){
							$num = @$db->result_first("select count(*) from {$tpf}shares where touserid='{$touserids[$i]}' and share_fid='{$arr[$j]}' and is_file=1 limit 1");
							if(!$num){
								$ins .= "('$pd_uid','{$touserids[$i]}','{$arr[$j]}',1,'$timestamp'),";
							}
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,touserid,share_fid,is_file,in_time) values $ins;");
				}
				$ins && $db->query_unbuffered("update {$tpf}files set in_share=1 where file_id in ($file_ids)");
				$sysmsg[] = '共享文件成功';
				tb_redirect(str_replace('&amp;','&',$ref),$sysmsg);
			}else{
				tb_redirect('back',$sysmsg);
			}
		}else{
			if($sel_type=='buddy'){
				$q = $db->query("select b.*,u.username from {$tpf}buddys b, {$tpf}users u where b.userid='$pd_uid' and b.touserid=u.userid order by bdid desc");
				$buddys_arr = array();
				while($rs = $db->fetch_array($q)){
					$buddys_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
			}
			if($file_ids){
				$q = $db->query("select file_name,file_extension,file_id from {$tpf}files where file_id in ($file_ids) and is_del=0 order by file_id desc");
				$file_arr = array();
				while($rs = $db->fetch_array($q)){
					$rs[file_name] = get_file_name($rs[file_name],$rs[file_extension]);
					$file_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
			}
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;
	case 'share_folder':

		$sel_type = trim(gpc('sel_type','GP',''));

		if(!get_group_power($pd_gid,'can_share_folder_to_corp',1) && $sel_type=='corp'){
			tb_redirect('','您的帐号没有【允许共享文件夹给公司】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_folder_to_depart',1) && $sel_type=='depart'){
			tb_redirect('','您的帐号没有【允许共享文件夹给自己部门】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_folder_to_other_depart',1) && $sel_type=='other_depart'){
			tb_redirect('','您的帐号没有【允许共享文件夹给其他部门】权限',0);
			exit;
		}elseif(!get_group_power($pd_gid,'can_share_folder_to_buddy',1) && $sel_type=='buddy'){
			tb_redirect('','您的帐号没有【允许共享文件夹给好友】权限',0);
			exit;
		}
		if($task=='share_folder'){
			form_auth(gpc('formhash','P',''),formhash());
			$ref = gpc('ref','P','');
			$folder_ids = gpc('folder_ids','P',array());

			$ids_arr = get_ids_arr($folder_ids,'请选择需要共享的目录',1);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}

			if($sel_type=='buddy'){
				$touserids = gpc('touserids','P',array());
				if(!count($touserids)){
					$error = true;
					$sysmsg[] = '请选择接收文件夹的用户。';
				}
			}elseif($sel_type=='depart'){
				if(!$pd_depart_id){
					$error = true;
					$sysmsg[] = '您的帐号暂时没有部门，无法指定文件部门共享';
				}
			}elseif($sel_type=='other_depart'){
				$depart_ids = gpc('depart_ids','P',array());
				if(!count($depart_ids)){
					$error = true;
					$sysmsg[] = '请选择接收文件的部门。';
				}
			}
			if(!$error){
				$ins = '';
				if($sel_type=='corp'){
					$arr = explode(',',$file_str);
					for($j=0;$j<count($arr);$j++){
						$num = @$db->result_first("select count(*) from {$tpf}shares where userid='$pd_uid' and depart_id=-1 and share_fid='{$arr[$j]}' and is_file=0 limit 1");
						if(!$num){
							$ins .= "('$pd_uid',-1,'{$arr[$j]}',0,'$timestamp'),";
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");
				}elseif($sel_type=='depart'){
					$arr = explode(',',$file_str);
					for($j=0;$j<count($arr);$j++){
						$num = @$db->result_first("select count(*) from {$tpf}shares where userid='$pd_uid' and depart_id='$pd_depart_id' and share_fid='{$arr[$j]}' and is_file=0 limit 1");
						if(!$num){
							$ins .= "('$pd_uid','$pd_depart_id','{$arr[$j]}',0,'$timestamp'),";
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");
				}elseif($sel_type=='other_depart'){
					for ($i=0;$i<count($depart_ids);$i++){
						$arr = explode(',',$file_str);
						for($j=0;$j<count($arr);$j++){
							$num = @$db->result_first("select count(*) from {$tpf}shares where depart_id='{$depart_ids[$i]}' and share_fid='{$arr[$j]}' and is_file=0 limit 1");
							if(!$num){
								$ins .= "('$pd_uid','{$depart_ids[$i]}','{$arr[$j]}',0,'$timestamp'),";
							}
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,depart_id,share_fid,is_file,in_time) values $ins;");
				}else{
					for ($i=0;$i<count($touserids);$i++){
						$arr = explode(',',$file_str);
						for($j=0;$j<count($arr);$j++){
							$num = @$db->result_first("select count(*) from {$tpf}shares where touserid='{$touserids[$i]}' and share_fid='{$arr[$j]}' and is_file=0 limit 1");
							if(!$num){
								$ins .= "('$pd_uid','{$touserids[$i]}','{$arr[$j]}',0,'$timestamp'),";
							}
						}
					}
					$ins = $ins ? substr($ins,0,-1) : '';
					$ins && $db->query_unbuffered("insert into {$tpf}shares(userid,touserid,share_fid,is_file,in_time) values $ins;");
				}
				$ins && $db->query_unbuffered("update {$tpf}folders set in_share=1 where folder_id in ($file_str)");
				$sysmsg[] = '共享文件夹成功';
				tb_redirect(str_replace('&amp;','&',$ref),$sysmsg);
			}else{
				tb_redirect('back',$sysmsg);
			}
		}else{
			if($sel_type=='buddy'){
				$q = $db->query("select b.*,u.username from {$tpf}buddys b, {$tpf}users u where b.userid='$pd_uid' and b.touserid=u.userid order by bdid desc");
				$buddys_arr = array();
				while($rs = $db->fetch_array($q)){
					$buddys_arr[] = $rs;
				}
				$db->free($q);
				unset($rs);
			}

			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;
	case 'unshare_file':
		$file_id = (int)gpc('file_id','GP',0);
		$sel_type = trim(gpc('sel_type','GP',''));

		if($task =='unshare_file'){
			form_auth(gpc('formhash','P',''),formhash());

			$ref = trim(gpc('ref','P',''));
			if($file_id){
				if($sel_type=='all'){
					$db->query_unbuffered("update {$tpf}files set in_share=0 where file_id='$file_id' and userid='$pd_uid'");
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$file_id' and is_file=1 and userid='$pd_uid'");
				}elseif($sel_type=='corp'){
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$file_id' and depart_id=-1 and is_file=1 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$file_id' and depart_id=-1 and is_file=1 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}files set in_share=0 where file_id='$file_id' and userid='$pd_uid'");
					}
				}elseif($sel_type=='depart'){
					if($pd_depart_id){
						$db->query_unbuffered("delete from {$tpf}shares where share_fid='$file_id' and depart_id='$pd_depart_id' and is_file=1 and userid='$pd_uid'");
						$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$file_id' and depart_id='$pd_depart_id' and is_file=1 and userid='$pd_uid'");
						if(!$num){
							$db->query_unbuffered("update {$tpf}files set in_share=0 where file_id='$file_id' and userid='$pd_uid'");
						}
					}else{
						exit('<script>alert("部门ID未指定");document.history.back();</script>');
					}
				}elseif($sel_type=='other_depart'){
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$file_id' and depart_id>0 and is_file=1 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$file_id' and depart_id>0 and is_file=1 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}files set in_share=0 where file_id='$file_id' and userid='$pd_uid'");
					}
				}else{
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$file_id' and is_file=1 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$file_id' and is_file=1 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}files set in_share=0 where file_id='$file_id' and userid='$pd_uid'");
					}
				}

				tb_redirect(str_replace('&amp;','&',$ref),__('unshare_file_success'));
			}else{
				tb_redirect('back','取消文件共享失败');
			}
		}else{
			$rs = $db->fetch_one_array("select file_name,file_extension from {$tpf}files where file_id='$file_id' and userid='$pd_uid' and is_del=0");
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$file_name = $rs['file_name'].$tmp_ext;
			$file_extension = $rs['file_extension'];
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;
	case 'unshare_folder':
		$folder_id = (int)gpc('folder_id','GP',0);
		$sel_type = trim(gpc('sel_type','GP',''));

		if($task =='unshare_folder'){
			form_auth(gpc('formhash','P',''),formhash());
			$ref = trim(gpc('ref','P',''));
			if($folder_id){
				if($sel_type=='corp'){
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$folder_id' and depart_id=-1 and is_file=0 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$folder_id' and depart_id=-1 and is_file=0 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}folders set in_share=0 where folder_id='$folder_id' and userid='$pd_uid'");
					}
				}elseif($sel_type=='depart'){
					if($pd_depart_id){
						$db->query_unbuffered("delete from {$tpf}shares where share_fid='$folder_id' and depart_id='$pd_depart_id' and is_file=0 and userid='$pd_uid'");
						$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$folder_id' and depart_id='$pd_depart_id' and is_file=0 and userid='$pd_uid'");
						if(!$num){
							$db->query_unbuffered("update {$tpf}folders set in_share=0 where folder_id='$folder_id' and userid='$pd_uid'");
						}
					}else{
						exit('<script>alert("部门ID未指定");document.history.back();</script>');
					}
				}elseif($sel_type=='other_depart'){
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$folder_id' and depart_id>0 and is_file=0 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$folder_id' and depart_id>0 and is_file=0 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}folders set in_share=0 where folder_id='$folder_id' and userid='$pd_uid'");
					}
				}else{
					$db->query_unbuffered("delete from {$tpf}shares where share_fid='$folder_id' and is_file=0 and userid='$pd_uid'");
					$num = @$db->result_first("select count(*) from {$tpf}shares where share_fid='$folder_id' and is_file=0 and userid='$pd_uid'");
					if(!$num){
						$db->query_unbuffered("update {$tpf}folders set in_share=0 where folder_id='$folder_id' and userid='$pd_uid'");
					}
				}
				tb_redirect(str_replace('&amp;','&',$ref),'取消共享目录成功');
			}else{
				tb_redirect('back','取消共享目录失败');
			}
		}else{
			$folder_name = @$db->result_first("select folder_name from {$tpf}folders where folder_id='$folder_id' and userid='$pd_uid'");
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('share',$user_tpl_dir);
		}
		break;

}
function get_folder_list($pid=-1,$lv=0){
	global $db,$tpf,$pd_uid;
	$q = $db->query("select folder_id,folder_name,parent_id from {$tpf}folders where userid='$pd_uid' and in_recycle=0 order by folder_order asc,folder_id asc ");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['parent_id'] == $pid){
				$html .= '<li><input type="checkbox" name="folder_ids[]" id="fd_'.$v[folder_id].'" value="'.$v[folder_id].'" />';
				$html .= str_repeat('&nbsp;',$lv*2).'<img src="images/folder.gif" align="absmiddle" border="0" />'.$v[folder_name].'<span class="txtgray" title="目录ID">('.$v[folder_id].')</span></li>'.LF;
				$lv++;
				$html .= get_folder_list($v['folder_id'],$lv);
				$lv--;
			}
		}
		return $html;
	}else{
		return '';
	}
}
?>