<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: upload.inc.php 64 2016-07-30 14:01:18Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

@set_time_limit(0);
$group_set = $group_settings[$pd_gid];
$upload_max = get_byte_value(ini_get('upload_max_filesize'));
$post_max = get_byte_value(ini_get('post_max_size'));
$settings_max = $settings['max_file_size'] ? get_byte_value($settings['max_file_size']) : 0;
$max_php_file_size = min($upload_max, $post_max);
$max_file_size_byte = ($settings_max && $settings_max <= $max_php_file_size) ? $settings_max : $max_php_file_size;
if($group_set['max_filesize']){
	$group_set_max_file_size = get_byte_value($group_set['max_filesize']);
	$max_file_size_byte = ($group_set_max_file_size >=$max_file_size_byte) ? $max_file_size_byte : $group_set_max_file_size;
}
$max_user_file_size = get_size($max_file_size_byte,'B',0);

$my_all_file = @$db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and is_del=0");
$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
$tmp_max_storage = $rs['user_store_space'] ? $rs['user_store_space'] : $group_set['max_storage'];
if($tmp_max_storage && $my_all_file >= get_byte_value($tmp_max_storage)){
	tb_redirect('',__('user_storage_exceeded'),0);
	exit;
}

$file_id = (int)gpc('file_id','GP',0);
$folder_id = (int)gpc('folder_id','G',0);
$uid = (int)gpc('uid','G',0);
$action = $action ? $action : 'doupload';


if(!get_group_power($pd_gid,'can_upload',1)){
	tb_redirect('','您的帐号没有上传权限',0);
	exit;
}

$upload_url = urr("mydisk","item=upload&folder_node=$folder_node&folder_id=$folder_id&uid=$pd_uid");
if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0)){
	$rs = $db->fetch_one_array("select server_host,server_key from {$tpf}servers where is_default=1 limit 1");
	if($rs){
		$token = md5($pd_uid.$folder_id.$rs['server_key'].$settings['encrypt_key']);
		$upload_url = $rs['server_host'].urr("mydisk","item=upload&folder_id=$folder_id&uid=$pd_uid&token=$token");
	}
	unset($rs);
}

/*$total = @$db->result_first("select count(*) from {$tpf}files where userid='$pd_uid'");
if($group_set['max_files'] && $total >= $group_set['max_files']){
tb_redirect('',__('user_files_exceeded'),0);
exit;
}*/
$folder_id = (int)gpc('folder_id','GP','');
$rs = $db->fetch_one_array("select user_file_types from {$tpf}users where userid='$pd_uid'");
if($group_set['group_file_types']){
	$arr = explode(',',trim($group_set['group_file_types']));
	for($i=0;$i<count($arr);$i++){
		$user_file_types .= '*.'.$arr[$i].';';
	}
}else{
	if($rs['user_file_types']){
		$arr = explode(',',trim($rs['user_file_types']));
		for($i=0;$i<count($arr);$i++){
			$user_file_types .= '*.'.$arr[$i].';';
		}
	}else{
		$user_file_types = '*.*';
	}
}
$token = md5(md5($pd_uid.'doupload'.$sess_id.$settings[encrypt_key]));

$sign = md5($pd_uid.$settings[encrypt_key].date('Ymd'));
if($settings['open_multi_server']){
	$rs = $db->fetch_one_array("select server_host,server_store_path,server_key from {$tpf}servers where server_id>1 order by is_default desc limit 1");
	if($rs){
		$h5_upload_url = $rs['server_host']."index.php?action=h5upload&uid=$pd_uid&folder_id=$folder_id&sign=$sign";
		$doupload_url = $rs['server_host']."rc_upload.php";
	}
	unset($rs);
}else{
	$h5_upload_url = urr("mydisk","item=h5upload&uid=$pd_uid&folder_id=$folder_id&sign=$sign");
	$doupload_url = "rc_upload.php";
}
$uid = $pd_uid;
require_once template_echo($item,$user_tpl_dir);



?>