<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: admin.inc.php 127 2014-03-17 08:20:36Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
phpdisk_core::admin_login();
switch($action){
	case 'setting':
		if($task=='setting'){
			form_auth(gpc('formhash','P',''),formhash());
			$settings = gpc('setting','P',$setting);

			if(substr($settings['ftp_path'],-1)!='/'){
				$error = true;
				$sysmsg[] = 'FTP根目录需要以 / 结尾。';
			}
			if(!$error){
				settings_cache($settings);
				$sysmsg[] = 'FTP上传参数配置成功';
				redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=phpdisk_ftp&action=$action"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			require_once template_echo('admin','',$app);
		}
		break;
	case 'bat_update_ftp_port':
		$port = (int)gpc('port','G',0);
		if(!$port || $port >65535){
			$error = true;
			$sysmsg[] = 'FTP端口范围只能是1-65535之间';
		}
		if(!$error){
			$ins = array(
			'ftp_port'=>$port,
			);
			$db->query_unbuffered("update {$tpf}ftp set ".$db->sql_array($ins));
			$sysmsg[] = '批量更新FTP端口成功';
			redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=phpdisk_ftp&action=active_ftp"),$sysmsg);
		}else{
			redirect('back',$sysmsg);
		}
		break;
	case 'bat_update_ftp':
		/*if($settings['open_multi_server']){
			$server_host = @$db->result_first("select server_host from {$tpf}servers where server_id>1 order by is_default desc limit 1");
			$arr = explode('/',$server_host);
			$ftp_host = $arr[2];
			$file_host = $server_host;
		}else{
			$arr = explode('/',$settings[phpdisk_url]);
			$ftp_host = $arr[2];
			$file_host = $settings[phpdisk_url];
		}*/
		$ins = array(
		'ftp_host'=>$db->escape(trim($settings[ftp_host])),
		'file_host'=>$db->escape(trim($settings[file_host])),
		'server_oid'=>(int)$settings[ftp_server_oid],
		);
		$db->query_unbuffered("update {$tpf}ftp set ".$db->sql_array($ins));
		$sysmsg[] = '批量更新FTP主机、文件入库地址成功';
		redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=phpdisk_ftp&action=active_ftp"),$sysmsg);
		break;

/*	case 'del_ftp':
		$uid = (int)gpc('uid','GP','');
		if(!$uid){
			exit('uid error!');
		}
		$db->query_unbuffered("delete from {$tpf}ftp where userid='$uid'");
		$sysmsg[] = '用户FTP信息删除成功';
		redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=phpdisk_ftp&action=active_ftp"),$sysmsg);
		break;*/
	case 'edit_ftp':
		$uid = (int)gpc('uid','GP','');
		if(!$uid){
			exit('uid error!');
		}
		$has_ftp = @$db->result_first("select count(*) from {$tpf}ftp where userid='$uid'");
		if($task=='edit_ftp'){
			form_auth(gpc('formhash','P',''),formhash());
			$ftp_host = trim(gpc('ftp_host','P',''));
			$ftp_user = trim(gpc('ftp_user','P',''));
			$ftp_pwd = trim(gpc('ftp_pwd','P',''));
			$ftp_port = (int)gpc('ftp_port','P','');
			$ftp_path = trim(gpc('ftp_path','P',''));
			$file_host = trim(gpc('file_host','P',''));
			$ftp_locked = (int)gpc('ftp_locked','P','');
			$server_oid = (int)gpc('server_oid','P','');

			if(!$ftp_host || !$ftp_user ||!$ftp_pwd||!$ftp_port||!$ftp_path||!$file_host){
				$error = true;
				$sysmsg[] = '所有项目均不能为空';
			}
			if(!preg_match('/^[a-z0-9]*$/i',$ftp_user)){
				$error = true;
				$sysmsg[] = 'FTP用户只支持英文和数字';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}ftp where ftp_user='$ftp_user' and userid<>'$uid' limit 1");
				if($num){
					$error = true;
					$sysmsg[] = '此FTP用户名已存在，请重新修改';
				}
			}
			if(!preg_match('/^[a-z0-9]*$/i',$ftp_pwd)){
				$error = true;
				$sysmsg[] = 'FTP密码只支持英文和数字';
			}
			if($ftp_path){
				$num = @$db->result_first("select count(*) from {$tpf}ftp where ftp_path='$ftp_path' and userid<>'$uid' limit 1");
				if($num){
					$error = true;
					$sysmsg[] = '此FTP对应目录已存在，每个用户目录不能相同，请重新修改';
				}elseif(substr($ftp_path,-1)!='/' && substr($ftp_path,-1)!='\\'){
					$error = true;
					$sysmsg[] = 'FTP对应目录需要以\\或/结尾';
				}
			}
			if(substr($file_host,-1)!='/'){
				$error = true;
				$sysmsg[] = 'FTP文件管理主机需要以/结尾';
			}
			if(!$error){
				$ins = array(
				'ftp_host'=>$ftp_host,
				'ftp_user'=>$ftp_user,
				'ftp_pwd'=>$ftp_pwd,
				'ftp_port'=>$ftp_port,
				'ftp_path'=>$ftp_path,
				'file_host'=>$file_host,
				'ftp_locked'=>$ftp_locked,
				'server_oid'=>$server_oid,
				);
				if(!$has_ftp){
					$db->query_unbuffered("insert into {$tpf}ftp set userid='$uid'");
				}
				$db->query_unbuffered("update {$tpf}ftp set ".$db->sql_array($ins)." where userid='$uid'");
				$sysmsg[] = '用户FTP信息更新成功';
				redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=phpdisk_ftp&action=active_ftp"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}

		}else{
			$ps = $db->fetch_one_array("select * from {$tpf}ftp where userid='$uid' limit 1");
			if(!$ps){
				$ps[ftp_port] = $ps[ftp_port] ? (int)$ps[ftp_port] : 21;
				$ps[ftp_user] = $ps[ftp_user] ? trim($ps[ftp_user]) : get_profile($uid,'username');

				if($settings['open_multi_server']){
					$server_host = $db->result_first("select server_host from {$tpf}servers where server_id>1 order by is_default desc limit 1");
					$arr = explode('/',$server_host);
					$ps[ftp_host] = $arr[2];
					$ps[file_host] = $server_host;
				}
			}
			require_once template_echo('admin','',$app);
		}
		break;
	case 'active_ftp':
		if($task=='search'){
			$word = trim(gpc('word','G',''));
			$o_type = trim(gpc('o_type','G',''));
			$word_str = str_replace('　',' ',replace_inject_str($word));
			$sql_keyword = " and u.{$o_type} like '%{$word_str}%'";
		}else{
			$sql_keyword = '';
		}
		$perpage = 30;
		$gid = (int)gpc('gid','G',0);
		$orderby = gpc('orderby','G','');
		$sql_str = "";
		switch($orderby){
			case 'time_desc':
				$sql_orderby = " order by userid desc";
				break;
			case 'time_asc':
				$sql_orderby = " order by reg_time asc";
				break;
			case 'is_locked':
				$sql_orderby = $sql_str = " and u.is_locked=1";
				break;
			default:
				if(substr($orderby,0,6)=='credit' || substr($orderby,0,7)=='mydowns'){
					$arr = explode('_',$orderby);
					$sql_orderby = " order by $arr[0] $arr[1]";
				}elseif(substr($orderby,0,10)=='used_space'){
					$arr = explode('_',$orderby);
					$sql_orderby = " order by $arr[0]_$arr[1] $arr[2]";
				}else{
					$sql_orderby = " order by userid asc";
				}
				//echo $sql_orderby;
		}
		$sql_ext = $gid ? " and u.gid='$gid'" : "";
		$sql_do = " {$tpf}ftp f,{$tpf}users u,{$tpf}servers s where f.userid=u.userid and f.server_oid=s.server_oid {$sql_ext} $sql_keyword";

		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do} {$sql_str}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select f.*,u.username,s.server_name from {$sql_do} {$sql_orderby} limit $start_num ,$perpage");
		$users = array();
		while($rs = $db->fetch_array($q)){
			$rs[last_time] = $rs[last_time] ? date('Y-m-d H:i:s',$rs[last_time]) : '-';
			$rs['a_user_edit'] = urr(ADMINCP,"item=users&menu=user&action=user_edit&uid={$rs['userid']}");
			$rs['a_user_ftp'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=edit_ftp&uid={$rs['userid']}");
			//$rs['a_del_ftp'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=del_ftp&uid={$rs['userid']}");
			$hash = md5(md5($_SERVER['HTTP_USER_AGENT'].'view'.$onlineip.$rs['userid'].$settings[encrypt_key]));
			$hash2 = md5(md5($_SERVER['HTTP_USER_AGENT'].'del_ftp'.$onlineip.$rs['userid'].$settings[encrypt_key]));
			$hash3 = md5(md5($_SERVER['HTTP_USER_AGENT'].'open_ftp'.$onlineip.$rs['userid'].$settings[encrypt_key]));
			$rs['a_import'] = $rs[file_host].'plugins/phpdisk_ftp/import.php?param='.rawurlencode(pd_encode("uid={$rs['userid']}&job=view&username=$rs[username]&hash=$hash"));
			$rs['a_del_ftp'] = $rs[file_host].'plugins/phpdisk_ftp/import.php?param='.rawurlencode(pd_encode("uid={$rs['userid']}&job=del_ftp&username=$rs[username]&hash=$hash2"));
			$rs['a_open_ftp'] = $rs[file_host].'plugins/phpdisk_ftp/import.php?param='.rawurlencode(pd_encode("uid={$rs['userid']}&job=open_ftp&username=$rs[username]&hash=$hash3"));
			$users[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$q = $db->query("select gid,group_name,group_type from {$tpf}groups order by gid asc");
		$groups = array();
		while($rs = $db->fetch_array($q)){
			$rs['txtcolor'] = $rs['group_type'] ? 'txtblue' : '';
			$groups[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action&task=$task&gid=$gid&orderby=$orderby"));
		require_once template_echo('admin','',$app);
		break;
	case 'ftp_log':
		if($task=='del_log_all'){
			$db->query_unbuffered("truncate table {$tpf}ftp_log");
			$sysmsg[] = 'FTP记录清空成功';
			redirect(urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action"),$sysmsg);
		}elseif($task=='del_log'){
			$ids = gpc('ids','P',array(''));
			$ids_arr = get_ids_arr($ids,'请选择需要操作的FTP上传记录',1);
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$id_str = $ids_arr[1];
			}

			if(!$error){
				$id_str && $db->query_unbuffered("delete from {$tpf}ftp_log where id in ($id_str)");
				$sysmsg[] = 'FTP记录删除成功';
				redirect(urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$perpage = 30;

			$sql_do = " {$tpf}ftp_log f,{$tpf}users u where f.userid=u.userid";

			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select f.*,u.username from {$sql_do} order by id desc limit $start_num ,$perpage");
			$logs = array();
			while($rs = $db->fetch_array($q)){
				//$rs[file_name] = '<span class="txtblue">'.$rs[ftp_path].'</span>'.$rs[file_name];
				$rs[start_time] = date('Y-m-d H:i:s',$rs[start_time]);
				$rs[file_size] = get_size($rs[file_size],'B',1);
				$rs[done_time] = $rs[done_time] ? date('Y-m-d H:i:s',$rs[done_time]) : '-';
				$rs['a_del_log'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=del_log&id={$rs['id']}");
				$logs[] = $rs;
			}
			$db->free($q);
			unset($rs);

			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action"));
			require_once template_echo('admin','',$app);
		}
		break;
	case 'search':
	default:
		if($task=='search'){
			$word = trim(gpc('word','G',''));
			$o_type = trim(gpc('o_type','G',''));
			$word_str = str_replace('　',' ',replace_inject_str($word));
			$sql_keyword = " and u.{$o_type} like '%{$word_str}%'";
		}else{
			$sql_keyword = '';
		}
		$perpage = 30;
		$gid = (int)gpc('gid','G',0);
		$orderby = gpc('orderby','G','');
		$sql_str = "";
		switch($orderby){
			case 'time_desc':
				$sql_orderby = " order by userid desc";
				break;
			case 'time_asc':
				$sql_orderby = " order by reg_time asc";
				break;
			case 'is_locked':
				$sql_orderby = $sql_str = " and u.is_locked=1";
				break;
			default:
				if(substr($orderby,0,6)=='credit' || substr($orderby,0,7)=='mydowns'){
					$arr = explode('_',$orderby);
					$sql_orderby = " order by $arr[0] $arr[1]";
				}elseif(substr($orderby,0,10)=='used_space'){
					$arr = explode('_',$orderby);
					$sql_orderby = " order by $arr[0]_$arr[1] $arr[2]";
				}else{
					$sql_orderby = " order by userid asc";
				}
				//echo $sql_orderby;
		}
		$sql_ext = $gid ? " and u.gid='$gid'" : "";
		$sql_do = " {$tpf}users u,{$tpf}groups g where u.gid=g.gid {$sql_ext} $sql_keyword";

		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do} {$sql_str}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select u.*,g.gid,g.group_name from {$sql_do} {$sql_orderby} limit $start_num ,$perpage");
		$users = array();
		while($rs = $db->fetch_array($q)){
			$rs['reg_time'] = date("Y-m-d H:i:s",$rs['reg_time']);
			$rs['status_text'] = $rs['is_locked'] ? '<span class="txtred">'.__('user_open').'</span>' : __('user_locked');
			$rs['a_user_edit'] = urr(ADMINCP,"item=users&menu=user&action=user_edit&uid={$rs['userid']}");
			$rs['a_user_ftp'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=edit_ftp&uid={$rs['userid']}");
			$rs['wealth'] = $rs['wealth'] ? "(￥{$rs['wealth']})" : "";
			$users[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$q = $db->query("select gid,group_name,group_type from {$tpf}groups order by gid asc");
		$groups = array();
		while($rs = $db->fetch_array($q)){
			$rs['txtcolor'] = $rs['group_type'] ? 'txtblue' : '';
			$groups[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action&task=$task&gid=$gid&orderby=$orderby"));
		require_once template_echo('admin','',$app);
}
update_action_time($app);

function get_multi_servers(){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}servers order by server_id asc");
	while ($rs = $db->fetch_array($q)) {
		$arr[] = $rs;			
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
?>