<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: admin.inc.php 145 2015-08-01 06:06:46Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}
phpdisk_core::admin_login();

switch($action){
	case 'add_site':

		if($task =='add_site'){
			form_auth(gpc('formhash','P',''),formhash());

			$subject = trim(gpc('subject','P',''));
			$site_url = trim(gpc('site_url','P',''));
			$site_status = (int)gpc('site_status','P',0);
			$site_key = trim(gpc('site_key','P',''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($subject,2,100)){
				$error = true;
				$sysmsg[] = '请填写标识名称';
			}
			if(substr($site_url,0,7) !='http://' && substr($site_url,0,8) !='https://'){
				$error = true;
				$sysmsg[] = 'SSO子网站地址需要以http:// 或 https:// 开头';
			}else{
				$site_url = substr($site_url,-1) =='/' ? $site_url : $site_url.'/';
			}
			if(!$site_key){
				$error = true;
				$sysmsg[] = '通信密码不能为空';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}sso where site_key='$site_key'");
				if($num){
					$error = true;
					$sysmsg[] = '密钥已存在，请重新修改';
				}
			}
			$num = @$db->result_first("select count(*) from {$tpf}sso where site_url='$site_url'");
			if($num){
				$error = true;
				$sysmsg[] = '子网站已存在，请重新修改';
			}
			if(!$error){
				$ins = array(
				'subject' => $subject,
				'site_url' => $site_url,
				'site_key' => $site_key,
				'site_status' => $site_status,
				);
				$db->query_unbuffered("insert into {$tpf}sso set ".$db->sql_array($ins).";");

				$sysmsg[] = '子网站添加成功';
				redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=$app"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			require_once template_echo('admin','',$app);
		}
		break;

	case 'edit_site':
		$id = (int)gpc('id','GP',0);

		if($task =='edit_site'){
			form_auth(gpc('formhash','P',''),formhash());

			$subject = trim(gpc('subject','P',''));
			$site_url = trim(gpc('site_url','P',''));
			$site_status = (int)gpc('site_status','P',0);
			$site_key = trim(gpc('site_key','P',''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($subject,2,100)){
				$error = true;
				$sysmsg[] = '请填写标识名称';
			}
			if(substr($site_url,0,7) !='http://' && substr($site_url,0,8) !='https://'){
				$error = true;
				$sysmsg[] = 'SSO子网站地址需要以http:// 或 https:// 开头';
			}else{
				$site_url = substr($site_url,-1) =='/' ? $site_url : $site_url.'/';
			}
			if(!$site_key){
				$error = true;
				$sysmsg[] = '通信密码不能为空';
			}else{
				$num = @$db->result_first("select count(*) from {$tpf}sso where site_key='$site_key' and id<>'$id'");
				if($num){
					$error = true;
					$sysmsg[] = '密钥已存在，请重新修改';
				}
			}
			$num = @$db->result_first("select count(*) from {$tpf}sso where site_url='$site_url' and id<>'$id'");
			if($num){
				$error = true;
				$sysmsg[] = '子网站已存在，请重新修改';
			}
			if(!$error){
				$ins = array(
				'subject' => $subject,
				'site_url' => $site_url,
				'site_key' => $site_key,
				'site_status' => $site_status,
				);
				$db->query_unbuffered("update {$tpf}sso set ".$db->sql_array($ins)." where id='$id';");

				$sysmsg[] = '子网站修改成功';
				redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=$app"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$p = $db->fetch_one_array("select * from {$tpf}sso where id='$id' limit 1");
			require_once template_echo('admin','',$app);
		}
		break;

	case 'del_site':
		$id = (int)gpc('id','G',0);
		if($id){
			$db->query_unbuffered("delete from {$tpf}sso where id='$id'");
			$sysmsg[] = 'SSO子网站删除成功';
			redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=$app"),$sysmsg);
		}else{
			$sysmsg[] = 'ID Error!';
			redirect('back',$sysmsg);
		}

		break;
	case 'sso_log':
		if($task=='del_log_all'){
			$db->query_unbuffered("truncate table {$tpf}sso_log");
			$sysmsg[] = '记录清空成功';
			redirect(urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action"),$sysmsg);
		}else{
			$perpage = 30;

			$sql_do = " {$tpf}sso_log";

			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select * from {$sql_do} order by intime desc limit $start_num ,$perpage");
			$logs = array();
			while($rs = $db->fetch_array($q)){
				$rs[intime] = date('Y-m-d H:i:s',$rs[intime]);
				$logs[] = $rs;
			}
			$db->free($q);
			unset($rs);

			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=plugins&menu=$menu&app=$app&action=$action"));
			require_once template_echo('admin','',$app);
		}
		break;
	default:
		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$settings = gpc('setting','P',$setting);

			$settings[sso_main_site_url] = trim($settings[sso_main_site_url]);

			if($settings[sso_main_site_url]){
				if((substr($settings[sso_main_site_url],0,7) !='http://' && substr($settings[sso_main_site_url],0,8) !='https://')){
					$error = true;
					$sysmsg[] = 'SSO主网站地址需要以http:// 或 https:// 开头';
				}else{
					$settings[sso_main_site_url] = substr($settings[sso_main_site_url],-1) =='/' ? $settings[sso_main_site_url] : $settings[sso_main_site_url].'/';
				}
			}
			if(!$error){
				settings_cache($settings);
				$sysmsg[] = 'SSO网站配置更新成功';
				redirect(urr(ADMINCP,"item=plugins&menu=plugin&app=$app"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{

			$q = $db->query("select * from {$tpf}sso order by id asc");
			$site_arr = array();
			while($rs = $db->fetch_array($q)){
				$rs['site_status'] = $rs['site_status'] ? '<span class="txtred">'.__('closed').'</span>' : '<span class="txtblue">'.__('using').'</span>';
				$rs['a_edit_site'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=edit_site&id={$rs['id']}");
				$rs['a_del_site'] = urr(ADMINCP,"item=plugins&menu=plugin&app=$app&action=del_site&id={$rs['id']}");
				$sign = md5(md5('test'.$rs[site_key].$settings[phpdisk_url]));
				$rs['a_test_site'] = $rs['site_url'].'plugins/phpdisk_sso/sso_api.php?action=test&sign='.$sign;
				$site_arr[] = $rs;
			}
			$db->free($q);
			unset($rs,$rs2);
			require_once template_echo('admin','',$app);
		}
}
update_action_time($app);

?>