<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: api.php 25 2014-01-10 03:13:43Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/
include "../../includes/commons.inc.php";

$sign = trim(gpc('sign','GP',''));
$param = trim(gpc('param','GP',''));
//$str = base64_decode($param);
$str = pd_encode(rawurldecode($param),'DECODE',$settings[sso_main_site_key]);
parse_str($str);
$sign_prefix = $settings[sso_main_site_key].$settings[sso_main_site_url];

if(!$settings[open_sso]){
	$json_arr = array('data'=>'','success'=>false,'msg'=>'子网站需要开启SSO整合登录插件');
	echo json_encode($json_arr);
	exit;
}
switch ($action){
	case 'test':
		if($settings[is_sso_main]){
			$error = true;
			$sysmsg[] = '目标子网站整合属性需要设置为子网站';
		}
		if(!$settings[sso_main_site_url] || $sign<>md5(md5($action.$sign_prefix))){
			$error = true;
			$sysmsg[] = '通信失败,请确认密钥、整合网址正确';
		}
		if(!$error){
			$json_arr = array('data'=>'','success'=>true,'msg'=>'通信成功');
		}else{
			sso_log($action,$sysmsg);
			$json_arr = array('data'=>'','success'=>false,'msg'=>arr2str($sysmsg));
		}
		echo json_encode($json_arr);
		break;
	case 'login':
		//$username = $username_pd = trim(gpc('username','GP','',1));
		//$password = $password_pd = trim(gpc('password','GP','',1));
		$md5_pwd = md5($password);

		if($sign<>md5(md5($action.$username.$password.$sign_prefix))){
			$error = true;
			$sysmsg = '数据较验失败';
		}else{
			$rs = $db->fetch_one_array("select userid,gid,username,password,email,is_locked from {$tpf}users where username='$username' limit 1");
			if(!$rs){
				$error = true;
				$sysmsg = __('user_not_exists');
			}else{
				if($md5_pwd != $rs['password']){
					$error = true;
					$sysmsg = __('user_password_false');
				}elseif($rs['is_locked']){
					$error = true;
					$sysmsg = __('user_is_locked');
				}else{
					$userid = (int)$rs['userid'];
					$gid = (int)$rs['gid'];
					$username = trim($rs['username']);
					$password = trim($rs['password']);
					$email = trim($rs['email']);
				}
			}
		}
		if(!$error){
			$num = @$db->result_first("select count(*) from {$tpf}users where username='$username' or email='$email'");
			if(!$num){
				$ins = array(
				'username' => $username,
				'password' => $md5_pwd,
				'email' => $email ? $email : "$username@guest.na",
				'gid' => $gid ? $gid : 4,
				'is_activated' => 1,
				'reg_time' => $timestamp,
				'reg_ip' => $onlineip,
				);
				$db->query("insert into {$tpf}users set ".$db->sql_array($ins).";");
				$userid = $db->insert_id();
			}
			$db->query_unbuffered("update {$tpf}users set last_login_ip='$onlineip',last_login_time='$timestamp' where userid='$userid'");
			pd_setcookie(PHPDISK_COOKIE,pd_encode("$userid\t$gid\t$username\t$password\t$email"));
			$json_arr = array('data'=>'','success'=>true,'msg'=>__('login_success'));
		}else{
			sso_log($action,$sysmsg);
			$json_arr = array('data'=>'','success'=>false,'msg'=>$sysmsg);
		}
		echo json_encode($json_arr);
		break;
	case 'register':
		//$username = trim(gpc('username','GP','',1));
		//$password = trim(gpc('password','GP','',1));
		//$confirm_password = trim(gpc('confirm_password','GP',''));
		$md5_pwd = md5($password);

		if($sign<>md5(md5($action.$username.$password.$email.$gid.$sign_prefix))){
			$error = true;
			$sysmsg = '数据较验失败';
		}else{
			if(checklength($username,2,60)){
				$error = true;
				$sysmsg = __('invalid_username');
			}elseif(is_bad_chars($username)){
				$error = true;
				$sysmsg = __('username_has_bad_chars');
			}else{
				$rs = $db->fetch_one_array("select username from {$tpf}users where username='$username' limit 1");
				if($rs){
					if(strcasecmp($username,$rs['username']) ==0){
						$error = true;
						$sysmsg = __('username_already_exists');
					}
				}
				unset($rs);
			}
			if(!checkemail($email)){
				$error = true;
				$sysmsg = __('invalid_email');
			}else{
				$rs = $db->fetch_one_array("select email from {$tpf}users where email='$email' limit 1");
				if($rs){
					if(strcasecmp($email,$rs['email']) ==0){
						$error = true;
						$sysmsg = __('email_already_exists');
					}
					unset($rs);
				}
			}
		}
		if(!$error){
			$ins = array(
			'username' => $username,
			'password' => $md5_pwd,
			'email' => $email ? $email : "$username@guest.na",
			'gid' => $gid ? $gid : 4,
			'is_activated' => 1,
			'reg_time' => $timestamp,
			'reg_ip' => $onlineip,
			);
			$db->query("insert into {$tpf}users set ".$db->sql_array($ins).";");
			$userid = $db->insert_id();
			$db->query_unbuffered("update {$tpf}users set last_login_ip='$onlineip',last_login_time='$timestamp' where userid='$userid'");
			pd_setcookie(PHPDISK_COOKIE,pd_encode("$userid\t$gid\t$username\t$password\t$email"));
			$json_arr = array('data'=>'','success'=>true,'msg'=>__('register_success'));
		}else{
			sso_log($action,$sysmsg);
			$json_arr = array('data'=>'','success'=>false,'msg'=>$sysmsg);
		}
		echo json_encode($json_arr);
		break;
	case 'logout':
		if($sign<>md5(md5($action.$sign_prefix))){
			$json_arr = array('data'=>'','success'=>false,'msg'=>'数据较验失败');
		}else{
			pd_setcookie(PHPDISK_COOKIE,'',-3600);
			$json_arr = array('data'=>'','success'=>true,'msg'=>__('logout_success'));
		}
		echo json_encode($json_arr);
		break;
	case 'edit_user':
		$md5_pwd = md5($password);
		if($sign<>md5(md5($action.$username.$password.$email.$gid.$sign_prefix))){
			$error = true;
			$sysmsg = '数据较验失败';
		}else{
			if($username){
				$userid = @$db->result_first("select count(*) from {$tpf}users where username='$username'");
				if(!$userid){
					$error = true;
					$sysmsg = '用户名不存在';
				}
			}else{
				$error = true;
				$sysmsg = '用户名不能为空';
			}
			if(!$error){
				$ins = array(
				'password' => $md5_pwd,
				'email' => $email,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$userid'");
				$json_arr = array('data'=>'','success'=>true,'msg'=>'用户信息修改成功');
			}else{
				sso_log($action,$sysmsg);
				$json_arr = array('data'=>'','success'=>false,'msg'=>$sysmsg);
			}
		}
		break;
	case 'del_user':
		if($sign<>md5(md5($action.$username.$sign_prefix))){
			$error = true;
			$sysmsg = '数据较验失败';
		}else{
			if(!$error){
				$db->query_unbuffered("delete from {$tpf}users where userid='$uid'");
				$json_arr = array('data'=>'','success'=>true,'msg'=>'用户删除成功');
			}else{
				sso_log($action,$sysmsg);
				$json_arr = array('data'=>'','success'=>false,'msg'=>$sysmsg);
			}
		}
		break;
	case 'get_userinfo':
		if($sign<>md5(md5($action.$username.$sign_prefix))){
			$error = true;
			$sysmsg = '数据较验失败';
		}else{
			if($username){
				$rs = $db->fetch_one_array("select * from {$tpf}users where username='$username' limit 1");
				$json_arr = array('data'=>$rs,'success'=>true,'msg'=>'获取用户数据成功');
			}else{
				$sysmsg = '用户未登录';
				sso_log($action,$sysmsg);
				$json_arr = array('data'=>'','success'=>false,'msg'=>$sysmsg);
			}
		}
		echo json_encode($json_arr);
		break;

	default:
		sso_log('error','no action');
		$json_arr = array('data'=>'','success'=>false,'msg'=>'no action');
		echo json_encode($json_arr);
}
function sso_log($action,$data){
	global $db,$tpf,$timestamp,$onlineip;
	$ins = array(
	'intime'=>$timestamp,
	'site'=>$db->escape($_SERVER['HTTP_HOST']),
	'action'=>$action,
	'param'=>serialize($data),
	'ip'=>$onlineip,
	);
	$db->query_unbuffered("insert into {$tpf}sso_log set ".$db->sql_array($ins));
}
?>