<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: public.php 25 2014-01-10 03:13:43Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;
if(!$auth[open_public_file]){
	exit;
}
$cate_id = (int)gpc('cate_id','G',0);

$cate_name = @$db->result_first("select cate_name from {$tpf}categories where cate_id='$cate_id'");
$title = $cate_name ? $cate_name.' - '.__('public_file') : '公共文件';
include PHPDISK_ROOT."./includes/header.inc.php";

if($cate_id){

	$perpage = 20;
	$sql_do = "{$tpf}files fl,{$tpf}users u where fl.cate_id='$cate_id' and is_del=0 and is_checked=1 and in_recycle=0 and fl.userid=u.userid";

	$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
	$total_num = $rs['total_num'];
	$start_num = ($pg-1) * $perpage;

	$q = $db->query("select fl.*,u.username from {$sql_do} order by pub_time desc limit $start_num, $perpage");
	$files_array = array();
	while($rs = $db->fetch_array($q)){
		$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
		$rs['file_name'] = $rs['file_name'].$tmp_ext;
		$rs['file_size'] = get_size($rs['file_size']);
		$rs['file_time'] = custom_time("Y-m-d",$rs['pub_time']);
		$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
		$files_array[] = $rs;
	}
	$db->free($q);
	unset($rs);
	$db->query_unbuffered("update {$tpf}categories set cate_num=(select count(*) from {$tpf}files where cate_id='$cate_id') where cate_id='$cate_id'");
	$page_nav = multi($total_num, $perpage, $pg, "public.php?cate_id=$cate_id");
	$page_nav = preg_replace("/public.php\?cate_id=([0-9]+)&amp;pg=([0-9]+)/i","public-\\1-\\2.html",$page_nav);
}else{
	$q = $db->query("select fl.*,u.username from {$tpf}files fl,{$tpf}users u where fl.cate_id>0 and is_checked=1 and is_del=0 and in_recycle=0 and fl.userid=u.userid order by pub_time desc limit 20");
	$files_array = array();
	while($rs = $db->fetch_array($q)){
		$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
		$rs['file_name'] = $rs['file_name'].$tmp_ext;
		$rs['file_size'] = get_size($rs['file_size']);
		$rs['file_time'] = custom_time("Y-m-d",$rs['pub_time']);
		$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
		$files_array[] = $rs;
	}
	$db->free($q);
	unset($rs);
}
$arr = get_public_folders();
//$tmp = $arr[file_count] ? __('all_file')."{$arr[file_count]} , ".__('folder_size').get_size($arr[folder_size]) : '';
$public_folder_tree = "tr.add(0,-1,'公共文件','".urr("public","")."','');".LF;
foreach($arr as $v){
	$public_folder_tree .= "tr.add({$v['cate_id']},{$v['pid']},'{$v['cate_name']}','".urr("public","cate_id={$v['cate_id']}")."','文件数:".$v[cate_num]."');".LF;
}
require_once template_echo('pd_public',$user_tpl_dir);

include PHPDISK_ROOT."./includes/footer.inc.php";

function get_public_folders(){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}categories where is_hidden=0 order by cate_id asc");
	$arr = array();
	while ($rs = $db->fetch_array($q)) {
		$arr[] =$rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
?>
