<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: rc_upload.php 187 2016-02-06 13:44:51Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$uid = (int)gpc('uid','GP','');
$uid = $uid ? (int)$uid : $pd_uid;
$folder_id = (int)gpc('folder_id','GP','');
$token = trim(gpc('token','GP',''));
$sess_id = trim(gpc('sess_id','GP',''));
$plugin_type = trim(gpc('plugin_type','GP',''));
$hash = trim(gpc('hash','GP',''));
$sign = trim(gpc('sign','GP',''));

$upload_log_fn = PHPDISK_ROOT.'system/upload.error.php';
$hacker_log_fn = PHPDISK_ROOT.'system/hacker.error.php';

$is_locked = @$db->result_first("select is_locked from {$tpf}users where userid='$uid'");
if($is_locked){
	write_file($upload_log_fn,'<?php exit; ?> User locked','ab');
	exit;
}

@set_time_limit(0);

$server_oid = get_server_oid();

if(in_array($action,array('guest_upload','doupload'))){
	if($token<>md5(md5($uid.$action.$sess_id.$settings[encrypt_key]))){
		$str = $action.' , token error!'.LF;
		write_file($upload_log_fn,'<?php exit;?>'.$str,'ab');
		exit($str);
	}
}
switch($action){

	case 'super_upload':
		include_once PHPDISK_ROOT.'includes/function/super_upload.func.php';
		if($task=='tk'){
			su_token();
		}elseif($task=='up'){
			if($folder_id>0){
				$num = @$db->result_first("select count(*) from {$tpf}folders where folder_id='$folder_id' and userid='$uid'");
				if(!$num){
					write_file($hacker_log_fn,'<?php exit; ?> hacker_folder_id '.date('Y-m-d H:i:s').LF,'a');
					exit;
				}
			}
			$token = $_GET['token'];
			$file = su_get_token($token);

			if(!is_utf8()){
				$file['name'] = convert_str('utf-8','gbk',$file['name']);
			}
			$file['name'] = filter_name($file['name']);
			$file_extension = strtolower($db->escape(get_extension($file['name'])));
			$esp = strlen($file_extension)+1;
			if($file_extension){
				$file_name = $db->escape(substr($file['name'],0,strlen($file['name'])-$esp));
			}else{
				$file_name = $db->escape($file['name']);
			}

			$file_real_path = PHPDISK_ROOT.$settings['file_path'].'/';
			$file_store_path = date('Y/m/d/');
			make_dir($file_real_path.$file_store_path);

			$file_real_name = $token;//md5(uniqid(mt_rand(),true).microtime().$uid);
			$file_ext = get_real_ext($file_extension);
			$dest_file = $file_real_path.$file_store_path.$file_real_name.$file_ext;

			$rs = $db->fetch_one_array("select * from {$tpf}files where file_real_name='$file_real_name' and file_store_path='$file_store_path' and file_extension='$file_extension'");
			if($rs){
				$ins = array(
				'file_name' => $file_name,
				'file_key' => $file_key,
				'file_extension' => $file_extension,
				'is_image' => $is_image,
				'file_mime' => $file_mime,
				'file_description' => $file_description ? $file_description : '',
				'file_store_path' => $file_store_path,
				'file_real_name' => $file_real_name,
				'file_md5' => $file_md5 ? $file_md5 : '',
				'server_oid' => (int)$server_oid,
				'file_size' => $file['size'],
				'file_time' => $timestamp,
				'is_checked' => 1,
				'report_status' => $report_status,
				'userid' => $uid,
				'folder_id' => $folder_id ? $folder_id : -1,
				'ip' => $onlineip,
				);
				$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");

				$result['msg'] = 'Upload success!';
				$result['success'] = true;

			}elseif(chk_extension_ok_h5($file_extension)){

				if($file['size'] > $file['up_size']){
					$data = file_get_contents('php://input', 'r');
					if(!empty($data)){
						$fp = fopen($file['filePath'], 'a');
						flock($fp, LOCK_EX);
						fwrite($fp, $data);
						flock($fp, LOCK_UN);
						fclose($fp);
						$file['up_size'] += strlen($data);
						if($file['size'] > $file['up_size']){
							su_set_token($token, $file);
						}else{
							$report_status =0;
							$report_arr = explode(',',$settings['report_word']);
							if(count($report_arr)){
								foreach($report_arr as $value){
									if (strpos($file['name'],$value) !== false){
										$report_status = 2;
									}
								}
							}
							$file_key = random(8);

							$file_mime = strtolower($db->escape($file['type']));
							$img_arr = getimagesize($dest_file);
							if($img_arr[2] && @in_array($file_extension,array('jpg','jpeg','png','gif','bmp'))){
								$is_image = 1;
								if($file['size']<1024*1024*2){
									make_thumb($dest_file, $file_real_path.$file_store_path.$file_real_name.'_thumb.'.$file_extension,150,120);
								}
							}else{
								$is_image = 0;
							}

							$db->ping();
							$ins = array(
							'file_name' => $file_name,
							'file_key' => $file_key,
							'file_extension' => $file_extension,
							'is_image' => $is_image,
							'file_mime' => $file_mime,
							'file_description' => $file_description ? $file_description : '',
							'file_store_path' => $file_store_path,
							'file_real_name' => $file_real_name,
							'file_md5' => $file_md5 ? $file_md5 : '',
							'server_oid' => (int)$server_oid,
							'file_size' => $file['size'],
							'file_time' => $timestamp,
							'is_checked' => 1,
							'report_status' => $report_status,
							'userid' => $uid,
							'folder_id' => $folder_id ? $folder_id : -1,
							'ip' => $onlineip,
							);
							$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");
							$file_id = $db->insert_id();
							$folder_id && $db->query_unbuffered("update {$tpf}folders set folder_size=folder_size+{$file['size']} where userid='$uid' and folder_id='$folder_id'");

							@unlink(PHPDISK_ROOT.'system/tokens/' . $token . '.phpdisk.token');
						}
					}
					$result['start'] = $file['up_size'];
					$result['success'] = true;
				}
			}else{
				$result['msg'] = $file[name].' Upload Error! Not Support Extension!';
				$result['success'] = false;
			}
			echo json_encode($result);
			exit;

		}else{
			$str = '<?php exit(); ?>'.$task.LF;
			$error_log = PHPDISK_ROOT.'system/super_upload.log.php';
			write_file($error_log,$str,'ab');
			exit;
		}
		break;
	case 'doupload':

		$desc_arr = gpc('desc','P',array());
		foreach($desc_arr as $v){
			$file_description = $v;
			if(!is_utf8()){
				$file_description = convert_str('utf-8','gbk',$file_description);
			}
		}
		$file = $_FILES['upload_file'];
		if(!is_utf8()){
			$file['name'] = convert_str('utf-8','gbk',$file['name']);
		}
		$file['name'] = filter_name($file['name']);
		$file_extension = strtolower($db->escape(get_extension($file['name'])));
		$esp = strlen($file_extension)+1;
		if($file_extension){
			$file_name = $db->escape(substr($file['name'],0,strlen($file['name'])-$esp));
		}else{
			$file_name = $db->escape($file['name']);
		}

		$file_real_path = PHPDISK_ROOT.$settings['file_path'].'/';
		$file_store_path = date('Y/m/d/');
		make_dir($file_real_path.$file_store_path);

		$file_real_name = md5(uniqid(mt_rand(),true).microtime().$uid);
		$file_ext = get_real_ext($file_extension);
		$dest_file = $file_real_path.$file_store_path.$file_real_name.$file_ext;

		if(chk_extension_ok($file_extension) && upload_file($file['tmp_name'],$dest_file)){

			$report_status =0;
			$report_arr = explode(',',$settings['report_word']);
			if(count($report_arr)){
				foreach($report_arr as $value){
					if (strpos($file['name'],$value) !== false){
						$report_status = 2;
					}
				}
			}
			$file_key = random(8);

			$file_mime = strtolower($db->escape($file['type']));
			$img_arr = getimagesize($dest_file);
			if($img_arr[2] && @in_array($file_extension,array('jpg','jpeg','png','gif','bmp'))){
				$is_image = 1;
				if($file['size']<1024*1024*2){
					make_thumb($dest_file, $file_real_path.$file_store_path.$file_real_name.'_thumb.'.$file_extension,150,120);
				}
			}else{
				$is_image = 0;
			}

			$db->ping();
			$ins = array(
			'file_name' => $file_name,
			'file_key' => $file_key,
			'file_extension' => $file_extension,
			'is_image' => $is_image,
			'file_mime' => $file_mime,
			'file_description' => $file_description ? $file_description : '',
			'file_store_path' => $file_store_path,
			'file_real_name' => $file_real_name,
			'file_md5' => $file_md5 ? $file_md5 : '',
			'server_oid' => (int)$server_oid,
			'file_size' => $file['size'],
			'file_time' => $timestamp,
			'is_checked' => 1,
			'report_status' => $report_status,
			'userid' => $uid,
			'folder_id' => $folder_id ? $folder_id : -1,
			'ip' => $onlineip,
			);
			$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");
			$file_id = $db->insert_id();
			$folder_id && $db->query_unbuffered("update {$tpf}folders set folder_size=folder_size+{$file['size']} where userid='$uid' and folder_id='$folder_id'");

			@unlink($file['tmp_name']);
		}else{
			$str = '<?php exit(); ?>'.$file_name.LF;
			write_file($upload_log_fn,$str,'ab');
		}
		break;
	default:
		write_file($upload_log_fn,'<?php exit;?> no action'.date('Y-m-d H:i:s'),'ab');
}

?>

