<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: viewfile.php 67 2016-08-05 07:26:31Z along $
#
#	Copyright (C) 2008-2016 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;

$file_id = (int)gpc('file_id','G',0);
$code = trim(gpc('code','G',''));

if($code && $file_id){
	$rs = @$db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' and file_key='$code' and is_del=0 and in_recycle=0");
	if(!$rs){
		$title = '提取码不正确或文件参数不正确';
		include PHPDISK_ROOT."./includes/header.inc.php";
		redirect('back',$title);
		
	}else{
		if(!$rs[use_code]){
			$title = '提取码未启用或已关闭,无法提取文件';
			include PHPDISK_ROOT."./includes/header.inc.php";
			redirect('back',$title);
		}else{
			$file = file_data($file_id);
			$title = $file['file_name'].' - '.$settings['site_title'];
			$file_keywords = $file['file_name'].',';
			$file_description = $file['file_name'].','.str_replace("\r\n",'',preg_replace("/<.+?>/i","",$file_description));
			include PHPDISK_ROOT."./includes/header.inc.php";
			require_once template_echo('pd_viewfile',$user_tpl_dir);
			$db->query_unbuffered("update {$tpf}files set file_views=file_views+1 where file_id='$file_id'");
		}
	}
	unset($rs);
}else{
	$public_file = @$db->result_first("select count(*) from {$tpf}files where file_id='$file_id' and is_checked=1 and cate_id>0");
	if($public_file){
		$file = file_data($file_id);

		$file[remain_time] = 3600;
		$file[share_end_time] = $timestamp+$remain_time;

		$title = $file['file_name'].' - '.$settings['site_title'];
		$file_keywords = $file['file_name'].',';
		$file_description = $file['file_name'].','.str_replace("\r\n",'',preg_replace("/<.+?>/i","",$file_description));
		include PHPDISK_ROOT."./includes/header.inc.php";
		require_once template_echo('pd_viewfile',$user_tpl_dir);
		$db->query_unbuffered("update {$tpf}files set file_views=file_views+1 where file_id='$file_id'");
		include PHPDISK_ROOT."./includes/footer.inc.php";
		exit;
	}

	$rs = @$db->fetch_one_array("select share_end_time from {$tpf}files where file_id='$file_id'");
	if(!$rs){
		$title = '找不到此文件记录，文件已经删除';
		include PHPDISK_ROOT."./includes/header.inc.php";
		redirect('back',$title);
	}else{
		if($rs[share_end_time]<$timestamp && $pd_gid<>1){
			$title = '文件共享链接已过期';
			include PHPDISK_ROOT."./includes/header.inc.php";
			if($rs[share_end_time]){
				$msg = '文件到期时间为：['.date('Y-m-d H:i:s',$rs[share_end_time]).'] - '.$title;
			}else{
				$msg = $title;
			}
			redirect('back',$msg);
		}else{
			$file = file_data($file_id);
			if($pd_gid==1){
				$file[remain_time] = 3600;
				$file[share_end_time] = $timestamp+$remain_time;
			}
			$title = $file['file_name'].' - '.$settings['site_title'];
			$file_keywords = $file['file_name'].',';
			$file_description = $file['file_name'].','.str_replace("\r\n",'',preg_replace("/<.+?>/i","",$file_description));
			include PHPDISK_ROOT."./includes/header.inc.php";
			require_once template_echo('pd_viewfile',$user_tpl_dir);
			$db->query_unbuffered("update {$tpf}files set file_views=file_views+1 where file_id='$file_id'");
		}
	}
}

include PHPDISK_ROOT."./includes/footer.inc.php";

function file_data($file_id){
	global $db,$tpf,$pd_gid,$settings,$timestamp;
	if($pd_gid==1){
		$sql_add = "file_id='$file_id'";
	}else{
		$sql_add = "file_id='$file_id' and in_recycle=0";
	}
	$file = $db->fetch_one_array("select * from {$tpf}files where $sql_add");
	if(!$file){
		$file['is_del'] = 1;
		$file['file_name'] = __('visited_tips');
	}else{
		$file['a_downfile'] = create_down_url($file);
		if($file['cate_id']){
			$file[cate_name] = $db->result_first("select cate_name from {$tpf}categories where cate_id='{$file[cate_id]}'");
			$file[a_cate] = urr("public","cate_id=$file[cate_id]");
		}
		$file['is_del'] = 0;
		$file_key = trim($file['file_key']);

		$file['username'] = @$db->result_first("select username from {$tpf}users where userid='{$file['userid']}' limit 1");
		$tmp_ext = $file['file_extension'] ? '.'.$file['file_extension'] : "";
		$file_extension = $file['file_extension'];
		$file_ext = get_real_ext($file_extension);

		$file_description = $file['file_description'];
		$file['file_description'] = nl2br($file['file_description']);
		$file['file_name'] = $file['file_name'].$tmp_ext;
		$file['file_size'] = get_size($file['file_size']);
		$file['file_time'] = date("Y-m-d",$file['file_time']);
		$file[remain_time] = $timestamp<$file[share_end_time] ? $file[share_end_time]-$timestamp : '';

		return $file;
	}
}
?>