﻿/*
FileUpload.as
Sascha Wenning
Jan 2006

Feel free to customize for your needs
Code is partly documentated
*/

import mx.controls.gridclasses.DataGridColumn;
import flash.net.FileReference;
import flash.net.FileReferenceList;
import mx.containers.Window;
import mx.utils.Delegate;

class de.saschawenning.fileUpload.FileUpload{
	private var tl:MovieClip;
	private var titleWindow:String;
	private var frWindow:MovieClip; //path to windowComponent
	private var uploadMode;
	private var xCoord;
	private var yCoord;
	private var uploadDir;	
	private var pathUploadScript;
	private var pathXmlFileStructure;
	
	private var waiter;
	private var xmlFileStructure;
	private var fileRef;
	private var fileRefListener;
	private var filesToUpload:Array;
	private var totalKilobytesToUpload;
	private var totalKiloBytesUploaded;
	private var filesUploaded; //num of files uploaded
	private static var maxFilesize; //in MB per file you can set this also by hand to limit it
	private var labelUploadBtn;
	

	public function FileUpload(timeline, titleW, uploadMode, xCoord, yCoord, uploadDir, pathUploadScript, pathXmlFileStructure){
		//vars
		this.tl = timeline;
		this.titleWindow = titleW;
		this.uploadMode = uploadMode;
		this.xCoord = xCoord,
		this.yCoord = yCoord
		this.uploadDir = uploadDir;
		this.pathUploadScript = pathUploadScript;
		this.pathXmlFileStructure = pathXmlFileStructure
		
		
		totalKilobytesToUpload = 0;
		totalKiloBytesUploaded = 0;
		filesUploaded = 0;
		filesToUpload = new Array();
		labelUploadBtn = "Upload now";
		
		//init stuff
		attachWindow();
	}
	
	//xmlFileStructure fully loaded 
	public function parseXmlFileStructure(success:Boolean){
		if(success){
			if(xmlFileStructure.status == 0){
				//no error
			} else {
				frWindow.content.feedback_txt.htmlText = "<p align='center'>An error occured while loading XmlFileStructure</p>";
			}
		} else {
			frWindow.content.feedback_txt.htmlText = "<p align='center'>Unable to load/parse XmlFileStructure. (Status: "+xmlFileStructure.status+")</p>"
		}
		frWindow.content.explorer_tree.dataProvider = xmlFileStructure.firstChild;
	}
	
	//user clicks select files button
	public function browseClick(){
		frWindow.content.feedback_txt.htmlText = "";
		checkLabelUploadBtn();
		
		fileRef.browse();
	}
	
	//user has selected some files
	public function fileRefListener_onSelect(fileRefList:FileReferenceList){
		var list:Array = fileRefList.fileList;
		var tempList = new Array();

		for(var i=0; i< list.length; i++){
			var sizeFile = list[i].size/1024/1024; //in MB
			if((sizeFile > maxFilesize) || (sizeFile >= 100)){ //100 MB is Flash Player limit per file
				frWindow.content.feedback_txt.htmlText = "<p align='center'>Info: At least one file exceeded the server's max upload size ("+maxFilesize+" MB)<br /> or is > 100 MB.<br>These files were removed from the list.</p>";
			}else{
				tempList.push(list[i])
			}
			
		}
		filesToUpload = filesToUpload.concat(tempList);
		frWindow.content.fileList_grid.dataProvider = filesToUpload;
		checkGridItems();
	}
	
	//while upload is in progress disable user interface
	public function disableWhileUploadContinues(){
		frWindow.content.refreshTree_btn.enabled = false;
		frWindow.content.explorer_tree.enabled = false;
		frWindow.content.fileList_grid.enabled = false;
		frWindow.content.del_btn.enabled = false;
		frWindow.content.browse_btn.enabled = false;
	}
	
	//upload is completed: enable user interface
	public function enableAfterUpload(){
		frWindow.content.refreshTree_btn.enabled = true;
		frWindow.content.explorer_tree.enabled = true;
		frWindow.content.fileList_grid.enabled = true;
		frWindow.content.del_btn.enabled = true;
		frWindow.content.browse_btn.enabled = true;
		fileListChange();
		checkGridItems();
		updateTree();
	}	
	
	//upload ach selected file
	public function uploadFiles(){
		filesUploaded = 0;
		totalKilobytesToUpload=0;
		totalKiloBytesUploaded=0;
		disableWhileUploadContinues();
		
		var item;
		for(var i:Number = 0; i < filesToUpload.length; i++) {
			item = filesToUpload[i];
			item.addListener(fileRefListener);
			item.bereitsGeladen = 0;
			if(!item.upload(pathUploadScript+"?uploadDir="+uploadDir)) {
				frWindow.content.feedback_txt.htmlText = "Upload dialog failed to open.";
			}
		}
	}
	
	//if an upload process is completed and user wants
	//to upload more files
	public function checkLabelUploadBtn(){
		if(frWindow.content.upload_btn.label != labelUploadBtn){
			frWindow.content.upload_btn.label = labelUploadBtn;	
		}
	}
	
	//check if grid is empty and enable/disable buttons
	public function checkGridItems(){
		if(frWindow.content.fileList_grid.dataProvider.length > 0){
			if(uploadMode == "Rich" && frWindow.content.explorer_tree.selectedItem.attributes.folders != undefined){
				frWindow.content.upload_btn.enabled = true;
				return true;
			}
			if(uploadMode == "Simple"){
				frWindow.content.upload_btn.enabled = true;
			}
		}else{
			frWindow.content.upload_btn.enabled = false;
			frWindow.content.del_btn.enabled = false;
		}
	}
	
	//cancel handler if you need it
	public function fileRefListener_onCancel(){
		trace("cancel");
	}
	
	//determine uploaded filesize in percent regarding total filesize to upload
	public function updateTransferStatus(){
		totalKiloBytesUploaded = 0;
		for(var i=0; i<filesToUpload.length; i++){
			totalKiloBytesUploaded += filesToUpload[i].bereitsGeladen;
		}
		frWindow.content.upload_btn.label = "Uploading...   (" + Math.round((totalKiloBytesUploaded/totalKilobytesToUpload)*100) + " %)";
	}
	
	//if up- or download starts
	public function fileRefListener_onOpen(file:FileReference){
		 totalKilobytesToUpload += (Math.ceil(file.size/1024));
		 updateTransferStatus();
		 
	}	
	
	//dispatch progress
	public function fileRefListener_onProgress(file, bytesLoaded:Number, bytesTotal:Number){
		 file.bereitsGeladen = Math.ceil(bytesLoaded/1024);
		 updateTransferStatus();
	}
	
	//when upload process is completed, clear grid
	public function clearGrid(){
		filesToUpload = new Array();
		frWindow.content.fileList_grid.dataProvider = filesToUpload;
		checkGridItems();
	}
	
	//a single file (perhaps in queue) has been uploaded
	public function fileRefListener_onComplete(){
		filesUploaded++;
		updateTransferStatus();
		if(filesUploaded == filesToUpload.length){
			enableAfterUpload();
			frWindow.content.upload_btn.label = "Upload complete.";
			clearGrid();
		}
	}
	
	//user clicks tree
	//set new uploadDir
	public function explorer_treeChange(whoSaid){
		checkLabelUploadBtn();
		
		var theTree = whoSaid.target;
		//we can't use getIsBranch() because folder could be empty
		var isBranch:Boolean = theTree.selectedItem.attributes.folders != undefined;
		frWindow.content.feedback_txt.htmlText = "";
		var node = theTree.selectedItem;
		if(isBranch && checkGridItems()){
			uploadDir = node.attributes.fullpath + "/";
			frWindow.content.upload_btn.enabled = true;
		}else if(isBranch){
				uploadDir = node.attributes.fullpath + "/";
		}else{
			frWindow.content.upload_btn.enabled = false;
			if(!isBranch){
				frWindow.content.feedback_txt.htmlText = "<p align='center'>Info: Please select a destination FOLDER, not a file.</p>";
			}
		}
	}
	
	//get actual tree source
	public function updateTree(){
		if(uploadMode == "Rich"){
			xmlFileStructure.load(pathXmlFileStructure);
		}
	}
	
	//files grid change event
	public function fileListChange(){
		checkLabelUploadBtn();
		
		if(frWindow.content.fileList_grid.selectedItem != undefined){
			frWindow.content.del_btn.enabled = true;
		}else{
			frWindow.content.del_btn.enabled = false;
		}
	}
	
	//delete file from dataProvider
	public function delFileFromList(){
		checkLabelUploadBtn();
		
		var numItems:Number = frWindow.content.fileList_grid.length;
		for(var i=0; i<numItems; i++){
			var numSelectedIndices = frWindow.content.fileList_grid.getSelectedIndices();
			frWindow.content.fileList_grid.removeItemAt(numSelectedIndices[numSelectedIndices.length-1])
		}
		
		filesToUpload = frWindow.content.fileList_grid.dataProvider;
		fileListChange();
		checkGridItems();
	}
	
	//some lyout operations
	public function setupFilesGrid(){
		var theGrid = frWindow.content.fileList_grid;
		//width 462
		//Status
		var column = new DataGridColumn("name");
		column.headerText = "Filename";
		column.width = 300;
		theGrid.addColumn(column);		
		
		var column = new DataGridColumn("size");
		column.headerText = "Size";
		column.width = 95;
		column.labelFunction = function(item):String {
			if ((item.size != undefined) && (item.name != undefined)) {
				return ((Math.ceil(item.size/1024)) + " KB");
			}
		}

		theGrid.addColumn(column);			
	}
	
	//layout simple mode
	public function layoutForSimple(){
		frWindow.content.refreshTree_btn._visible = false;
		frWindow.content.explorer_tree._visible = false;
		
		frWindow.setSize(400, 300);	
		
		setupFilesGrid();
		
		frWindow.content.fileList_grid.move(10,10);
		frWindow.content.fileList_grid.setSize(375,160);
		
		frWindow.content.labelFilesToUpload_mc._visible = false;
		frWindow.content.labelUploadDestination_mc._visible = false;
		
		frWindow.content.browse_btn.move(frWindow.content.fileList_grid._x + frWindow.content.fileList_grid.width - frWindow.content.browse_btn.width,180);
		frWindow.content.del_btn.move(frWindow.content.browse_btn._x-frWindow.content.del_btn.width-10,180);
		frWindow.content.del_btn.enabled = false;
		frWindow.content.upload_btn.setSize(frWindow.content.fileList_grid.width,35);
		frWindow.content.upload_btn.move(frWindow.content.fileList_grid._x, frWindow.content.del_btn._y + frWindow.content.del_btn._height + 10);
		frWindow.content.upload_btn.enabled = false;
		frWindow.content.feedback_txt._width = frWindow.content.upload_btn.width;
		frWindow.content.feedback_txt._x = frWindow.content.upload_btn.x;
		frWindow.content.feedback_txt._y = frWindow.content.upload_btn.y + frWindow.content.upload_btn.height + 1;		
	}
	
	//layout rich mode
	public function layoutForRich(){
		frWindow.setSize(610, 400);	
		
		setupFilesGrid();
		
		frWindow.content.fileList_grid.move(frWindow.content.explorer_tree._x + frWindow.content.explorer_tree.width+ 10, frWindow.content.explorer_tree._y + 22);
		frWindow.content.fileList_grid.setSize(375,200);
		
		frWindow.content.labelFilesToUpload_mc._x = frWindow.content.fileList_grid.x;
		frWindow.content.labelFilesToUpload_mc._y = frWindow.content.fileList_grid.y - 22;
		frWindow.content.labelUploadDestination_mc._x = frWindow.content.explorer_tree.x;
		frWindow.content.labelUploadDestination_mc._y = frWindow.content.explorer_tree.y - 22;
		
		frWindow.content.browse_btn.move(frWindow.content.fileList_grid._x + frWindow.content.fileList_grid.width - frWindow.content.browse_btn.width, frWindow.content.fileList_grid._y + frWindow.content.fileList_grid.height + 10);
		frWindow.content.del_btn.move(frWindow.content.browse_btn._x-frWindow.content.del_btn.width-10, frWindow.content.browse_btn._y);
		frWindow.content.del_btn.enabled = false;
		frWindow.content.upload_btn.setSize(frWindow.content.fileList_grid.width,35);
		frWindow.content.upload_btn.move(frWindow.content.fileList_grid._x, frWindow.content.del_btn._y + frWindow.content.del_btn._height + 10);
		frWindow.content.upload_btn.enabled = false;
		frWindow.content.feedback_txt._width = frWindow.content.upload_btn.width;
		frWindow.content.feedback_txt._x = frWindow.content.upload_btn.x;
		frWindow.content.feedback_txt._y = frWindow.content.upload_btn.y + frWindow.content.upload_btn.height + 5;
	}	
	
	//ask web server phpinfo() to return possible maxUpload filesize
	public function getPhpUploadSettings(){
		var phpRestrictions = new LoadVars();
		phpRestrictions.action = "getMaxFilesize";
		phpRestrictions.sendAndLoad(pathUploadScript, phpRestrictions, "POST");
		phpRestrictions.refThis = this;
		phpRestrictions.onLoad = function(success){
			if(success){
				maxFilesize = phpRestrictions.maxFilesize.substr(0,phpRestrictions.maxFilesize.length-2);
				if(maxFilesize.length > 5){
					//path to ini_get is relative and environment is desptop
					//so php can not be interpreted
					this.refThis.frWindow.content.feedback_txt.htmlText = "<p align='center'>An Error occured (can't get maxFilesize)</p>";
				}
			}else{
				this.refThis.frWindow.content.feedback_txt.htmlText = "<p align='center'>An Error occured (can't get maxFilesize)</p>";
			}
		}	
	}
	
	//-------------------------------------------------------------------------------------
	//window component is attached and contentPath has initialized...
	//...so fire the laser
	//-------------------------------------------------------------------------------------
	public function initFileBrowser(){
		frWindow.content.feedback_txt.htmlText = "";
		frWindow.content.upload_btn.label = labelUploadBtn;
		
		if(uploadMode == "Rich"){
			layoutForRich();
		}
		
		if(uploadMode == "Simple"){
			layoutForSimple();
		}
		
		getPhpUploadSettings();
		
		//get file structure data for explorer_tree
		//is invoked in all modes, you could change this...
		xmlFileStructure = new XML();
		xmlFileStructure.ignoreWhite = true;
		xmlFileStructure.onLoad = Delegate.create(this, parseXmlFileStructure);
		updateTree();
		
		//create reference object
		fileRef = new FileReferenceList();
		fileRefListener = new Object();
		fileRefListener.onSelect = Delegate.create(this, fileRefListener_onSelect);
		fileRefListener.onCancel = Delegate.create(this, fileRefListener_onCancel);
		
		fileRefListener.onOpen = Delegate.create(this, fileRefListener_onOpen);
		fileRefListener.onProgress = Delegate.create(this, fileRefListener_onProgress);
		fileRefListener.onComplete = Delegate.create(this, fileRefListener_onComplete);
		fileRef.addListener(fileRefListener);
		
		//events
		frWindow.content.browse_btn.addEventListener("click", Delegate.create(this, browseClick));
		frWindow.content.upload_btn.addEventListener("click", Delegate.create(this, uploadFiles));
		frWindow.content.refreshTree_btn.addEventListener("click", Delegate.create(this, updateTree));
		frWindow.content.fileList_grid.addEventListener("change", Delegate.create(this, fileListChange));
		frWindow.content.del_btn.addEventListener("click", Delegate.create(this, delFileFromList));
		
		frWindow.content.explorer_tree.setStyle("openDuration", 0);
		frWindow.content.explorer_tree.addEventListener("change", Delegate.create(this, explorer_treeChange));
	}
	
	public function waitForAttachedContent(arguments){
		if(frWindow.content != undefined){
			initFileBrowser();
			clearInterval(waiter);
		}
	}
	
	public function attachWindow(){
		frWindow = mx.managers.PopUpManager.createPopUp(tl, Window, true, {closeButton:true, title:titleWindow, contentPath:"fileUpload_mc"});
		frWindow.move(xCoord, yCoord);
		
		var frWindowListener:Object = new Object();
		frWindowListener.click = function(whoSaid:Object) {
			whoSaid.target.deletePopUp();
		};
		
		frWindow.addEventListener("click", frWindowListener);

		waiter = setInterval(Delegate.create(this, waitForAttachedContent), 250);
	}
}