﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using EKETEAM.FrameWork;
using EKETEAM.Data;

/// <summary>
/// SiteInfo 的摘要说明
/// </summary>
public class SiteInfo
{
    #region 属性
    //所有栏目
    private DataTable _Columns;
    public DataTable Columns
    {
        get
        {
            if (_Columns == null)
            {
                string CacheName = "Site" + Pub.getSiteID() + "_Columns";
                //HttpRuntime.Cache.Remove(CacheName);
                _Columns = (DataTable)HttpRuntime.Cache.Get(CacheName);
                if (_Columns == null)
                {

                    _Columns = eOleDB.getDataTable("SELECT ColumnID,ParentColumnID,Type,MC,Url,Show,PX FROM eWeb_Columns where SiteID='" + Pub.getSiteID() + "' and delTag=0");// and Show=1
                    //HttpRuntime.Cache.Insert(CacheName, _Columns);
                    //eBase.Writeln("set Cache");
                }
                else
                {
                    //eBase.Writeln("get Cache");
                }
            }
            return _Columns;
        }
    }
    //所有分类
    private DataTable _Class;
    public DataTable Class
    {
        get
        {
            if (_Class == null)
            {
                string CacheName = "Site" + Pub.getSiteID() + "_Class";
                //HttpRuntime.Cache.Remove(CacheName);
                _Class = (DataTable)HttpRuntime.Cache.Get(CacheName);
                if (_Class == null)
                {

                    _Class = eOleDB.getDataTable("SELECT ClassID,ColumnID,ParentClassID,MC,Show,PX FROM eWeb_Class where SiteID='" + Pub.getSiteID() + "' and delTag=0");// and Show=1
                    //HttpRuntime.Cache.Insert(CacheName, _Class);
                    //eBase.Writeln("set Cache");
                }
                else
                {
                    //eBase.Writeln("get Cache");
                }
            }
            return _Class;
        }
    }

    //所有广告
    private DataTable _Ads;
    public DataTable Ads
    {
        get
        {
            if (_Ads == null)
            {
                string CacheName = "Site" + Pub.getSiteID() + "_Ads";
                //HttpRuntime.Cache.Remove(CacheName);
                _Ads = (DataTable)HttpRuntime.Cache.Get(CacheName);
                if (_Ads == null)
                {

                    _Ads = eOleDB.getDataTable("SELECT AdsID, SiteID, Type, ColumnIDS, MC, PIC, URL, Show, PX FROM eWeb_Ads where Show=1 and SiteID='" + Pub.getSiteID() + "' and delTag=0");
                    //HttpRuntime.Cache.Insert(CacheName, _Ads);
                    //eBase.Writeln("set Cache");
                }
                else
                {
                    //eBase.Writeln("get Cache");
                }
            }
            return _Ads;
        }
    }
    //漂浮广告
    public string MoveAds
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='1' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"moveads\">");
                if (drs[0]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[0]["url"].ToString() + "\" title=\"" + drs[0]["MC"].ToString() + "\" target=\"_blank\">");
                sb.Append("<img src=\"" + drs[0]["pic"].ToString() + "\" alt=\"" + drs[0]["MC"].ToString() + "\">");
                if (drs[0]["url"].ToString().Length > 0) sb.Append("</a>\r\n");
                sb.Append("</div>\r\n");
                sb.Append("<script src=\"Plugins/eAds/moveads/moveads.js?beacon=7\"></script>");

            }
            return sb.ToString();
        }
    }
    //顶部广告
    public string TopAds
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='2' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"topads\">");
                for (int i = 0; i < drs.Length; i++)
                {
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[i]["url"].ToString() + "\" title=\"" + drs[i]["MC"].ToString() + "\" target=\"_blank\">");
                    sb.Append("<img src=\"" + drs[i]["pic"].ToString() + "\" alt=\"" + drs[i]["MC"].ToString() + "\">");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("</a>\r\n");
                }

                sb.Append("</div>\r\n");

            }
            return sb.ToString();
        }
    }
    //居中广告
    public string MiddleAds
    {
        get
        {
            int w = 980;
            int h = 216;

            StringBuilder sb = new StringBuilder();
            sb.Append("<div id=\"ads\">\r\n");
            DataRow[] drs = Ads.Select("Type='3' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length == 1)
            {
                if (drs[0]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[0]["url"].ToString() + "\" title=\"" + drs[0]["MC"].ToString() + "\" target=\"_blank\">");
                sb.Append("<img src=\"" + drs[0]["pic"].ToString() + "\" width=\"" + w.ToString() +  "\" height=\"" + h.ToString() + "\" alt=\"" + drs[0]["MC"].ToString() + "\">");
                if (drs[0]["url"].ToString().Length > 0) sb.Append("</a>\r\n");
            }
            else
            { 
                sb.Append("<div class=\"w_ctr\">\r\n");
                sb.Append("<div class=\"JQ-slide\">\r\n");
                sb.Append("<ul class=\"JQ-slide-content\">\r\n");
                for (int i = 0; i < drs.Length; i++)
                {
                    sb.Append("<li>");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[i]["url"].ToString() + "\" title=\"" + drs[i]["MC"].ToString() + "\" target=\"_blank\">");
                    sb.Append("<img src=\"" + drs[i]["pic"].ToString() + "\" width=\"" + w.ToString() + "\" height=\"" + h.ToString() + "\" alt=\"" + drs[i]["MC"].ToString() + "\">");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("</a>");
                    sb.Append("</li>\r\n");
                }
                sb.Append("</ul>\r\n");
                sb.Append("<ul class=\"JQ-slide-nav\">\r\n");
                 for (int i = 0; i < drs.Length; i++)
                {
                     sb.Append("<li" + (i==0 ? " class=\"on\"" : "") + ">" + (i+1).ToString() + "</li>\r\n");
                }
                sb.Append("</ul>\r\n");
                sb.Append("</div>\r\n");
                sb.Append("</div>\r\n");

                sb.Append("<script>\r\n");
                sb.Append("$(function (){\r\n");
                sb.Append("$(\".w_ctr .JQ-slide\").Slide({\r\n");
                sb.Append("effect:\"scroolX\",\r\n");
                sb.Append("speed:\"normal\",\r\n");
                sb.Append("timer:4000\r\n");
                sb.Append("});\r\n");
                sb.Append("});\r\n");
                sb.Append("</script>\r\n");
            }
            
            sb.Append("</div>\r\n");
            return sb.ToString();
        }
    }
    //居中广告 - FLASH版
    public string MiddleAds_Flash
    {
        get
        {
            int w = 980;
            int h = 216;
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='3' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"ads\">");
                if (drs[0]["pic"].ToString().ToLower().IndexOf(".swf") > -1)
                {
                    sb.Append("<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" id=\"scriptmain\" name=\"scriptmain\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0\" width=\"" + w.ToString() + "\" height=\"" + h.ToString() + "\">\r\n"); //  title=\"FLASH广告位\"
                    sb.Append("<param name=\"movie\" value=\"" + drs[0]["pic"].ToString() + "\" />\r\n");
                    sb.Append("<param name=\"quality\" value=\"high\" />\r\n");
                    sb.Append("<param name=\"scale\" value=\"noscale\" />\r\n");
                    sb.Append("<param name=\"allowFullScreen\" value=\"true\" />\r\n");
                    sb.Append("<param name=\"LOOP\" value=\"false\" />\r\n");
                    sb.Append("<param name=\"menu\" value=\"false\" />\r\n");
                    sb.Append("<param name=\"wmode\" value=\"transparent\" />\r\n");
                    sb.Append("<embed src=\"" + drs[0]["pic"].ToString() + "\" width=\"" + w.ToString() + "\" height=\"" + h.ToString() + "\" loop=\"False\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" salign=\"T\" name=\"scriptmain\" menu=\"false\" allowFullScreen=\"true\" wmode=\"transparent\"></embed>\r\n");
                    sb.Append("</object>\r\n");
                    sb.Append("</div>\r\n");
                    return sb.ToString();
                }

                string images = "";
                string links = "";
                for (int i = 0; i < drs.Length; i++)
                {
                    if (i > 0)
                    {
                        images += "|";
                        links += "|";
                    }
                    images += drs[i]["pic"].ToString();
                    links += drs[i]["url"].ToString();
                }



                sb.Append("<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" id=\"scriptmain\" name=\"scriptmain\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0\" width=\"" + w.ToString() + "\" height=\"" + h.ToString() + "\">\r\n"); //  title=\"FLASH广告位\"
                sb.Append("<param name=\"movie\" value=\"images/focus.swf\" />\r\n");
                sb.Append("<param name=\"quality\" value=\"high\" />\r\n");
                sb.Append("<param name=\"scale\" value=\"noscale\" />\r\n");
                sb.Append("<param name=\"LOOP\" value=\"false\" />\r\n");
                sb.Append("<param name=\"menu\" value=\"false\" />\r\n");
                sb.Append("<param name=\"wmode\" value=\"transparent\" />\r\n");
                sb.Append("<param name=\"FlashVars\" value=\"bcastr_flie=" + images + "&bcastr_link=" + links + "\" />\r\n");
                sb.Append("<embed src=\"images/focus.swf\" FlashVars=\"bcastr_flie=" + images + "&bcastr_link=" + links + "\" width=\"" + w.ToString() + "\" height=\"" + h.ToString() + "\" loop=\"False\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" salign=\"T\" name=\"scriptmain\" menu=\"false\" wmode=\"transparent\"></embed>\r\n");
                sb.Append("</object>\r\n");
                sb.Append("</div>\r\n");

            }
            return sb.ToString();
        }
    }
    //左侧广告
    public string LeftAds
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='4' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"leftads\">");
                for (int i = 0; i < drs.Length; i++)
                {
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[i]["url"].ToString() + "\" title=\"" + drs[i]["MC"].ToString() + "\" target=\"_blank\">");
                    sb.Append("<img src=\"" + drs[i]["pic"].ToString() + "\" alt=\"" + drs[i]["MC"].ToString() + "\">");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("</a>\r\n");
                }


                sb.Append("</div>\r\n");

            }
            return sb.ToString();
        }
    }
    public string SubTopAds
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='5' and (ColumnIDS like '%-1%' or ',' + ColumnIDS + ',' like '%," + TopColumnID + ",%')", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"subtopads\">");
                if (drs[0]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[0]["url"].ToString() + "\" title=\"" + drs[0]["MC"].ToString() + "\" target=\"_blank\">");
                sb.Append("<img src=\"" + drs[0]["pic"].ToString() + "\" alt=\"" + drs[0]["MC"].ToString() + "\">");
                if (drs[0]["url"].ToString().Length > 0) sb.Append("</a>\r\n");

                /*
                for (int i = 0; i < drs.Length; i++)
                {
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[i]["url"].ToString() + "\" title=\"" + drs[i]["MC"].ToString() + "\" target=\"_blank\">");
                    sb.Append("<img src=\"" + drs[i]["pic"].ToString() + "\" alt=\"" + drs[i]["MC"].ToString() + "\">");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("</a>\r\n");
                }
                */

                sb.Append("</div>\r\n");

            }
            return sb.ToString();
        }
    }
    //手机端广告
    public string MobileAds
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Ads.Select("Type='6'", "PX,AdsID Desc");
            if (drs.Length > 0)
            {
                sb.Append("<div id=\"banner\">\r\n");
                sb.Append("<div class=\"flexslider\">\r\n");
                sb.Append("<ul class=\"slides\">\r\n");
                for (int i = 0; i < drs.Length; i++)
                {
                    sb.Append("<li>");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("<a href=\"" + drs[i]["url"].ToString() + "\" title=\"" + drs[i]["MC"].ToString() + "\" target=\"_blank\">");
                    sb.Append("<img src=\"../" + drs[i]["pic"].ToString() + "\" alt=\"" + drs[i]["MC"].ToString() + "\">");
                    if (drs[i]["url"].ToString().Length > 0) sb.Append("</a>");
                    sb.Append("</li>");
                }
                sb.Append("</ul>\r\n");
                sb.Append("</div>\r\n");
                sb.Append("<script type=\"text/javascript\">\r\n");
	            sb.Append("$(document).ready(function () {\r\n");
	            sb.Append("$('.flexslider').flexslider({\r\n");
	            sb.Append("controlNav: true,\r\n");
	            sb.Append("directionNav: false,\r\n");
	            sb.Append("animation: \"slide\"\r\n");
                //,manualControls: ".myflexslider .slidenav"
	            sb.Append("});\r\n");
	            sb.Append("});\r\n");
                sb.Append("</script>\r\n");
                sb.Append("</div>\r\n");
            }
            return sb.ToString();
        }
    }
    //顶级栏目编号
    private string _TopColumnID = "0";//首页默认
    public string TopColumnID
    {
        get { return _TopColumnID; }
        set { _TopColumnID = value; }
    }
    private string _ColumnName = "";
    public string ColumnName
    {
        get
        {
            if (_ColumnName.Length == 0 && ColumnID.Length > 0)
            {
                DataRow[] rows = Columns.Select("ColumnID='" + ColumnID + "'");
                if (rows.Length == 1) _ColumnName = rows[0]["MC"].ToString();
            }
            return _ColumnName;
        }
    }
    //当前栏目编号
    private string _ColumnID = "";
    public string ColumnID
    {
        get { return _ColumnID; }
        set 
        {
            _ColumnID = value;
            _TopColumnID = getTopColumnID(value);
        }
    }
    //顶级分类编号
    private string _TopClassID = "0";
    public string TopClassID
    {
        get { return _TopClassID; }
        set { _TopClassID = value; }
    }
    //当前分类编号
    private string _ClassID = "0";
    public string ClassID
    {
        get { return _ClassID; }
        set
        {
            _ClassID = value;
            _TopClassID = getTopClassID(value);
        }
    }
    //站点信息
    private DataRow _Site;
    public DataRow Site
    {
        get
        {
            if (_Site == null)
            {
                _Site = eOleDB.getDataTable("select * from eWeb_Sites where SiteID='" + Pub.getSiteID() + "'").Rows[0];
            }
            return _Site;
        }
    }
    //内容数据
    private DataRow _Data;
    public DataRow Data
    {
        get
        {
            if (_Data == null)
            {

            }
            return _Data;
        }
    }
    //网站名称
    private string _SiteName = "";
    public string SiteName
    {
        get 
        {
            if (_SiteName.Length == 0)
            {
                _SiteName =  Site["SiteName"].ToString();
            }
            return _SiteName;
        }
    }
    //当前位置
    public string mLink
    {
        get
        {
            DataRow dr;
            StringBuilder sb = new StringBuilder();
            sb.Append("<a href=\"Default.aspx\">首页</a>");
            if (TopColumnID != ColumnID)
            {
                sb.Append(" -> ");
                dr = Columns.Select("ColumnID='" + TopColumnID + "'")[0];
                sb.Append("<a href=\"" + getmhref(dr["ColumnID"].ToString(), "", dr["Type"].ToString(), "") + "\">" + dr["MC"].ToString() + "</a>");
            }

            sb.Append(" -> ");
            dr = Columns.Select("ColumnID='" + ColumnID + "'")[0];
            sb.Append("<a href=\"" + getmhref(dr["ColumnID"].ToString(), "", dr["Type"].ToString(), "") + "\">" + dr["MC"].ToString() + "</a>");
            if (TopClassID != "0")
            {
                DataRow _dr = Class.Select("show=1 and ClassID='" + TopClassID + "'")[0];
                sb.Append(" -> ");
                sb.Append("<a href=\"" + getmhref(dr["ColumnID"].ToString(), TopClassID, dr["Type"].ToString(), "") + "\">" + _dr["MC"].ToString() + "</a>");

            }
            if (ClassID != "0" && ClassID != TopClassID)
            {
                //DataRow _dr = Class.Select("show=1 and ClassID='" + ClassID + "'")[0];
                 DataRow[] drct = Class.Select("show=1 and ClassID='" + ClassID + "'");
                 if (drct.Length > 0)
                 {
                     DataRow _dr = drct[0];
                     sb.Append(" -> ");
                     sb.Append("<a href=\"" + getmhref(dr["ColumnID"].ToString(), ClassID, dr["Type"].ToString(), "") + "\">" + _dr["MC"].ToString() + "</a>");
                 }
            }

            //+ColumnID + ":::" + ClassID;
            return sb.ToString();
        }
    }
    public string Link
    {
        get
        {
            DataRow dr;
            StringBuilder sb = new StringBuilder();
            sb.Append("<a href=\"Default.aspx\">首页</a>");
            if (TopColumnID != ColumnID)
            {
                sb.Append(" -> ");
                dr = Columns.Select("ColumnID='" + TopColumnID + "'")[0];
                sb.Append("<a href=\"" + gethref(dr["ColumnID"].ToString(), "", dr["Type"].ToString(), "") + "\">" + dr["MC"].ToString() + "</a>");
                /*
                 if (dr["Type"].ToString() == "0")
                {
                    DataRow _dr = Columns.Select("ParentColumnID='" + TopColumnID + "'", "px,ColumnID")[0];
                    sb.Append("<a href=\"" + Pub.gethref(_dr["ColumnID"].ToString(), "", _dr["Type"].ToString(), "") + "\">" + dr["MC"].ToString() + "</a>");
                }
                else
                {
                    sb.Append("<a href=\"" + Pub.gethref(dr["ColumnID"].ToString(), "", dr["Type"].ToString(), "") + "\">" + dr["MC"].ToString() + "</a>");
                }
                 */
            }

            sb.Append(" -> ");          
            dr = Columns.Select("ColumnID='" + ColumnID + "'")[0];
            sb.Append("<a href=\"" + gethref(dr["ColumnID"].ToString(),"",dr["Type"].ToString(),"") + "\">" + dr["MC"].ToString() + "</a>");
            if (TopClassID != "0")
            {
                DataRow _dr = Class.Select("show=1 and ClassID='" + TopClassID + "'")[0];
                sb.Append(" -> ");
                sb.Append("<a href=\"" + gethref(dr["ColumnID"].ToString(), TopClassID, dr["Type"].ToString(), "") + "\">" + _dr["MC"].ToString() + "</a>");

            }
            if (ClassID != "0" && ClassID!=TopClassID)
            {
                //DataRow _dr = Class.Select("show=1 and ClassID='" + ClassID + "'")[0];
                DataRow[] drct = Class.Select("show=1 and ClassID='" + ClassID + "'");
                if (drct.Length > 0)
                {
                    DataRow _dr = drct[0];
                    sb.Append(" -> ");
                    sb.Append("<a href=\"" + gethref(dr["ColumnID"].ToString(), ClassID, dr["Type"].ToString(), "") + "\">" + _dr["MC"].ToString() + "</a>");
                }
            }

            //+ColumnID + ":::" + ClassID;
            return sb.ToString();
        }
    }
    //网站标题
    private string _Title = "";
    public string Title
    {
        get
        {
            if (_Title.Length == 0)
            {
                _Title = BT + SiteName;
            }
            return _Title;
        }
        set
        {
            _Title = value;
        }
    }
    //内容标题
    private string _BT = "";
    public string BT
    {
        get
        {
            return _BT;
        }
        set
        {
            _BT = value;
        }
    }
    //版权信息
    private string _State = ""; 
    public string State
    {
        get
        {
            if (_State.Length == 0)
            {
                _State = Site["State"].ToString();
            }
            return _State;
        }
    }
    //关健词
    private string _KeyWords = ""; 
    public string KeyWords
    {
        get
        {            
            return _KeyWords;
        }
    }
    //描述
    private string _Description = ""; 
    public string Description
    {
        get
        {
            return _Description;
        }
    }
    private string _ID;
    public string ID
    {
        get
        {
            if (_ID == null)
            {
                _ID = eParameters.QueryString("id");
            }
            return _ID;
        }
    }
    private string _PID;
    public string PID
    {
        get
        {
            if (_PID == null)
            {
                _PID = eParameters.QueryString("pid");
                if (_PID.Length == 0) _PID = "0";
            }
            return _PID;
        }
    }
    #endregion    
    private string getTopColumnID(string ColumnID)
    {
      
        DataRow[] dr = Columns.Select("ColumnID='" + ColumnID + "'");
        if (dr.Length == 0) return ColumnID;
        if (dr[0]["ParentColumnID"].ToString() == "0" || dr[0]["ParentColumnID"].ToString().Length==0)
        {
            return ColumnID;
        }
        else
        {
            return dr[0]["ParentColumnID"].ToString();
        }
    }
    private string getTopClassID(string ClassID)
    {
       
        if (ClassID == "0" || ClassID.Length == 0) return "0";

        DataRow[] dr = Class.Select("show=1 and ClassID='" + ClassID + "'");
        if (dr.Length == 0) return "0";
        if (dr[0]["ParentClassID"].ToString() == "0" || dr[0]["ParentClassID"].ToString().Length == 0)
        {
            return ClassID;
        }
        else
        {
            return dr[0]["ParentClassID"].ToString();
        }
    }
	public SiteInfo()
	{
       // Title = "OK" + PID;

        string file = eBase.getAspxFileName().ToLower();
        DataTable tb = new DataTable();
        if (file == "content.aspx" || file == "mcontent.aspx" || file.IndexOf("s.aspx") > -1)
        {
            tb = eOleDB.getDataTable("select *,'" + PID + "' as ClassID from eWeb_Columns where ColumnID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
            if(tb.Rows.Count>0)  BT = tb.Rows[0]["MC"].ToString() + "-";
        }
        else
        {           

            switch (file)
            {
                case "article.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Articles where ArticleID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "marticle.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Articles where ArticleID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "product.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Products where ProductID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "mproduct.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Products where ProductID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "video.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Videos where VideoID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "mvideo.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Videos where VideoID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "case.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Cases where CaseID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "mcase.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Cases where CaseID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "picture.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Pictures where PictureID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "mpicture.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Pictures where PictureID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
                case "resume.aspx":
                    tb = eOleDB.getDataTable("select * from eWeb_Jobs where JobID='" + ID + "' and SiteID='" + Pub.getSiteID() + "' and delTag=0 ");
                    break;
            }           
        }
        if (tb.Rows.Count > 0)
        {
            _Data = tb.Rows[0];
            ColumnID = _Data["ColumnID"].ToString();
            if(_Data["ClassID"].ToString().Length >0) ClassID = _Data["ClassID"].ToString();

            _KeyWords = _Data["KeyWords"].ToString();
            _Description = _Data["Description"].ToString();
        }
        else
        {
            _KeyWords = Site["KeyWords"].ToString();
            _Description = Site["Description"].ToString();
        }
	}
    //主导航菜单
    public string mMeun
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] dr = Columns.Select("show=1 and ParentColumnID='0'", "px,ColumnID");
            sb.Append("<ul id=\"menu\">\r\n");

            sb.Append("<li><a href=\"Default.aspx\"" + (TopColumnID == "0" ? " class=\"cur\"" : "") + "><span>首页</span></a></li>\r\n");
            for (int i = 0; i < dr.Length; i++)
            {
                /*
                if (dr[i]["Type"].ToString() == "0")
                {
                    DataRow[] rows = Columns.Select("show=1 and ParentColumnID='" + dr[i]["ColumnID"].ToString() + "'", "px,ColumnID");
                    if (rows.Length > 0)
                    {
                        sb.Append("<li class=\"top\"><a href=\"" + getmhref(rows[0]["ColumnID"].ToString(), "", rows[0]["Type"].ToString(), rows[0]["url"].ToString()) + "&pid=0\" class=\"top_link" + (TopColumnID == rows[0]["ColumnID"].ToString() ? " cur" : "") + "\"><span>" + dr[i]["mc"].ToString() + "</span></a></li>\r\n");
                    }
                }
                else
                {
                    sb.Append("<li class=\"top\"><a href=\"" + getmhref(dr[i]["ColumnID"].ToString(), "", dr[i]["Type"].ToString(), dr[i]["url"].ToString()) + "\" class=\"top_link" + (TopColumnID == dr[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span>" + dr[i]["mc"].ToString() + "</span></a></li>\r\n");
                }
                */
                sb.Append("<li class=\"top\"><a href=\"" + getmhref(dr[i]["ColumnID"].ToString(), "", dr[i]["Type"].ToString(), dr[i]["url"].ToString()) + "\" class=\"top_link" + (TopColumnID == dr[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span>" + dr[i]["mc"].ToString() + "</span></a></li>\r\n");
            }
            sb.Append("</ul>\r\n");
            return sb.ToString();
        }
    }
    public string Menu
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] dr1, dr2, dr3, dr4;
            // eBase.Writeln(Columns.Rows.Count.ToString());
            //return "";
            dr1 = Columns.Select("show=1 and (ParentColumnID='0' or ParentColumnID is null)", "px,ColumnID");
            sb.Append("<ul id=\"menu\">\r\n");
            sb.Append("<li class=\"top\"><a href=\"Default.aspx\" class=\"top_link" + (TopColumnID == "0" ? " cur" : "") + "\"><span>首页</span></a></li>\r\n");
            for (int i = 0; i < dr1.Length; i++)
            {
                dr2 = Columns.Select("show=1 and ParentColumnID='" + dr1[i]["ColumnID"].ToString() + "' ", "px,ColumnID");


                if (dr2.Length == 0)//无子栏目
                {

                    #region 显示分类
                    dr3 = Class.Select("show=1 and ColumnID='" + dr1[i]["ColumnID"].ToString() + "' and ParentClassID='0'", "px,ClassID");
                    if (dr3.Length == 0)//无子栏目、无分类
                    {
                        sb.Append("<li class=\"top\"><a href=\"" + gethref(dr1[i]["ColumnID"].ToString(), "", dr1[i]["Type"].ToString(), dr1[i]["url"].ToString()) + "\" class=\"top_link" + (TopColumnID == dr1[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span>" + dr1[i]["mc"].ToString() + "</span></a></li>\r\n");
                    }
                    else//有分类
                    {

                        sb.Append("<li class=\"top\"><a href=\"" + gethref(dr1[i]["ColumnID"].ToString(), "", dr1[i]["Type"].ToString(), dr1[i]["url"].ToString()) + "\" class=\"top_link" + (TopColumnID == dr1[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span class=\"down\">" + dr1[i]["mc"].ToString() + "</span></a>\r\n");
                        sb.Append("<ul class=\"sub\">\r\n");
                        for (int j = 0; j < dr3.Length; j++)//循环一级分类
                        {

                            //二级分类
                            dr4 = Class.Select("ParentClassID='" + dr3[j]["ClassID"].ToString() + "' and ColumnID='" + dr1[i]["ColumnID"].ToString() + "'", "px,ClassID");
                            if (dr4.Length == 0)//只有一级分类
                            {
                                sb.Append("<li><a href=\"" + gethref(dr1[i]["ColumnID"].ToString(), dr3[j]["ClassID"].ToString(), dr1[i]["Type"].ToString(), dr1[i]["url"].ToString()) + "\">" + dr3[j]["mc"].ToString() + "</a></li>\r\n");
                            }
                            else//有两级分类
                            {
                                sb.Append("<li><a href=\"" + gethref(dr1[i]["ColumnID"].ToString(), dr3[j]["ClassID"].ToString(), dr1[i]["Type"].ToString(), dr1[i]["url"].ToString()) + "\" class=\"fly\">" + dr3[j]["mc"].ToString() + "</a>\r\n");
                                sb.Append("<ul>\r\n");
                                for (int k = 0; k < dr4.Length; k++)
                                {
                                    sb.Append("<li><a href=\"" + gethref(dr1[i]["ColumnID"].ToString(), dr4[k]["ClassID"].ToString(), dr1[i]["Type"].ToString(), dr1[i]["url"].ToString()) + "\">" + dr4[k]["mc"].ToString() + "</a></li>\r\n");
                                }
                                sb.Append("</ul>\r\n");
                                sb.Append("</li>\r\n");
                            }
                        }
                        sb.Append("</ul>\r\n");
                        sb.Append("</li>\r\n");

                    }
                    #endregion
                }
                else//有子栏目
                {
                    #region 循环子栏目
                    sb.Append("<li class=\"top\"><a href=\"Parents.aspx?id=" + dr1[i]["ColumnID"].ToString() + "\" class=\"top_link" + (TopColumnID == dr1[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span class=\"down\">" + dr1[i]["mc"].ToString() + "</span></a>\r\n");
                    //sb.Append("<li class=\"top\"><a href=\"" + gethref(dr2[0]["ColumnID"].ToString(), "", dr2[0]["Type"].ToString(), dr2[0]["url"].ToString()) + "\" class=\"top_link" + (TopColumnID == dr1[i]["ColumnID"].ToString() ? " cur" : "") + "\"><span class=\"down\">" + dr1[i]["mc"].ToString() + "</span></a>\r\n");
                    sb.Append("<ul class=\"sub\">\r\n");
                    for (int j = 0; j < dr2.Length; j++)
                    {
                        //一级分类
                        dr3 = Class.Select("ParentClassID=0 and ColumnID='" + dr2[j]["ColumnID"].ToString() + "'", "px,ClassID");

                        if (dr3.Length == 0)//无分类
                        {
                            sb.Append("<li><a href=\"" + gethref(dr2[j]["ColumnID"].ToString(), "", dr2[j]["Type"].ToString(), dr2[j]["url"].ToString()) + "\">" + dr2[j]["mc"].ToString() + "</a></li>\r\n");
                        }
                        else//有分类
                        {
                            sb.Append("<li><a href=\"" + gethref(dr2[j]["ColumnID"].ToString(), "", dr2[j]["Type"].ToString(), dr2[j]["url"].ToString()) + "\" class=\"fly\">" + dr2[j]["mc"].ToString() + "</a>");
                            sb.Append("<ul>\r\n");
                            for (int k = 0; k < dr3.Length; k++)//循环一级分类
                            {
                                //二级分类

                                dr4 = Class.Select("ParentClassID='" + dr3[k]["ClassID"].ToString() + "' and ColumnID='" + dr2[j]["ColumnID"].ToString() + "'", "px,ClassID");
                                if (dr4.Length == 0)//只有一级分类
                                {
                                    sb.Append("<li><a href=\"" + gethref(dr2[j]["ColumnID"].ToString(), dr3[k]["ClassID"].ToString(), dr2[j]["Type"].ToString(), dr2[j]["url"].ToString()) + "\">" + dr3[k]["mc"].ToString() + "</a></li>\r\n");
                                }
                                else//有两级分类
                                {
                                    sb.Append("<li><a href=\"" + gethref(dr2[j]["ColumnID"].ToString(), dr3[k]["ClassID"].ToString(), dr2[j]["Type"].ToString(), dr2[j]["url"].ToString()) + "\" class=\"fly\">" + dr3[k]["mc"].ToString() + "</a>");
                                    sb.Append("<ul>\r\n");
                                    for (int m = 0; m < dr4.Length; m++)
                                    {
                                        sb.Append("<li><a href=\"" + gethref(dr2[j]["ColumnID"].ToString(), dr4[m]["ClassID"].ToString(), dr2[j]["Type"].ToString(), dr2[j]["url"].ToString()) + "\">" + dr4[m]["mc"].ToString() + "</a></li>\r\n");
                                    }
                                    sb.Append("</ul>\r\n");
                                    sb.Append("</li>\r\n");
                                }
                            }
                            sb.Append("</ul>\r\n");
                            sb.Append("</li>\r\n");
                        }
                    }
                    sb.Append("</ul>\r\n");
                    sb.Append("</li>\r\n");
                    #endregion
                }
                //sb.Append(dr1[i]["mc"].ToString() + "::");
            }
            //sb.Append("LitMenu" + Columns.Rows.Count.ToString() + "::" + dr1.Length.ToString());
            sb.Append("</ul>\r\n");
            return sb.ToString();
        }

    }
    //子菜单
    public string mSubMenu
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            /*
            string showmenu = eParameters.QueryString("menu");
            if (showmenu.Length > 0)
            {
                DataRow[] rows = Columns.Select("show=1 and ParentColumnID='" + TopColumnID + "'", "px,ColumnID");
                #region 显示栏目
                sb.Append("<ul class=\"subchannellist\">\r\n");
                for (int i = 0; i < rows.Length; i++)
                {
                    sb.Append("<li><a href=\"" + getmhref(rows[i]["ColumnID"].ToString(), "", rows[i]["Type"].ToString(), rows[i]["url"].ToString()) + "&menu=1\"" + (ColumnID == rows[i]["ColumnID"].ToString() ? " class=\"cur\"" : "") + ">" + rows[i]["mc"].ToString() + "</a></li>\r\n");
                }
                sb.Append("</ul>\r\n");
                return sb.ToString();
                #endregion                
            }
            */
            DataRow[] drs = Columns.Select("show=1 and ParentColumnID='" + ColumnID + "'", "px,ColumnID");
            if (drs.Length == 0 && ColumnID != TopColumnID)
            {
                DataRow[] _drs = Class.Select("show=1 and ColumnID='" + ColumnID + "'");
                if (_drs.Length == 0)
                {
                    drs = Columns.Select("show=1 and ParentColumnID='" + TopColumnID + "'", "px,ColumnID");
                    #region 显示栏目
                    sb.Append("<ul class=\"subchannellist\">\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" +  getmhref(drs[i]["ColumnID"].ToString(), "", drs[i]["Type"].ToString(), drs[i]["url"].ToString()) + "\"" + (ColumnID == drs[i]["ColumnID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                    return sb.ToString();
                    #endregion
                }
            }
            if (drs.Length > 0) //显示栏目
            {
                #region 显示栏目
                sb.Append("<ul class=\"subchannellist\">\r\n");
                for (int i = 0; i < drs.Length; i++)
                {
                    sb.Append("<li><a href=\"" + getmhref(drs[i]["ColumnID"].ToString(), "", drs[i]["Type"].ToString(), drs[i]["url"].ToString()) + "\">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                }
                sb.Append("</ul>\r\n");
                return sb.ToString();
                #endregion
            }
            else //显示分类
            {
                #region 显示分类
                DataRow dr = Columns.Select("ColumnID='" + ColumnID + "'")[0];
                drs = Class.Select("show=1 and ColumnID='" + ColumnID + "'");
                if (drs.Length == 0) return "";//无分类
                if (ClassID == "0")//输出一级分类    
                {
                    drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='0'", "px,ColumnID");
                    sb.Append("<ul class=\"subchannellist\">\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + getmhref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");

                    return sb.ToString();
                }
                //DataRow _dr = Class.Select("show=1 and ClassID='" + ClassID + "'")[0];
                DataRow[] drct = Class.Select("show=1 and ClassID='" + ClassID + "'");
                if (drct.Length == 0) return "";
                DataRow _dr = drct[0];
                drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='" + ClassID + "'", "px,ColumnID");
                if (drs.Length == 0 && _dr["ParentClassID"].ToString() == "0")  //输出一级分类
                {
                    drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='0'", "px,ColumnID");
                    sb.Append("<ul class=\"subchannellist\">\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + getmhref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");

                }
                else //输出二级分类
                {

                    if (drs.Length == 0) drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='" + TopClassID + "'", "px,ColumnID");


                    sb.Append("<ul class=\"subchannellist\">\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + getmhref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                }
                return sb.ToString();
                #endregion
            } 

        }
    }
    public string SubMenu
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataRow[] drs = Columns.Select("show=1 and ParentColumnID='" + ColumnID + "'", "px,ColumnID");
            if (drs.Length == 0 && ColumnID != TopColumnID)
            {
                DataRow[] _drs = Class.Select("show=1 and ColumnID='" + ColumnID + "'");
                if (_drs.Length == 0)
                {
                    drs = Columns.Select("show=1 and ParentColumnID='" + TopColumnID + "'", "px,ColumnID");
                    #region 显示栏目
                    sb.Append("<div id=\"submenu\">\r\n");
                    sb.Append("<span>" + Columns.Select("ColumnID='" + TopColumnID + "'")[0]["MC"].ToString() + "</span>\r\n");
                    sb.Append("<ul>\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + gethref(drs[i]["ColumnID"].ToString(), "", drs[i]["Type"].ToString(), drs[i]["url"].ToString()) + "\"" + (ColumnID == drs[i]["ColumnID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                    sb.Append("</div>\r\n");
                    return sb.ToString();
                    #endregion
                }
            }
            if (drs.Length > 0) //显示栏目
            {
                #region 显示栏目
                sb.Append("<div id=\"submenu\">\r\n");
                sb.Append("<span>" + Columns.Select("ColumnID='" + ColumnID + "'")[0]["MC"].ToString()+ "</span>\r\n");
                sb.Append("<ul>\r\n");
                for (int i = 0; i < drs.Length; i++)
                {
                    sb.Append("<li><a href=\"" + gethref(drs[i]["ColumnID"].ToString(), "", drs[i]["Type"].ToString(), drs[i]["url"].ToString()) + "\">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                }
                sb.Append("</ul>\r\n");
                sb.Append("</div>\r\n");
                return sb.ToString();
                #endregion
            }
            else //显示分类
            {
                #region 显示分类
             
                DataRow dr = Columns.Select("ColumnID='" + ColumnID + "'")[0];
                drs = Class.Select("show=1 and ColumnID='" + ColumnID + "'");
                if (drs.Length == 0) return "";//无分类
                if (ClassID == "0")//输出一级分类    
                {
                    drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='0'", "px,ColumnID");
                    sb.Append("<div id=\"submenu\">\r\n");
                    sb.Append("<span>" + dr["MC"].ToString() + "</span>\r\n");
                    sb.Append("<ul>\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + gethref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                    sb.Append("</div>\r\n");
                    return sb.ToString();
                }
                //eBase.Writeln(ClassID);
                //eBase.End();

                //DataRow _dr = Class.Select("show=1 and ClassID='" + ClassID + "'")[0];
                DataRow[] drct = Class.Select("show=1 and ClassID='" + ClassID + "'");
                if (drct.Length == 0) return "";
                DataRow _dr = drct[0];

                drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='" + ClassID + "'", "px,ColumnID");
                if (drs.Length == 0 && _dr["ParentClassID"].ToString() == "0")  //输出一级分类
                {
                    drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='0'", "px,ColumnID");

                    sb.Append("<div id=\"submenu\">\r\n");
                    sb.Append("<span>" + dr["MC"].ToString() + "</span>\r\n");        
                    sb.Append("<ul>\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + gethref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                    sb.Append("</div>\r\n");
                }
                else //输出二级分类
                {
                    #region 二级分类
                    sb.Append("<div id=\"submenu\">\r\n");
                    if (drs.Length == 0)
                    {
                        drs = Class.Select("show=1 and ColumnID='" + ColumnID + "' and ParentClassID='" + TopClassID + "'", "px,ColumnID");
                        sb.Append("<span>" + Class.Select("show=1 and ClassID='" + TopClassID + "'")[0]["MC"].ToString() + "</span>\r\n");
                    }
                    else
                    {
                        sb.Append("<span>" + Class.Select("show=1 and ClassID='" + ClassID + "'")[0]["MC"].ToString() + "</span>\r\n");
                    }
                   
                    
                    sb.Append("<ul>\r\n");
                    for (int i = 0; i < drs.Length; i++)
                    {
                        sb.Append("<li><a href=\"" + gethref(dr["ColumnID"].ToString(), drs[i]["ClassID"].ToString(), dr["Type"].ToString(), dr["url"].ToString()) + "\"" + (ClassID == drs[i]["ClassID"].ToString() ? " class=\"cur\"" : "") + ">" + drs[i]["mc"].ToString() + "</a></li>\r\n");
                    }
                    sb.Append("</ul>\r\n");
                    sb.Append("</div>\r\n");
                    #endregion
                }
                return sb.ToString();
                #endregion
            }           
        }
    }
    public string ServiceOnline
    {
        get
        {
            StringBuilder sb = new StringBuilder();
            DataTable tb = eOleDB.getDataTable("select mc,qq from  eWeb_ServicesOnlines where SiteID=" + Pub.getSiteID() + " and show=1 and delTag=0 order by px,ServicesOnlineID");
            if (tb.Rows.Count > 0)
            {
                sb.Append("<div id=\"ServiceOnline\" style=\"display:none;\">\r\n");
                sb.Append("<div class=\"top\"><a class=\"close\" href=\"javascript:void();\" onclick=\"closeService();\"><img src=\"images/none.gif\" /></a></div>\r\n");
                //sb.Append("<div class=\"top\"><a class=\"close\" src=\"images/none.gif\" onclick=\"closeService();\" /></a></div>\r\n");

                sb.Append("<div class=\"bg\">\r\n");
                sb.Append("<div class=\"middle\">\r\n");
                for (int i = 0; i < tb.Rows.Count; i++)
                {
                    //sb.Append("<a href=\"tencent://message/?uin=" + tb.Rows[i]["qq"].ToString() + "&Site=" + "Pub.getSiteName()" + "&Menu=yes\" target=\"_blank\"><img src=\"images/webqq/qq.gif\" alt=\"" + tb.Rows[i]["mc"].ToString() + "\" align=\"absmiddle\">&nbsp;" + tb.Rows[i]["mc"].ToString() + "</a>\r\n");
                    sb.Append("<a href=\"tencent://message/?uin=" + tb.Rows[i]["qq"].ToString() + "&Site=" + SiteName + "&Menu=yes\" target=\"_blank\"><img src=\"http://wpa.qq.com/pa?p=1:" + tb.Rows[i]["qq"].ToString() + ":4\" alt=\"" + tb.Rows[i]["mc"].ToString() + "\" align=\"absmiddle\">&nbsp;" + tb.Rows[i]["mc"].ToString() + "</a>\r\n");
                }
                sb.Append("</div>\r\n");
                sb.Append("</div>\r\n");

                sb.Append("<div class=\"bottom\"></div>\r\n");


                sb.Append("</div>\r\n");
            }
            return sb.ToString();
        }
    }

    public string gethref(string id, string pid, string type, string url)
    {
        if (url.Length > 0) return url + "\" target=\"_blank\"";
        string temp = "";
        switch (type)
        {
            case "0"://父栏目
                temp = "Parents.aspx?id=" + id;
                break;
            case "1"://单页文章
                temp = "Content.aspx?id=" + id;
                break;
            case "2"://文章列表
                temp = "Articles.aspx?id=" + id;
                break;
            case "3"://产品展示
                temp = "Products.aspx?id=" + id;
                break;
            case "4"://图片展示
                temp = "Pictures.aspx?id=" + id;
                break;
            case "5"://案例展示
                temp = "Cases.aspx?id=" + id;
                break;
            case "6"://视频展示
                temp = "Videos.aspx?id=" + id;
                break;
            case "7"://在线留言
                temp = "GuestBooks.aspx?id=" + id;
                break;
            case "8"://下载栏目
                temp = "DownLoads.aspx?id=" + id;
                break;
            case "9"://媒体栏目
                temp = "Medias.aspx?id=" + id;
                break;
            case "10"://招聘栏目
                temp = "Jobs.aspx?id=" + id;
                break;
        }
        if (pid.Length > 0) temp += "&pid=" + pid;
        return temp;
    }
    public string getmhref(string id, string pid, string type, string url)
    {
        if (url.Length > 0) return url + "\" target=\"_blank\"";
        string temp = "";
        switch (type)
        {
            case "0"://父栏目
                temp = "Parents.aspx?id=" + id;
                /*
                DataRow[] rows = Columns.Select("show=1 and ParentColumnID='" + id + "'", "px,ColumnID");
                if (rows.Length == 0)
                {
                    temp= "javascript:;";
                }
                else
                {
                    temp= getmhref(rows[0]["ColumnID"].ToString(), "", rows[0]["Type"].ToString(), rows[0]["url"].ToString()) + "&menu=1";
                }
                */
                break;
            case "1"://单页文章
                temp = "Content.aspx?id=" + id;
                break;
            case "2"://文章列表
                temp = "Articles.aspx?id=" + id;
                break;
            case "3"://产品展示
                temp = "Products.aspx?id=" + id;
                break;
            case "4"://图片展示
                temp = "Pictures.aspx?id=" + id;
                break;
            case "5"://案例展示
                temp = "Cases.aspx?id=" + id;
                break;
            case "6"://视频展示
                temp = "Videos.aspx?id=" + id;
                break;
            case "7"://在线留言
                temp = "GuestBooks.aspx?id=" + id;
                break;
            case "8"://下载栏目
                temp = "DownLoads.aspx?id=" + id;
                break;
            case "9"://媒体栏目
                temp = "Medias.aspx?id=" + id;
                break;
            case "10"://招聘栏目
                temp = "Jobs.aspx?id=" + id;
                break;
        }
        if (pid.Length > 0) temp += "&pid=" + pid;
        return temp;
    }
}
