﻿function postComment(targetCommentId) {
    $('#submit-' + targetCommentId).attr('href', 'javascript:;');
    postJson('/Articles/Comments', {
        ArticleId: $('#articleId').val(),
        CContent: $('#comment-content-' + targetCommentId).val(),
        VerificationCode: $('#comment-content-' + targetCommentId).parent().find('.verificationCode').val(),
        TargetCommentId: targetCommentId
    },
        function (response) {
            if (response.Success) {
                $('.comment-content').val('');
                $('#comment-content-' + targetCommentId).val('');
                successMessage($('#comment-message-' + targetCommentId), '提交成功');
                if (targetCommentId == 0) {
                    if ($('.comment-list').length > 0) {
                        $('.comment-list ul:eq(0)').prepend('<li class="comment-list-item-parent">' + response.Message + '<li>');
                    } else {
                        $('.comments').append('<div class="comment-list"><ul class=\"comment-list-parent\"><li class="comment-list-item-parent">' + response.Message + '</li></ul></div>');
                    }
                } else {
                    if ($('#comment-list-dateinfo-' + targetCommentId).parent().find('ul:eq(0)').length > 0) {
                        $('#comment-list-dateinfo-' + targetCommentId).parent().find('ul:eq(0)').prepend(response.Message);
                    } else {
                        $('#comment-list-dateinfo-' + targetCommentId).parent().append('<ul>' + response.Message + '</ul>');
                    }
                }
            } else {
                failMessage($('#comment-message-' + targetCommentId), response.Message);
            }
            resetImage();
            $('#submit-' + targetCommentId).attr('href', 'javascript:postComment(' + targetCommentId + ');');
        },
        function () {
            failMessage($('#comment-message-' + targetCommentId), '未知错误');
            resetImage();
            $('#submit-' + targetCommentId).attr('href', 'javascript:postComment(' + targetCommentId + ');');
        });
}

function reply(targetCommentId) {
    closeReply();
    $('#comment-content-0').hide();
    $('.submit-container').hide();
    var html = '<div class="comment-target"><textarea id="comment-content-' + targetCommentId + '"></textarea><span class="comment-message" id="comment-message-' + targetCommentId + '"></span> <img class="verificationCodeImage" src="/Utility/VerificationCodeImage?rnd=' + Math.random() + '" /> <input type="text" id="verificationCode" class="verificationCode" /> <a href="javascript:postComment(' + targetCommentId + ');" class="submit-target">提交</a> <a href="javascript:closeReply();" class="submit-target">关闭</a></div>';
    $('#comment-list-dateinfo-' + targetCommentId).append(html);
}

function closeReply() {
    $('.comment-target').remove();
    $('#comment-content-0').show();
    $('.submit-container').show();
    resetImage();
}
function resetImage() {
    if ($('.comment-target').length > 0) {
        $('.verificationCode').val('');
        $('.comment-target .verificationCodeImage').attr('src', '/Utility/VerificationCodeImage?rnd=' + Math.random());
    } else {
        $('.verificationCode').val('');
        $('.verificationCodeImage').attr('src', '/Utility/VerificationCodeImage?rnd=' + Math.random());
    }
}