/*
 * Copyright (c) 2009, www.jc001.cn! All rights reserved.
 * Switch images
 *
 * description : ͼƬֻ
 * web         : http://www.jc001.cn
 * author      : stcer (ab12cxyh@163.com)
 * version     : 0.1.0 
 */
 
var IMGSwitch = IMGSwitch || function(options){
	this.setOptions(options);
}

IMGSwitch.prototype = {
	w : 210,
	h : 140,
	pause : 5000,
	wrap : null,
	cnter : null,
	index : 0,
	ttlcname : 'isttl',
	disttl : false,
	setwp : true,
	
	setOptions: function(options) {
		this.extend(this, options || {});
	},
	
	extend : function(destination, source) {
		for (var property in source) {
			destination[property] = source[property];
		}
		return destination;
	},
	
	run : function(){
	
		this.wrap = this.ge(this.wrap);
		if(!this.wrap){
			return false;
		}
		
		if(!this.cnter){
			this.cnter = this.wrap;
		}else{
			this.cnter = this.ge(this.cnter);
		}
		
		// array : img, link, title
		this.imgs = [];
		this.ttls = [];
        this.links = [];
		this.rels = [];
		var imgs = this.cnter.getElementsByTagName('img');
		if(imgs.length == 0){
			return;	
		}
		
		for(var i=0; i < imgs.length; i++){
			this.ttls[i] = imgs[i].alt;
            this.imgs[i] = imgs[i].src;
		}
		
		var links = this.cnter.getElementsByTagName('a');
		for(var i=0; i < links.length; i++){
			this.links[i] = links[i].href;
            this.rels[i] = links[i].rel;
		}
		
		// imglink, img, num
		this.wrap.innerHTML = '';
		if(this.setwp){
			this.wrap.style.position = 'relative';
		}
		this.wrap.style.width = this.w + 'px';
		
		this.imglink = this.wrap.appendChild(document.createElement('a'));
        this.imglink.target = '_blank';
        this.imglink.href = this.links[0];
        if(this.rels[0]){
            this.imglink.rel = this.rels[0];
        }
        
		this.img = this.imglink.appendChild(document.createElement('img'));
		this.img.style.filter = 'progid:dximagetransform.microsoft.wipe(gradientsize=1.0,wipestyle=4, motion=forward)';
		this.img.style.width = this.w + 'px';
		this.img.style.height = this.h + 'px';
		this.img.src = this.imgs[0];
		
		this.nums = this.wrap.appendChild(document.createElement('div'));
		with(this.nums){
			className = 'num';
			style.position = 'absolute';
			style.right = '5px';
			style.top = (this.h - 25) + 'px';
		}
		var _n, _this = this;
		for(var i = 0; i < this.imgs.length; i++){
			_n = document.createElement('a');
			_n.innerHTML = i + 1;
			_n.onmouseover = _n.onclick = function(){
				_this.setIndex(parseInt(this.innerHTML) - 1);
				_this.show();
			}
			this.cssNum(_n);
			this.nums.appendChild(_n);
		}
		
		if(!this.disttl){
			var ttl = this.wrap.appendChild(document.createElement('div'));
			ttl.className = this.ttlcname;
			this.ttl = ttl.appendChild(document.createElement('a'));
			this.ttl.innerHTML = this.ttls[0];
		}else{
			this.ttl = null;	
		}
		
		if(this.onload && typeof(_this.onload) == 'function'){
			this.onload();
		}
		this.start();
	},
	
	start : function(){
		var _this = this;
		this.clearTimer();
		this.timer = setTimeout(function(){
			_this.setIndex(_this.index + 1); 
			if(_this.onstart && typeof(_this.onstart) == 'function'){
				_this.onstart();
			}
			_this.show();
			if(_this.onstop && typeof(_this.onstop) == 'function'){
				_this.onstop();
			}
		}, this.pause);
	},
	
	clearTimer : function(){
		clearTimeout(this.timer);
	},
	
	show : function(){
		if(document.all){
            this.img.filters[0].Apply();
            this.img.filters[0].Play(duration=2);
        }
		
		var crt = this.index;
		this.imglink.href = this.links[crt];
        if(this.rels[crt]){
            this.imglink.rel = this.rels[crt];
        }
		this.img.src = this.imgs[crt];
		if(this.ttl){
			this.ttl.innerHTML = this.ttls[crt];
		}
		for(var i = 0; i < this.nums.childNodes.length; i++){
			if(this.nums.childNodes[i].className == 'on'){
				this.nums.childNodes[i].className= '';
				this.cssNum(this.nums.childNodes[i]);
			}
		}
		this.nums.childNodes[crt].className = 'on';
		this.cssNumOn(this.nums.childNodes[crt]);
		this.start();
	},
	
	setIndex : function(i){
		this.index = i;
		if(this.index >= this.imgs.length){
			this.index = 0;
		}	
	},

	ge: function (id) {
		return "string" == typeof id ? document.getElementById(id) : id;
	},
	
	cssNum : function(n){
		with(n.style){
			color = '#FF7300';
			textAlign = 'center';
			lineHeight = '16px';
			width = '16px';
			height = '16px';
			fontFamily = 'Arial';
			fontSize = '12px';
			cursor = 'pointer';
			overflow = 'hidden';
			margin = '3px 1px';
			padding = '0 4px';
			border = '1px solid #FF7300';
			backgroundColor = '#fff';
		}
	},
	
	cssNumOn : function(n){
		with(n.style){
			color = '#fff';
			lineHeight = '21px';
			width = '21px';
			height = '21px';
			fontSize = '16px';
			margin = '0 1px';
			border = '0';
			backgroundColor = '#FF7300';
			fontWeight = 'bold';
		}
	}
};
