
var WXShare = (function($){
    var F = function(callback, configUrl, pageUrl){
        this.configUrl = configUrl ? configUrl : 'http://wm.jc001.cn/js_config.php';
        this.pageUrl = pageUrl ? pageUrl : document.location.href;
        this.callback = callback ? callback : function(){};
    };

    F.prototype = {
        ready : function(info, apiList){
            if(typeof wx == 'undefined'){
                return;
            }

            if(!apiList){
                apiList = [
                    'onMenuShareTimeline',
                    'onMenuShareAppMessage',
                    'onMenuShareQZone',
                    'onMenuShareQQ'
                ];
            }

            var that = this;
            this._config(function(){
                wx.ready(function(){
                    that._initShare(info, apiList);
                })
            }, apiList);
        },

        _initShare : function(info, apiList) {
            var that = this;
            apiList.forEach(function(item, index){
                wx[item]({
                    title: info.title,
                    link: info.link,
                    desc: info.desc,
                    imgUrl: info.img,
                    success: function () {
                        that.callback(index, info);
                    },
                    cancel: function () {
                        console.log('cancel share')
                    }
                });
            });
        },

        _config : function(callback, apiList){
            $.getJSON(this.configUrl, {url: this.pageUrl}, function(rs){
                if(rs.code != 200){
                    console.log(rs);
                    return;
                }
                var info = rs.data;
                var api = $.extend([], apiList);
                wx.config({
                    appId : info.appId,
                    nonceStr : info.nonceStr,
                    timestamp : info.timestamp,
                    signature : info.signature,
                    jsApiList : api});
                wx.error(function(res){
                    console.log('has error');
                    console.log(res);
                });
                callback();
            }, 'jsonp')
        }
    };

    return F;
})($);


