﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="PromotionOrder.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.PromotionOrder"
    Title="推广订单管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<style type="text/css">
#AdminTabs a {
      min-width:53px;
}
</style>
 <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnSureOrder" />> 
                        <asp:LinkButton ID="LinkUnSureOrder" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>未确认</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnPayOrder" />>   
                        <asp:LinkButton ID="LinkUnPay" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>未付款</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnPayFinish" />>    
                        <asp:LinkButton ID="LinkUnPayFinish" runat="server" CommandArgument="6" onclick="ShowBookmarks"><span>未付清</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnSend" />>    
                        <asp:LinkButton ID="LinkUnSend" runat="server" CommandArgument="7" onclick="ShowBookmarks"><span>未送货</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnSign" />>    
                        <asp:LinkButton ID="LinkUnSign" runat="server" CommandArgument="8" onclick="ShowBookmarks"><span>未签收</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnFinish" />>    
                        <asp:LinkButton ID="LinkUnFinish" runat="server" CommandArgument="11" onclick="ShowBookmarks"><span>未结清</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="Ltrzf" />>    
                        <asp:LinkButton ID="Linkzf" runat="server" CommandArgument="16" onclick="ShowBookmarks"><span>已作废</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrStop" />>                        
                        <asp:LinkButton ID="LinkStop" runat="server" CommandArgument="17" onclick="ShowBookmarks"><span>暂停处理</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrSend" />>    
                        <asp:LinkButton ID="LinkSend" runat="server" CommandArgument="13" onclick="ShowBookmarks"><span>已发货</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrSign" />>    
                        <asp:LinkButton ID="LinkSign" runat="server" CommandArgument="14" onclick="ShowBookmarks"><span>已签收</span></asp:LinkButton> 
                    </li>
                      <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrFinish" />>    
                        <asp:LinkButton ID="LinkFinish" runat="server" CommandArgument="12" onclick="ShowBookmarks"><span>已结清</span></asp:LinkButton> 
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="GdvPromotionOrder" runat="server" AutoGenerateColumns="False"
        DataSourceID="OdsOrder" DataKeyNames="OrderId" OnRowDataBound="GdvPromotionOrder_RowDataBound"
        AllowPaging="True" OnDataBound="GdvPromotionOrder_DataBound" ItemName="订单" ItemUnit="个"
        EmptyDataText="没有任何符合条件的订单！" AutoGenerateCheckBoxColumn="False" ShowFooter="True"
        CheckBoxFieldHeaderWidth="3%" SerialText="" RowDblclickBoundField="OrderId" RowDblclickUrl="../Shop/OrderManage.aspx?OrderID={$Field}">
        <Columns>
            <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <a href=' <%#string.Format("../Shop/OrderManage.aspx?OrderID={0}",Eval("OrderId")) %>'>
                        <%#Eval("OrderNum")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="下单时间" SortExpression="InputTime">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <%# Eval("InputTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="客户名称" SortExpression="ClientName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='<%#string.Format("../Crm/ClientShow.aspx?ClientID={0}",Eval("ClientID")) %>'>
                        <%#Eval("ClientName")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="推广人" SortExpression="PromotionUser">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='<%#string.Format("../User/UserShow.aspx?UserName={0}",Server.UrlEncode(Convert.ToString(Eval("PromotionUser")))) %>'>
                        <%#Eval("PromotionUser")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单金额" >
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="70px" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderMoney" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="佣金金额" >
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="70px" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblCommission" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单状态">
                <HeaderStyle Width="60px" />
                <ItemTemplate>
                   <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="付款状态">
                <HeaderStyle Width="60px" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblPayStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="物流状态">
                <HeaderStyle Width="60px" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server" ForeColor="AliceBlue" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
        <FooterStyle CssClass="tdbg" />
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnOrderType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsOrder" runat="server" SelectCountMethod="GetTotalOfPromotionOrder"
        SelectMethod="GetPromotionOrderInfoList" TypeName="PowerEasy.Module.Promotion.BusinessLogic.PromotionOrder" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnOrderType" Type="Int32" Name="orderType" PropertyName="Value" />
            <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="ListType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyWord" QueryStringField="KeyWord"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource> 
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        <a>订单管理</a>
        <span class="right-line"></span></dt>  
        <dd class="prompt-note-con">
          <p>
           <li>订单金额只统计该订单中所有推广商品的金额统计。</li>
           <li>如果普通管理员要进行推广订单处理，必须要拥有订单处理权限。</li>
        </p>
        </dd>   
        <div class="clearbox"></div>
        </dl>
    </div>
</asp:Content>
