﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="RegisterCommission.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.RegisterCommission"
    Title="注册推广佣金明细管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" OnClick="ShowBookmarks"><span>所有状态</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrGathered" />>
                        <asp:LinkButton ID="LinkGathered" runat="server" CommandArgument="2" OnClick="ShowBookmarks"><span>已提现</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnGather" />>
                        <asp:LinkButton ID="LinkUnGather" runat="server" CommandArgument="1" OnClick="ShowBookmarks"><span>未提现</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvRegister" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsSearch" IsHoldState="True" SerialText=""
        AutoGenerateCheckBoxColumn="False" DataKeyNames="ID" ShowFooter="True" OnRowDataBound="EgvRegister_RowDataBound"
        OnDataBound="EgvRegister_DataBound">
        <Columns>
             <pe:TemplateField HeaderText="推广人">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                  <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'><%# Eval("UserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
             <pe:TemplateField HeaderText="注册会员名">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                  <a href='../User/UserShow.aspx?UserName=<%#Eval("RegisterUserName") %>'><%# Eval("RegisterUserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="RegisterIP" HeaderText="注册IP" SortExpression="RegisterIP" />
            <pe:TemplateField HeaderText="注册时间">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <%# Eval("RegisterTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="佣金">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# Eval("Commission", "{0:N}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:TemplateField HeaderText="状态">
                <ItemTemplate>
                    <pe:ExtendedLabel ID="ELblState" HtmlEncode="false" runat="server" Text="未提现">
                    </pe:ExtendedLabel>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <FooterStyle CssClass="tdbg" />
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnCommissionStatus" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsSearch" runat="server" SelectMethod="GetRegisterCommissionInfoList" EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId"
        TypeName="PowerEasy.Module.Promotion.BusinessLogic.RegisterPromotionManage" SelectCountMethod="GetTotalOfRegisterPromotion">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnCommissionStatus" Name="commissionStatus" PropertyName="Value"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="listType"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="" Name="keyWord" QueryStringField="keyWord"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
