﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/Guide.master"
    CodeBehind="CategoryGuide.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.RedirectUrl.RedirectCategoryGuide"
    Title="转向链接类别管理向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="server">
    转向链接类别管理
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="server">
    <div class="guideexpand" onclick="Switch(this)">
        管理操作</div>
    <div class="guide">
        <ul>
            <li><a href="CategoryManage.aspx" target="main_right">链接类别管理</a></li>
            <li><a href="Category.aspx?Action=Add" target="main_right">添加链接类别</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        链接查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px">
                    <option value="1">ID</option>
                    <option value="2" selected="selected">类别名称</option>
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="return OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">
        function OpenMainRight() {
            var field = 0;
            var keyword = document.getElementById("TxtKeyWord").value.trim();
            var objSel = document.getElementById("SelField");

            if (keyword == "") {
                alert("请输入要查询的条件！");
                return false;
            }
            field = objSel.options[objSel.options.selectedIndex].value;

            if (field == "1") {
                if (checknumber(keyword)) {
                    alert("只允许输入数字！");
                    return false;
                }
            }

            var url = "CategoryManage.aspx?ListType=" + field + "&KeyWord=" + escape(keyword);
            JumpToMainRight(url);
        }

        function checknumber(String) {
            var Letters = "1234567890";
            var i;
            var c;
            for (i = 0; i < String.length; i++) {
                c = String.charAt(i);
                if (Letters.indexOf(c) == -1) {
                    return true;
                }
            }
            return false;
        } 
    </script>

</asp:Content>
