﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    CodeBehind="RedirectUrlManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.RedirectUrl.RedirectUrlManage"
    Title="转向链接信息管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvRedirectUrlManage" runat="server" AllowPaging="True"
        AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
        DataSourceID="OdsRedirectUrlManage" DataKeyNames="Id" IsHoldState="True" OnRowCommand="EgvRedirectUrlManage_RowCommand"
        SerialText="" RowDblclickBoundField="id" RowDblclickUrl="RedirectUrl.aspx?Action=Modify&amp;ID={$Field}">
        <Columns>
            <pe:BoundField DataField="Id" HeaderText="ID" SortExpression="Id">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="链接名称" SortExpression="UrlName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='<%#Eval("UrlValue") %>' target='_blank'>
                         <%# PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("UrlName"))%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="所属类别" SortExpression="CategoryName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='RedirectUrlManage.aspx?CategoryId=<%#Eval("CategoryId") %>'>
                        <%# GetCategoryName((int)Eval("CategoryId"))%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="链接地址" SortExpression="UrlValue">
                <ItemTemplate>
                    <textarea rows='1' cols='20' readonly='readonly' class='inputtext' onclick='copyToClipboard(this);'
                        title='点击即可复制链接' style='height: 18px; width: 98%;'><%# FullBasePath + "go.aspx?uid=" + Eval("UrlId")%></textarea>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ELbtnView" IsChecked="true" OperateCode="RedirectUrl" href='<%# "RedirectUrlShow.aspx?Id=" + Eval("id")%>'
                        runat="server">
                        查看页面</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ELbtnModify" IsChecked="true" OperateCode="RedirectUrl" href='<%# "RedirectUrl.aspx?Action=Modify&Id=" + Eval("id")%>'
                        runat="server">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ELbtnDelete" Text="删除" IsChecked="true" OperateCode="RedirectUrl"
                        OnClientClick="return confirm('是否删除此链接吗？')" runat="server" CommandArgument='<%# Bind("id") %>'
                        CommandName="Del" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsRedirectUrlManage" runat="server" SelectCountMethod="GetTotalOfRedirectUrl"
        SelectMethod="GetRedirectUrlList" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.RedirectUrl"
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="categoryID" QueryStringField="CategoryID"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="ListType"
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <table border='0' cellpadding="0" cellspacing="0" width='100%'>
        <tr>
            <td>
                &nbsp;
            </td>
        </tr>
        <tr>
            <td>
                <asp:Button ID="BtnDelect" runat="server" Text="批量删除选定转向链接" CausesValidation="False"
                    OnClientClick="return confirm('确实要删除选中的转向链接？');" OnClick="BtnDelect_OnClick" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function copyToClipboard(obj) {
            var txt = obj.value;
            if (window.clipboardData) {
                window.clipboardData.clearData();
                window.clipboardData.setData("Text", txt);
                alert("调用代码已经成功的复制到了剪贴板！");
            } else if (navigator.userAgent.indexOf("Opera") != -1) {
                window.location = txt;
            } else if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                } catch (e) {
                    alert("被浏览器拒绝！\n请在浏览器地址栏输入'about:config'并回车\n然后将'signed.applets.codebase_principal_support'设置为'true'");
                }
                var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
                if (!clip)
                    return;
                var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
                if (!trans)
                    return;
                trans.addDataFlavor('text/unicode');
                var str = new Object();
                var len = new Object();
                var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                var copytext = txt;
                str.data = copytext;
                trans.setTransferData("text/unicode", str, copytext.length * 2);
                var clipid = Components.interfaces.nsIClipboard;
                if (!clip)
                    return false;
                clip.setData(trans, null, clipid.kGlobalClipboard);
                alert("调用代码已经成功的复制到了剪贴板！");
            }
        }
    
    </script>
</asp:Content>
