﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" AutoEventWireup="true"
    CodeBehind="AdministratorGuide.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.AdministratorGuide"
    Title="管理员管理向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="server">
    管理员管理
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="server">
    <div class="guideexpand" onclick="Switch(this)">
        管理员管理</div>
    <div class="guide">
        <ul>
            <li><a href="AdministratorManage.aspx" target="main_right">管理员管理</a></li>
            <li><a href="Administrator.aspx" target="main_right">添加管理员</a> </li>
            <li><a href="AdministratorImport.aspx" target="main_right">批量导入管理员</a> </li>
        </ul>
    </div>
    <div class="guidecollapse" onclick="Switch(this)">
        按角色查询</div>
    <div class="guide" style="display:none">
        <ul>
            <asp:Repeater ID="RptRoles" runat="server">
                <ItemTemplate>
                    <li><a href="AdministratorManage.aspx?RoleId=<%# Eval("RoleId") %>" target="main_right">
                        <%# Eval("RoleName")%></a></li>
                </ItemTemplate>
            </asp:Repeater>
        </ul>
    </div>
    <div class="guidecollapse" onclick="Switch(this)">
        按部门查看</div>
    <div style="display: none">
        <table>
            <tr>
                <td align="left">
                    <pe:XLoadTree ID="XLoadTreeCategory" RootIcon="WebSite" runat="server">
                    </pe:XLoadTree>
                </td>
            </tr>
        </table>
    </div>
    <div class="guidecollapse" onclick="Switch(this)">
        快速查找</div>
    <div class="guide" style="display: none">
        <ul>
            <li><a href="AdministratorManage.aspx?ListType=1" target="main_right">最近一个月未修改密码管理员</a></li>
            <li><a href="AdministratorManage.aspx?ListType=2" target="main_right">最近24小时内登录的管理员</a></li>
            <li><a href="AdministratorManage.aspx?ListType=3" target="main_right">所有被锁住的管理员</a></li>
            <li><a href="AdministratorManage.aspx?ListType=4" target="main_right">允许多人登录管理员</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        管理员查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px">
                    <option value="5">管理员ID</option>
                    <option value="6" selected="selected">管理员名字</option>
                    <option value="7">前台用户名字</option>
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="return OpenMainRight()" />
            </li>
        </ul>
    </div>
    <script type="text/javascript">
        function OpenMainRight() {
            var field = 0;
            var keyword = document.getElementById("TxtKeyWord").value.trim();
            var objSel = document.getElementById("SelField");

            if (keyword == "") {
                alert("请输入要查询的条件！");
                return false;
            }
            field = objSel.options[objSel.options.selectedIndex].value;

            if (field == "5") {
                if (checknumber(keyword)) {
                    alert("只允许输入数字！");
                    return false;
                }
            }

            var url = "AdministratorManage.aspx?ListType=" + field + "&KeyWord=" + escape(keyword) + "&ListText=" + escape(objSel.options[objSel.options.selectedIndex].text);
            JumpToMainRight(url);
        }
        function checknumber(String) {
            var Letters = "1234567890";
            var i;
            var c;
            for (i = 0; i < String.length; i++) {
                c = String.charAt(i);
                if (Letters.indexOf(c) == -1) {
                    return true;
                }
            }
            return false;
        } 
    </script>
</asp:Content>
