﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.User.PaymentLogManage" Title="在线支付记录管理"
    Codebehind="PaymentLogManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnSubmit" />>
                        <asp:LinkButton ID="LinkUnSubmit" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>未提交</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnSuccess" />>    
                       <asp:LinkButton ID="LinkUnSuccess" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>未成功</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitSuccess" />>    
                       <asp:LinkButton ID="LinkSuccess" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>成功</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="GdvPaymentLogList" runat="server" AutoGenerateCheckBoxColumn="True"
        DataSourceID="OdsPaymentLog" DataKeyNames="PaymentLogId" OnRowCommand="GdvPaymentLogList_RowCommand"
        AutoGenerateColumns="False" AllowPaging="True" OnRowDataBound="GdvPaymentLogList_RowDataBound"
        HorizontalAlign="Center" CheckBoxFieldHeaderWidth="3%" SerialText=""
         RowDblclickBoundField="PaymentLogID" RowDblclickUrl="PaymentLogDetail.aspx?PaymentLogID={$Field}">
        <Columns>
            <pe:BoundField DataField="PaymentNum" HeaderText="支付序号" SortExpression="PaymentNum"
                >
                <HeaderStyle Width="14%" />
            </pe:BoundField>
             <pe:TemplateField HeaderText="用户名">
                 <HeaderStyle Width="8%" />
                <ItemTemplate>
                   <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'><%#Eval("UserName") %></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="支付平台">
                <ItemTemplate>
                    <asp:Label ID="LblPlatform" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="交易时间" SortExpression="PayTime">
                <HeaderStyle Width="16%" />
                <ItemTemplate>
                    <%# Eval("PayTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="汇款金额" SortExpression="MoneyPay">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyPay", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="实际转账金额" SortExpression="MoneyTrue">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyTrue", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="交易状态">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:Label ID="LblStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="PaymentLogManage" ID="LbtnDelete"
                        OnClientClick="return confirm('确定要删除此记录吗？');" runat="server" CommandName="Delete"
                        CommandArgument='<%# Eval("PaymentLogID") %>' Text="删除" Visible='<%# (int)Eval("Status") == 1 ? true : false%>' />
                    <a href='<%#string.Format("PaymentLogDetail.aspx?PaymentLogID={0}",Eval("PaymentLogID"))%>'>
                        查看</a>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="PaymentLogManage" ID="LbtnStatus"
                        runat="server" CommandName="Status" CommandArgument='<%# Eval("PaymentLogID") %>'
                        Visible='<%# (int)Eval("Status") == 1 ? true : false%>' Text="成功" />
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="OnsignmentList" ID="LbtSendGood" runat="server" Text="发货" 
                    PostBackUrl="" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="hdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsPaymentLog" runat="server" SelectCountMethod="GetTotalOfPaymentLog"
        SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.PaymentLog" DeleteMethod="Delete"
        EnablePaging="true" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <DeleteParameters>
            <asp:Parameter Name="paymentLogId" Type="String" />
        </DeleteParameters>
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
            <asp:ControlParameter ControlID="hdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <pe:ExtendedButton IsChecked="true" OperateCode="PaymentLogManage" ID="BtnDelete"
        runat="server" Text="删除选中的记录" OnClick="BtnDelete_Click" OnClientClick="return batchconfirm('确定要删除记录吗？');" />
    <br />
    <table width="100%" cellpadding="5" cellspacing="0" class="border">
        <tr class="tdbg">
            <td align="right" style="width: 10%;">
                时间范围：
            </td>
            <td align="left" style="width: 55%;">
                <asp:RadioButtonList ID="RadlDatepartType" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Value="0" Selected="True">10天前</asp:ListItem>
                    <asp:ListItem Value="1">1个月前</asp:ListItem>
                    <asp:ListItem Value="2">2个月前</asp:ListItem>
                    <asp:ListItem Value="3">3个月前</asp:ListItem>
                    <asp:ListItem Value="4">6个月前</asp:ListItem>
                    <asp:ListItem Value="5">1年前</asp:ListItem>
                </asp:RadioButtonList></td>
            <td align="left">
                <asp:Button ID="BtnBatchDelete" runat="server" OnClientClick="return confirm('确实要删除有关记录吗？')"
                    Text="删除" OnClick="BtnBatchDelete_Click" CausesValidation="False" /></td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        </dt>
            <dd class="prompt-note-con">
                  <li>对于一些交易未成功的支付记录，可以删除一定时间段前的记录以加快速度。</li>
                  <li>对于支付宝担保交易的支付方式，可以在这里同步支付宝确认发货，慎重操作。</li>
            </dd>  
        </dl>
    </div>
</asp:Content>
