﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="WorkManage.aspx.cs" ValidateRequest="false" Inherits="PowerEasy.Module.General.WebSite.Admin.Work.WorkManageUI" Title="表单数据管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <div style="padding-top: 5px;">
    </div>
    <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
        <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteContentList" />>
                    <asp:LinkButton ID="LinkContentList" runat="server"   CommandArgument="100"
                        onclick="ShowBookmarks"><span>所有表单数据</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteDraft" />> 
                    <asp:LinkButton ID="LinkDraft" runat="server"  CommandArgument="-1"
                        onclick="ShowBookmarks"><span>草稿</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="ElitePending" />>    
                    <asp:LinkButton ID="LinkPending" runat="server" CommandArgument="101"
                        onclick="ShowBookmarks"><span>待审核</span></asp:LinkButton> 
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteAudited" />>
                    <asp:LinkButton ID="LinkAudited"  CommandArgument="99"  runat="server" 
                        onclick="ShowBookmarks"><span>已审核</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteTuigao" />>
                    <asp:LinkButton ID="LinkTuigao" CommandArgument="-2" runat="server" 
                        onclick="ShowBookmarks"><span>退稿</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteRecycle" />>
                    <asp:LinkButton ID="LinkRecycle" CommandArgument="-3" runat="server" 
                        onclick="ShowBookmarks"><span>回收站</span></asp:LinkButton></li>
                </ul>
            </td>
            <td align="right">
                排序方式：
                <asp:DropDownList ID="DropRescentQuery" AutoPostBack="true" OnSelectedIndexChanged="DropSelectedIndex_Changed"
                    runat="server">
                    <asp:ListItem Value="-1">按ID降序</asp:ListItem>
                    <asp:ListItem Value="-2">按ID升序</asp:ListItem>
                </asp:DropDownList>
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvContent" runat="server" DataSourceID="OdsContents" SerialText=""
        AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" AllowPaging="True"
        OnRowDataBound="EgvContent_RowDataBound" OnRowCommand="EgvContent_RowCommand"
        DataKeyNames="WorkId" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="WorkId" HeaderText="ID" SortExpression="WorkId">
                <HeaderStyle Width="5%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="标题" SortExpression="WorkName">
                <ItemTemplate>
                    <pe:LinkImage ID="LinkImageModel" runat="server">
                        <pe:ExtendedHyperLink ID="LnkNodeLink" runat="server" />
                        <asp:HyperLink ID="HypTitle" runat="server" />
                    </pe:LinkImage>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="状态" SortExpression="Status">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <asp:Label ID="LabStatusName" runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="常规管理操作" SortExpression="Disabled">
                <ItemTemplate>
                    <asp:HyperLink ID="ContentModify" runat="server" />
                    <asp:LinkButton ID="ContentRestore" Visible="false" runat="server" />
                    <asp:LinkButton ID="ContentDelete" runat="server" />
                </ItemTemplate>
                <HeaderStyle Width="12%" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
    <asp:HiddenField ID="HdnStatus" runat="server" Value="100" />
    <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
    <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
    <asp:ObjectDataSource ID="OdsContents" runat="server" SelectMethod="GetWorkList"
        TypeName="PowerEasy.Module.General.BusinessLogic.Work.WorkManage" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
        StartRowIndexParameterName="startRowIndexId" SelectCountMethod="GetTotalOfWorkInfo">
        <SelectParameters>
            <asp:QueryStringParameter Name="workCategoryId" QueryStringField="cid" Type="Int32" />
            <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="sortType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchField"
                PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
        for="ChkAll">选中本页显示的所有项目</label>
    <asp:Button ID="EBtnBatchDelete" Text="批量删除" CommandName="D" OnClientClick="return batchconfirm('确定要删除选中的项目吗？本操作把选中的表单数据移到回收站中。必要时您可从回收站中恢复！');"
        OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
    <asp:Button ID="EBtnPass" Text="审核通过" runat="server" OnClick="EBtnPass_Click" />
    <asp:Button ID="EBtnCancelPass" Text="取消审核" runat="server" OnClick="EBtnCancelPass_Click" />
    <asp:Button ID="EBtnRestore" Text="批量还原" runat="server" OnClick="EBtnRestore_Click" />

    <br />
    <br />
    <table style="width: 100%;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td style="width: 80px" align="left" class="tdbg">
                <b>搜索选项：</b>
            </td>
            <td class="tdbg">
                <asp:DropDownList ID="DrpSearchType" runat="server">
                    <asp:ListItem Value="WorkID" Text="ID" />
                    <asp:ListItem Value="WorkName" Text="标题" />
                </asp:DropDownList>
                <asp:TextBox ID="TxtSearchKeyword" runat="server" />
                <asp:Button ID="BtnSearch" runat="server" OnClick="BtnSearch_Click" Text="搜索" />&nbsp;
            </td>
        </tr>
    </table>
</asp:Content>
