﻿<%@ Page Language="C#" Inherits="PowerEasy.Foundation.Web.UI.DynamicPage"%>
<%@ Import Namespace="PowerEasy.Foundation" %>
<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Module.Shop.Model" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        string payOnlineShopID;
        string PayOnlineKey;

        int payPlatformId = 6;  //易付通
        PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payPlatform = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
        if (payPlatform.IsDisabled || payPlatform.MD5 == "3069" || string.IsNullOrEmpty(payPlatform.MD5))
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo;
            return;
        }
              
        payOnlineShopID = payPlatform.AccountsId;
        PayOnlineKey = payPlatform.MD5;
        
       string  v_mid = payOnlineShopID;
       string  v_oid = Request["bid"].Trim();       //支付订单号
       string v_sid = Request["sid"].Trim();         //易付通交易成功 流水号
       string v_md5 = Request["md"].Trim();      //数字签名
       string v_amount = Request["prc"].Trim();       //支付金额
       string v_pstatus = Request["success"].Trim();       //支付状态
       string v_pmode = Request["bankcode"].Trim();       //支付银行
       string v_pstring = Request["v_pstring"].Trim();       //支付结果说明
        
       StringBuilder md5string = new StringBuilder();
        md5string.Append(PayOnlineKey);
         md5string.Append(":");
         md5string.Append(v_oid);
         md5string.Append(",");
         md5string.Append(v_sid);
         md5string.Append(",");
         md5string.Append(v_amount);
         md5string.Append(",sell,,");
         md5string.Append(v_mid);
         md5string.Append(",bank,");
        md5string.Append(v_pstatus);
        string md5 = PowerEasy.Framework.Common.DataCrypto.MD5(md5string.ToString());
        
        bool paySuccess = false;
        if(v_md5.ToUpper() == md5.ToUpper() && v_pstatus.ToLower() == "true")
        {
            paySuccess =  true;
        }
        if(paySuccess)
        {
            StringBuilder msg = new StringBuilder();
            msg.Append(Resources.DynamicPageResources.PayOnline_PayResultXpay_ToPayYes);
            PowerEasy.Module.Shop.BusinessLogic.PayOnline payOnline = new PowerEasy.Module.Shop.BusinessLogic.PayOnline();
            PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState payOnlineState = payOnline.UpdateOrder(v_oid, PowerEasy.Framework.Common.DataConverter.ToDecimal(v_amount), v_pstring, 3, v_pmode, true, true);
            if (payOnlineState == PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState.Ok)
            {
                msg.Append(payOnline.Message);
            }
            else
            {
                msg.Append(PowerEasy.Module.Shop.BusinessLogic.PayOnline.GetStateDescription(payOnlineState));
            }
            LblMsg.Text = msg.ToString();  
        }
        else
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResultXpay_MD5Err;
        }
        PowerEasy.Module.Shop.BusinessLogic.PayOnline.TestLog(false, Resources.DynamicPageResources.PayOnline_PayResultXpay_FastToPay, v_pstatus.ToLower(), v_md5.ToUpper(), md5.ToUpper());
    }

    protected void BtnShowOrder_Click(object sender, EventArgs e)
    {
        int orderId = Convert.ToInt32(PEContext.Current.Context.Session["OrderID"]);
        if (orderId > 0)
        {
            if (PEContext.Current.User.Identity.IsAuthenticated)
            {
                DynamicResponseRedirect("../User/Shop/ShowOrder.aspx?OrderId=" + orderId.ToString());
            }
            else
            {
                OrderInfo orderInfo = Order.GetOrderById(orderId);
                DynamicResponseRedirect("OrderForm.aspx?OrderNum=" + orderInfo.OrderNum + "&Name=" + orderInfo.ContacterName);
            }
        }

    }

    protected void BtnReturn_Click(object sender, EventArgs e)
    {
        ShopConfig shopConfig = SiteConfig.ShopConfig;
        string returnUrl = shopConfig.AgainBuyUrl;
        if (string.IsNullOrEmpty(returnUrl))
        {
            returnUrl = "~/Category.aspx?id=4";
        }
        DynamicResponseRedirect(returnUrl);
    }

    protected void BtnGotoUserCenter_Click(object sender, EventArgs e)
    {
        DynamicResponseRedirect("~/User/Default.aspx");
    }

    protected void BtnShowPayRecord_Click(object sender, EventArgs e)
    {
        DynamicResponseRedirect("~/User/Info/PaymentLog.aspx");
    }
    
</script>
<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResultXpay_Page , 易付通 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <!--支付成功消息-->
    <div class="ebuycar_order">
        <div class="orderinfo_show">
            <ul class="ebuy_complete">
                <li><span class="p_orderform_mess">
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server" ></pe:ExtendedLabel>
                </span></li>
            </ul>
        </div>
        <div class="orderinfo_button">
            <asp:Button ID="BtnReturn" runat="server" OnClick="BtnReturn_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnReturn,返回商店首页 %>" />
            <asp:Button ID="BtnShowOrder" runat="server" OnClick="BtnShowOrder_Click" CssClass="inputbutton"
                Text="<%$ Res: Shop_OrderSuccess_BtnShowOrder,查看订单明细 %>" />
            <asp:Button ID="BtnShowPayRecord" runat="server" OnClick="BtnShowPayRecord_Click" CssClass="inputbutton"
            Text="查看支付明细" />
            <asp:Button ID="BtnGotoUserCenter" runat="server" OnClick="BtnGotoUserCenter_Click"
                CssClass="inputbutton" Text="<%$ Res: Shop_OrderSuccess_BtnGotoUserCenter,进入会员中心 %>" />
            <asp:HiddenField ID="HdnContacterName" runat="server" />
            <asp:HiddenField ID="HdnOrderNum" runat="server" />
        </div>
    </div>    
    </form>
</body>
</html>
