﻿/**
 * 通用辅助功能
 */
var Util = {};
/**
 * 居中元素于屏幕中间
 * 用法: Util.Layout.Center(obj, option)
 * obj 为需要居中的jQuery元素
 * option 可选参数有:
 * @param  {object} Main   相对居中的父元素, 默认为window
 * @param  {number} option 偏移量, 默认0
 */
Util.Layout = function() {
    return {
        Center: function(box, option) {
            var mainBox, cssT, cssL, st,
                cut = 0, t = 0, l = 0;
            if(option) {
                if(option.Main) {
                    mainBox = option.Main;
                    t = mainBox.offset().top;
                    l = mainBox.offset().left;
                } else {
                    mainBox = $(window);
                }
                if(option.Cut != undefined) {
                    cut = option.Cut;
                }
            } else {
                mainBox = $(window);
            }
            cssT = (mainBox.height() - box.height()) / 2 + cut + t;
            cssL = (mainBox.width() - box.width()) / 2 + cut + l;
            if(cssT < 0) {
                cssT = 0;
            }
            if(cssL < 0) {
                cssL = 0;
            }
            box.css({
                top: cssT,
                left: cssL
            });
        }
    }
}();
/**
 * 编码特殊字符, 一般用于ajax方法
 */
Util.htmlEncode = function (text) {
    var standard = function (text) {
        var span = $('<span>');
        span.html(text);
        return span.html();
    };
    var fix1 = (standard('\n').toLowerCase() == '<br>') ?
        function (text) {
            // #3874 IE and Safari encode line-break into <br>
            return standard(text).replace(/<br>/gi, '\n');
        } :
        standard;
    var fix2 = (standard('>') == '>') ?
        function (text) {
            // WebKit does't encode the ">" character, which makes sense, but
            // it's different than other browsers.
            return fix1(text).replace(/>/g, '&gt;');
        } :
        fix1;
    var fix3 = (standard('  ') == '&nbsp; ') ?
        function (text) {
            // #3785 IE8 changes spaces (>= 2) to &nbsp;
            return fix2(text).replace(/&nbsp;/g, ' ');
        } :
        fix2;
    this.htmlEncode = fix3;
    return this.htmlEncode(text);
};


/**
 * Cookies 插件
 */
;(function ($) {
    var pluses = /\+/g;
    function raw(s) {
        return s;
    }
    function decoded(s) {
        return decodeURIComponent(s.replace(pluses, ' '));
    }
    function converted(s) {
        if (s.indexOf('"') === 0) {
            // This is a quoted cookie as according to RFC2068, unescape
            s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
        }
        try {
            return config.json ? JSON.parse(s) : s;
        } catch(er) {}
    }

    var config = $.cookie = function (key, value, options) {
        // write
        if (value !== undefined) {
            options = $.extend({}, config.defaults, options);
            if (typeof options.expires === 'number') {
                var days = options.expires, t = options.expires = new Date();
                t.setDate(t.getDate() + days);
            }
            value = config.json ? JSON.stringify(value) : String(value);
            return (document.cookie = [
                config.raw ? key : encodeURIComponent(key),
                '=',
                config.raw ? value : encodeURIComponent(value),
                options.expires ? '; expires=' + options.expires.toUTCString() : '',
                options.path    ? '; path=' + options.path : '',
                options.domain  ? '; domain=' + options.domain : '',
                options.secure  ? '; secure' : ''
            ].join(''));
        }
        // read
        var decode = config.raw ? raw : decoded;
        var cookies = document.cookie.split('; ');
        var result = key ? undefined : {};
        for (var i = 0, l = cookies.length; i < l; i++) {
            var parts = cookies[i].split('=');
            var name = decode(parts.shift());
            var cookie = decode(parts.join('='));
            if (key && key === name) {
                result = converted(cookie);
                break;
            }
            if (!key) {
                result[name] = converted(cookie);
            }
        }
        return result;
    };
    config.defaults = {};
    $.removeCookie = function (key, options) {
        if ($.cookie(key) !== undefined) {
            $.cookie(key, '', $.extend({}, options, { expires: -1 }));
            return true;
        }
        return false;
    };
})(jQuery);


/**
 * PE库, 系统方法
 */
;(function($) {
    var PE = {};
    /**
     * 系统 ajax 方法
     * @param  {string} actionType accesslabel        : 访问标签, 
     *                             accesspage         : ?,
     *                             checkuserlogin     : 用户登录判断,
     *                             checkloginvalidate : 判断是否开启验证码,
     *                             logout             : 退出登录
     * @param  {object} option     ajax配置内容
     */
    PE.ajax = function (actionType, option) {
        if (typeof (actionType) != 'string' || actionType == 'undefind') return;
        var option = $.extend({
            url: siteSetup.ajaxPath,
            data: '',
            type: 'POST',
            dataType: 'xml',
            params: {}
        }, option),
        actionType = $.trim(actionType).toLowerCase(),
        data = "",
        paramToString = function (params, b) {
            var str = '', d;
            for (d in params) {
                if (b)
                    str += ('<attrib><' + d + '>' + Util.htmlEncode(params[d]) + '</' + d + '></attrib>');
                else
                    str += ('<' + d + '>' + Util.htmlEncode(params[d]) + '</' + d + '>')
            }
            return str;
        };

        switch (actionType) {
            case 'accesslabel':
                actionType = 'updatelabel';
                break;
            case 'accesspage':
                actionType = 'updatepage';
                break;
            case 'logincheck':
                actionType = 'logincheck';
                break;
            case 'checkloginvalidate':
                actionType = 'EnableValidCode';
                break;
            case 'logout':
                actionType = 'userlogout';
                break;
            default:
                break;
        }
        
        data = '<root><type>' + actionType + '</type>';
        switch (actionType) {
            case 'updatelabel':
                data += ('<labelname>' + option.labelName + '</labelname>')
                data += ('<currentpage>' + option.currentPage + '</currentpage>');
                data += paramToString(option.params, true);
                break;
            case 'updatepage':
                data += ('<labelname>' + option.labelName + '</labelname>');
                data += ('<sourcename>' + option.pageName + '</sourcename>');
                data += ('<pagesize>' + option.pageSize + '</pagesize>');
                data += ('<currentpage>' + option.currentPage + '</currentpage>');
                data += ('<total>' + option.recordCount + '</total>');
                break;
            default:
                data += paramToString(option.params, false);
                break;
        }
        data += '</root>';
        option.data = data;
        $.ajax(option);
    };

    /**
     * 信息提示功能模块
     * 
     * $.pe.tip.show(option)
     * 作用: 显示提示信息
     * option 可选参数有:
     * @param {string} text 提示文字, 默认为空
     * @param {string} type 提示图标, 默认为notice, 可选值有 ['suc', 'err', 'notice', 'load']
     * @param {number} fade 提示信息淡入速度, 默认为200, 设置为小于等于0则直接显示没有淡入动画效果
     * @param {number} timeout 提示信息自动隐藏时间, 单位毫秒, 默认 1500 【设置为0则不自动隐藏, 一般用于load类型, 等待回调响应后再通过$.pe.tip.hide隐藏提示】
     * 用法:
     * $.pe.tip.show({
     *     text: "提示文字",
     *     type: "suc",
     *     fade: 200,
     *     timeout: 1500
     * });
     * 
     * $.pe.tip.hide(fade)
     * 作用: 隐藏提示信息, 一般用于load类型, 等待回调响应后通过$.pe.tip.hide隐藏提示
     * @param {number} fade 提示信息淡出时间, 默认为200, 设置为小于等于0则直接隐藏没有淡出动画效果
     * 用法:
     * $.pe.tip.hide(200);
     */
    PE.tip = function() {
        var timer, dom,
            template = '<div class="popTip"><i class="icon"></i><span class="text"></span></div>',
            type = ['suc', 'err', 'notice', 'load'],
            _creat = function(type, text, fade) {
                dom = dom || $(template).hide().appendTo($("body"));
                dom.find(".icon").attr("class", "icon").addClass(type);
                dom.find(".text").html(text);
            },
            _hide = function(fade, callback) {
                timer && window.clearTimeout(timer);
                if (fade>0) {
                    dom && dom.fadeOut(fade,function(){
                        callback && callback.call(this);
                    });
                } else {

                }
            }

        return {
            show: function(option, callback) {
                var option = $.extend({
                    text: "",
                    type: "",
                    fade: 200,
                    timeout: 1500
                }, option);
                option.type = $.inArray(option.type, type)>-1 ? option.type : "notice";
                option.text = (option.type=="load" && option.text=="") ? "读取中..." : option.text;
                
                _creat(option.type, option.text, option.fade);
                if (option.fade>0) {
                    dom.fadeIn(option.fade);
                } else {
                    dom.show();
                }
                Util.Layout.Center(dom);

                if (option.timeout) timer = window.setTimeout(function(){ _hide(option.fade, callback) }, option.timeout);
            },
            hide: function(fade, callback) {
                fade = fade==undefined ? 200 : fade;
                _hide(fade, callback);
            }
        }
    }();

    $.pe = PE;
})(jQuery);




//data-url 替换 href
(function($){
    $.extend($.fn, {
        jump: function(){
            this.each(function(){
                var _this = $(this);
                if (_this.attr("data-url") && _this.attr("data-url").trim()=="") return false;
                _this.click(function(){
                    _this.addClass("touchOn");
                    setTimeout(function(){

						if ( _this.attr("data-url")=="no" ){
							$.pe.tip.show({text:"建设中...",type:"notice"})
						}else{window.location.href=_this.attr("data-url");}
                        

                        _this.removeClass("touchOn");
                    },300);
                });
            });
        }
    })


})(jQuery);

$(function(){ $("[data-url]").jump(); });


//设置swipe当前tab高度
var setSwipeHeight = function(con, index){ 

	var curItem = con.children().eq(index);
	var pic = curItem.find("img");
	var picCount = pic.size();

	if( picCount<=0 ){ con.height( curItem.children().eq(0).height() ); return; }
	pic.each(function(){ //存在图片时监测图片高度
		var img=$(this); 
		var imgInt=setInterval( function(){
			if(img.height()>0){
				clearInterval(imgInt);
				picCount--;
				if(picCount<=0){ con.height( curItem.children().eq(0).height() ); }
			}
		},50 );
	 });
}


