
!function () {
    $(function () {
        initAllVideo();
    });

    function initAllVideo($dom) {
        if (!$dom) {
            $dom = $("body");
        }

        var videoAll;

        if (isIE8() || isIE7()) {
            videoAll = $dom.find('.edui-upload-video');
            videoAll.each(function () {
                var src = $(this).attr('src') || $(this).data('url');
                if (isWmv(src)) {
                    var wmvHtml = createWmvVideo(src, $(this).attr('width'), $(this).attr('height'));
                    $(this).replaceWith($(wmvHtml));
                } else {
                    swfVideoInit(src, $(this).attr('height'), $(this).attr('width'), $(this));
                }
            });

            var videoDiv = $dom.find('[data-ui="video"]');
            videoDiv.each(function () {
                var src = $(this).attr('src') || $(this).data('url');
                if (isWmv(src)) {
                    var wmvHtml = createWmvVideo(src, $(this).data('width'), $(this).data('height'));
                    $(this).replaceWith($(wmvHtml));
                } else {
                    swfVideoInit(src, $(this).data('height'), $(this).data('width'), $(this));
                }
            });
        } else {
            videoAll = $dom.find('.edui-upload-video');
            $.each(videoAll,
                function (i, val) {
                    //IE9޶˼ΣӸclassһûдƵ
                    if ($(this).attr("class").indexOf("edui-upload-video-done") > 0) {
                        return;
                    }
                    $(this).addClass("edui-upload-video-done");
                    var src = $(this).attr('src') || $(this).data('url');
                    var wmvHtml;
                    if (src.indexOf('mp3') > 0) {
                        $(this).parent().attr('class', 'mp3Player');
                        $(this).replaceWith($('<audio src="' + src + '" controls="controls"></audio>'));
                        return;
                    }
                    if (isIe() && isWmv(src)) {
                        wmvHtml = createWmvVideo(src, $(this).attr('width'), $(this).attr('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else if (!isIe() && isWmv(src)) {
                        wmvHtml = createIeTooltip($(this).attr('width'), $(this).attr('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else if (!IsInternetExplorer10() && isFlv(src)) {
                        wmvHtml = createIe10FlvVideo(src, $(this).attr('width'), $(this).attr('height'));
                        $(this).replaceWith($(wmvHtml));
                    }
                    else {
                        videoInit(src, $(this).attr('height'), $(this).attr('width'), $(this));
                    }
                });

            var embedAll = $dom.find('.edui-faked-video');
            $.each(embedAll,
                function (i, val) {
                    var src = $(this).attr('src') || $(this).data('url');
                    if (src.indexOf('mp3') > 0) {
                        $(this).parent().attr('class', 'mp3Player');
                        $(this).replaceWith($('<audio src="' + src + '" controls="controls"></audio>'));
                        return;
                    }
                    if (isIe() && isWmv(src)) {
                        var wmvHtml = createWmvVideo(src, $(this).attr('width'), $(this).attr('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else {
                        embedInit(src, $(this).attr('height'), $(this).attr('width'), $(this));
                    }
                });

            var blendDiv = $dom.find('[data-ui="video"]');
            $.each(blendDiv,
                function (i, val) {
                    var src = $(this).attr('src') || $(this).data('url');
                    var wmvHtml;
                    if (src.indexOf('mp3') > 0) {
                        $(this).parent().attr('class', 'mp3Player');
                        $(this).replaceWith($('<audio src="' + src + '" controls="controls"></audio>'));
                        return;
                    }
                    if (isIe() && isWmv(src)) {
                        wmvHtml = createWmvVideo(src, $(this).data('width'), $(this).data('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else if (!isIe() && isWmv(src)) {
                        wmvHtml = createIeTooltip($(this).data('width'), $(this).data('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else if (!IsInternetExplorer10() && isFlv(src)) {
                        wmvHtml = createIe10FlvVideo(src, $(this).attr('width'), $(this).attr('height'));
                        $(this).replaceWith($(wmvHtml));
                    } else {
                        blendInit(src, $(this).data('autoplay'), $(this));
                    }
                });
        }
    }

    function swfVideoInit(src, height, width, $this) {
        var random = parseInt(Math.random() * (99999 - 10000 + 1) + 10000);
        var id = 'PowerPlay' + random;
        $this.attr('id', id);
        var parameters =
        {
            src: src,
            autoPlay: true,
            title: '',
            controlBarAutoHide: "false",
            scaleMode: "liveOrRecorded"
        };
        swfobject.embedSWF("/UEditor/VideoPlayer/PowerPlayback.swf",
            id,
            width,
            height,
            "10.1.0",
            {},
            parameters,
            { allowFullScreen: "true", wmode: "opaque" },
            { name: "powerPlayback" }
        );
    }

    function videoInit(src, height, width, $this) {
        var random = parseInt(Math.random() * (99999 - 10000 + 1) + 10000);
        var id = 'PowerPlay' + random;
        var $width = width;
        var $height = height;
        var boardDiv =
            "<div id='" + id + "' class='videoPlayer' style='width:" + $width + "px;height:" + $height + "px;'></div>";

        var videoUrl = src;
        $this.after(boardDiv);
        $this.hide();

        var videoObject = {
            container: '#' + id, //ID
            variable: 'player', //Աãֵnew chplayer()Ķ
            autoplay: true, //ǷԶ
            video: videoUrl
        };

        var embed;
        if (videoUrl.indexOf('.flv') > 0) {
            $this.hide();
            embed = createEmbedVideo(src, $height, $width);

            $('#' + id).replaceWith($(embed));
        } else if (videoUrl.indexOf('.swf') > 0) {
            $this.hide();
            embed = swfHtml(src, $height, $width);
            $('#' + id).replaceWith($(embed));
        } else {
            var player = new ckplayer(videoObject);
        }
    }

    function createIe10FlvVideo(src, width, height) {
        return '<OBJECT name="powerPlayback"  width=' + width + ' height=' + height + '  classid=clsid:D27CDB6E-AE6D-11cf-96B8-444553540000 ><PARAM NAME="FlashVars" VALUE="src=' + src + '"><PARAM NAME="Src" VALUE="/UEditor/VideoPlayer/PowerPlayback.swf"></OBJECT>';
    }

    function IsInternetExplorer10() {
        var browser = navigator.appName;
        var b_version = navigator.appVersion;
        var version = b_version.split(";");
        if (version.length > 1) {
            var trim_Version = parseInt(version[1].replace(/[ ]/g, "").replace(/MSIE/g, ""));
            if (trim_Version < 11) {
                return false;
            }
        }
        return true;
    }

    function embedInit(src, height, width, $this) {
        var random = parseInt(Math.random() * (99999 - 10000 + 1) + 10000);
        var id = 'PowerPlay' + random;
        var $width = width;
        var $height = height;
        var boardDiv =
            "<div id='" + id + "' class='videoPlayer' style='width:" + $width + "px;height:" + $height + "px;'></div>";

        $this.after(boardDiv);

        var videoUrl = src;

        var videoObject = {
            container: '#' + id, //ID
            variable: 'player', //Աãֵnew chplayer()Ķ
            autoplay: true, //ǷԶ
            video: videoUrl
        };

        if (videoUrl.indexOf('.swf') < 0) {
            $this.hide();
            var player = new ckplayer(videoObject);
        } else {
            $this.hide();
            var swf = swfHtml(src, $height, $width);
            $('#' + id).replaceWith($(swf));
        }
    }

    function blendInit(src, autoplay, $this) {
        $this.width($this.data('width'));
        $this.height($this.data('height'));
        var random = parseInt(Math.random() * (99999 - 10000 + 1) + 10000);
        var id = 'powerPlay' + random;
        $this.attr('id', id);
        var videoObject = {
            container: '#' + id, //IDclassName
            variable: 'player', //ź
            autoplay: autoplay, //ǷԶ
            video: src
        };

        if (src.indexOf('.flv') < 0) {
            var player = new ckplayer(videoObject);
        } else {
            var embed = createEmbedVideo(src, $this.data('height'), $this.data('width'));
            $('#' + id).replaceWith($(embed));
        }

    }

    function swfHtml(src, height, width) {
        return '<div class="videoPlayer"><embed  src="' +
            src +
            '" allowFullScreen="true" quality="high" width="' +
            width +
            '" height="' +
            height +
            '" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed></div>';
    }

    function createWmvVideo(src, width, height) {
        return '<div class="videoPlayer"><object classid="clsid:6BF52A52-394A-11D3-B153-00C04F79FAA6" id="WindowsMediaPlayer" ' +
            'width="' +
            width +
            '" ' +
            'height="' +
            height +
            '">' +
            '<param name="URL" value="' +
            src +
            '">' +
            '</object></div>';
    }

    function createEmbedVideo(src, height, width) {
        return '<div class="videoPlayer"><embed src="/ckplayer/ckplayer.swf" flashvars="video=' +
            src +
            '"  quality="high" width="' +
            width +
            '" height="' +
            height +
            '" align="middle" allowScriptAccess="always" allowFullscreen="true" type="application/x-shockwave-flash"></embed></div>';
    }

    function isIE8() {
        return navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.match(/8./i) == "8.";
    }

    function isIE7() {
        return navigator.appName == "Microsoft Internet Explorer" && navigator.userAgent.indexOf("MSIE 7.0") > 0;
    }

    function isIe() {
        return !!window.ActiveXObject || 'ActiveXObject' in window;
    }

    function isWmv(src) {
        return src.toLocaleLowerCase().indexOf('.wmv') > 0;
    }

    function isFlv(src) {
        return src.toLocaleLowerCase().indexOf('.flv') > 0;
    }

    function createIeTooltip(width, height) {
        return '<div style="width:' +
            width +
            'px; height:' +
            height +
            'px; background-color:#000;">' +
            '<p style="width: ' +
            width +
            'px;height: ' +
            height +
            'px;line-height:' +
            height +
            'px; color:#fff; text-align:center;">ʹIE鿴Ƶ</p></div>';
    }

    var powerVideoReversion = function () { };
    powerVideoReversion.prototype = {
        initVideo: initAllVideo
    };

    window.powerVideoReversion = powerVideoReversion;
}();