﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="GetPassword.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.GetPassword"
    Async="true" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="MainForm" runat="server">
    <asp:PlaceHolder ID="PnlStep1" runat="server" Visible="False">
        <asp:TextBox ID="TxtUserName" CssClass="inputxt" runat="server"></asp:TextBox>
        <pe:RequiredFieldValidator ID="ValrTxtUserName" runat="server" ErrorMessage="<%$ Res: User_GetPassword_ValrTxtUserName,请输入用户名！ %>"
            ControlToValidate="TxtUserName" Display="dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator>
        <asp:RadioButton Text="邮件方式" runat="server" ID="rBtnEmail" Value="0" Checked="true"
            GroupName="type"></asp:RadioButton>
        <asp:RadioButton Text="密码问题方式" runat="server" ID="rBtnQA" Value="1" GroupName="type">
        </asp:RadioButton>
        <asp:Button ID="BtnStep1" runat="server" Text="<%$ Res: User_GetPassword_BtnStep1,下一步 %>"
            OnClick="BtnStep1_Click" />
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="PnlSendToEmail" runat="server" Visible="False">
        <pe:CSSFriendlyRadioButtonList ID="RadPwdType" runat="server" RepeatDirection="Horizontal">
            <asp:ListItem Text="<%$ Res: User_GetPassword_ListItem1,登录密码 %>" Value="0" Selected="True"></asp:ListItem>
            <asp:ListItem Text="<%$ Res: User_GetPassword_ListItem2,预付款支付密码 %>" Value="1"></asp:ListItem>
        </pe:CSSFriendlyRadioButtonList>
        <asp:Button ID="btnSendEmail" runat="server" Text="<%$ Res: User_GetPassword_btnSendEmail,发送链接至邮箱 %>" OnClick="btnSendEmail_Click" />
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="PnlStep2" runat="server" Visible="False">
        <asp:Literal ID="LitQuestion" runat="server"></asp:Literal>
        <asp:TextBox ID="TxtAnswer" CssClass="inputxt" runat="server"></asp:TextBox>
        <asp:TextBox ID="TxtValidateCode" CssClass="inputxt" runat="server"></asp:TextBox>
        <pe:ValidateCode ID="VcodeLogOn" align="absmiddle" runat="server" RefreshLinkToolTip="<%$ Res: User_GetPassword_VcodeLogOn,看不清楚，换一个 %>" />
        <pe:RequiredFieldValidator ID="ValrValidateCode" runat="server" ErrorMessage="<%$ Res: User_GetPassword_ValrValidateCode,请输入验证码！ %>"
            ControlToValidate="TxtValidateCode" SetFocusOnError="True"></pe:RequiredFieldValidator>
        <asp:PlaceHolder ID="PnListPwdType" runat="server" Visible="false">
            <li class="password_area">
                <label>
                    请选择密码类型：
                </label>
                <pe:CSSFriendlyRadioButtonList ID="RadListPwdType" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Text="<%$ Res: User_GetPassword_ListItem3,登录密码 %>" Value="0" Selected="True"></asp:ListItem>
                    <asp:ListItem Text="<%$ Res: User_GetPassword_ListItem4,预付款支付密码 %>" Value="1"></asp:ListItem>
                </pe:CSSFriendlyRadioButtonList>
            </li>
        </asp:PlaceHolder>
        <asp:Button ID="BtnStep2" runat="server" Text="<%$ Res: User_GetPassword_BtnStep2,完成 %>"
            OnClick="BtnStep2_Click" />
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="PnlStep3" runat="server" Visible="False">
        <asp:TextBox ID="TxtPassword" TextMode="Password" runat="server" AutoComplete="off"></asp:TextBox>
        <asp:RegularExpressionValidator ID="RegularExpressionValidatorPassword" runat="server"
            ControlToValidate="TxtPassword" SetFocusOnError="True" Display="Dynamic" ValidationGroup="valsPassword"
            ValidationExpression="[\S]{6,}" ErrorMessage="<%$ Res: User_GetPassword_RegularExpressionValidatorPassword,密码至少6位 %>"></asp:RegularExpressionValidator>
        <pe:RequiredFieldValidator ID="RequiredTxtPassword" runat="server" ErrorMessage="<%$ Res: User_Register_ReqTxtPassword,密码不能为空 %>"
            ControlToValidate="TxtPassword" Display="dynamic" SetFocusOnError="True" ValidationGroup="valsPassword"></pe:RequiredFieldValidator>
        <asp:TextBox ID="TxtConfirmPassword" runat="server" TextMode="Password" AutoComplete="off"></asp:TextBox>
        <pe:RequiredFieldValidator ID="RequiredTxtConfirmPassword" runat="server" ErrorMessage="<%$ Res: User_Register_ReqTxtPassword,确认密码不能为空 %>"
            ControlToValidate="TxtConfirmPassword" Display="dynamic" SetFocusOnError="True"
            ValidationGroup="valsPassword"></pe:RequiredFieldValidator>
        <asp:CompareValidator ID="CompareValTxtConfirmPassword" ControlToValidate="TxtConfirmPassword"
            ValidationGroup="valsPassword" ControlToCompare="TxtPassword" Display="Dynamic"
            Type="String" Operator="Equal" runat="server" ErrorMessage="<%$ Res: User_GetPassword_CompareValTxtConfirmPassword,两次密码输入不一致！ %>"></asp:CompareValidator>
        <asp:Button ID="BtnStep3" CssClass="input_button" runat="server" Text="<%$ Res: User_GetPassword_BtnStep3,修改密码 %>"
            ValidationGroup="valsPassword" OnClick="BtnStep3_Click" />
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="PalChangePayPassword" runat="server" Visible="False">
        <asp:TextBox ID="txtNewPayPassword" TextMode="Password" runat="server" AutoComplete="off"></asp:TextBox>
        <asp:RegularExpressionValidator ID="RegNewPayPassword" ValidationGroup="valsPayPassword"
            runat="server" ControlToValidate="txtNewPayPassword" SetFocusOnError="True" Display="Dynamic"
            ValidationExpression="[\S]{6,}" ErrorMessage="<%$ Res: User_GetPassword_RegNewPayPassword,密码至少6位 %>"></asp:RegularExpressionValidator>
        <pe:RequiredFieldValidator ID="RequiredtxtNewPayPassword" runat="server" ErrorMessage="<%$ Res: User_Register_ReqTxtPassword,密码不能为空 %>"
            ControlToValidate="txtNewPayPassword" Display="dynamic" SetFocusOnError="True"
            ValidationGroup="valsPayPassword"></pe:RequiredFieldValidator>
        <asp:TextBox ID="txtConfirmNewPayPassword" runat="server" TextMode="Password" AutoComplete="off"></asp:TextBox>
        <pe:RequiredFieldValidator ID="RequiredtxtConfirmNewPayPassword" runat="server" ErrorMessage="<%$ Res: User_Register_ReqTxtPassword,确认密码不能为空 %>"
            ControlToValidate="txtConfirmNewPayPassword" Display="dynamic" SetFocusOnError="True"
            ValidationGroup="valsPassword"></pe:RequiredFieldValidator>
        <asp:CompareValidator ID="CompNewPayPassword" ValidationGroup="valsPayPassword" ControlToValidate="txtNewPayPassword"
            ControlToCompare="txtConfirmNewPayPassword" Display="Dynamic" Type="String" Operator="Equal"
            runat="server" ErrorMessage="<%$ Res: User_GetPassword_CompNewPayPassword,两次密码输入不一致！ %>"></asp:CompareValidator>
        <asp:Button ID="btnChangePayPassword" runat="server" Text="<%$ Res: User_GetPassword_btnChangePayPassword,修改预付款支付密码 %>"
            ValidationGroup="valsPayPassword" OnClick="btnChangePayPassword_Click" />
    </asp:PlaceHolder>
    </form>
</body>
</html>
