﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RegisterPromotionQuery.aspx.cs"
    Inherits="PowerEasy.Module.Promotion.WebSite.User.Promotion.RegisterPromotionQuery" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Literal ID="LitQuery" runat="server" Text="<%$ Res:User_Promotion_RegisterPromotionQuery_Query,注册推广查询 %>" /></a></span>
                </li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvPromotionQuery" runat="server" AutoGenerateColumns="False"
                CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsSearch" IsHoldState="True" SerialText=""
                AllowPaging="True" OnRowDataBound="EgvPromotionQuery_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="RegisterUserName" HeaderText="<%$ Res: User_Promotion_RegisterPromotionQuery_RegisterUserName,注册会员名%>"
                        SortExpression="RegisterUserName" />
                    <asp:BoundField DataField="RegisterIP" HeaderText="<%$ Res: User_Promotion_RegisterPromotionQuery_RegisterIP,注册IP%>"
                        SortExpression="RegisterIP" />
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_RegisterPromotionQuery_RegisterTime,注册时间%>">
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <%# Eval("RegisterTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_RegisterPromotionQuery_Commission,佣金%>">
                        <ItemStyle HorizontalAlign="Right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%# Eval("Commission", "{0:N}")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Promotion_RegisterPromotionQuery_State,状态%>">
                        <ItemTemplate>
                            <pe:ExtendedLabel ID="ELblState" runat="server" Text='<%# Eval("State") %>'>
                    &nbsp;
                            </pe:ExtendedLabel>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
            <asp:ObjectDataSource ID="OdsSearch" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.Promotion.BusinessLogic.RegisterPromotionManage"
                SelectCountMethod="GetTotalOfRegisterPromotion" EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HdnUserName" Name="userName" PropertyName="Value"
                        Type="String" />
                    <asp:ControlParameter ControlID="DpkStartDate" Name="startTime" PropertyName="Text"
                        Type="DateTime" />
                    <asp:ControlParameter ControlID="DpkEndDate" Name="endTime" PropertyName="Text" Type="DateTime" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <asp:Literal ID="LitStart" runat="server" Text="<%$ Res:User_Promotion_RegisterPromotionQuery_StartTime,开始日期 %>" />：
        <pe:DatePicker ID="DpkStartDate" runat="server" Width="80" CssClass="inputxt" DateImage="~/User/Images/Calendar.gif"></pe:DatePicker>
        <pe:RequiredFieldValidator ID="ValrDpkStartDate" ControlToValidate="DpkStartDate"
            runat="server" ErrorMessage="<%$ Res: User_Promotion_PromotionOrder_14,开始日期不能为空！%>"
            Display="Dynamic" RequiredText="" ValidationGroup="Search"></pe:RequiredFieldValidator>
        <pe:RegexValidator ValidateType="Date" ID="VdateStartDate" runat="server" ControlToValidate="DpkStartDate"
            Display="Dynamic" SetFocusOnError="true" ValidationGroup="Search" ErrorMessage="<%$ Res: User_Promotion_RegisterPromotionQuery_ErrorDate,日期不正确！%>"></pe:RegexValidator>
        &nbsp;
        <asp:Literal ID="Literal1" runat="server" Text="<%$ Res:User_Promotion_RegisterPromotionQuery_EndTime,结束日期 %>" />：
        <pe:DatePicker ID="DpkEndDate" runat="server" Width="80" CssClass="inputxt" DateImage="~/User/Images/Calendar.gif"></pe:DatePicker><pe:RequiredFieldValidator
            ID="ValrDpkEndDate" ControlToValidate="DpkEndDate" runat="server" ErrorMessage="<%$ Res: User_Promotion_PromotionOrder_15,结束日期不能为空！%>"
            Display="Dynamic" RequiredText="" ValidationGroup="Search"></pe:RequiredFieldValidator>
        <pe:RegexValidator ValidateType="Date" ID="VdateEndDate" runat="server" ControlToValidate="DpkEndDate"
            Display="Dynamic" SetFocusOnError="true" ValidationGroup="Search" ErrorMessage="<%$ Res: User_Promotion_RegisterPromotionQuery_ErrorDate,日期不正确！%>"></pe:RegexValidator>
        &nbsp;&nbsp;
        <asp:Button ID="BtnSearch" runat="server" Text="<%$ Res: User_Promotion_RegisterPromotionQuery_Search, 查询 %>"
            OnClick="BtnSearch_Click" ValidationGroup="Search" CssClass="submit_button" />
    </div>
    <asp:HiddenField ID="HdnUserName" runat="server" />
    </form>
</body>
</html>
