﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Register.aspx.cs" ValidateRequest="false"
    Inherits="PowerEasy.Module.General.WebSite.User.Register" EnableEventValidation="false"
    Async="true" %>

<%@ Import Namespace="Resources" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="form1" runat="server">
        <script type="text/javascript" src="../JS/Encrypt/BigInt.js"></script>
        <script type="text/javascript" src="../JS/Encrypt/Encrypt.js"></script>
        <script type="text/javascript" src="../JS/Encrypt/Barrett.js"></script>
        <script type="text/javascript" src="../JS/Encrypt/Common.js"></script>
        <asp:ScriptManager ID="SmgeRegion" runat="server" EnablePartialRendering="true">
        </asp:ScriptManager>
        <pe:ExtendedLabel HtmlEncode="false" ID="LitControlTreeInfo" runat="server">
        </pe:ExtendedLabel>
        <asp:Panel ID="PnlRegStep2" runat="server" Visible="false">
            <script type="text/javascript">
                var BeginClick = function () {
                    if (Page_ClientValidate()) {
                        var status = false;
                        $.ajax({
                            type: "POST",
                            async: false,
                            dataType: "xml",
                            url: "/User/Register.aspx",
                            data: "AsyncAction=CheckUserName&Name=" + $("#TxtRegUserName").val() + "&Code=" + $("#TxtValidateCode").val(),
                            success: function (xml) {
                                var result = jQuery(xml).find("status").text();
                                var checkUserNameMessage = document.getElementById("CheckUserNameMessage");
                                checkUserNameMessage.style.display = "";
                                if (result == "true") {
                                    checkUserNameMessage.innerHTML = "<%=DynamicPageResources.User_Register_UserNameIsRegister%>";
                                    checkUserNameMessage.className = "d_err";
                                    $("#VcodeRegister").click();
                                }
                                else if (result == "disabled") {
                                    checkUserNameMessage.innerHTML = "<%=DynamicPageResources.User_Register_UserNameIsdisabled%>";
                                    checkUserNameMessage.className = "d_err";
                                    $("#VcodeRegister").click();
                                }
                                else if (result == "false") {
                                    checkUserNameMessage.innerHTML = "<%=DynamicPageResources.User_Register_UserNameYes%>";
                                    checkUserNameMessage.className = "d_ok";
                                    GetRsaEncrypt(2);
                                    $("#TxtRegPassword").val(rsaEncrypt($("#TxtRegPassword").val()));
                                    $("#TxtPwdConfirm").val(rsaEncrypt($("#TxtPwdConfirm").val()));
                                    if ($("#TxtAnswer").length > 0) {
                                        $("#TxtAnswer").val(rsaEncrypt($("#TxtAnswer").val()));
                                    }
                                    status = true;
                                }
                                else if (result == "limite") {
                                    var msg = jQuery(xml).find("msg").text();
                                    checkUserNameMessage.innerHTML = msg;
                                    checkUserNameMessage.className = "d_err";
                                    $("#VcodeRegister").click();
                                }
                                else if (result == "error") {
                                    checkUserNameMessage.innerHTML = "请重新正确填写验证码";
                                    checkUserNameMessage.className = "d_err";
                                    $("#VcodeRegister").click();
                                }
                            }
                        });
                        return status;
                    }
                    else {
                        return false;
                    }
                }

                $(function(){
                    var $userpass = $("#TxtRegPassword")[0];
                    try {
                        $userpass.type = 'password';
                    } catch (e) {
                        $userpass.outerHTML = $userpass.outerHTML.replace('type=text', '').replace('>', ' type="password">');
                    }
                    var $usercpass = $("#TxtPwdConfirm")[0];
                    try {
                        $usercpass.type = 'password';
                    } catch (e) {
                        $usercpass.outerHTML = $usercpass.outerHTML.replace('type=text', '').replace('>', ' type="password">');
                    }
                });
                
                function SwicthSelectFill()
                {
                    var selectFill = document.getElementById("<%=TableRegisterSelect.ClientID%>");
                        if(selectFill.style.display=="none")
                        {
                            selectFill.style.display="";
                        }
                        else
                        {
                            selectFill.style.display="none";
                        }
                    }
                    
                    Sys.WebForms.PageRequestManager.getInstance().add_endRequest(EndRequestHandler);
                    function EndRequestHandler(sender, args)
                    {
                        if (args.get_error() != undefined){
                            alert("<%=DynamicPageResources.User_Register_CheckForm%>");
                            args.set_errorHandled(true);
                        }
                    }
                    
                    function userNameChange()
                    {
                        document.getElementById("CheckUserNameMessage").innerHTML="";
                        document.getElementById("CheckUserNameMessage").style.display="none";
                    }
            </script>
            <div id="TableRegisterMust" runat="server">
                <fieldset id="TableRegisterMustfieldset" runat="server">
                    <legend>会员注册</legend>
                    <div class="reg_input">
                        <label>
                            <asp:Literal ID="Literal5" Text="<%$ Res: User_Register_Literal5,用户名 %>" runat="server" />：</label>
                        <asp:TextBox ID="TxtRegUserName" runat="server" MaxLength="50"
                            oninput="userNameChange();" onpropertychange="userNameChange();"></asp:TextBox>
                        <div class="d_default" id="CheckUserNameMessage" style="margin-top: 0px; display: none;">
                        </div>
                        <pe:RequiredFieldValidator ID="ReqTxtUserName" runat="server" ControlToValidate="TxtRegUserName"
                            SetFocusOnError="false" ErrorMessage="<%$ Res: User_Register_ReqTxtUserName,用户名不能为空 %>"
                            Display="None">
                        </pe:RequiredFieldValidator>
                    </div>
                    <div class="user_line">
                    </div>
                    <div class="reg_input">
                        <label>
                            <asp:Literal ID="Literal6" Text="<%$ Res: User_Register_Literal6,密码 %>" runat="server" />：</label>
                        <%-- 取消Type=Password，利用JS在页面加载完毕后修改 --%>
                        <asp:TextBox ID="TxtRegPassword" runat="server" AutoComplete="off"></asp:TextBox>
                        <asp:Label Text="" runat="server" ID="LabelStrongPwd" />
                        <pe:InteractiveMessager ID="InteractiveMessagerTxtPassword" Text="<%$ Res: User_Register_InteractiveMessagerTxtPassword,请输入密码，区分大小写(至少6位)。尽量设得复杂一些，以防被人暴力猜解 %>"
                            ControlToMessage="TxtRegPassword" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtPassword_ValidatorOkMessage,密码已输入 %>"
                            runat="server">
                        </pe:InteractiveMessager>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidatorPassword" runat="server"
                            ControlToValidate="TxtRegPassword" SetFocusOnError="false" Display="None" ValidationExpression="[\S]{6,}"
                            ErrorMessage="<%$ Res: User_Register_RegularExpressionValidatorPassword,密码至少6位 %>"></asp:RegularExpressionValidator>
                        <pe:RequiredFieldValidator ID="ReqTxtPassword" runat="server" ControlToValidate="TxtRegPassword"
                            SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtPassword,密码不能为空 %>">
                        </pe:RequiredFieldValidator>
                    </div>
                    <div class="reg_input">
                        <label>
                            <asp:Literal ID="Literal" Text="<%$ Res: User_Register_Literal,确认密码 %>" runat="server" />：</label>
                        <%-- 取消Type=Password，利用JS在页面加载完毕后修改 --%>
                        <asp:TextBox ID="TxtPwdConfirm" runat="server" AutoComplete="off"></asp:TextBox>
                        <pe:InteractiveMessager ID="InteractiveMessagerTxtPwdConfirm" Text="<%$ Res: User_Register_InteractiveMessagerTxtPwdConfirm,请再输一遍以确认密码 %>"
                            ControlToMessage="TxtPwdConfirm" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtPwdConfirm_ValidatorOkMessage,确认密码已输入 %>"
                            runat="server">
                        </pe:InteractiveMessager>
                        <pe:RequiredFieldValidator ID="ReqTxtPwdConfirm" runat="server" ControlToValidate="TxtPwdConfirm"
                            SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtPwdConfirm,确认密码不能为空 %>">
                        </pe:RequiredFieldValidator><asp:CompareValidator ID="ValCompPassword" runat="server"
                            ControlToValidate="TxtPwdConfirm" ControlToCompare="TxtRegPassword" Operator="Equal"
                            SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ValCompPassword,两次密码输入不一致 %>"></asp:CompareValidator>
                    </div>
                    <asp:PlaceHolder ID="holdPWDQA" runat="server" Visible="false">
                        <div class="user_line">
                        </div>
                        <div id="TRPWDQuestion" runat="server">
                            <div class="reg_input">
                                <label>
                                    <asp:Literal ID="Literal8" Text="<%$ Res: User_Register_Literal8,密码问题 %>" runat="server" />：</label>
                                <asp:TextBox ID="TxtQuestion" runat="server"></asp:TextBox>
                                <pe:InteractiveMessager ID="InteractiveMessager1" Text="<%$ Res: User_Register_InteractiveMessager1,最好设成别人不知道答案的问题，以防被人用找回密码功能窃取您的帐号。 %>"
                                    ControlToMessage="TxtQuestion" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessager1_ValidatorOkMessage,密码问题已输入 %>"
                                    runat="server">
                                </pe:InteractiveMessager>
                                <pe:RequiredFieldValidator ID="ReqTxtQuestion" runat="server" ControlToValidate="TxtQuestion"
                                    SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtQuestion,密码问题不能为空 %>">
                                </pe:RequiredFieldValidator>
                            </div>
                            <div class="reg_input">
                                <label>
                                    <asp:Literal ID="Literal9" Text="<%$ Res: User_Register_Literal9,问题答案 %>" runat="server" />：</label>
                                <asp:TextBox ID="TxtAnswer" runat="server"></asp:TextBox>
                                <pe:InteractiveMessager ID="InteractiveMessagerTxtAnswer" Text="<%$ Res: User_Register_InteractiveMessagerTxtAnswer,用于取回密码。请尽量设得复杂一些，以防被人用找回密码功能窃取您的帐号。 %>"
                                    ControlToMessage="TxtAnswer" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtAnswer_ValidatorOkMessage,问题答案已输入 %>"
                                    runat="server">
                                </pe:InteractiveMessager>
                                <pe:RequiredFieldValidator ID="ReqAnswer" runat="server" ControlToValidate="TxtAnswer"
                                    SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqAnswer,问题答案不能为空 %>">
                                </pe:RequiredFieldValidator>
                            </div>
                        </div>
                    </asp:PlaceHolder>
                    <asp:PlaceHolder ID="PhEmail" runat="server">
                        <div class="user_line">
                        </div>
                        <div class="reg_input" id="trEmail" runat="server">
                            <label>
                                <asp:Literal ID="Literal20" Text="<%$ Res: User_Register_Literal20,Email地址 %>" runat="server" />：</label>
                            <asp:TextBox ID="TxtEmail" runat="server"></asp:TextBox>
                            <pe:InteractiveMessager ID="InteractiveMessagerTxtEmail" Text="<%$ Res: User_Register_InteractiveMessagerTxtEmail,请输入有效的邮件地址，以便我们可以及时和你联系。 %>"
                                ControlToMessage="TxtEmail" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtEmail_ValidatorOkMessage,Email地址已输入 %>"
                                runat="server">
                            </pe:InteractiveMessager>
                            <pe:RequiredFieldValidator ID="ReqTxtEmail" runat="server" ControlToValidate="TxtEmail"
                                SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtEmail,Email不能为空 %>">
                            </pe:RequiredFieldValidator><pe:RegexValidator ValidateType="Email" ID="ValeTxtEmail"
                                runat="server" ControlToValidate="TxtEmail" ErrorMessage="<%$ Res: User_Register_ValeTxtEmail,请输入正确的Email %>"
                                SetFocusOnError="false" Display="None"></pe:RegexValidator>
                        </div>
                    </asp:PlaceHolder>
                    <div id="TrVcodeRegister" runat="server" visible="false" class="reg_input">
                        <label>
                            <asp:Literal ID="Literal61" Text="<%$ Res: User_Register_Literal61,验证码： %>" runat="server" /></label>
                        <asp:TextBox ID="TxtValidateCode" runat="server"></asp:TextBox><pe:ValidateCode ID="VcodeRegister"
                            runat="server" RefreshLinkToolTip="<%$ Res: User_Register_TxtValidateCode,看不清楚，换一个 %>" />
                        <pe:RequiredFieldValidator ID="ValrValidateCode" runat="server" ErrorMessage="<%$ Res: User_Register_ValrValidateCode,请输入验证码！ %>"
                            ControlToValidate="TxtValidateCode" Display="None" SetFocusOnError="false">
                        </pe:RequiredFieldValidator>
                        <pe:InteractiveMessager ID="InteractiveMessagerTxtValidateCode" Text="<%$ Res: User_Register_InteractiveMessagerTxtValidateCode,请输入验证码 %>"
                            ControlToMessage="TxtValidateCode" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtValidateCode_ValidatorOkMessage,验证码已输入 %>"
                            runat="server">
                        </pe:InteractiveMessager>
                    </div>
                </fieldset>
            </div>
            <div id="TableRegisterSelect" style="display: none" runat="server">
            </div>
            <div class="reg_protocol">
                <div class="ok_info">
                    <asp:Literal ID="Literal22" Text="<%$ Res: User_Register_Literal22,以上所有信息都必须先正确填写后才能继续下一步注册操作。 %>"
                        runat="server" />
                </div>
                <div class="agree">
                    <asp:Button ID="BtnRegStep2" runat="server" Text="<%$ Res: User_Register_BtnRegStep2,提交注册信息 %>"
                        OnClick="BtnRegStep2_Click" OnClientClick="return BeginClick();" />
                    <input id="Reset" runat="server" type="reset" value="<%$ Res: User_Register_Reset, 重新填写  %>"
                        name="Reset" />
                    <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True"
                        ShowSummary="False" DisplayMode="List" />
                </div>
                <div class="reg_improve">
                    <asp:Literal ID="Literal3" Text="<%$ Res: User_Register_Literal3,点击提交，即表示你同意接受下面的服务条款和声明 %>"
                        runat="server" />
                </div>
            </div>
            <textarea cols="20" rows="2" style="font-weight: normal; font-size: 9pt; width: 70%; line-height: normal; font-style: normal; height: 100px; font-variant: normal; margin-left: 130px"
                readonly="readonly"><pe:ExtendedLiteral HtmlEncode="false" ID="LitProtocol" runat="server"></pe:ExtendedLiteral></textarea>
            <div id="TableRegister" visible="false" runat="server">
                <div id="TRSwicthSelectFill" runat="server">
                    <label onclick="SwicthSelectFill()">
                        <span><b>
                            <asp:Literal ID="Literal23" Text="<%$ Res: User_Register_Literal23,选填信息： %>" runat="server" /></b></span>
                    </label>
                    <label for="checkSelectFill" class="checkbox">
                        <input type="checkbox" id="checkSelectFill" onclick="SwicthSelectFill()" style="vertical-align: -6px;" />
                        <asp:Literal ID="Literal24" Text="<%$ Res: User_Register_Literal24,显示用户设置选填信息 %>"
                            runat="server" /></label>
                </div>
                <div runat="server" class="reg_input" id="TRSpareEmail">
                    <label>
                        <asp:Literal ID="Literal25" Text="<%$ Res: User_Register_Literal25,备用Email地址： %>"
                            runat="server" /></label>
                    <asp:TextBox ID="TxtSpareEmail" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtSpareEmail" Text="<%$ Res: User_Register_InteractiveMessagerTxtSpareEmail,请输入备用Email地址 %>"
                        ControlToMessage="TxtSpareEmail" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtSpareEmail_ValidatorOkMessage,备用Email地址已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RegexValidator ValidateType="Email" ID="EmailValidator1" runat="server" ControlToValidate="TxtSpareEmail"
                        ErrorMessage="<%$ Res: User_Register_EmailValidator1,请输入正确的Email %>" SetFocusOnError="false"
                        Display="None">
                        &nbsp;&nbsp;&nbsp;&nbsp;
                    </pe:RegexValidator>
                    <pe:RequiredFieldValidator ID="ReqTxtSpareEmail" runat="server" ControlToValidate="TxtSpareEmail"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtSpareEmail,备用Email地址不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRHomepage">
                    <label>
                        <asp:Literal ID="Literal26" Text="<%$ Res: User_Register_Literal26,主页： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtHomepage" runat="server">http://</asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtHomepage" Text="<%$ Res: User_Register_InteractiveMessagerTxtHomepage,请输入主页地址 %>"
                        ControlToMessage="TxtHomepage" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtHomepage_ValidatorOkMessage,主页地址已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtHomepage" runat="server" ControlToValidate="TxtHomepage"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtHomepage,主页地址不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRQQ">
                    <label>
                        <asp:Literal ID="Literal27" Text="<%$ Res: User_Register_Literal27,QQ号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtQQ" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtQQ" Text="<%$ Res: User_Register_InteractiveMessagerTxtQQ,请输入QQ号码 %>"
                        ControlToMessage="TxtQQ" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtQQ_ValidatorOkMessage,QQ号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtQQ" runat="server" ControlToValidate="TxtQQ"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtQQ,QQ号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRICQ">
                    <label>
                        <asp:Literal ID="Literal28" Text="<%$ Res: User_Register_Literal28,ICQ号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtICQ" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtICQ" Text="<%$ Res: User_Register_InteractiveMessagerTxtICQ,请输入ICQ号码 %>"
                        ControlToMessage="TxtICQ" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtICQ_ValidatorOkMessage,ICQ号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtICQ" runat="server" ControlToValidate="TxtICQ"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtICQ,ICQ号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRMSN">
                    <label>
                        <asp:Literal ID="Literal29" Text="<%$ Res: User_Register_Literal29,MSN帐号： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtMSN" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtMSN" Text="<%$ Res: User_Register_InteractiveMessagerTxtMSN,请输入MSN帐号 %>"
                        ControlToMessage="TxtMSN" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtMSN_ValidatorOkMessage,MSN帐号已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtMSN" runat="server" ControlToValidate="TxtMSN"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtMSN,MSN帐号不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRYahoo">
                    <label>
                        <asp:Literal ID="Literal30" Text="<%$ Res: User_Register_Literal30,雅虎通帐号： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtYahoo" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtYahoo" Text="<%$ Res: User_Register_InteractiveMessagerTxtYahoo,请输入雅虎通帐号 %>"
                        ControlToMessage="TxtYahoo" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtYahoo_ValidatorOkMessage,雅虎通帐号已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtYahoo" runat="server" ControlToValidate="TxtYahoo"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtYahoo,雅虎通帐号不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRUC">
                    <label>
                        <asp:Literal ID="Literal31" Text="<%$ Res: User_Register_Literal31,UC号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtUC" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtUC" Text="<%$ Res: User_Register_InteractiveMessagerTxtUC,请输入UC号码 %>"
                        ControlToMessage="TxtUC" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtUC_ValidatorOkMessage,UC号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtUC" runat="server" ControlToValidate="TxtUC"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtUC,UC号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRAim">
                    <label>
                        <asp:Literal ID="Literal32" Text="<%$ Res: User_Register_Literal32 %>" runat="server" /></label>
                    <asp:TextBox ID="TxtAim" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtAim" Text="<%$ Res: User_Register_InteractiveMessagerTxtAim,请输入Aim帐号 %>"
                        ControlToMessage="TxtAim" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtAim_ValidatorOkMessage,Aim帐号已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtAim" runat="server" ControlToValidate="TxtAim"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtAim,Aim帐号不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TROfficePhone">
                    <label>
                        <asp:Literal ID="Literal33" Text="<%$ Res: User_Register_Literal33,办公电话： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtOfficePhone" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtOfficePhone" Text="<%$ Res: User_Register_InteractiveMessagerTxtOfficePhone,请输入办公电话 %>"
                        ControlToMessage="TxtOfficePhone" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtOfficePhone_ValidatorOkMessage,办公电话已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtOfficePhone" runat="server" ControlToValidate="TxtOfficePhone"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtOfficePhone,办公电话不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRHomePhone">
                    <label>
                        <asp:Literal ID="Literal34" Text="<%$ Res: User_Register_Literal34,家庭电话： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtHomePhone" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtHomePhone" Text="<%$ Res: User_Register_InteractiveMessagerTxtHomePhone,请输入家庭电话 %>"
                        ControlToMessage="TxtHomePhone" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtHomePhone_ValidatorOkMessage,家庭电话已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtHomePhone" runat="server" ControlToValidate="TxtHomePhone"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtHomePhone,家庭电话不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRFax">
                    <label>
                        <asp:Literal ID="Literal36" Text="<%$ Res: User_Register_Literal36,传真号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtFax" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtFax" Text="<%$ Res: User_Register_InteractiveMessagerTxtFax,请输入传真号码 %>"
                        ControlToMessage="TxtFax" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtFax_ValidatorOkMessage,传真号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtFax" runat="server" ControlToValidate="TxtFax"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtFax,传真号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRMobile">
                    <label>
                        <asp:Literal ID="Literal37" Text="<%$ Res: User_Register_Literal37,手机号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtMobile" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtMobile" Text="<%$ Res: User_Register_InteractiveMessagerTxtMobile,请输入手机号码 %>"
                        ControlToMessage="TxtMobile" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtMobile_ValidatorOkMessage,手机号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtMobile" runat="server" ControlToValidate="TxtMobile"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtMobile,手机号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Mobile" ID="MValTxtMobile" runat="server" ControlToValidate="TxtMobile"
                        SetFocusOnError="false" Display="None">
                    </pe:RegexValidator>
                </div>
                <div runat="server" class="reg_input" id="TRPHS">
                    <label>
                        <asp:Literal ID="Literal38" Text="<%$ Res: User_Register_Literal38,小灵通号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtPHS" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtPHS" Text="<%$ Res: User_Register_InteractiveMessagerTxtPHS,请输入小灵通号码 %>"
                        ControlToMessage="TxtPHS" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtPHS_ValidatorOkMessage,小灵通号码已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtPHS" runat="server" ControlToValidate="TxtPHS"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtPHS,小灵通号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Mobile" ID="TValTxtPHS" runat="server" ControlToValidate="TxtPHS"
                        SetFocusOnError="false" Display="None">
                    </pe:RegexValidator>
                </div>
                <div runat="server" class="reg_input" id="TRRegion">
                    <label>
                        <asp:Literal ID="Literal39" Text="<%$ Res: User_Register_Literal39,区域信息： %>" runat="server" /></label>
                    <div style="padding-left: 50px;">
                        <pe:Region ID="Region" runat="server" ShowCountry="false" />
                    </div>
                </div>
                <div runat="server" class="reg_input" id="TRAddress">
                    <label>
                        <asp:Literal ID="Literal40" Text="<%$ Res: User_Register_Literal40,联系地址： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtAddress" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtAddress" Text="<%$ Res: User_Register_InteractiveMessagerTxtAddress,请输入联系地址 %>"
                        ControlToMessage="TxtAddress" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtAddress_ValidatorOkMessage,联系地址已输入 %>"
                        runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtAddress" runat="server" ControlToValidate="TxtAddress"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtAddress,联系地址不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRZipCode">
                    <label>
                        <asp:Literal ID="Literal41" Text="<%$ Res: User_Register_Literal41,邮政编码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtZipCode" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqTxtZipCode" runat="server" ControlToValidate="TxtZipCode"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtZipCode,邮政编码不能为空 %>">
                    </pe:RequiredFieldValidator>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtZipCode" Text="<%$ Res: User_Register_InteractiveMessagerTxtZipCode,请输入邮政编码 %>"
                        ControlToMessage="TxtZipCode" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtZipCode_ValidatorOkMessage,邮政编码已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RegexValidator ValidateType="ZipCode" ID="ZCValorTxtZipCode" runat="server" ControlToValidate="TxtZipCode"
                        ErrorMessage="" Display="None" SetFocusOnError="false">
                    </pe:RegexValidator>
                </div>
                <div runat="server" class="reg_input" id="TRTrueName">
                    <label>
                        <asp:Literal ID="Literal42" Text="<%$ Res: User_Register_Literal42,真实姓名： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtTrueName" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtTrueName" Text="<%$ Res: User_Register_InteractiveMessagerTxtTrueName,请输入真实姓名 %>"
                        ControlToMessage="TxtTrueName" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtTrueName_ValidatorOkMessage,真实姓名已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtTrueName" runat="server" ControlToValidate="TxtTrueName"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtTrueName,真实姓名不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRSex">
                    <label>
                        <asp:Literal ID="Literal43" Text="<%$ Res: User_Register_Literal43,性别： %>" runat="server" /></label>
                    <asp:DropDownList ID="DropSex" runat="server">
                        <asp:ListItem Text="<%$ Res: User_Register_DropSexListItem1,保密 %>" Value="0"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropSexListItem2,男 %>" Value="1"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropSexListItem3,女 %>" Value="2"></asp:ListItem>
                    </asp:DropDownList>
                    <pe:InteractiveMessager ID="InteractiveMessagerDropSex" Text="<%$ Res: User_Register_InteractiveMessagerDropSex,请选择性别 %>"
                        ControlToMessage="DropSex" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerDropSex_ValidatorOkSex,性别已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager><pe:RequiredFieldValidator ID="ReqDropSex" runat="server"
                        ControlToValidate="DropSex" InitialValue="0" SetFocusOnError="false" Display="None"
                        ErrorMessage="<%$ Res: User_Register_ReqDropSex,请选择性别 %>"></pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRBirthday">
                    <label>
                        <asp:Literal ID="Literal44" Text="<%$ Res: User_Register_Literal44,出生日期： %>" runat="server" /></label>
                    <pe:DatePicker ID="TxtBirthday" runat="server" DateImage="~/User/Images/Calendar.gif">
                    </pe:DatePicker>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtBirthday" Text="<%$ Res: User_Register_InteractiveMessagerTxtBirthday,请输入出生日期 %>"
                        ControlToMessage="TxtBirthday" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtBirthday_ValidatorOkMessage,出生日期已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtBirthday" runat="server" ControlToValidate="TxtBirthday"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtBirthday,出生日期不能为空 %>">
                    </pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Date" ID="DateValTxtBirthday" runat="server" ControlToValidate="TxtBirthday"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_DateValTxtBirthday,请填写正确的日期格式：yyyy-mm-dd %>">
                    </pe:RegexValidator>
                </div>
                <div runat="server" class="reg_input" id="TRIDCard">
                    <label>
                        <asp:Literal ID="Literal45" Text="<%$ Res: User_Register_Literal45,身份证号码： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtIDCard" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtIDCard" Text="<%$ Res: User_Register_InteractiveMessagerTxtIDCard,请输入身份证号码 %>"
                        ControlToMessage="TxtIDCard" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtIDCard_ValidatorOkMessage,身份证号码已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtIDCard" runat="server" ControlToValidate="TxtIDCard"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtIDCard,身份证号码不能为空 %>">
                    </pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="IdCard" ID="RegTxtIDCard" runat="server" ControlToValidate="TxtIDCard"
                        SetFocusOnError="false" Display="None" ErrorMessage="请输入正确的身份证号码">
                    </pe:RegexValidator>
                </div>
                <div runat="server" class="reg_input" id="TRVocation">
                    <label>
                        <asp:Literal ID="Literal46" Text="<%$ Res: User_Register_Literal46,职业： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtVocation" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtVocation" Text="<%$ Res: User_Register_InteractiveMessagerTxtVocation,请输入职业 %>"
                        ControlToMessage="TxtVocation" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtVocation_ValidatorOkMessage,职业已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtVocation" runat="server" ControlToValidate="TxtVocation"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtVocation,职业不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRCompany">
                    <label>
                        <asp:Literal ID="Literal47" Text="<%$ Res: User_Register_Literal47,公司/单位名称： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtCompany" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtCompany" Text="<%$ Res: User_Register_InteractiveMessagerTxtCompany,请输入公司/单位名称 %>"
                        ControlToMessage="TxtCompany" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtCompany_ValidatorOkMessage,公司/单位名称已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtCompany" runat="server" ControlToValidate="TxtCompany"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtCompany,公司/单位名称不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRDepartment">
                    <label>
                        <asp:Literal ID="Literal48" Text="<%$ Res: User_Register_Literal48,部门名称： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtDepartment" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtDepartment" Text="<%$ Res: User_Register_InteractiveMessagerTxtDepartment,请输入部门名称 %>"
                        ControlToMessage="TxtDepartment" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtDepartment_ValidatorOkMessage,部门名称已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtDepartment" runat="server" ControlToValidate="TxtDepartment"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtDepartment,部门名称不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRPosTitle">
                    <label>
                        <asp:Literal ID="Literal49" Text="<%$ Res: User_Register_Literal49,职务： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtPosTitle" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtPosTitle" Text="<%$ Res: User_Register_InteractiveMessagerTxtPosTitle,请输入职务 %>"
                        ControlToMessage="TxtPosTitle" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtPosTitle_ValidatorOkMessage,职务已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtPosTitle" runat="server" ControlToValidate="TxtPosTitle"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtPosTitle,职务不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRMarriage">
                    <label>
                        <asp:Literal ID="Literal50" Text="<%$ Res: User_Register_Literal50,婚姻状况： %>" runat="server" /></label>
                    <asp:DropDownList ID="DropMarriage" runat="server">
                        <asp:ListItem Text="<%$ Res: User_Register_DropMarriageListItem1,请选择 %>" Value=""></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropMarriageListItem2,保密 %>" Value="0"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropMarriageListItem3,未婚 %>" Value="1"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropMarriageListItem4,已婚 %>" Value="2"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropMarriageListItem5,离异 %>" Value="3"></asp:ListItem>
                    </asp:DropDownList>
                    <pe:InteractiveMessager ID="InteractiveMessagerDropMarriage" Text="<%$ Res: User_Register_InteractiveMessagerDropMarriage,请选择婚姻状况 %>"
                        ControlToMessage="DropMarriage" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerDropMarriage_ValidatorOkMessage,婚姻状况已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager><pe:RequiredFieldValidator ID="ReqDropMarriage" runat="server"
                        ControlToValidate="DropMarriage" SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqDropMarriage,请选择婚姻状况 %>"></pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRIncome">
                    <label>
                        <asp:Literal ID="Literal52" Text="<%$ Res: User_Register_Literal52,收入情况： %>" runat="server" /></label>
                    <asp:DropDownList ID="DropIncome" runat="server">
                    </asp:DropDownList>
                    <pe:InteractiveMessager ID="InteractiveMessagerDropIncome" Text="<%$ Res: User_Register_InteractiveMessagerDropIncome,请选择收入情况 %>"
                        ControlToMessage="DropIncome" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerDropMarriage_ValidatorOkIncome,收入情况已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager><pe:RequiredFieldValidator ID="ReqDropIncome" runat="server"
                        ControlToValidate="DropIncome" InitialValue="-1" SetFocusOnError="false" Display="None"
                        ErrorMessage="<%$ Res: User_Register_ReqDropIncome,请选择收入情况 %>"></pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRUserFace">
                    <label>
                        <asp:Literal ID="Literal53" Text="<%$ Res: User_Register_Literal53,头像地址： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtUserFace" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtUserFace" Text="<%$ Res: User_Register_InteractiveMessagerTxtUserFace,请输入头像地址 %>"
                        ControlToMessage="TxtUserFace" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtUserFace_ValidatorOkMessage,头像地址已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtUserFace" runat="server" ControlToValidate="TxtUserFace"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtUserFace,头像地址不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRFaceWidth">
                    <label>
                        <asp:Literal ID="Literal54" Text="<%$ Res: User_Register_Literal54,头像宽度： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtFaceWidth" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtFaceWidth" Text="<%$ Res: User_Register_InteractiveMessagerTxtFaceWidth,请输入头像宽度 %>"
                        ControlToMessage="TxtFaceWidth" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtFaceWidth_ValidatorOkMessage,头像宽度已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtFaceWidth" runat="server" ControlToValidate="TxtFaceWidth"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtFaceWidth,头像宽度不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRFaceHeight">
                    <label>
                        <asp:Literal ID="Literal56" Text="<%$ Res: User_Register_Literal56,头像高度： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtFaceHeight" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtFaceHeight" Text="<%$ Res: User_Register_InteractiveMessagerTxtFaceHeight,请输入头像高度 %>"
                        ControlToMessage="TxtFaceHeight" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtFaceHeight_ValidatorOkMessage,头像高度已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtFaceHeight" runat="server" ControlToValidate="TxtFaceHeight"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtFaceHeight,头像高度不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRSign">
                    <label>
                        <asp:Literal ID="Literal561" Text="<%$ Res: User_Register_Literal561,签名档： %>" runat="server" /></label>
                    <asp:TextBox ID="TxtSign" TextMode="MultiLine" Height="60" Width="300" runat="server"></asp:TextBox>
                    <pe:InteractiveMessager ID="InteractiveMessagerTxtSign" Text="<%$ Res: User_Register_InteractiveMessagerTxtSign,请输入签名档 %>"
                        ControlToMessage="TxtSign" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerTxtSign_ValidatorOkMessage,签名档已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager>
                    <pe:RequiredFieldValidator ID="ReqTxtSign" runat="server" ControlToValidate="TxtSign"
                        SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqTxtSign,签名档不能为空 %>">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" class="reg_input" id="TRPrivacy">
                    <label>
                        <asp:Literal ID="Literal57" Text="<%$ Res: User_Register_Literal57,隐私设定： %>" runat="server" /></label>
                    <asp:DropDownList ID="DropPrivacy" runat="server">
                        <asp:ListItem Text="<%$ Res: User_Register_DropPrivacyListItem1,公开全部信息(包括真实姓名/电话号码/生日等) %>"
                            Value="0"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropPrivacyListItem2,公开部分信息(只公开QQ/Email等网上联络的信息) %>"
                            Value="1"></asp:ListItem>
                        <asp:ListItem Text="<%$ Res: User_Register_DropPrivacyListItem3,完全保密(别人只能查看你的昵称) %>"
                            Value="2"></asp:ListItem>
                    </asp:DropDownList>
                    <pe:InteractiveMessager ID="InteractiveMessagerDropPrivacy" Text="<%$ Res: User_Register_InteractiveMessagerDropPrivacy,请选择隐私设定 %>"
                        ControlToMessage="DropPrivacy" ValidatorOkMessage="<%$ Res: User_Register_InteractiveMessagerDropMarriage_ValidatorOkPrivacy,隐私设定已输入 %>"
                        IsValidEmpty="false" runat="server">
                    </pe:InteractiveMessager><pe:RequiredFieldValidator ID="ReqDropPrivacy" runat="server"
                        ControlToValidate="DropPrivacy" SetFocusOnError="false" Display="None" ErrorMessage="<%$ Res: User_Register_ReqDropPrivacy,请选择隐私设定 %>"></pe:RequiredFieldValidator>
                </div>
                <div id="TrRegQuestion1" class="reg_input" runat="server" visible="false">
                    <label>
                        <asp:Literal ID="Literal58" Text="<%$ Res: User_Register_Literal58,回答注册问题： %>" runat="server" /></label>
                    <asp:Literal ID="LitRegQuestion1" runat="server"></asp:Literal>
                    <asp:TextBox ID="TxtRegAnswer1" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqTxtRegAnswer1" runat="server" ControlToValidate="TxtRegAnswer1"
                        SetFocusOnError="false" Display="None" ErrorMessage="问题答案不能为空">
                    </pe:RequiredFieldValidator>
                </div>
                <div id="TrRegQuestion2" class="reg_input" runat="server" visible="false">
                    <label>
                        <asp:Literal ID="Literal59" Text="<%$ Res: User_Register_Literal59,回答注册问题： %>" runat="server" /></label>
                    <asp:Literal ID="LitRegQuestion2" runat="server"></asp:Literal>
                    <asp:TextBox ID="TxtRegAnswer2" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqTxtRegAnswer2" runat="server" ControlToValidate="TxtRegAnswer2"
                        SetFocusOnError="false" Display="None" ErrorMessage="问题答案不能为空">
                    </pe:RequiredFieldValidator>
                </div>
                <div id="TrRegQuestion3" class="reg_input" runat="server" visible="false">
                    <label>
                        <asp:Literal ID="Literal60" Text="<%$ Res: User_Register_Literal60,回答注册问题： %>" runat="server" /></label>
                    <asp:Literal ID="LitRegQuestion3" runat="server"></asp:Literal>
                    <asp:TextBox ID="TxtRegAnswer3" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqTxtRegAnswer3" runat="server" ControlToValidate="TxtRegAnswer3"
                        SetFocusOnError="false" Display="None" ErrorMessage="问题答案不能为空">
                    </pe:RequiredFieldValidator>
                </div>
                <div runat="server" id="TRUserOption">
                </div>
            </div>
        </asp:Panel>
        <asp:Panel ID="PnlStep3" runat="server">
        </asp:Panel>
    </form>
</body>
</html>
